/*
 * Decompiled with CFR 0.152.
 */
package com.textflex.jarajar.selfextractor;

import com.textflex.jarajar.selfextractor.SelfExtractor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

public class Prefs {
    private Preferences prefs = Preferences.userNodeForPackage(SelfExtractor.class);
    private Preferences installationsPrefs = this.prefs.node("Installations");
    private static final String INSTALL_DIR = "installDir";
    private static final String JUST_LAUNCH = "justLaunch";
    private static final String FIRST_FILE = "firstFile";
    private static final String ARG_EXPORT = "--export";
    private static final String ARG_RESET = "--reset";

    public static void main(String[] stringArray) {
        Prefs prefs = new Prefs();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].indexOf(ARG_RESET) == 0) {
                prefs.resetPrefs();
                continue;
            }
            if (stringArray[i].indexOf(ARG_EXPORT) != 0) continue;
            prefs.exportPrefs(new File("export.xml"));
        }
        System.exit(0);
    }

    public Preferences storeInstallationPrefs(String string, String string2, String string3, String string4) {
        Preferences preferences = this.getInstallationsPrefs().node(string);
        Preferences preferences2 = preferences.node(string2);
        preferences2.put(INSTALL_DIR, string3);
        preferences2.put(FIRST_FILE, string4);
        try {
            preferences2.flush();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        return preferences2;
    }

    public void storeJustLaunch(Preferences preferences, boolean bl) {
        if (preferences != null) {
            preferences.putBoolean(JUST_LAUNCH, bl);
            System.out.println("stored just launch: " + bl);
        }
    }

    public Preferences getInstallationsPrefs() {
        try {
            if (!this.installationsPrefs.nodeExists("")) {
                this.installationsPrefs = this.prefs.node("Installations");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("The installation preferences node could not be found or created.");
        }
        return this.installationsPrefs;
    }

    public Preferences getInstallNode(String string) {
        try {
            if (this.getInstallationsPrefs().nodeExists(string)) {
                return this.getInstallationsPrefs().node(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("The " + string + " installation preferences node " + "could not be found or created.");
        }
        return null;
    }

    public String getInstallDir(String string, String string2) {
        Preferences preferences;
        Preferences preferences2 = this.getInstallNode(string);
        if (preferences2 != null && (preferences = this.getVersionNode(preferences2, string2)) != null) {
            return preferences.get(INSTALL_DIR, "");
        }
        return "";
    }

    public String getInstallDir(Preferences preferences) {
        if (preferences != null) {
            return preferences.get(INSTALL_DIR, "");
        }
        return "";
    }

    public Preferences getVersionNode(Preferences preferences, String string) {
        try {
            if (preferences != null && preferences.nodeExists(string)) {
                return preferences.node(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("The version preferences node for this application installation could not be found or created.");
        }
        return null;
    }

    public Preferences getVersionNode(String string, String string2) {
        return this.getVersionNode(this.getInstallNode(string), string2);
    }

    public boolean getJustLaunch(Preferences preferences) {
        if (preferences != null) {
            return preferences.getBoolean(JUST_LAUNCH, false);
        }
        return false;
    }

    public String getFirstFile(Preferences preferences) {
        if (preferences != null) {
            return preferences.get(FIRST_FILE, "");
        }
        return "";
    }

    public void exportPrefs(File file) {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            this.prefs.exportSubtree(bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    public void importPrefs(File file) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            Preferences.importPreferences(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InvalidPreferencesFormatException invalidPreferencesFormatException) {
            invalidPreferencesFormatException.printStackTrace();
        }
    }

    public void resetPrefs(Preferences preferences) {
        if (preferences == null) {
            return;
        }
        try {
            String[] stringArray = preferences.childrenNames();
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("children names: " + stringArray[i]);
                Preferences preferences2 = preferences.node(stringArray[i]);
                this.resetPrefs(preferences2);
            }
            preferences.clear();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
    }

    public void resetPref(Preferences preferences) {
        if (preferences == null) {
            return;
        }
        try {
            preferences.removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
    }

    public void resetPrefs() {
        this.resetPrefs(this.prefs);
    }
}

