/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.File;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.VFSUpdate;
import org.gjt.sp.jedit.search.DirectoryListSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchFileSet;

class SettingsReloader {
    SettingsReloader() {
    }

    @EditBus.EBHandler
    public void handleVFSUpdate(VFSUpdate vmsg) {
        this.maybeReload(vmsg.getPath());
    }

    private void maybeReload(String path) {
        DirectoryListSet dirset;
        String dir2;
        SearchFileSet fileset;
        String jEditHome = jEdit.getJEditHome();
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (!MiscUtilities.isURL(path)) {
            path = MiscUtilities.resolveSymlinks(path);
        }
        if ((VFSManager.getVFSForPath(path).getCapabilities() & 0x80) != 0) {
            path = path.toLowerCase();
            jEditHome = jEditHome.toLowerCase();
            if (settingsDirectory != null) {
                settingsDirectory = settingsDirectory.toLowerCase();
            }
        }
        if ((fileset = SearchAndReplace.getSearchFileSet()) instanceof DirectoryListSet && path.startsWith(dir2 = MiscUtilities.resolveSymlinks((dirset = (DirectoryListSet)fileset).getDirectory()))) {
            dirset.invalidateCachedList();
        }
        if (jEditHome != null && path.startsWith(jEditHome)) {
            path = path.substring(jEditHome.length());
        } else if (settingsDirectory != null && path.startsWith(settingsDirectory)) {
            path = path.substring(settingsDirectory.length());
        } else {
            return;
        }
        if (path.startsWith(File.separator) || path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.startsWith("macros")) {
            Macros.loadMacros();
        } else if (path.startsWith("modes") && (path.endsWith(".xml") || path.endsWith("catalog"))) {
            jEdit.reloadModes();
        }
    }
}

