/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class AboutDialog
extends JDialog
implements ActionListener {
    public AboutDialog(View view) {
        super(view, jEdit.getProperty("about.title"), true);
        this.setResizable(false);
        JButton closeBtn = new JButton(jEdit.getProperty("common.close"));
        closeBtn.addActionListener(this);
        this.getRootPane().setDefaultButton(closeBtn);
        JPanel p = new JPanel(new BorderLayout());
        final AboutPanel aboutPanel = new AboutPanel();
        JPanel flowP = new JPanel(new FlowLayout());
        flowP.add(closeBtn);
        flowP.add(Box.createRigidArea(new Dimension(40, 40)));
        Dimension dim = new Dimension(10, 0);
        p.add("West", Box.createRigidArea(dim));
        p.add("East", Box.createRigidArea(dim));
        p.add("North", Box.createRigidArea(new Dimension(10, 10)));
        p.add("South", flowP);
        p.add("Center", aboutPanel);
        closeBtn.setToolTipText(jEdit.getProperty("about.navigate"));
        closeBtn.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                aboutPanel.handleKeyEvent(e);
            }
        });
        this.setContentPane(p);
        this.pack();
        this.setLocationRelativeTo(jEdit.getActiveView());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AboutDialog.this.closeDialog();
            }
        });
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.closeDialog();
    }

    private void closeDialog() {
        AboutPanel.stopThread();
        this.dispose();
    }

    private static class AboutPanel
    extends JComponent
    implements Runnable {
        private BufferedImage bufImage;
        private Graphics2D g;
        private static final Font defaultFont = UIManager.getFont("Label.font");
        private final Font bottomLineFont = defaultFont.deriveFont(9.8f);
        private final String sBottomLine;
        private final ImageIcon image;
        private final List<String> vLines;
        private static boolean doWork;
        private Thread th;
        private final FontMetrics fm;
        private int iLineHeight = 0;
        private int iListHeight;
        private int iLineCount = 0;
        private int iBottomLineXOffset = 0;
        private int iBottomLineYOffset = 0;
        private int iPipeLineCount = 0;
        private int w = 0;
        private int h = 0;
        private int y = 0;
        private static final int SLEEP_TIME = 30;
        private static final int iBottomPadding = 36;
        private static final int iTopPadding = 120;
        private static Rectangle2D.Float rectangle;
        private static GradientPaint gradientPaint;
        private boolean skipDrain = false;

        AboutPanel() {
            String mode = jEdit.getEditServer() != null ? (jEdit.isBackgroundModeEnabled() ? jEdit.getProperty("about.mode.server-background") : jEdit.getProperty("about.mode.server")) : jEdit.getProperty("about.mode.standalone");
            Object[] args = new String[]{jEdit.getVersion(), mode, System.getProperty("java.vendor"), System.getProperty("java.version")};
            this.sBottomLine = jEdit.getProperty("about.version", args);
            this.setFont(defaultFont);
            this.fm = this.getFontMetrics(defaultFont);
            FontMetrics fmBottom = this.getFontMetrics(this.bottomLineFont);
            this.iLineHeight = this.fm.getHeight();
            this.image = (ImageIcon)GUIUtilities.loadIcon("about.png");
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(this.image.getImage(), 0);
            try {
                tracker.waitForID(0);
            }
            catch (Exception exc) {
                AboutPanel.tell("AboutPanel: " + exc);
            }
            Dimension d = new Dimension(this.image.getIconWidth(), this.image.getIconHeight());
            this.setSize(d);
            this.setPreferredSize(d);
            this.w = d.width;
            this.h = d.height;
            this.iBottomLineXOffset = this.w / 2 - fmBottom.stringWidth(this.sBottomLine) / 2;
            this.iBottomLineYOffset = this.h - this.iLineHeight / 2;
            String aboutText = jEdit.getProperty("about.text.prefix") + "\n \n" + jEdit.getProperty("about.text.contributors") + "\n \n" + jEdit.getProperty("about.text.suffix");
            String[] contributors = aboutText.split("\n");
            this.vLines = Arrays.asList(contributors);
            this.iLineCount = this.vLines.size();
            this.iListHeight = this.iLineCount * this.iLineHeight;
            this.startThread();
            this.updateUI();
        }

        private void handleKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 40) {
                this.skipDrain = false;
                Collections.rotate(this.vLines, -1);
            } else if (e.getKeyCode() == 38) {
                this.skipDrain = false;
                Collections.rotate(this.vLines, 1);
            } else if (e.getKeyCode() == 37 || e.getKeyCode() == 39 || e.getKeyCode() == 32) {
                this.skipDrain = !this.skipDrain;
                e.consume();
            } else if (e.getKeyCode() == 27) {
                e.consume();
                JDialog d = GUIUtilities.getParentDialog(this);
                AboutPanel.stopThread();
                d.dispose();
            }
        }

        private void drain() {
            if (this.skipDrain) {
                return;
            }
            if (this.bufImage == null) {
                Dimension d = this.getSize();
                this.bufImage = new BufferedImage(d.width, d.height, 1);
                this.g = this.bufImage.createGraphics();
                rectangle = new Rectangle2D.Float(0.0f, 120.0f, d.width, d.height - 36 - 120);
                this.iPipeLineCount = 1 + (int)Math.ceil(AboutPanel.rectangle.height / (float)this.iLineHeight);
                this.y = d.height + 36;
                this.g.setFont(defaultFont);
                gradientPaint = new GradientPaint(AboutPanel.rectangle.width / 2.0f, 200.0f, new Color(80, 80, 80), AboutPanel.rectangle.width / 2.0f, 120.0f, new Color(205, 205, 205));
                this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            this.g.drawImage(this.image.getImage(), 0, 0, this.w, this.h, this);
            this.g.setFont(this.bottomLineFont);
            this.g.setPaint(new Color(55, 55, 55));
            this.g.drawString(this.sBottomLine, this.iBottomLineXOffset, this.iBottomLineYOffset);
            this.g.setPaint(new Color(255, 255, 255, 50));
            this.g.drawString(this.sBottomLine, this.iBottomLineXOffset + 1, this.iBottomLineYOffset + 1);
            this.g.setFont(defaultFont);
            this.g.setPaint(Color.black);
            this.g.drawRect(0, 0, this.w - 1, this.h - 1);
            this.g.clip(rectangle);
            this.g.setPaint(gradientPaint);
            int iDrawnLinesCount = 0;
            int yCoor = 0;
            for (int i = 0; i < this.iLineCount; ++i) {
                yCoor = this.y + i * this.iLineHeight;
                if (yCoor < 120) continue;
                String sLine = this.vLines.get(i);
                int x = (this.w - this.fm.stringWidth(sLine)) / 2;
                this.g.drawString(sLine, x, yCoor);
                if (++iDrawnLinesCount >= this.iPipeLineCount) break;
            }
            --this.y;
            this.paint(this.getGraphics());
            if (this.y + this.iListHeight < 120) {
                this.y = this.h + 36;
            }
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public void paint(Graphics panelGraphics) {
            if (panelGraphics != null && this.bufImage != null) {
                panelGraphics.drawImage(this.bufImage, 0, 0, this.w, this.h, this);
            }
        }

        @Override
        public void run() {
            try {
                while (doWork) {
                    this.drain();
                    Thread.sleep(30L);
                }
            }
            catch (Exception exc) {
                Log.log(9, this, exc);
            }
            doWork = false;
            this.th = null;
        }

        public void startThread() {
            if (this.th == null) {
                this.th = new Thread(this);
                doWork = true;
                this.th.start();
            }
        }

        public static void stopThread() {
            doWork = false;
        }

        public static void tell(Object obj) {
            String str = obj == null ? "NULL" : obj.toString();
            JOptionPane.showMessageDialog(jEdit.getActiveView(), str, "Title", 1);
        }
    }
}

