/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.gui.JCheckBoxList;

class CheckBoxListModel
extends AbstractTableModel {
    Vector<JCheckBoxList.Entry> items;

    CheckBoxListModel(Vector _items) {
        this.items = new Vector(_items.size());
        for (int i = 0; i < _items.size(); ++i) {
            this.items.add(CheckBoxListModel.createEntry(_items.elementAt(i)));
        }
    }

    CheckBoxListModel(Object[] _items) {
        this.items = new Vector(_items.length);
        for (int i = 0; i < _items.length; ++i) {
            this.items.add(CheckBoxListModel.createEntry(_items[i]));
        }
    }

    private static JCheckBoxList.Entry createEntry(Object obj) {
        if (obj instanceof JCheckBoxList.Entry) {
            return (JCheckBoxList.Entry)obj;
        }
        return new JCheckBoxList.Entry(false, obj);
    }

    @Override
    public int getRowCount() {
        return this.items.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int col) {
        return null;
    }

    @Override
    public Object getValueAt(int row, int col) {
        JCheckBoxList.Entry entry = this.items.get(row);
        switch (col) {
            case 0: {
                return entry.checked;
            }
            case 1: {
                return entry.value;
            }
        }
        throw new InternalError();
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
        }
        throw new InternalError();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        JCheckBoxList.Entry entry = this.items.get(row);
        return col == 0 && !entry.caption;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            JCheckBoxList.Entry entry = this.items.get(row);
            if (!entry.caption) {
                entry.checked = value.equals(Boolean.TRUE);
                this.fireTableRowsUpdated(row, row);
            }
        }
    }
}

