/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;

public class FavoritesVFS
extends VFS {
    public static final String PROTOCOL = "favorites";
    private static FavoritesVFS instance;
    private static final Object lock;
    private static List<Favorite> favorites;

    public FavoritesVFS() {
        super(PROTOCOL, 344, new String[]{"type"});
        instance = this;
    }

    @Override
    public String getParentOfPath(String path) {
        return "favorites:";
    }

    @Override
    public VFSFile[] _listFiles(Object session, String url, Component comp) {
        return FavoritesVFS.getFavorites();
    }

    @Override
    public VFSFile _getFile(Object session, String path, Component comp) {
        return new Favorite(path, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean _delete(Object session, String path, Component comp) {
        Object object = lock;
        synchronized (object) {
            path = path.substring(PROTOCOL.length() + 1);
            Iterator<Favorite> iter = favorites.iterator();
            while (iter.hasNext()) {
                if (!iter.next().getPath().equals(path)) continue;
                iter.remove();
                VFSManager.sendVFSUpdate(this, "favorites:", false);
                EditBus.sendAsync(new DynamicMenuChanged(PROTOCOL));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean _rename(Object session, String from, String to, Component comp) {
        VFSFile[] favorites = FavoritesVFS.getFavorites();
        for (int i = 0; i < favorites.length; ++i) {
            Favorite favorite = (Favorite)favorites[i];
            if (!favorite.getPath().equals(from)) continue;
            favorite.label = to;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFavorites() {
        Object object = lock;
        synchronized (object) {
            String favoritePath;
            favorites = new LinkedList<Favorite>();
            int i = 0;
            while ((favoritePath = jEdit.getProperty("vfs.favorite." + i)) != null) {
                Favorite favorite = new Favorite(favoritePath, jEdit.getIntegerProperty("vfs.favorite." + i + ".type", 1));
                favorites.add(favorite);
                String label = jEdit.getProperty("vfs.favorite." + i + ".label");
                if (label != null) {
                    favorite.label = label;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToFavorites(String path, int type) {
        Object object = lock;
        synchronized (object) {
            if (favorites == null) {
                FavoritesVFS.loadFavorites();
            }
            for (Favorite favorite : favorites) {
                if (!favorite.getPath().equals(path)) continue;
                return;
            }
            favorites.add(new Favorite(path, type));
            VFSManager.sendVFSUpdate(instance, "favorites:", false);
            EditBus.send(new DynamicMenuChanged(PROTOCOL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFavorites() {
        Object object = lock;
        synchronized (object) {
            if (favorites == null) {
                return;
            }
            int i = 0;
            for (Favorite favorite : favorites) {
                String p = favorite.getPath();
                String l = favorite.getLabel();
                jEdit.setProperty("vfs.favorite." + i, p);
                if (p.equals(l) || MiscUtilities.abbreviateView(p).equals(l)) {
                    jEdit.unsetProperty("vfs.favorite." + i + ".label");
                } else {
                    jEdit.setProperty("vfs.favorite." + i + ".label", l);
                }
                jEdit.setIntegerProperty("vfs.favorite." + i + ".type", favorite.getType());
                ++i;
            }
            jEdit.unsetProperty("vfs.favorite." + favorites.size());
            jEdit.unsetProperty("vfs.favorite." + favorites.size() + ".type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VFSFile[] getFavorites() {
        Object object = lock;
        synchronized (object) {
            if (favorites == null) {
                FavoritesVFS.loadFavorites();
            }
            return favorites.toArray(new VFSFile[favorites.size()]);
        }
    }

    static {
        lock = new Object();
    }

    public static class Favorite
    extends VFSFile {
        private String label;

        Favorite(String path, int type) {
            super(path, path, "favorites:" + path, type, 0L, false);
            this.label = MiscUtilities.abbreviateView(path);
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public String getExtendedAttribute(String name) {
            if (name.equals("type")) {
                return super.getExtendedAttribute(name);
            }
            return null;
        }

        @Override
        public VFS getVFS() {
            return VFSManager.getVFSForProtocol(FavoritesVFS.PROTOCOL);
        }
    }
}

