/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Color;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferio.BufferInsertRequest;
import org.gjt.sp.jedit.bufferio.BufferLoadRequest;
import org.gjt.sp.jedit.bufferio.BufferSaveRequest;
import org.gjt.sp.jedit.io.GlobVFSFileFilter;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSFileFilter;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.ThreadUtilities;

public abstract class VFS {
    public static final int READ_CAP = 1;
    public static final int WRITE_CAP = 2;
    public static final int BROWSE_CAP = 4;
    public static final int DELETE_CAP = 8;
    public static final int RENAME_CAP = 16;
    public static final int MKDIR_CAP = 32;
    public static final int LOW_LATENCY_CAP = 64;
    public static final int CASE_INSENSITIVE_CAP = 128;
    public static final int NON_AWT_SESSION_CAP = 256;
    public static final String EA_TYPE = "type";
    public static final String EA_STATUS = "status";
    public static final String EA_SIZE = "size";
    public static final String EA_MODIFIED = "modified";
    public static int IOBUFSIZE = 32678;
    private String name;
    private int caps;
    private String[] extAttrs;
    private static List<ColorEntry> colors;
    private static final Object lock;

    protected VFS(String name, int caps) {
        this.name = name;
        this.caps = caps;
        this.extAttrs = new String[]{EA_SIZE, EA_TYPE};
    }

    protected VFS(String name, int caps, String[] extAttrs) {
        this.name = name;
        this.caps = caps;
        this.extAttrs = extAttrs;
    }

    public String getName() {
        return this.name;
    }

    public int getCapabilities() {
        return this.caps;
    }

    public boolean isMarkersFileSupported() {
        return true;
    }

    public String[] getExtendedAttributes() {
        return this.extAttrs;
    }

    public String getFileName(String path) {
        if (path.equals("/")) {
            return path;
        }
        while (path.endsWith("/") || path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        int index = Math.max(path.lastIndexOf(47), path.lastIndexOf(File.separatorChar));
        if (index == -1) {
            index = path.indexOf(58);
        }
        if (index == -1 || index == path.length() - 1) {
            return path;
        }
        return path.substring(index + 1);
    }

    public String getFilePath(String vfsPath) {
        if (!MiscUtilities.isURL(vfsPath)) {
            return vfsPath;
        }
        String filePath = vfsPath.substring(MiscUtilities.getProtocolOfURL(vfsPath).length() + 1);
        return VFSManager.getVFSForPath(filePath).getFilePath(filePath);
    }

    public String getParentOfPath(String path) {
        int lastIndex;
        for (lastIndex = path.length() - 1; lastIndex > 0 && (path.charAt(lastIndex) == File.separatorChar || path.charAt(lastIndex) == '/'); --lastIndex) {
        }
        int count = Math.max(0, lastIndex);
        int index = path.lastIndexOf(File.separatorChar, count);
        if (index == -1) {
            index = path.lastIndexOf(47, count);
        }
        if (index == -1) {
            index = path.lastIndexOf(58);
        }
        return path.substring(0, index + 1);
    }

    public String constructPath(String parent, String path) {
        return parent + path;
    }

    public char getFileSeparator() {
        return '/';
    }

    public String getTwoStageSaveName(String path) {
        return MiscUtilities.constructPath(this.getParentOfPath(path), '#' + this.getFileName(path) + "#save#");
    }

    public void reloadDirectory(String path) {
    }

    public Object createVFSSession(String path, Component comp) {
        return new Object();
    }

    public Object createVFSSessionSafe(String path, Component comp) {
        Object session = null;
        if ((this.getCapabilities() & 0x100) != 0) {
            session = this.createVFSSession(path, comp);
        } else {
            SessionGetter getter = new SessionGetter(path, comp);
            ThreadUtilities.runInDispatchThreadAndWait(getter);
            session = getter.get();
        }
        return session;
    }

    public boolean load(View view, Buffer buffer, String path) {
        if ((this.getCapabilities() & 1) == 0) {
            VFSManager.error(view, path, "vfs.not-supported.load", new String[]{this.name});
            return false;
        }
        Object session = this.createVFSSession(path, view);
        if (session == null) {
            return false;
        }
        if ((this.getCapabilities() & 2) == 0) {
            buffer.setReadOnly(true);
        }
        BufferLoadRequest request = new BufferLoadRequest(view, buffer, session, this, path);
        if (buffer.isTemporary()) {
            request.run();
        } else {
            ThreadUtilities.runInBackground(request);
        }
        return true;
    }

    public boolean save(View view, Buffer buffer, String path) {
        if ((this.getCapabilities() & 2) == 0) {
            VFSManager.error(view, path, "vfs.not-supported.save", new String[]{this.name});
            return false;
        }
        Object session = this.createVFSSession(path, view);
        if (session == null) {
            return false;
        }
        if (!path.equals(buffer.getPath())) {
            buffer.unsetProperty("Buffer__backedUp");
        }
        ThreadUtilities.runInBackground(new BufferSaveRequest(view, buffer, session, this, path));
        return true;
    }

    public static boolean copy(ProgressObserver progress, VFS sourceVFS, Object sourceSession, String sourcePath, VFS targetVFS, Object targetSession, String targetPath, Component comp, boolean canStop) throws IOException {
        return VFS.copy(progress, sourceVFS, sourceSession, sourcePath, targetVFS, targetSession, targetPath, comp, canStop, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static boolean copy(ProgressObserver progress, VFS sourceVFS, Object sourceSession, String sourcePath, VFS targetVFS, Object targetSession, String targetPath, Component comp, boolean canStop, boolean sendVFSUpdate) throws IOException {
        block9: {
            if (sourcePath.equals(targetPath)) {
                Log.log(7, VFS.class, jEdit.getProperty("ioerror.copy-self", new Object[]{sourcePath}));
                return false;
            }
            if (progress != null) {
                progress.setStatus("Initializing");
            }
            in = null;
            out = null;
            try {
                block10: {
                    block11: {
                        sourceVFSFile = sourceVFS._getFile(sourceSession, sourcePath, comp);
                        if (sourceVFSFile == null) {
                            throw new FileNotFoundException("source path " + sourcePath + " doesn't exists");
                        }
                        if (progress != null) {
                            progress.setMaximum(sourceVFSFile.getLength());
                        }
                        if ((targetVFSFile = targetVFS._getFile(targetSession, targetPath, comp)) != null) break block10;
                        parentTargetPath = MiscUtilities.getParentOfPath(targetPath);
                        parentTargetVFSFile = targetVFS._getFile(targetSession, parentTargetPath, comp);
                        if (parentTargetVFSFile == null) {
                            throw new FileNotFoundException("target path " + parentTargetPath + " doesn't exists");
                        }
                        if (parentTargetVFSFile.getType() != 1) break block11;
                        targetFilename = MiscUtilities.getFileName(targetPath);
                        targetPath = MiscUtilities.constructPath(parentTargetPath, targetFilename);
                        ** GOTO lbl39
                    }
                    throw new IOException("The parent of target path is a file");
                }
                if (targetVFSFile.getType() != 1) ** GOTO lbl39
                if (!targetVFSFile.getPath().equals(sourceVFSFile.getPath())) break block9;
                parentTargetPath = false;
            }
            catch (Throwable var17_20) {
                IOUtilities.closeQuietly(in);
                IOUtilities.closeQuietly(out);
                throw var17_20;
            }
            IOUtilities.closeQuietly(in);
            IOUtilities.closeQuietly(out);
            return parentTargetPath;
        }
        targetPath = MiscUtilities.constructPath(targetPath, sourceVFSFile.getName());
lbl39:
        // 3 sources

        in = new BufferedInputStream(sourceVFS._createInputStream(sourceSession, sourcePath, false, comp));
        out = new BufferedOutputStream(targetVFS._createOutputStream(targetSession, targetPath, comp));
        copyResult = IOUtilities.copyStream(VFS.IOBUFSIZE, progress, in, out, canStop);
        if (sendVFSUpdate) {
            VFSManager.sendVFSUpdate(targetVFS, targetPath, true);
        }
        var15_18 = copyResult;
        IOUtilities.closeQuietly((Closeable)in);
        IOUtilities.closeQuietly((Closeable)out);
        return var15_18;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(ProgressObserver progress, String sourcePath, String targetPath, Component comp, boolean canStop, boolean sendVFSUpdate) throws IOException {
        boolean bl;
        Object targetSession;
        VFS targetVFS;
        block13: {
            Object sourceSession;
            VFS sourceVFS;
            block11: {
                boolean bl2;
                block12: {
                    block9: {
                        boolean bl3;
                        block10: {
                            sourceVFS = VFSManager.getVFSForPath(sourcePath);
                            targetVFS = VFSManager.getVFSForPath(targetPath);
                            sourceSession = null;
                            targetSession = null;
                            try {
                                sourceSession = sourceVFS.createVFSSession(sourcePath, comp);
                                if (sourceSession != null) break block9;
                                Log.log(7, VFS.class, "Unable to get a valid session from " + sourceVFS + " for path " + sourcePath);
                                bl3 = false;
                                if (sourceSession == null) break block10;
                            }
                            catch (Throwable throwable) {
                                if (sourceSession != null) {
                                    sourceVFS._endVFSSession(sourceSession, comp);
                                }
                                if (targetSession != null) {
                                    targetVFS._endVFSSession(targetSession, comp);
                                }
                                throw throwable;
                            }
                            sourceVFS._endVFSSession(sourceSession, comp);
                        }
                        if (targetSession != null) {
                            targetVFS._endVFSSession(targetSession, comp);
                        }
                        return bl3;
                    }
                    targetSession = targetVFS.createVFSSession(targetPath, comp);
                    if (targetSession != null) break block11;
                    Log.log(7, VFS.class, "Unable to get a valid session from " + targetVFS + " for path " + targetPath);
                    bl2 = false;
                    if (sourceSession == null) break block12;
                    sourceVFS._endVFSSession(sourceSession, comp);
                }
                if (targetSession != null) {
                    targetVFS._endVFSSession(targetSession, comp);
                }
                return bl2;
            }
            bl = VFS.copy(progress, sourceVFS, sourceSession, sourcePath, targetVFS, targetSession, targetPath, comp, canStop, sendVFSUpdate);
            if (sourceSession == null) break block13;
            sourceVFS._endVFSSession(sourceSession, comp);
        }
        if (targetSession != null) {
            targetVFS._endVFSSession(targetSession, comp);
        }
        return bl;
    }

    public static boolean copy(ProgressObserver progress, String sourcePath, String targetPath, Component comp, boolean canStop) throws IOException {
        return VFS.copy(progress, sourcePath, targetPath, comp, canStop, true);
    }

    public boolean insert(View view, Buffer buffer, String path) {
        if ((this.getCapabilities() & 1) == 0) {
            VFSManager.error(view, path, "vfs.not-supported.load", new String[]{this.name});
            return false;
        }
        Object session = this.createVFSSession(path, view);
        if (session == null) {
            return false;
        }
        ThreadUtilities.runInBackground(new BufferInsertRequest(view, buffer, session, this, path));
        return true;
    }

    public String _canonPath(Object session, String path, Component comp) throws IOException {
        return path;
    }

    public String[] _listDirectory(Object session, String directory, String glob, boolean recursive, Component comp) throws IOException {
        String[] retval = this._listDirectory(session, directory, glob, recursive, comp, true, false);
        return retval;
    }

    public String[] _listDirectory(Object session, String directory, String glob, boolean recursive, Component comp, boolean skipBinary, boolean skipHidden) throws IOException {
        GlobVFSFileFilter filter = new GlobVFSFileFilter(glob);
        return this._listDirectory(session, directory, filter, recursive, comp, skipBinary, skipHidden);
    }

    public String[] _listDirectory(Object session, String directory, VFSFileFilter filter, boolean recursive, Component comp, boolean skipBinary, boolean skipHidden) throws IOException {
        ArrayList<String> files = new ArrayList<String>(100);
        this.listFiles(session, new HashSet<String>(), files, directory, filter, recursive, comp, skipBinary, skipHidden);
        String[] retVal = files.toArray(new String[files.size()]);
        Arrays.sort(retVal, new StandardUtilities.StringCompare(true));
        return retVal;
    }

    public VFSFile[] _listFiles(Object session, String directory, Component comp) throws IOException {
        VFSManager.error(comp, directory, "vfs.not-supported.list", new String[]{this.name});
        return null;
    }

    public VFSFile _getFile(Object session, String path, Component comp) throws IOException {
        return null;
    }

    public boolean _delete(Object session, String path, Component comp) throws IOException {
        return false;
    }

    public boolean _rename(Object session, String from, String to, Component comp) throws IOException {
        return false;
    }

    public boolean _mkdir(Object session, String directory, Component comp) throws IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _backup(Object session, String path, Component comp) throws IOException {
        VFS vfsSrc = VFSManager.getVFSForPath(path);
        if (null == vfsSrc._getFile(session, path, comp)) {
            return;
        }
        File backupDir = MiscUtilities.prepareBackupDirectory(path);
        if (backupDir == null) {
            Log.log(7, VFS.class, "Backup of remote file " + path + " failed, because there is no backup directory.");
            return;
        }
        if (!backupDir.exists()) {
            Log.log(7, VFS.class, "Backup of file " + path + " failed. Directory " + backupDir + " does not exist.");
            return;
        }
        File backupFile = MiscUtilities.prepareBackupFile(path, backupDir);
        if (backupFile == null) {
            return;
        }
        VFS vfsDst = VFSManager.getVFSForPath(backupFile.getPath());
        Object sessionDst = vfsDst.createVFSSessionSafe(backupFile.getPath(), comp);
        if (sessionDst == null) {
            return;
        }
        try {
            if (!VFS.copy(null, vfsSrc, session, path, vfsDst, sessionDst, backupFile.getPath(), comp, true)) {
                Log.log(7, VFS.class, "Backup of file " + path + " failed. Copy to " + backupFile + " failed.");
            }
        }
        finally {
            vfsDst._endVFSSession(sessionDst, comp);
        }
    }

    public InputStream _createInputStream(Object session, String path, boolean ignoreErrors, Component comp) throws IOException {
        VFSManager.error(comp, path, "vfs.not-supported.load", new String[]{this.name});
        return null;
    }

    public OutputStream _createOutputStream(Object session, String path, Component comp) throws IOException {
        VFSManager.error(comp, path, "vfs.not-supported.save", new String[]{this.name});
        return null;
    }

    public void _saveComplete(Object session, Buffer buffer, String path, Component comp) throws IOException {
    }

    public void _finishTwoStageSave(Object session, Buffer buffer, String path, Component comp) throws IOException {
    }

    public void _endVFSSession(Object session, Component comp) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color getDefaultColorFor(String name) {
        Object object = lock;
        synchronized (object) {
            if (colors == null) {
                VFS.loadColors();
            }
            for (int i = 0; i < colors.size(); ++i) {
                ColorEntry entry = colors.get(i);
                if (!entry.re.matcher(name).matches()) continue;
                return entry.color;
            }
            return null;
        }
    }

    private void listFiles(Object session, Collection<String> stack, List<String> files, String directory, VFSFileFilter filter, boolean recursive, Component comp, boolean skipBinary, boolean skipHidden) throws IOException {
        VFSFile[] _files;
        String resolvedPath;
        if (recursive && !MiscUtilities.isURL(directory) && !directory.equals(resolvedPath = MiscUtilities.resolveSymlinks(directory))) {
            if (stack.contains(resolvedPath)) {
                Log.log(9, this, "Recursion in listFiles(): " + directory);
                return;
            }
            stack.add(resolvedPath);
        }
        if ((_files = this._listFiles(session, directory, comp)) == null || _files.length == 0) {
            return;
        }
        for (int i = 0; i < _files.length && !Thread.currentThread().isInterrupted(); ++i) {
            VFSFile file = _files[i];
            if (skipHidden && (file.isHidden() || MiscUtilities.isBackup(file.getName())) || !filter.accept(file)) continue;
            if (file.getType() == 1 || file.getType() == 2) {
                if (!recursive) continue;
                String canonPath = this._canonPath(session, file.getPath(), comp);
                this.listFiles(session, stack, files, canonPath, filter, recursive, comp, skipBinary, skipHidden);
                continue;
            }
            if (skipBinary) {
                try {
                    if (file.isBinary(session)) {
                        Log.log(5, this, file.getPath() + ": skipped as a binary file");
                        continue;
                    }
                }
                catch (IOException e) {
                    Log.log(9, this, e);
                }
            }
            files.add(file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadColors() {
        Object object = lock;
        synchronized (object) {
            String glob;
            colors = new ArrayList<ColorEntry>();
            if (!jEdit.getBooleanProperty("vfs.browser.colorize")) {
                return;
            }
            int i = 0;
            while ((glob = jEdit.getProperty("vfs.browser.colors." + i + ".glob")) != null) {
                try {
                    colors.add(new ColorEntry(Pattern.compile(StandardUtilities.globToRE(glob)), jEdit.getColorProperty("vfs.browser.colors." + i + ".color", Color.black)));
                }
                catch (PatternSyntaxException e) {
                    Log.log(9, VFS.class, "Invalid regular expression: " + glob);
                    Log.log(9, VFS.class, e);
                }
                ++i;
            }
        }
    }

    static {
        lock = new Object();
        EditBus.addToBus(new EBComponent(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleMessage(EBMessage msg) {
                if (msg instanceof PropertiesChanged) {
                    Object object = lock;
                    synchronized (object) {
                        colors = null;
                    }
                }
            }
        });
    }

    private class SessionGetter
    implements Runnable {
        private Object session;
        private String path;
        private Component comp;

        public SessionGetter(String path, Component comp) {
            this.path = path;
            this.comp = comp;
        }

        @Override
        public void run() {
            this.session = VFS.this.createVFSSession(this.path, this.comp);
        }

        public Object get() {
            return this.session;
        }
    }

    private static class ColorEntry {
        Pattern re;
        Color color;

        ColorEntry(Pattern re, Color color) {
            this.re = re;
            this.color = color;
        }
    }

    public static class DirectoryEntryCompare
    implements Comparator<VFSFile> {
        private boolean sortIgnoreCase;
        private boolean sortMixFilesAndDirs;

        public DirectoryEntryCompare(boolean sortMixFilesAndDirs, boolean sortIgnoreCase) {
            this.sortMixFilesAndDirs = sortMixFilesAndDirs;
            this.sortIgnoreCase = sortIgnoreCase;
        }

        @Override
        public int compare(VFSFile file1, VFSFile file2) {
            if (!this.sortMixFilesAndDirs && file1.getType() != file2.getType()) {
                return file2.getType() - file1.getType();
            }
            return StandardUtilities.compareStrings(file1.getName(), file2.getName(), this.sortIgnoreCase);
        }
    }
}

