/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.textarea.Anchor;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

class ScrollLineCount
extends Anchor {
    ScrollLineCount(DisplayManager displayManager, TextArea textArea) {
        super(displayManager, textArea);
    }

    @Override
    public void changed() {
    }

    @Override
    public void reset() {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "reset()");
        }
        int scrollLine = 0;
        int physicalLine = this.getDisplayManager().getFirstVisibleLine();
        while (physicalLine != -1) {
            scrollLine += this.getDisplayManager().getScreenLineCount(physicalLine);
            physicalLine = this.getDisplayManager().getNextVisibleLine(physicalLine);
        }
        this.setPhysicalLine(this.getDisplayManager().getBuffer().getLineCount());
        this.setScrollLine(scrollLine);
    }

    @Override
    void preContentInserted(int startLine, int numLines) {
        this.preContentInsertedScrollLines = 0;
        int physicalLine = startLine;
        if (!this.getDisplayManager().isLineVisible(physicalLine)) {
            physicalLine = this.getDisplayManager().getNextVisibleLine(physicalLine);
        }
        this.preContentInsertedScrollLines = this.getDisplayManager().getScreenLineCount(physicalLine);
    }

    @Override
    void contentInserted(int startLine, int numLines) {
        int scrollLines = 0;
        int physicalLine = startLine;
        int i = 0;
        int n = numLines;
        while (i < n) {
            if (this.getDisplayManager().isLineVisible(physicalLine)) {
                scrollLines += this.getDisplayManager().getScreenLineCount(physicalLine);
            }
            ++i;
            ++physicalLine;
        }
        if (!this.getDisplayManager().isLineVisible(physicalLine)) {
            physicalLine = this.getDisplayManager().getNextVisibleLine(physicalLine);
        }
        if (physicalLine >= 0) {
            scrollLines += this.getDisplayManager().getScreenLineCount(physicalLine);
        }
        this.movePhysicalLine(numLines);
        this.moveScrollLine(scrollLines -= this.preContentInsertedScrollLines);
    }

    @Override
    void preContentRemoved(int startLine, int offset, int numLines) {
        int scrollLines = 0;
        int physicalLine = startLine;
        int numLinesVisible = 0;
        int i = 0;
        int n = numLines;
        while (i < n) {
            if (this.getDisplayManager().isLineVisible(physicalLine)) {
                scrollLines += this.getDisplayManager().getScreenLineCount(physicalLine);
                ++numLinesVisible;
            }
            ++i;
            ++physicalLine;
        }
        if (!this.getDisplayManager().isLineVisible(physicalLine)) {
            physicalLine = this.getDisplayManager().getNextVisibleLine(physicalLine);
        }
        if (physicalLine >= 0) {
            scrollLines += this.getDisplayManager().getScreenLineCount(physicalLine);
            ++numLinesVisible;
        }
        this.preContentRemovedScrollLines = scrollLines;
    }

    @Override
    void contentRemoved(int startLine, int startOffset, int numLines) {
        int scrollLines = 0;
        int physicalLine = startLine;
        if (!this.getDisplayManager().isLineVisible(physicalLine)) {
            physicalLine = this.getDisplayManager().getNextVisibleLine(physicalLine);
        }
        scrollLines = this.getDisplayManager().getScreenLineCount(physicalLine);
        this.movePhysicalLine(-numLines);
        this.moveScrollLine(scrollLines -= this.preContentRemovedScrollLines);
    }
}

