/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.io;

import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.MalformedInputException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gjt.sp.jedit.io.CharsetEncoding;
import org.gjt.sp.jedit.io.Encoding;

public class Native2ASCIIEncoding
implements Encoding {
    private final CharsetEncoder asciiEncoder = Charset.forName("ASCII").newEncoder();
    private final CharsetEncoding asciiEncoding = new CharsetEncoding("ASCII");

    @Override
    @Nonnull
    public Reader getTextReader(@Nonnull InputStream in) throws IOException {
        return new Native2ASCIIReader(in, false);
    }

    @Override
    @Nonnull
    public Writer getTextWriter(@Nonnull OutputStream out) throws IOException {
        return new FilterWriter(this.asciiEncoding.getTextWriter(out)){

            @Override
            @Nonnull
            public Writer append(@Nullable CharSequence csq) throws IOException {
                this.write(csq == null ? "null" : ((Object)csq).toString());
                return this;
            }

            @Override
            @Nonnull
            public Writer append(@Nullable CharSequence csq, int start, int end) throws IOException {
                CharSequence cs = csq == null ? "null" : csq;
                this.write(((Object)cs.subSequence(start, end)).toString());
                return this;
            }

            @Override
            @Nonnull
            public Writer append(char c) throws IOException {
                this.write(c);
                return this;
            }

            @Override
            public void write(@Nonnull String str) throws IOException {
                this.write(str, 0, str.length());
            }

            @Override
            public void write(@Nonnull char[] cbuf) throws IOException {
                this.write(cbuf, 0, cbuf.length);
            }

            @Override
            public void write(@Nonnull String str, int off, int len) throws IOException {
                this.write(str.substring(off, off + len).toCharArray());
            }

            @Override
            public void write(@Nonnull char[] cbuf, int off, int len) throws IOException {
                char[] buf = new char[len * 6];
                int i = 0;
                int j2 = off + len;
                for (int j = off; j < j2; ++j) {
                    char c = cbuf[j];
                    if (Native2ASCIIEncoding.this.asciiEncoder.canEncode(c)) {
                        buf[i++] = c;
                        continue;
                    }
                    System.arraycopy(String.format("\\u%04X", c).toCharArray(), 0, buf, i, 6);
                    i += 6;
                }
                super.write(buf, 0, i);
            }

            @Override
            public void write(int c) throws IOException {
                if (Native2ASCIIEncoding.this.asciiEncoder.canEncode((char)c)) {
                    super.write(c);
                } else {
                    this.write(String.format("\\u%04X", c));
                }
            }
        };
    }

    @Override
    @Nonnull
    public Reader getPermissiveTextReader(@Nonnull InputStream in) throws IOException {
        return new Native2ASCIIReader(in, true);
    }

    @Nonnull
    Reader getTextReader(@Nonnull InputStream in, @Nullable Class<? extends PushbackReader> clazz) throws IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return new Native2ASCIIReader(in, false, clazz);
    }

    @Nonnull
    Reader getPermissiveTextReader(@Nonnull InputStream in, @Nullable Class<? extends PushbackReader> clazz) throws IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return new Native2ASCIIReader(in, true, clazz);
    }

    private static class Native2ASCIIReader
    extends FilterReader {
        private static final int MAX_SKIP_BUFFER_SIZE = 8192;
        private static final Encoding iso_8859_1Encoding = new CharsetEncoding("ISO-8859-1");
        private PushbackReader in;
        private boolean permissive;
        private char[] skipBuffer;
        private boolean escaped;

        private Native2ASCIIReader(@Nonnull InputStream in, boolean permissive) throws IOException {
            super(new PushbackReader(iso_8859_1Encoding.getTextReader(in), 5));
            this.in = (PushbackReader)((FilterReader)this).in;
            this.permissive = permissive;
        }

        private Native2ASCIIReader(@Nonnull InputStream in, boolean permissive, @Nullable Class<? extends PushbackReader> clazz) throws IOException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
            super(clazz == null ? new PushbackReader(iso_8859_1Encoding.getTextReader(in), 5) : clazz.getConstructor(Reader.class, Integer.TYPE).newInstance(iso_8859_1Encoding.getTextReader(in), 5));
            this.in = (PushbackReader)((FilterReader)this).in;
            this.permissive = permissive;
        }

        @Override
        public int read() throws IOException {
            int result = this.in.read();
            if (result != 92 || this.escaped) {
                this.escaped = false;
                return result;
            }
            int read = this.in.read();
            if (read == -1) {
                return result;
            }
            if (read != 117) {
                this.escaped = true;
                this.in.unread(read);
                return result;
            }
            char[] escape = new char[]{'u', '\u0000', '\u0000', '\u0000', '\u0000'};
            read = 1 + this.in.read(escape, 1, 4);
            if (read == 0) {
                if (this.permissive) {
                    this.escaped = true;
                    this.in.unread(117);
                    return result;
                }
                throw new MalformedInputException(1);
            }
            while (read < 5) {
                int read2 = this.in.read(escape, read, 5 - read);
                if (read2 == -1) {
                    if (this.permissive) {
                        this.escaped = true;
                        this.in.unread(escape, 0, read);
                        return result;
                    }
                    throw new MalformedInputException(1);
                }
                read += read2;
            }
            for (int i = 1; i < 5; ++i) {
                char e = escape[i];
                if (e >= '0' && e <= '9' || e >= 'a' && e <= 'f' || e >= 'A' && e <= 'F') continue;
                if (this.permissive) {
                    this.escaped = true;
                    this.in.unread(escape, 0, read);
                    return result;
                }
                throw new MalformedInputException(1);
            }
            this.escaped = false;
            return Integer.parseInt(new String(escape, 1, 4), 16);
        }

        @Override
        public int read(CharBuffer target) throws IOException {
            int len = target.remaining();
            char[] cbuf = new char[len];
            int n = this.read(cbuf, 0, len);
            if (n > 0) {
                target.put(cbuf, 0, n);
            }
            return n;
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            return this.read(cbuf, 0, cbuf.length);
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.readn(cbuf, off, len);
        }

        private int readn(char[] cbuf, int off, int len) throws IOException {
            int i;
            int bufLen = len + 5;
            char[] buf = new char[bufLen];
            int read = this.in.read(buf);
            if (read == -1) {
                return read;
            }
            int result = 0;
            int needed = 0;
            block0: for (i = 0; i < read && i < len; ++i) {
                char c = buf[i];
                if (c != '\\' || this.escaped) {
                    this.escaped = false;
                    cbuf[off + result++] = c;
                    continue;
                }
                if (read - i - 1 < 5) {
                    while (read < i + 1 + 5) {
                        int read2 = this.in.read(buf, read, i + 1 + 5 - read);
                        if (read2 == -1) {
                            if (this.permissive || read - i - 1 == 0 || buf[i + 1] != 'u') {
                                this.escaped = true;
                                cbuf[off + result++] = c;
                                continue block0;
                            }
                            throw new MalformedInputException(1);
                        }
                        read += read2;
                    }
                }
                if (buf[i + 1] != 'u') {
                    this.escaped = true;
                    cbuf[off + result++] = c;
                    continue;
                }
                int j2 = i + 6;
                for (int j = i + 2; j < j2; ++j) {
                    char e = buf[j];
                    if (e >= '0' && e <= '9' || e >= 'a' && e <= 'f' || e >= 'A' && e <= 'F') continue;
                    if (this.permissive) {
                        this.escaped = true;
                        cbuf[off + result++] = c;
                        continue block0;
                    }
                    throw new MalformedInputException(1);
                }
                this.escaped = false;
                cbuf[off + result++] = (char)Integer.parseInt(new String(buf, i + 2, 4), 16);
                needed += Math.min(len - i - 1, 5);
                i += 5;
            }
            this.in.unread(buf, i, read - i);
            if (needed == 0) {
                return result;
            }
            read = this.readn(cbuf, off + result, needed);
            if (read == -1) {
                return result;
            }
            return result + read;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long toSkip) throws IOException {
            long remaining;
            if (toSkip < 0L) {
                throw new IllegalArgumentException("skip value is negative");
            }
            int skipBufferSize = (int)Math.min(toSkip, 8192L);
            if (this.skipBuffer == null || this.skipBuffer.length < skipBufferSize) {
                this.skipBuffer = new char[skipBufferSize];
            }
            PushbackReader pushbackReader = this.in;
            synchronized (pushbackReader) {
                int skipped;
                for (remaining = toSkip; remaining > 0L && (skipped = this.read(this.skipBuffer, 0, (int)Math.min(remaining, (long)skipBufferSize))) != -1; remaining -= (long)skipped) {
                }
            }
            return toSkip - remaining;
        }
    }
}

