/*
 * Decompiled with CFR 0.152.
 */
package jnpad;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jnpad.JNPadCardViewer;
import jnpad.text.Buffer;
import jnpad.text.BufferSet;
import jnpad.text.Viewer;
import jnpad.ui.tab.CardTabbedPane;

public class JNPadCardPane
extends CardTabbedPane
implements BufferSet {
    private JNPadCardViewer viewer;
    private static final long serialVersionUID = -1555865677176455496L;

    public JNPadCardPane(JNPadCardViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public Viewer getViewer() {
        return this.viewer;
    }

    @Override
    public Buffer getSelectedBuffer() {
        return (Buffer)this.getSelectedComponent();
    }

    @Override
    public Buffer getBufferAt(int index) {
        return (Buffer)this.getComponentAt(index);
    }

    @Override
    public int getBufferCount() {
        return this.getTabCount();
    }

    @Override
    public void setActiveLineVisible(boolean b) {
        int i = 0;
        while (i < this.getTabCount()) {
            this.getBufferAt(i).setActiveLineVisible(b);
            ++i;
        }
    }

    @Override
    public void setLineNumbersVisible(boolean b) {
        int i = 0;
        while (i < this.getBufferCount()) {
            this.getBufferAt(i).setLineNumbersVisible(b);
            ++i;
        }
    }

    @Override
    public void setLineWrap(boolean b) {
        int i = 0;
        while (i < this.getBufferCount()) {
            this.getBufferAt(i).setLineWrap(b);
            ++i;
        }
    }

    @Override
    public void setRightMarginLineVisible(boolean b) {
        int i = 0;
        while (i < this.getBufferCount()) {
            this.getBufferAt(i).setRightMarginLineVisible(b);
            ++i;
        }
    }

    @Override
    public void setMarkStripVisible(boolean b) {
        int i = 0;
        while (i < this.getBufferCount()) {
            this.getBufferAt(i).setMarkStripVisible(b);
            ++i;
        }
    }

    @Override
    public void setOccurrencesHighlighterVisible(boolean b) {
        int i = 0;
        while (i < this.getBufferCount()) {
            this.getBufferAt(i).setOccurrencesHighlighterVisible(b);
            ++i;
        }
    }

    @Override
    public void setBracketHighlighterVisible(boolean b) {
        int i = 0;
        while (i < this.getBufferCount()) {
            this.getBufferAt(i).setBracketHighlighterVisible(b);
            ++i;
        }
    }

    @Override
    public Iterator<Buffer> iterator() {
        return new Itr();
    }

    private class Itr
    implements Iterator<Buffer> {
        int pos = 0;
        int lastRet = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < JNPadCardPane.this.getTabCount();
        }

        @Override
        public Buffer next() {
            try {
                Buffer next = JNPadCardPane.this.getBufferAt(this.pos);
                this.lastRet = this.pos++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            try {
                JNPadCardPane.this.removeTabAt(this.lastRet);
                if (this.lastRet < this.pos) {
                    --this.pos;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

