/*
 * Decompiled with CFR 0.152.
 */
package jnpad;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnpad.JNPadInput;
import jnpad.config.Config;

public class JNPadParser {
    private String file;
    private List<JNPadInput> jNPadInputs = new ArrayList<JNPadInput>();
    private static final Logger LOGGER = Logger.getLogger(JNPadParser.class.getName());

    public JNPadParser(String file) {
        this.file = file;
    }

    public void load() throws IOException {
        this.clear();
        BufferedReader in = null;
        try {
            try {
                String line;
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8"));
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() < 1 || line.startsWith("#")) continue;
                    int i = line.indexOf(35);
                    if (i != -1) {
                        line = line.substring(0, i);
                    }
                    try {
                        this.jNPadInputs.add(Config.parseJNPadInput(line));
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.warning(ex.getMessage());
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex2) {
                    LOGGER.log(Level.WARNING, ex2.getMessage(), ex2);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    public void add(JNPadInput in) {
        this.jNPadInputs.add(in);
    }

    public void addAll(Collection<? extends JNPadInput> c) {
        this.jNPadInputs.addAll(c);
    }

    public void clear() {
        this.jNPadInputs.clear();
    }

    public List<JNPadInput> getJNPadInputList() {
        return this.jNPadInputs;
    }

    public void save() throws IOException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF-8"));
            pw.println("# ===========================================================================");
            pw.println("# JNPad session");
            pw.println("# ===========================================================================");
            for (JNPadInput jNPadInput : this.jNPadInputs) {
                pw.println(Config.writeJNPadInputProp(jNPadInput));
            }
            pw.println("# ===========================================================================");
        }
        finally {
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

