/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import jnpad.JNPadFrame;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.text.EditPane;
import jnpad.text.IEditAction;
import jnpad.text.JNPadTextArea;

public final class InsertFileFullNameAction
extends JNPadAction
implements IEditAction {
    private static final Logger LOGGER = Logger.getLogger(InsertFileFullNameAction.class.getName());
    private static final long serialVersionUID = -4651213839679323573L;

    public InsertFileFullNameAction(JNPadFrame jNPad) {
        super(jNPad, "insert-file-full-name", JNPadActions.Group.EDIT, Accelerators.INSERT_FILE_FULL_NAME, null);
    }

    @Override
    public void performAction() {
        EditPane editPane = this.jNPad.getActiveEditPane();
        if (editPane != null) {
            File file = new File(editPane.getFilePath());
            if (!file.exists()) {
                return;
            }
            try {
                String fullName = file.getName();
                JNPadTextArea target = editPane.getTextArea();
                Document doc = target.getDocument();
                int caretPosition = target.getCaretPosition();
                doc.insertString(caretPosition, fullName, null);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }
}

