/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import jnpad.JNPadFrame;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.text.EditPane;
import jnpad.text.IEditAction;
import jnpad.text.JNPadTextArea;

public final class InsertFilePathAction
extends JNPadAction
implements IEditAction {
    private static final Logger LOGGER = Logger.getLogger(InsertFilePathAction.class.getName());
    private static final long serialVersionUID = 4564309053801516834L;

    public InsertFilePathAction(JNPadFrame jNPad) {
        super(jNPad, "insert-file-path", JNPadActions.Group.EDIT, Accelerators.INSERT_FILE_PATH, null);
    }

    @Override
    public void performAction() {
        EditPane editPane = this.jNPad.getActiveEditPane();
        if (editPane != null) {
            File file = new File(editPane.getFilePath());
            if (!file.exists()) {
                return;
            }
            try {
                String parent = file.getParent();
                JNPadTextArea target = editPane.getTextArea();
                Document doc = target.getDocument();
                int caretPosition = target.getCaretPosition();
                doc.insertString(caretPosition, parent, null);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }
}

