/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.event.ItemEvent;
import jnpad.JNPadFrame;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.config.ViewActionScope;
import jnpad.text.Viewer;

public final class LineNumbersAction
extends JNPadAction {
    private static final long serialVersionUID = -4155660358833356341L;

    public LineNumbersAction(JNPadFrame jNPad) {
        super(jNPad, "line-numbers", JNPadActions.Group.VIEW, Accelerators.LINE_NUMBERS, "line-numbers.png");
        this.setSelected(Config.GUTTER_VISIBLE.getValue());
        this.setStateAction(true);
    }

    @Override
    public void handleStateChanged(ItemEvent e) {
        ViewActionScope scope = Config.VIEW_ACTION_SCOPE.getValue();
        Viewer viewer = this.jNPad.getViewer();
        switch (scope) {
            case VIEWER: {
                viewer.setLineNumbersVisible(1 == e.getStateChange());
                break;
            }
            case BUFFER_SET: {
                viewer.getActiveBufferSet().setLineNumbersVisible(1 == e.getStateChange());
                break;
            }
            case EDIT_PANE: {
                viewer.getActiveEditPane().setLineNumbersVisible(1 == e.getStateChange());
                break;
            }
            default: {
                viewer.getActiveBuffer().setLineNumbersVisible(1 == e.getStateChange());
            }
        }
    }
}

