/*
 * Decompiled with CFR 0.152.
 */
package jnpad.config;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnpad.GUIUtilities;
import jnpad.JNPad;
import jnpad.JNPadInput;
import jnpad.config.BooleanProp;
import jnpad.config.BooleanProp2;
import jnpad.config.ColorProp;
import jnpad.config.DoubleProp;
import jnpad.config.FloatProp;
import jnpad.config.FontProp;
import jnpad.config.IntProp;
import jnpad.config.Mode;
import jnpad.config.ModeProp;
import jnpad.config.Prop;
import jnpad.config.PropChangeListener;
import jnpad.config.StringProp;
import jnpad.config.ViewActionScope;
import jnpad.config.ViewActionScopeProp;
import jnpad.ui.plaf.LAFUtils;
import jnpad.util.Platform;
import jnpad.util.Utilities;

public final class Config {
    public static final String PROPERTIES_FILE_PATH = String.valueOf(JNPad.PROPS_DIR) + Utilities.DIR_SEPARATOR + "jnpad.properties";
    public static final String DEFAULTS_FILE_PATH = String.valueOf(JNPad.PROPS_DIR) + Utilities.DIR_SEPARATOR + "jnpad.defaults.properties";
    public static final String SEARCH_FILE_PATH = String.valueOf(JNPad.PROPS_DIR) + Utilities.DIR_SEPARATOR + "search.properties";
    private static List<String> findList = new ArrayList<String>();
    private static List<String> replaceList = new ArrayList<String>();
    public static final String COLORSCHEMES_DIR = String.valueOf(JNPad.PROPS_DIR) + Utilities.DIR_SEPARATOR + "colors";
    public static final String KEYMAP_DIR = String.valueOf(JNPad.PROPS_DIR) + Utilities.DIR_SEPARATOR + "keymaps";
    private static Locale locale;
    private static String homeDir;
    private static Properties options;
    private static Properties defaults;
    private static Properties changes;
    private static List<String> removes;
    public static final String AUTO = "auto";
    public static final IntProp JNPAD_X;
    public static final IntProp JNPAD_Y;
    public static final IntProp JNPAD_WIDTH;
    public static final IntProp JNPAD_HEIGHT;
    public static final BooleanProp JNPAD_MAXIMIZE;
    public static final StringProp JNPAD_COLORSCHEME;
    public static final StringProp JNPAD_KEYMAP;
    public static final StringProp JNPAD_LAF;
    public static final BooleanProp JNPAD_LAF_BOLD_METAL;
    public static final StringProp JNPAD_LANG;
    public static final ModeProp JNPAD_MODE;
    private static Mode mode;
    private static boolean mode_setting_flag;
    public static final BooleanProp JNPAD_ANTIALIAS;
    public static final BooleanProp TOOLBARS_FILE_SELECTED;
    public static final BooleanProp TOOLBARS_EDIT_RECANTATION_SELECTED;
    public static final BooleanProp TOOLBARS_EDIT_CLIPBOARD_SELECTED;
    public static final BooleanProp TOOLBARS_EDIT_SELECTION_SELECTED;
    public static final BooleanProp TOOLBARS_EDIT_DELETION_SELECTED;
    public static final BooleanProp TOOLBARS_SEARCH_SELECTED;
    public static final BooleanProp TOOLBARS_VIEW_SELECTED;
    public static final BooleanProp TOOLBARS_FORMAT_SELECTED;
    public static final BooleanProp TOOLBARS_WINDOWS_SELECTED;
    public static final FontProp TITLED_LABEL_FONT;
    public static final ColorProp TITLED_LABEL_FOREGROUND;
    public static final ColorProp TITLED_LABEL_GRADIENT1;
    public static final ColorProp TITLED_LABEL_GRADIENT2;
    public static final IntProp TITLED_LABEL_ORIENTATION;
    public static final FontProp TEXT_FONT;
    public static final ColorProp TEXT_BACKGROUND;
    public static final ColorProp TEXT_FOREGROUND;
    public static final ColorProp TEXT_SELECTION_BACKGROUND;
    public static final ColorProp TEXT_SELECTION_FOREGROUND;
    public static final ColorProp TEXT_CARET_INS_COLOR;
    public static final ColorProp TEXT_CARET_OVR_COLOR;
    public static final IntProp TEXT_TAB_SIZE;
    public static final BooleanProp TEXT_TAB_ENABLED;
    public static final BooleanProp TEXT_AUTO_INDENT;
    public static final BooleanProp TEXT_AUTO_CLOSE_BRACKETS;
    public static final BooleanProp TEXT_RIGHT_MARGIN_LINE_VISIBLE;
    public static final IntProp TEXT_RIGHT_MARGIN_LINE_WIDTH;
    public static final ColorProp TEXT_RIGHT_MARGIN_LINE_COLOR;
    public static final BooleanProp TEXT_LINE_WRAP;
    public static final BooleanProp TEXT_AUTOCOMPLETION_ENABLED;
    public static final BooleanProp TEXT_AUTOCOMPLETION_ALL;
    public static final IntProp TEXT_AUTOCOMPLETION_TRIGGER;
    public static final StringProp TEXT_DELIMITERS;
    public static final BooleanProp SYNTAX_CLASSIFY_ENABLED;
    public static final BooleanProp SYNTAX_KNOWN_ENABLED;
    public static final ColorProp SYNTAX_COMMENT_COLOR;
    public static final IntProp SYNTAX_COMMENT_STYLE;
    public static final ColorProp SYNTAX_COMMENT1_COLOR;
    public static final IntProp SYNTAX_COMMENT1_STYLE;
    public static final ColorProp SYNTAX_COMMENT2_COLOR;
    public static final IntProp SYNTAX_COMMENT2_STYLE;
    public static final ColorProp SYNTAX_COMMENT3_COLOR;
    public static final IntProp SYNTAX_COMMENT3_STYLE;
    public static final ColorProp SYNTAX_COMMENT4_COLOR;
    public static final IntProp SYNTAX_COMMENT4_STYLE;
    public static final ColorProp SYNTAX_STRING_COLOR;
    public static final IntProp SYNTAX_STRING_STYLE;
    public static final ColorProp SYNTAX_NUMBER_COLOR;
    public static final ColorProp SYNTAX_KEYWORD_COLOR;
    public static final IntProp SYNTAX_KEYWORD_STYLE;
    public static final ColorProp SYNTAX_KEYWORD2_COLOR;
    public static final IntProp SYNTAX_KEYWORD2_STYLE;
    public static final ColorProp SYNTAX_KEYWORD3_COLOR;
    public static final IntProp SYNTAX_KEYWORD3_STYLE;
    public static final ColorProp SYNTAX_KEYWORD4_COLOR;
    public static final IntProp SYNTAX_KEYWORD4_STYLE;
    public static final ColorProp SYNTAX_KEYWORD5_COLOR;
    public static final IntProp SYNTAX_KEYWORD5_STYLE;
    public static final ColorProp SYNTAX_KEYWORD6_COLOR;
    public static final IntProp SYNTAX_KEYWORD6_STYLE;
    public static final ColorProp SYNTAX_KEYWORD7_COLOR;
    public static final IntProp SYNTAX_KEYWORD7_STYLE;
    public static final ColorProp SYNTAX_KEYWORD8_COLOR;
    public static final IntProp SYNTAX_KEYWORD8_STYLE;
    public static final ColorProp SYNTAX_KEYWORD9_COLOR;
    public static final IntProp SYNTAX_KEYWORD9_STYLE;
    public static final BooleanProp SYNTAX_CLASSIFY2_ENABLED;
    public static final ColorProp SYNTAX_KEYWORD10_COLOR;
    public static final IntProp SYNTAX_KEYWORD10_STYLE;
    public static final ColorProp SYNTAX_KEYWORD11_COLOR;
    public static final IntProp SYNTAX_KEYWORD11_STYLE;
    public static final ColorProp SYNTAX_OPERATOR_COLOR;
    public static final IntProp SYNTAX_OPERATOR_STYLE;
    public static final ColorProp SYNTAX_BRACKET_COLOR;
    public static final IntProp SYNTAX_BRACKET_STYLE;
    public static final BooleanProp GUTTER_VISIBLE;
    public static final ColorProp GUTTER_BACKGROUND;
    public static final ColorProp GUTTER_FOREGROUND;
    public static final ColorProp GUTTER_CURRENT_FOREGROUND;
    public static final ColorProp GUTTER_CURRENT_BACKGROUND;
    public static final BooleanProp GUTTER_CURRENT_BACKGROUND_ENABLED;
    public static final BooleanProp GUTTER_UPDATE_FONT;
    public static final IntProp GUTTER_BORDER_GAP;
    public static final IntProp GUTTER_BORDER_WIDTH;
    public static final BooleanProp GUTTER_BORDER_VISIBLE;
    public static final ColorProp GUTTER_BORDER_COLOR;
    public static final ColorProp GUTTER_SELECTION_COLOR;
    public static final ColorProp GUTTER_SELECTION_BORDER_COLOR;
    public static final IntProp GUTTER_SELECTION_WIDTH;
    public static final BooleanProp GUTTER_SELECTION_BORDER;
    public static final ColorProp GUTTER_BOOKMARK_BACKGROUND;
    public static final ColorProp GUTTER_BOOKMARK_COLOR;
    public static final ColorProp GUTTER_BOOKMARK_BORDER_COLOR;
    public static final IntProp GUTTER_BOOKMARK_WIDTH;
    public static final IntProp GUTTER_BOOKMARK_GAP;
    public static final BooleanProp GUTTER_BRACKET_SCOPE_VISIBLE;
    public static final ColorProp GUTTER_BRACKET_SCOPE_COLOR;
    public static final BooleanProp USE_CUSTOM_SHORTCUTS;
    public static final IntProp UNDO_LIMIT;
    public static final BooleanProp ACTIVE_LINE_VISIBLE;
    public static final ColorProp ACTIVE_LINE_COLOR;
    public static final BooleanProp BOOKMARKING_ENABLED;
    public static final BooleanProp OCCURRENCES_HIGHLIGHTER_VISIBLE;
    public static final ColorProp OCCURRENCES_HIGHLIGHTER_COLOR;
    public static final ColorProp OCCURRENCES_HIGHLIGHTER_BORDER_COLOR;
    public static final BooleanProp OCCURRENCES_CIRCULAR_NAVIGATION;
    public static final BooleanProp BOOKMARKS_CIRCULAR_NAVIGATION;
    public static final ColorProp SEARCH_HIGHLIGHTER_COLOR;
    public static final ColorProp SEARCH_HIGHLIGHTER_BORDER_COLOR;
    public static final BooleanProp BRACKET_HIGHLIGHTER_VISIBLE;
    public static final ColorProp BRACKET_HIGHLIGHTER_COLOR;
    public static final StringProp CHOOSER_FILE_DIRECTORY;
    public static final IntProp FILES_RECENT_MAX;
    public static final BooleanProp SECURE_SAVE;
    public static final StringProp FILE_ENCODING;
    public static final BooleanProp REMOVE_END_SPACES;
    public static final BooleanProp TOOLBAR_VISIBLE;
    public static final BooleanProp STATUSBAR_VISIBLE;
    public static final BooleanProp FINDRESULTS_VISIBLE;
    public static final BooleanProp HEAP_MONITOR_VISIBLE;
    public static final BooleanProp TOOLBAR_ROWS;
    public static final StringProp DATE_FORMAT;
    public static final ViewActionScopeProp VIEW_ACTION_SCOPE;
    public static final IntProp TAB_LAYOUT_POLICY;
    public static final IntProp TAB_PLACEMENT;
    public static final BooleanProp TAB_FILE_EXTENSION;
    public static final BooleanProp TAB_FILE_ICON;
    public static final BooleanProp TAB_CLOSE_BUTTON;
    public static final BooleanProp TAB_ROUNDED;
    public static final BooleanProp TAB_TABBED;
    public static final BooleanProp SPLIT_CONTINUOUS_LAYOUT;
    public static final IntProp SPLIT_DIVIDER_SIZE;
    public static final BooleanProp MARKER_VISIBLE;
    public static final ColorProp MARKER_OCCURRENCE_COLOR;
    public static final ColorProp MARKER_OCCURRENCE_BORDER_COLOR;
    public static final ColorProp MARKER_SEARCH_COLOR;
    public static final ColorProp MARKER_SEARCH_BORDER_COLOR;
    public static final ColorProp MARKER_BOOKMARK_COLOR;
    public static final ColorProp MARKER_BOOKMARK_BORDER_COLOR;
    public static final ColorProp MARKER_CARET_COLOR;
    public static final IntProp MARKER_PREFERRED_WIDTH;
    public static final FontProp BROWSER_NORMAL_FONT;
    public static final FontProp BROWSER_BOLD_FONT;
    public static final FontProp BROWSER_DEVICE_FONT;
    public static final ColorProp BROWSER_DIR_FOREGROUND;
    public static final ColorProp BROWSER_EXEC_FOREGROUND;
    public static final ColorProp BROWSER_LINK_FOREGROUND;
    public static final ColorProp BROWSER_COMP_FOREGROUND;
    public static final ColorProp BROWSER_IMAGE_FOREGROUND;
    public static final ColorProp BROWSER_AUDIO_FOREGROUND;
    public static final BooleanProp BROWSER_COLORS_ENABLED;
    public static final BooleanProp BROWSER_HUMAN_READABLE;
    public static final BooleanProp BROWSER_CLASSIFY;
    public static final BooleanProp BROWSER_INFO_VISIBLE;
    public static final FloatProp BROWSER_TRANSPARENCY;
    public static final DoubleProp BROWSER_LOCATION_HORIZONTAL;
    public static final DoubleProp BROWSER_LOCATION_VERTICAL;
    public static final BooleanProp MINIMAP_VIEWRECT_VISIBLE;
    public static final ColorProp MINIMAP_VIEWRECT_COLOR;
    public static final ColorProp MINIMAP_VIEWRECT_BORDER_COLOR;
    public static final FloatProp MINIMAP_FONT_SIZE;
    public static final FloatProp PERFORM_ACTION_TRANSPARENCY;
    public static final DoubleProp PERFORM_ACTION_LOCATION_HORIZONTAL;
    public static final DoubleProp PERFORM_ACTION_LOCATION_VERTICAL;
    public static final IntProp PERFORM_ACTION_COLUMNS;
    public static final IntProp FIND_LOOKIN;
    public static final BooleanProp FIND_FROMCURSOR;
    public static final BooleanProp FIND_MATCH_CASE;
    public static final BooleanProp FIND_MATCH_WHOLEWORD;
    public static final BooleanProp FIND_DIRECTION_DOWN;
    public static final BooleanProp FIND_HIGHLIGHT_ALL;
    public static final BooleanProp FIND_REGEX;
    public static final IntProp REPLACE_LOOKIN;
    public static final BooleanProp REPLACE_FROMCURSOR;
    public static final BooleanProp REPLACE_MATCH_CASE;
    public static final BooleanProp REPLACE_MATCH_WHOLEWORD;
    public static final BooleanProp REPLACE_DIRECTION_DOWN;
    public static final BooleanProp REPLACE_HIGHLIGHT_ALL;
    public static final BooleanProp REPLACE_REGEX;
    public static final BooleanProp PRINT_LINE_NUMBERS;
    public static final BooleanProp PRINT_HEADER;
    public static final BooleanProp PRINT_WRAP_TEXT;
    public static final FontProp PRINT_FONT;
    private static boolean isAdjustPostLAFChangedEnabled;
    private static boolean isAdjustPostModeChangedEnabled;
    private static final Logger LOGGER;

    static {
        homeDir = System.getProperty("user.dir", "");
        removes = new ArrayList<String>();
        JNPAD_X = new IntProp("jnpad.x", Integer.MIN_VALUE);
        JNPAD_Y = new IntProp("jnpad.y", Integer.MIN_VALUE);
        JNPAD_WIDTH = new IntProp("jnpad.width", 740);
        JNPAD_HEIGHT = new IntProp("jnpad.height", 576);
        JNPAD_MAXIMIZE = new BooleanProp("jnpad.maximize", false);
        JNPAD_COLORSCHEME = new StringProp("jnpad.colorscheme", "default");
        JNPAD_KEYMAP = new StringProp("jnpad.keymap", "jnpad-default");
        JNPAD_LAF = new StringProp("jnpad.laf", "System");
        JNPAD_LAF_BOLD_METAL = new BooleanProp("jnpad.laf.boldMetal", false);
        JNPAD_LANG = new StringProp("jnpad.lang", AUTO);
        JNPAD_MODE = new ModeProp("jnpad.mode", Mode.DEFAULT);
        JNPAD_ANTIALIAS = new BooleanProp2("jnpad.antialias", false);
        TOOLBARS_FILE_SELECTED = new BooleanProp("toolbars.file.selected", true);
        TOOLBARS_EDIT_RECANTATION_SELECTED = new BooleanProp("toolbars.edit.recantation.selected", true);
        TOOLBARS_EDIT_CLIPBOARD_SELECTED = new BooleanProp("toolbars.edit.clipboard.selected", true);
        TOOLBARS_EDIT_SELECTION_SELECTED = new BooleanProp("toolbars.edit.selection.selected", true);
        TOOLBARS_EDIT_DELETION_SELECTED = new BooleanProp("toolbars.edit.deletion.selected", true);
        TOOLBARS_SEARCH_SELECTED = new BooleanProp("toolbars.search.selected", true);
        TOOLBARS_VIEW_SELECTED = new BooleanProp("toolbars.view.selected", true);
        TOOLBARS_FORMAT_SELECTED = new BooleanProp("toolbars.format.selected", true);
        TOOLBARS_WINDOWS_SELECTED = new BooleanProp("toolbars.window.selected", true);
        TITLED_LABEL_FONT = new FontProp("titled.label.font", new Font("Dialog", 1, 11));
        TITLED_LABEL_FOREGROUND = new ColorProp("titled.label.foreground", Color.WHITE);
        TITLED_LABEL_GRADIENT1 = new ColorProp("titled.label.gradient1", new Color(0, 0, 205));
        TITLED_LABEL_GRADIENT2 = new ColorProp("titled.label.gradient2", Color.BLUE);
        TITLED_LABEL_ORIENTATION = new IntProp("titled.label.orientation", 10);
        TEXT_BACKGROUND = new ColorProp("text.background", Color.WHITE);
        TEXT_FOREGROUND = new ColorProp("text.foreground", Color.BLACK);
        TEXT_SELECTION_BACKGROUND = new ColorProp("text.selection.background", new Color(49, 106, 197));
        TEXT_SELECTION_FOREGROUND = new ColorProp("text.selection.foreground", Color.WHITE);
        TEXT_CARET_INS_COLOR = new ColorProp("text.caret.ins.color", Color.BLACK);
        TEXT_CARET_OVR_COLOR = new ColorProp("text.caret.ovr.color", new Color(0, 0, 128));
        TEXT_TAB_SIZE = new IntProp("text.tab.size", 4);
        TEXT_TAB_ENABLED = new BooleanProp("text.tab.enabled", true);
        TEXT_AUTO_INDENT = new BooleanProp("text.auto.indent", true);
        TEXT_AUTO_CLOSE_BRACKETS = new BooleanProp("text.auto.close.brackets", true);
        TEXT_RIGHT_MARGIN_LINE_VISIBLE = new BooleanProp("text.right.margin.line.visible", false);
        TEXT_RIGHT_MARGIN_LINE_WIDTH = new IntProp("text.right.margin.line.width", 80);
        TEXT_RIGHT_MARGIN_LINE_COLOR = new ColorProp("text.right.margin.line.color", new Color(192, 192, 192, 100));
        TEXT_LINE_WRAP = new BooleanProp("text.line.wrap", false);
        TEXT_AUTOCOMPLETION_ENABLED = new BooleanProp("text.autocompletion.enabled", false);
        TEXT_AUTOCOMPLETION_ALL = new BooleanProp("text.autocompletion.all", false);
        TEXT_AUTOCOMPLETION_TRIGGER = new IntProp("text.autocompletion.trigger", 4);
        TEXT_DELIMITERS = new StringProp("text.delimiters", "!@%^&*()-=+[]{};:'\",.<>/?");
        SYNTAX_CLASSIFY_ENABLED = new BooleanProp("syntax.classify.enabled", true);
        SYNTAX_KNOWN_ENABLED = new BooleanProp("syntax.known.enabled", true);
        SYNTAX_COMMENT_COLOR = new ColorProp("syntax.comment.color", new Color(0, 128, 0));
        SYNTAX_COMMENT_STYLE = new IntProp("syntax.comment.style", 2);
        SYNTAX_COMMENT1_COLOR = new ColorProp("syntax.comment1.color", new Color(0, 128, 64));
        SYNTAX_COMMENT1_STYLE = new IntProp("syntax.comment1.style", 0);
        SYNTAX_COMMENT2_COLOR = new ColorProp("syntax.comment2.color", new Color(0, 128, 64));
        SYNTAX_COMMENT2_STYLE = new IntProp("syntax.comment2.style", 1);
        SYNTAX_COMMENT3_COLOR = new ColorProp("syntax.comment3.color", new Color(128, 128, 128));
        SYNTAX_COMMENT3_STYLE = new IntProp("syntax.comment3.style", 0);
        SYNTAX_COMMENT4_COLOR = new ColorProp("syntax.comment4.color", new Color(0, 128, 64));
        SYNTAX_COMMENT4_STYLE = new IntProp("syntax.comment4.style", 2);
        SYNTAX_STRING_COLOR = new ColorProp("syntax.string.color", new Color(75, 0, 130));
        SYNTAX_STRING_STYLE = new IntProp("syntax.string.style", 0);
        SYNTAX_NUMBER_COLOR = new ColorProp("syntax.number.color", new Color(51, 102, 255));
        SYNTAX_KEYWORD_COLOR = new ColorProp("syntax.keyword.color", new Color(0, 0, 139));
        SYNTAX_KEYWORD_STYLE = new IntProp("syntax.keyword.style", 1);
        SYNTAX_KEYWORD2_COLOR = new ColorProp("syntax.keyword2.color", new Color(0, 0, 255));
        SYNTAX_KEYWORD2_STYLE = new IntProp("syntax.keyword2.style", 1);
        SYNTAX_KEYWORD3_COLOR = new ColorProp("syntax.keyword3.color", new Color(51, 102, 255));
        SYNTAX_KEYWORD3_STYLE = new IntProp("syntax.keyword3.style", 1);
        SYNTAX_KEYWORD4_COLOR = new ColorProp("syntax.keyword4.color", new Color(0, 0, 255));
        SYNTAX_KEYWORD4_STYLE = new IntProp("syntax.keyword4.style", 0);
        SYNTAX_KEYWORD5_COLOR = new ColorProp("syntax.keyword5.color", new Color(0, 0, 205));
        SYNTAX_KEYWORD5_STYLE = new IntProp("syntax.keyword5.style", 1);
        SYNTAX_KEYWORD6_COLOR = new ColorProp("syntax.keyword6.color", new Color(0, 0, 205));
        SYNTAX_KEYWORD6_STYLE = new IntProp("syntax.keyword6.style", 0);
        SYNTAX_KEYWORD7_COLOR = new ColorProp("syntax.keyword7.color", new Color(208, 0, 0));
        SYNTAX_KEYWORD7_STYLE = new IntProp("syntax.keyword7.style", 1);
        SYNTAX_KEYWORD8_COLOR = new ColorProp("syntax.keyword8.color", new Color(0, 0, 128));
        SYNTAX_KEYWORD8_STYLE = new IntProp("syntax.keyword8.style", 0);
        SYNTAX_KEYWORD9_COLOR = new ColorProp("syntax.keyword9.color", new Color(64, 64, 139));
        SYNTAX_KEYWORD9_STYLE = new IntProp("syntax.keyword9.style", 1);
        SYNTAX_CLASSIFY2_ENABLED = new BooleanProp("syntax.classify2.enabled", false);
        SYNTAX_KEYWORD10_COLOR = new ColorProp("syntax.keyword10.color", new Color(0, 0, 128));
        SYNTAX_KEYWORD10_STYLE = new IntProp("syntax.keyword10.style", 0);
        SYNTAX_KEYWORD11_COLOR = new ColorProp("syntax.keyword11.color", new Color(0, 0, 128));
        SYNTAX_KEYWORD11_STYLE = new IntProp("syntax.keyword11.style", 0);
        SYNTAX_OPERATOR_COLOR = new ColorProp("syntax.operator.color", new Color(208, 0, 0));
        SYNTAX_OPERATOR_STYLE = new IntProp("syntax.operator.style", 0);
        SYNTAX_BRACKET_COLOR = new ColorProp("syntax.bracket.color", new Color(153, 17, 17));
        SYNTAX_BRACKET_STYLE = new IntProp("syntax.bracket.style", 1);
        GUTTER_VISIBLE = new BooleanProp("gutter.visible", true);
        GUTTER_BACKGROUND = new ColorProp("gutter.background", new Color(239, 237, 226));
        GUTTER_FOREGROUND = new ColorProp("gutter.foreground", new Color(157, 156, 180));
        GUTTER_CURRENT_FOREGROUND = new ColorProp("gutter.current.foreground", new Color(0, 0, 128));
        GUTTER_CURRENT_BACKGROUND = new ColorProp("gutter.current.background", new Color(239, 237, 226));
        GUTTER_CURRENT_BACKGROUND_ENABLED = new BooleanProp("gutter.current.background.enabled", false);
        GUTTER_UPDATE_FONT = new BooleanProp("gutter.update.font", true);
        GUTTER_BORDER_GAP = new IntProp("gutter.border.gap", 10);
        GUTTER_BORDER_WIDTH = new IntProp("gutter.border.width", 1);
        GUTTER_BORDER_VISIBLE = new BooleanProp("gutter.border.visible", true);
        GUTTER_BORDER_COLOR = new ColorProp("gutter.border.color", new Color(201, 199, 190));
        GUTTER_SELECTION_COLOR = new ColorProp("gutter.selection.color", new Color(255, 255, 156));
        GUTTER_SELECTION_BORDER_COLOR = new ColorProp("gutter.selection.border.color", ((Color)GUTTER_SELECTION_COLOR.getDefault()).darker());
        GUTTER_SELECTION_WIDTH = new IntProp("gutter.selection.width", 3);
        GUTTER_SELECTION_BORDER = new BooleanProp("gutter.selection.border", true);
        GUTTER_BOOKMARK_BACKGROUND = new ColorProp("gutter.bookmark.background", new Color(224, 220, 199));
        GUTTER_BOOKMARK_COLOR = new ColorProp("gutter.bookmark.color", new Color(135, 188, 247));
        GUTTER_BOOKMARK_BORDER_COLOR = new ColorProp("gutter.bookmark.border.color", new Color(14, 98, 164));
        GUTTER_BOOKMARK_WIDTH = new IntProp("gutter.bookmark.width", 7);
        GUTTER_BOOKMARK_GAP = new IntProp("gutter.bookmark.gap", 2);
        GUTTER_BRACKET_SCOPE_VISIBLE = new BooleanProp("gutter.bracket.scope.visible", true);
        GUTTER_BRACKET_SCOPE_COLOR = new ColorProp("gutter.bracket.scope.color", new Color(224, 220, 199));
        USE_CUSTOM_SHORTCUTS = new BooleanProp2("shortcuts.custom", false);
        UNDO_LIMIT = new IntProp("undo.limit", 1000);
        ACTIVE_LINE_VISIBLE = new BooleanProp("active.line.visible", true);
        ACTIVE_LINE_COLOR = new ColorProp("active.line.color", new Color(232, 232, 255));
        BOOKMARKING_ENABLED = new BooleanProp("bookmarking.enabled", true);
        OCCURRENCES_HIGHLIGHTER_VISIBLE = new BooleanProp("occurrences.highlighter.visible", true);
        OCCURRENCES_HIGHLIGHTER_COLOR = new ColorProp("occurrences.highlighter.color", new Color(155, 255, 155, 200));
        OCCURRENCES_HIGHLIGHTER_BORDER_COLOR = new ColorProp("occurrences.highlighter.border.color", new Color(0, 128, 0, 200));
        OCCURRENCES_CIRCULAR_NAVIGATION = new BooleanProp("occurrences.circular.navigation", true);
        BOOKMARKS_CIRCULAR_NAVIGATION = new BooleanProp("bookmarks.circular.navigation", true);
        SEARCH_HIGHLIGHTER_COLOR = new ColorProp("search.highlighter.color", new Color(255, 200, 0, 200));
        SEARCH_HIGHLIGHTER_BORDER_COLOR = new ColorProp("search.highlighter.border.color", new Color(255, 102, 0, 200));
        BRACKET_HIGHLIGHTER_VISIBLE = new BooleanProp("bracket.highlighter.visible", true);
        BRACKET_HIGHLIGHTER_COLOR = new ColorProp("bracket.highlighter.color", new Color(255, 128, 128, 128));
        CHOOSER_FILE_DIRECTORY = new StringProp("chooser.file.directory", System.getProperty("user.dir", ""));
        FILES_RECENT_MAX = new IntProp("files.recent.max", 15);
        SECURE_SAVE = new BooleanProp("secure.save", false);
        REMOVE_END_SPACES = new BooleanProp("remove.end.spaces", true);
        TOOLBAR_VISIBLE = new BooleanProp("toolbar.visible", true);
        STATUSBAR_VISIBLE = new BooleanProp("statusbar.visible", true);
        FINDRESULTS_VISIBLE = new BooleanProp("findresults.visible", false);
        HEAP_MONITOR_VISIBLE = new BooleanProp("heap.monitor.visible", true);
        TOOLBAR_ROWS = new BooleanProp("toolbar.rows", true);
        DATE_FORMAT = new StringProp("date.format", "dd/MM/yyyy - HH:mm:ss");
        VIEW_ACTION_SCOPE = new ViewActionScopeProp("view.action.scope", ViewActionScope.BUFFER);
        TAB_LAYOUT_POLICY = new IntProp("tab.layout.policy", 0);
        TAB_PLACEMENT = new IntProp("tab.placement", 1);
        TAB_FILE_EXTENSION = new BooleanProp("tab.file.extension", true);
        TAB_FILE_ICON = new BooleanProp("tab.file.icon", true);
        TAB_CLOSE_BUTTON = new BooleanProp("tab.close.button", true);
        TAB_ROUNDED = new BooleanProp("tab.rounded", true);
        TAB_TABBED = new BooleanProp("tab.tabbed", true);
        SPLIT_CONTINUOUS_LAYOUT = new BooleanProp("split.continuous.layout", true);
        SPLIT_DIVIDER_SIZE = new IntProp("split.divider.size", 3);
        MARKER_VISIBLE = new BooleanProp("marker.visible", true);
        MARKER_OCCURRENCE_COLOR = new ColorProp("marker.occurrence.color", new Color(155, 255, 155));
        MARKER_OCCURRENCE_BORDER_COLOR = new ColorProp("marker.occurrence.border.color", new Color(0, 205, 0));
        MARKER_SEARCH_COLOR = new ColorProp("marker.search.color", (Color)SEARCH_HIGHLIGHTER_COLOR.getDefault());
        MARKER_SEARCH_BORDER_COLOR = new ColorProp("marker.search.border.color", (Color)SEARCH_HIGHLIGHTER_BORDER_COLOR.getDefault());
        MARKER_BOOKMARK_COLOR = new ColorProp("marker.bookmark.color", (Color)GUTTER_BOOKMARK_COLOR.getDefault());
        MARKER_BOOKMARK_BORDER_COLOR = new ColorProp("marker.bookmark.border.color", (Color)GUTTER_BOOKMARK_BORDER_COLOR.getDefault());
        MARKER_CARET_COLOR = new ColorProp("marker.caret.color", (Color)TEXT_CARET_INS_COLOR.getDefault());
        MARKER_PREFERRED_WIDTH = new IntProp("marker.preferred.width", 14);
        BROWSER_NORMAL_FONT = new FontProp("browser.normal.font", new Font("Courier", 0, 12));
        BROWSER_BOLD_FONT = new FontProp("browser.bold.font", new Font("Courier", 1, 12));
        BROWSER_DEVICE_FONT = new FontProp("browser.device.font", new Font("Courier", 3, 12));
        BROWSER_DIR_FOREGROUND = new ColorProp("browser.dir.foreground", Color.BLUE);
        BROWSER_EXEC_FOREGROUND = new ColorProp("browser.exec.foreground", new Color(153, 204, 0));
        BROWSER_LINK_FOREGROUND = new ColorProp("browser.link.foreground", new Color(0, 128, 128));
        BROWSER_COMP_FOREGROUND = new ColorProp("browser.comp.foreground", Color.RED);
        BROWSER_IMAGE_FOREGROUND = new ColorProp("browser.image.foreground", Color.MAGENTA);
        BROWSER_AUDIO_FOREGROUND = new ColorProp("browser.audio.foreground", new Color(51, 204, 204));
        BROWSER_COLORS_ENABLED = new BooleanProp("browser.colors.enabled", false);
        BROWSER_HUMAN_READABLE = new BooleanProp("browser.human.readable", true);
        BROWSER_CLASSIFY = new BooleanProp("browser.classify", true);
        BROWSER_INFO_VISIBLE = new BooleanProp("browser.info.visible", true);
        BROWSER_TRANSPARENCY = new FloatProp("browser.transparency", 1.0f);
        BROWSER_LOCATION_HORIZONTAL = new DoubleProp("browser.location.horizontal", 0.5);
        BROWSER_LOCATION_VERTICAL = new DoubleProp("browser.location.vertical", 0.5);
        MINIMAP_VIEWRECT_VISIBLE = new BooleanProp("minimap.viewrect.visible", false);
        MINIMAP_VIEWRECT_COLOR = new ColorProp("minimap.viewrect.color", new Color(255, 255, 128, 50));
        MINIMAP_VIEWRECT_BORDER_COLOR = new ColorProp("minimap.viewrect.border.color", new Color(128, 128, 0, 50));
        MINIMAP_FONT_SIZE = new FloatProp("minimap.font.size", 9.0f);
        PERFORM_ACTION_TRANSPARENCY = new FloatProp("perform.action.transparency", 1.0f);
        PERFORM_ACTION_LOCATION_HORIZONTAL = new DoubleProp("perform.action.location.horizontal", 0.5);
        PERFORM_ACTION_LOCATION_VERTICAL = new DoubleProp("perform.action.location.vertical", 0.5);
        PERFORM_ACTION_COLUMNS = new IntProp("perform.action.columns", 50);
        FIND_LOOKIN = new IntProp("find.lookin", -1);
        FIND_FROMCURSOR = new BooleanProp("find.fromcursor", false);
        FIND_MATCH_CASE = new BooleanProp("find.match.case", true);
        FIND_MATCH_WHOLEWORD = new BooleanProp("find.match.wholeword", false);
        FIND_DIRECTION_DOWN = new BooleanProp("find.direction.down", true);
        FIND_HIGHLIGHT_ALL = new BooleanProp("find.highlightall", true);
        FIND_REGEX = new BooleanProp("find.regex", false);
        REPLACE_LOOKIN = new IntProp("replace.lookin", -1);
        REPLACE_FROMCURSOR = new BooleanProp("replace.fromcursor", false);
        REPLACE_MATCH_CASE = new BooleanProp("replace.match.case", true);
        REPLACE_MATCH_WHOLEWORD = new BooleanProp("replace.match.wholeword", false);
        REPLACE_DIRECTION_DOWN = new BooleanProp("replace.direction.down", true);
        REPLACE_HIGHLIGHT_ALL = new BooleanProp("replace.highlightall", true);
        REPLACE_REGEX = new BooleanProp("replace.regex", false);
        PRINT_LINE_NUMBERS = new BooleanProp("print.lineNumbers", true);
        PRINT_HEADER = new BooleanProp("print.header", true);
        PRINT_WRAP_TEXT = new BooleanProp("print.wrapText", true);
        PRINT_FONT = new FontProp("print.font", new Font("Courier", 0, 10));
        LOGGER = Logger.getLogger(Config.class.getName());
        options = new Properties();
        defaults = new Properties();
        changes = new Properties();
        FILE_ENCODING = new StringProp("file.encoding", GUIUtilities.getJNPadDefaultEncoding());
        Config.loadProperties();
        if (!Config.isMininalistMode()) {
            Config.loadDefaultProperties();
        }
        Config.loadSearchHistorial();
        Config.initDirectories();
        try {
            String lang = JNPAD_LANG.getValue();
            locale = ((String)JNPAD_LANG.getDefault()).equals(lang) ? Locale.getDefault() : new Locale(lang);
        }
        catch (Exception ex) {
            locale = Locale.getDefault();
            LOGGER.warning(ex.getMessage());
        }
        String[] fontNames = new String[]{"Courier New", "Courier new", "courier new", "CourierNew", "Couriernew", "couriernew", "Courier", "courier", "DialogInput", "Dialoginput", "dialoginput", "Dialog Input", "Dialog input", "dialog input", "Dialog", "dialog", "Monospaced", "MonoSpaced", "monospaced", "Mono spaced", "Mono Spaced", "mono spaced", "Monotxt", "MonoTxt", "monotxt", "Lucida Console", "lucida console", "LucidaConsole", "lucidaconsole"};
        Font font = new Font(fontNames[0], 0, 13);
        try {
            Object[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            String[] stringArray = fontNames;
            int n = fontNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fontName = stringArray[n2];
                if (Arrays.binarySearch(names, fontName) < 0 || !GUIUtilities.isValidFont(font = new Font(fontName, 0, 13))) {
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        TEXT_FONT = new FontProp("text.font", font);
    }

    private Config() {
    }

    public static String getHomeDir() {
        return homeDir;
    }

    public static Locale getLocale() {
        return locale;
    }

    public static void initDirectories() {
        boolean bl;
        File file = new File(homeDir);
        if (!file.exists()) {
            homeDir = System.getProperty("user.dir", "");
        }
        if (!(file = new File(COLORSCHEMES_DIR)).exists()) {
            bl = file.mkdir();
        }
        if (!(file = new File(KEYMAP_DIR)).exists()) {
            bl = file.mkdir();
        }
    }

    public static void loadSearchHistorial() {
        findList.clear();
        replaceList.clear();
        BufferedReader in = null;
        try {
            try {
                String line;
                in = new BufferedReader(new FileReader(SEARCH_FILE_PATH));
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    int i = line.indexOf(35);
                    if (i != -1) {
                        line = line.substring(0, i);
                    }
                    Config._interpret_(line);
                }
            }
            catch (IOException iOException) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    public static void saveSearchHistorial() {
        block14: {
            PrintWriter pw = null;
            try {
                try {
                    pw = new PrintWriter(new BufferedWriter(new FileWriter(SEARCH_FILE_PATH)));
                    for (String aFindList : findList) {
                        pw.println("find.list=" + aFindList);
                    }
                    for (String aReplaceList : replaceList) {
                        pw.println("replace.list=" + aReplaceList);
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    if (pw == null) break block14;
                    try {
                        pw.close();
                    }
                    catch (Exception ex2) {
                        LOGGER.log(Level.WARNING, ex2.getMessage(), ex2);
                    }
                }
            }
            finally {
                if (pw != null) {
                    try {
                        pw.close();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
            }
        }
    }

    private static boolean _isKey_(String line, String key) {
        int i = line.indexOf(61);
        return i > 0 && line.substring(0, i).trim().equalsIgnoreCase(key);
    }

    private static String _getValue_(String line) {
        return line.substring(line.indexOf(61) + 1, line.length());
    }

    private static void _interpret_(String s) {
        try {
            if (Config._isKey_(s, "find.list")) {
                findList.add(Config._getValue_(s));
            } else if (Config._isKey_(s, "replace.list")) {
                replaceList.add(Config._getValue_(s));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<String> getFindList() {
        return findList;
    }

    public static void setFindList(List<String> find_list) {
        findList = find_list;
    }

    public static List<String> getReplaceList() {
        return replaceList;
    }

    public static void setReplaceList(List<String> replace_list) {
        replaceList = replace_list;
    }

    public static void loadProperties() {
        FileInputStream is = null;
        try {
            try {
                is = new FileInputStream(PROPERTIES_FILE_PATH);
                options.load(is);
            }
            catch (IOException iOException) {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    public static void setAdjustPostModeChangedEnabled(boolean b) {
        isAdjustPostModeChangedEnabled = b;
    }

    public static boolean isAdjustPostModeChangedEnabled() {
        return isAdjustPostModeChangedEnabled;
    }

    public static void setAdjustPostLAFChangedEnabled(boolean b) {
        isAdjustPostLAFChangedEnabled = b;
    }

    public static boolean isAdjustPostLAFChangedEnabled() {
        return isAdjustPostLAFChangedEnabled;
    }

    public static void saveProperties() {
        if (Config.isAdjustPostModeChangedEnabled()) {
            Config.adjustPostModeChanged();
        }
        if (Config.isAdjustPostLAFChangedEnabled()) {
            Config.adjustPostLAFChanged();
        }
        options.clear();
        Config.loadProperties();
        options.putAll((Map<?, ?>)changes);
        for (String key : removes) {
            options.remove(key);
        }
        FileOutputStream os = null;
        try {
            try {
                os = new FileOutputStream(PROPERTIES_FILE_PATH);
                Properties tmp = new Properties(){
                    private static final long serialVersionUID = 6975987883580014663L;

                    @Override
                    public synchronized Enumeration<Object> keys() {
                        return Collections.enumeration(new TreeSet<Object>(super.keySet()));
                    }
                };
                tmp.putAll((Map<?, ?>)options);
                tmp.store(os, "jNPad".concat(" Config"));
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                try {
                    if (os != null) {
                        ((OutputStream)os).close();
                    }
                }
                catch (IOException ex2) {
                    LOGGER.log(Level.WARNING, ex2.getMessage(), ex2);
                }
            }
        }
        finally {
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    public static void loadDefaultProperties() {
        FileInputStream is = null;
        try {
            try {
                is = new FileInputStream(DEFAULTS_FILE_PATH);
                defaults.load(is);
            }
            catch (IOException iOException) {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    public static String getProperty(String key) {
        return options.getProperty(key);
    }

    public static String getProperty(String key, String def) {
        return options.getProperty(key, def);
    }

    public static void setProperty(String key, String value) {
        options.setProperty(key, value);
        changes.setProperty(key, value);
    }

    public static Object remove(String key) {
        Object o = options.remove(key);
        changes.remove(key);
        removes.add(key);
        return o;
    }

    public static void putAll(Map<?, ?> map) {
        options.putAll(map);
        changes.putAll(map);
    }

    public static String getStringProp(StringProp id) {
        return Config.getStringProp(id.getName(), (String)id.getDefault());
    }

    public static String getStringProp(String key, String def) {
        String propVal = options.getProperty(key);
        return propVal != null ? propVal : defaults.getProperty(key, def);
    }

    public static void setStringProp(StringProp id, String value) {
        Config.setStringProp(id.getName(), value);
    }

    public static void setStringProp(String key, String value) {
        Config.setProperty(key, value);
    }

    public static void setViewActionScopeProp(ViewActionScopeProp id, ViewActionScope scope) {
        Config.setViewActionScopeProp(id.getName(), scope);
    }

    public static void setViewActionScopeProp(String key, ViewActionScope scope) {
        Config.setProperty(key, ViewActionScopeProp.format(scope));
    }

    public static ViewActionScope getViewActionScopeProp(ViewActionScopeProp id) {
        return Config.getViewActionScopeProp(id.getName(), (ViewActionScope)((Object)id.getDefault()));
    }

    public static ViewActionScope getViewActionScopeProp(String key, ViewActionScope def) {
        String propval = options.getProperty(key);
        if (propval == null) {
            propval = defaults.getProperty(key);
        }
        if (propval != null) {
            try {
                ViewActionScope scope = ViewActionScopeProp.parse(propval);
                return scope != null ? scope : def;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public static void setModeProp(ModeProp id, Mode mode) {
        Config.setModeProp(id.getName(), mode);
    }

    public static void setModeProp(String key, Mode mode) {
        Config.setProperty(key, ModeProp.format(mode));
    }

    public static Mode getModeProp(ModeProp id) {
        return Config.getModeProp(id.getName(), (Mode)((Object)id.getDefault()));
    }

    public static Mode getModeProp(String key, Mode def) {
        String propval = options.getProperty(key);
        if (propval == null) {
            propval = defaults.getProperty(key);
        }
        if (propval != null) {
            try {
                Mode mode = ModeProp.parse(propval);
                return mode != null ? mode : def;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public static int getIntProp(IntProp id) {
        return Config.getIntProp(id.getName(), (Integer)id.getDefault());
    }

    public static int getIntProp(String key, int def) {
        String propval = options.getProperty(key);
        if (propval == null) {
            propval = defaults.getProperty(key);
        }
        if (propval != null) {
            try {
                return IntProp.parse(propval);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public static void setIntProp(IntProp id, int i) {
        Config.setIntProp(id.getName(), i);
    }

    public static void setIntProp(String key, int i) {
        Config.setProperty(key, IntProp.format(i));
    }

    public static double getDoubleProp(DoubleProp id) {
        return Config.getDoubleProp(id.getName(), (Double)id.getDefault());
    }

    public static double getDoubleProp(String key, double def) {
        String propval = options.getProperty(key);
        if (propval == null) {
            propval = defaults.getProperty(key);
        }
        if (propval != null) {
            try {
                return DoubleProp.parse(propval);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public static void setDoubleProp(DoubleProp id, double doubl) {
        Config.setDoubleProp(id.getName(), doubl);
    }

    public static void setDoubleProp(String key, double doubl) {
        Config.setProperty(key, DoubleProp.format(doubl));
    }

    public static float getFloatProp(FloatProp id) {
        return Config.getFloatProp(id.getName(), ((Float)id.getDefault()).floatValue());
    }

    public static float getFloatProp(String key, float def) {
        String propval = options.getProperty(key);
        if (propval == null) {
            propval = defaults.getProperty(key);
        }
        if (propval != null) {
            try {
                return FloatProp.parse(propval);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public static void setFloatProp(FloatProp id, float f) {
        Config.setFloatProp(id.getName(), f);
    }

    public static void setFloatProp(String key, float f) {
        Config.setProperty(key, FloatProp.format(f));
    }

    public static boolean getBooleanProp(BooleanProp id) {
        return Config.getBooleanProp(id.getName(), (Boolean)id.getDefault());
    }

    public static boolean getBooleanProp(String key, boolean def) {
        String propval = options.getProperty(key);
        if (propval == null && (propval = defaults.getProperty(key)) == null) {
            return def;
        }
        return BooleanProp.parse(propval);
    }

    public static void setBooleanProp(BooleanProp id, boolean bool) {
        Config.setProperty(id.getName(), BooleanProp.format(bool));
    }

    public static void setBooleanProp(String key, boolean bool) {
        Config.setProperty(key, BooleanProp.format(bool));
    }

    public static Font getFontProp(FontProp id) {
        return Config.getFontProp(id.getName(), (Font)id.getDefault());
    }

    public static Font getFontProp(String key, Font def) {
        String propval = options.getProperty(key);
        if (propval == null) {
            propval = defaults.getProperty(key);
        }
        if (propval != null) {
            try {
                return FontProp.parse(propval);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public static void setFontProp(FontProp id, Font font) {
        Config.setFontProp(id.getName(), font);
    }

    public static void setFontProp(String key, Font font) {
        Config.setProperty(key, FontProp.format(font));
    }

    public static String getLineSeparatorProp(String key) {
        String propval = options.getProperty(key);
        if (propval == null) {
            propval = defaults.getProperty(key);
        }
        if (propval != null) {
            int i;
            StringBuilder sb = new StringBuilder();
            int j = 0;
            while ((i = propval.indexOf(92, j)) != -1) {
                j = i + 1;
                while (j < propval.length() && propval.charAt(j) != '\\') {
                    ++j;
                }
                sb.append((char)IntProp.parse(propval.substring(i + 1, j)));
            }
            String s1 = sb.toString();
            if (Utilities.isEmptyString(s1)) {
                s1 = null;
            }
            return s1;
        }
        return null;
    }

    public static void setLineSeparatorProp(String key, String line_separator) {
        Config.setProperty(key, Config.writeLineSeparatorProp(line_separator));
    }

    public static Color getColorProp(ColorProp id) {
        return Config.getColorProp(id.getName(), (Color)id.getDefault());
    }

    public static Color getColorProp(String key, Color def) {
        String propval = options.getProperty(key);
        if (propval == null) {
            propval = defaults.getProperty(key);
        }
        if (propval != null) {
            try {
                return ColorProp.parse(propval);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public static void setColorProp(ColorProp id, Color color) {
        Config.setColorProp(id.getName(), color);
    }

    public static void setColorProp(String key, Color color) {
        Config.setProperty(key, ColorProp.format(color));
    }

    public static List<String> getListProp(String key) {
        ArrayList<String> list = new ArrayList<String>();
        String propval = options.getProperty(key);
        if (propval == null) {
            propval = defaults.getProperty(key);
        }
        if (propval != null) {
            return Config.getList(propval);
        }
        return list;
    }

    public static void setListProp(String key, List<?> list) {
        Config.setProperty(key, Config.writeListProp(list));
    }

    public static List<JNPadInput> getJNPadInputListProp(String key) {
        ArrayList<JNPadInput> list = new ArrayList<JNPadInput>();
        String propval = options.getProperty(key);
        if (propval == null) {
            propval = defaults.getProperty(key);
        }
        if (propval != null) {
            List<String> l_values = Config.getList(propval);
            for (String value : l_values) {
                try {
                    list.add(Config.parseJNPadInput(value));
                }
                catch (Exception ex) {
                    LOGGER.warning("jNPad Input inv\u00e1lido: ".concat(value));
                }
            }
        }
        return list;
    }

    public static JNPadInput parseJNPadInput(String s) throws IllegalArgumentException {
        try {
            s = s.trim();
            StringTokenizer st = new StringTokenizer(s, ",");
            String path = st.nextToken().trim();
            int position = st.hasMoreTokens() ? IntProp.parse(st.nextToken().trim()) : -1;
            boolean readOnly = st.hasMoreTokens() && BooleanProp.parse(st.nextToken().trim());
            boolean current = st.hasMoreTokens() && BooleanProp.parse(st.nextToken().trim());
            boolean linewrap = st.hasMoreTokens() && BooleanProp.parse(st.nextToken().trim());
            String splitCfg = st.hasMoreTokens() ? st.nextToken().trim() : "";
            return new JNPadInput(path, position, readOnly, current, splitCfg, linewrap);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("jNPad Input inv\u00e1lido: " + s);
        }
    }

    public static void setJNPadInputListProp(String key, List<JNPadInput> list) {
        Config.setProperty(key, Config.writeJNPadInputListProp(list));
    }

    private static List<String> getList(String value) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, ";");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken().trim());
        }
        return list;
    }

    public static void setMode(Mode mode) {
        if (mode_setting_flag) {
            return;
        }
        Mode oldMode = Config.getMode();
        if (oldMode == mode) {
            return;
        }
        JNPAD_MODE.setValue(mode);
        Config.mode = mode;
        if (oldMode == Mode.MINIMALIST) {
            Config.loadDefaultProperties();
        } else if (mode == Mode.MINIMALIST) {
            defaults.clear();
        }
        mode_setting_flag = true;
    }

    public static Mode getMode() {
        if (mode == null) {
            mode = JNPAD_MODE.getValue();
        }
        return mode;
    }

    public static boolean isMininalistMode() {
        return Config.getMode() == Mode.MINIMALIST;
    }

    public static boolean isBasicMode() {
        return Config.getMode() == Mode.BASIC;
    }

    public static boolean isDefaultMode() {
        return Config.getMode() == Mode.DEFAULT;
    }

    public static boolean isDistractionFreeMode() {
        return Config.getMode() == Mode.DISTRACTION_FREE;
    }

    private static void adjustPostModeChanged() {
        Mode mode_;
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config("-- adjustPostModeChanged --");
        }
        if (mode != (mode_ = JNPAD_MODE.getValue())) {
            switch (mode_) {
                case DISTRACTION_FREE: {
                    TAB_TABBED.setValue(false);
                    STATUSBAR_VISIBLE.setValue(false);
                    GUTTER_VISIBLE.setValue(false);
                    MARKER_VISIBLE.setValue(false);
                    Config.setBooleanProp("jnpad.maximize", true);
                    TEXT_LINE_WRAP.setValue(true);
                    ACTIVE_LINE_VISIBLE.setValue(false);
                    Config.setColorScheme("dark");
                    JNPAD_LAF.setValue("jNPad_dark");
                    break;
                }
                default: {
                    TAB_TABBED.setToDefault();
                    STATUSBAR_VISIBLE.setToDefault();
                    GUTTER_VISIBLE.setToDefault();
                    MARKER_VISIBLE.setToDefault();
                    TEXT_LINE_WRAP.setToDefault();
                    ACTIVE_LINE_VISIBLE.setToDefault();
                    if (mode != Mode.DISTRACTION_FREE) break;
                    Config.setColorScheme(Config.getColorSchemeByLAF(JNPAD_LAF.getValue()));
                    JNPAD_LAF.setToDefault();
                }
            }
        }
    }

    private static void adjustPostLAFChanged() {
        String laf;
        String lafKey;
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config("-- adjustPostLAFChanged --");
        }
        if (!(lafKey = LAFUtils.getCurrentLAFKey()).equals(laf = JNPAD_LAF.getValue())) {
            Config.setColorScheme(Config.getColorSchemeByLAF(laf));
        }
    }

    private static String getColorSchemeByLAF(String lafKey) {
        String colorscheme;
        if ("jNPad_light".equals(lafKey)) {
            colorscheme = "jnpad";
        } else if ("jNPad_dark".equals(lafKey)) {
            switch (JNPAD_MODE.getValue()) {
                case DISTRACTION_FREE: {
                    colorscheme = "black";
                    break;
                }
                default: {
                    colorscheme = "dark";
                    break;
                }
            }
        } else {
            colorscheme = "Steel".equals(lafKey) ? "gray" : ("System".equals(lafKey) ? (Platform.isWindows ? "default" : (Platform.isMac ? "light" : "jnpad")) : ("CrossPlatform".equals(lafKey) || "javax.swing.plaf.metal.MetalLookAndFeel".equals(lafKey) || "Ocean2".equals(lafKey) ? "light" : ("com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(lafKey) || "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel".equals(lafKey) ? "default" : ("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel".equals(lafKey) ? "cobalt" : ("com.sun.java.swing.plaf.motif.MotifLookAndFeel".equals(lafKey) ? "plastic" : ("com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(lafKey) ? "jnpad" : ("com.sun.java.swing.plaf.mac.MacLookAndFeel".equals(lafKey) || "apple.laf.AquaLookAndFeel".equals(lafKey) || "com.apple.laf.AquaLookAndFeel".equals(lafKey) ? "light" : "default")))))));
        }
        return colorscheme;
    }

    private static void setColorScheme(String colorscheme) {
        String path = String.valueOf(COLORSCHEMES_DIR) + Utilities.DIR_SEPARATOR + colorscheme + ".properties";
        Properties prop = new Properties();
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
                prop.load(in);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex2) {
                    LOGGER.log(Level.WARNING, ex2.getMessage(), ex2);
                }
                return;
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        Config.putAll(prop);
        JNPAD_COLORSCHEME.setValue(colorscheme);
    }

    public static boolean isUsingCustomShortcuts() {
        return USE_CUSTOM_SHORTCUTS.getValue();
    }

    public static String writeLineSeparatorProp(String line_separator) {
        if (line_separator == null) {
            return AUTO;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < line_separator.length()) {
            sb.append("\\".concat(Integer.toString(line_separator.charAt(i))));
            ++i;
        }
        return sb.toString();
    }

    public static String writeListProp(List<?> list) {
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = list.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
            if (!it.hasNext()) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    public static String writeJNPadInputProp(JNPadInput in) {
        StringBuilder sb = new StringBuilder();
        sb.append(in.getPath()).append(",").append(IntProp.format(in.getCaretPosition())).append(",").append(BooleanProp.format(in.isReadOnly())).append(",").append(BooleanProp.format(in.isCurrent())).append(",").append(BooleanProp.format(in.isLineWrapped()));
        if (Utilities.isNotEmptyString(in.getSplitConfig())) {
            sb.append(",").append(in.getSplitConfig());
        }
        return sb.toString();
    }

    public static String writeJNPadInputListProp(List<JNPadInput> list) {
        StringBuilder sb = new StringBuilder();
        Iterator<JNPadInput> it = list.iterator();
        while (it.hasNext()) {
            JNPadInput in = it.next();
            sb.append(Config.writeJNPadInputProp(in));
            if (!it.hasNext()) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    public static void saveDefaultProperties() {
        block12: {
            PrintWriter pw = null;
            try {
                try {
                    pw = new PrintWriter(new BufferedWriter(new FileWriter(DEFAULTS_FILE_PATH)));
                    pw.println("# =========================================================");
                    pw.println("# jNPad Default Config");
                    pw.println("# =========================================================");
                    pw.println();
                    pw.println("# Generals:");
                    pw.println(JNPAD_X);
                    pw.println(JNPAD_Y);
                    pw.println(JNPAD_WIDTH);
                    pw.println(JNPAD_HEIGHT);
                    pw.println(JNPAD_MAXIMIZE);
                    pw.println(JNPAD_COLORSCHEME);
                    pw.println(JNPAD_KEYMAP);
                    pw.println(JNPAD_LAF);
                    pw.println(JNPAD_LAF_BOLD_METAL);
                    pw.println(JNPAD_LANG);
                    pw.println(JNPAD_MODE);
                    pw.println(JNPAD_ANTIALIAS);
                    pw.println();
                    pw.println(UNDO_LIMIT);
                    pw.println(USE_CUSTOM_SHORTCUTS);
                    pw.println(CHOOSER_FILE_DIRECTORY);
                    pw.println(FILES_RECENT_MAX);
                    pw.println(SECURE_SAVE);
                    pw.println(FILE_ENCODING);
                    pw.println(REMOVE_END_SPACES);
                    pw.println(STATUSBAR_VISIBLE);
                    pw.println(FINDRESULTS_VISIBLE);
                    pw.println(HEAP_MONITOR_VISIBLE);
                    pw.println(DATE_FORMAT);
                    pw.println(TAB_LAYOUT_POLICY);
                    pw.println(TAB_PLACEMENT);
                    pw.println(TAB_FILE_EXTENSION);
                    pw.println(TAB_FILE_ICON);
                    pw.println(TAB_CLOSE_BUTTON);
                    pw.println(TAB_ROUNDED);
                    pw.println(TAB_TABBED);
                    pw.println(SPLIT_CONTINUOUS_LAYOUT);
                    pw.println(SPLIT_DIVIDER_SIZE);
                    pw.println();
                    pw.println();
                    pw.println("# Toolbars:");
                    pw.println(TOOLBAR_VISIBLE);
                    pw.println(TOOLBAR_ROWS);
                    pw.println(TOOLBARS_FILE_SELECTED);
                    pw.println(TOOLBARS_EDIT_RECANTATION_SELECTED);
                    pw.println(TOOLBARS_EDIT_CLIPBOARD_SELECTED);
                    pw.println(TOOLBARS_EDIT_SELECTION_SELECTED);
                    pw.println(TOOLBARS_EDIT_DELETION_SELECTED);
                    pw.println(TOOLBARS_SEARCH_SELECTED);
                    pw.println(TOOLBARS_VIEW_SELECTED);
                    pw.println(TOOLBARS_FORMAT_SELECTED);
                    pw.println(TOOLBARS_WINDOWS_SELECTED);
                    pw.println();
                    pw.println();
                    pw.println("# Titled Label:");
                    pw.println(TITLED_LABEL_FONT);
                    pw.println(TITLED_LABEL_FOREGROUND);
                    pw.println(TITLED_LABEL_GRADIENT1);
                    pw.println(TITLED_LABEL_GRADIENT2);
                    pw.println(TITLED_LABEL_ORIENTATION);
                    pw.println();
                    pw.println();
                    pw.println("# Text Pane:");
                    pw.println(TEXT_FONT);
                    pw.println(TEXT_BACKGROUND);
                    pw.println(TEXT_FOREGROUND);
                    pw.println(TEXT_SELECTION_BACKGROUND);
                    pw.println(TEXT_SELECTION_FOREGROUND);
                    pw.println(TEXT_CARET_INS_COLOR);
                    pw.println(TEXT_CARET_OVR_COLOR);
                    pw.println(TEXT_TAB_SIZE);
                    pw.println(TEXT_TAB_ENABLED);
                    pw.println(TEXT_AUTO_INDENT);
                    pw.println(TEXT_AUTO_CLOSE_BRACKETS);
                    pw.println(TEXT_RIGHT_MARGIN_LINE_VISIBLE);
                    pw.println(TEXT_RIGHT_MARGIN_LINE_WIDTH);
                    pw.println(TEXT_RIGHT_MARGIN_LINE_COLOR);
                    pw.println(TEXT_LINE_WRAP);
                    pw.println(TEXT_AUTOCOMPLETION_ENABLED);
                    pw.println(TEXT_AUTOCOMPLETION_ALL);
                    pw.println(TEXT_AUTOCOMPLETION_TRIGGER);
                    pw.println(TEXT_DELIMITERS);
                    pw.println();
                    pw.println(SYNTAX_CLASSIFY_ENABLED);
                    pw.println(SYNTAX_KNOWN_ENABLED);
                    pw.println(SYNTAX_COMMENT_COLOR);
                    pw.println(SYNTAX_COMMENT_STYLE);
                    pw.println(SYNTAX_COMMENT2_COLOR);
                    pw.println(SYNTAX_COMMENT2_STYLE);
                    pw.println(SYNTAX_COMMENT3_COLOR);
                    pw.println(SYNTAX_COMMENT3_STYLE);
                    pw.println(SYNTAX_COMMENT4_COLOR);
                    pw.println(SYNTAX_COMMENT4_STYLE);
                    pw.println(SYNTAX_STRING_COLOR);
                    pw.println(SYNTAX_STRING_STYLE);
                    pw.println(SYNTAX_NUMBER_COLOR);
                    pw.println(SYNTAX_KEYWORD_COLOR);
                    pw.println(SYNTAX_KEYWORD_STYLE);
                    pw.println(SYNTAX_KEYWORD2_COLOR);
                    pw.println(SYNTAX_KEYWORD2_STYLE);
                    pw.println(SYNTAX_KEYWORD3_COLOR);
                    pw.println(SYNTAX_KEYWORD3_STYLE);
                    pw.println(SYNTAX_KEYWORD4_COLOR);
                    pw.println(SYNTAX_KEYWORD4_STYLE);
                    pw.println(SYNTAX_KEYWORD5_COLOR);
                    pw.println(SYNTAX_KEYWORD5_STYLE);
                    pw.println(SYNTAX_KEYWORD6_COLOR);
                    pw.println(SYNTAX_KEYWORD6_STYLE);
                    pw.println(SYNTAX_KEYWORD7_COLOR);
                    pw.println(SYNTAX_KEYWORD7_STYLE);
                    pw.println(SYNTAX_KEYWORD8_COLOR);
                    pw.println(SYNTAX_KEYWORD8_STYLE);
                    pw.println(SYNTAX_KEYWORD9_COLOR);
                    pw.println(SYNTAX_KEYWORD9_STYLE);
                    pw.println(SYNTAX_OPERATOR_COLOR);
                    pw.println(SYNTAX_OPERATOR_STYLE);
                    pw.println(SYNTAX_BRACKET_COLOR);
                    pw.println(SYNTAX_BRACKET_STYLE);
                    pw.println("# --- [v0.3] ---");
                    pw.println(SYNTAX_COMMENT1_COLOR);
                    pw.println(SYNTAX_COMMENT1_STYLE);
                    pw.println(SYNTAX_CLASSIFY2_ENABLED);
                    pw.println(SYNTAX_KEYWORD10_STYLE);
                    pw.println(SYNTAX_KEYWORD11_STYLE);
                    pw.println("# ---");
                    pw.println();
                    pw.println(ACTIVE_LINE_VISIBLE);
                    pw.println(ACTIVE_LINE_COLOR);
                    pw.println(BOOKMARKING_ENABLED);
                    pw.println(OCCURRENCES_HIGHLIGHTER_VISIBLE);
                    pw.println(OCCURRENCES_HIGHLIGHTER_COLOR);
                    pw.println(OCCURRENCES_HIGHLIGHTER_BORDER_COLOR);
                    pw.println(OCCURRENCES_CIRCULAR_NAVIGATION);
                    pw.println(BOOKMARKS_CIRCULAR_NAVIGATION);
                    pw.println(SEARCH_HIGHLIGHTER_COLOR);
                    pw.println(SEARCH_HIGHLIGHTER_BORDER_COLOR);
                    pw.println(BRACKET_HIGHLIGHTER_VISIBLE);
                    pw.println(BRACKET_HIGHLIGHTER_COLOR);
                    pw.println(VIEW_ACTION_SCOPE);
                    pw.println();
                    pw.println();
                    pw.println("# Gutter:");
                    pw.println(GUTTER_VISIBLE);
                    pw.println(GUTTER_BACKGROUND);
                    pw.println(GUTTER_FOREGROUND);
                    pw.println(GUTTER_CURRENT_FOREGROUND);
                    pw.println(GUTTER_CURRENT_BACKGROUND);
                    pw.println(GUTTER_CURRENT_BACKGROUND_ENABLED);
                    pw.println(GUTTER_UPDATE_FONT);
                    pw.println(GUTTER_BORDER_GAP);
                    pw.println(GUTTER_BORDER_WIDTH);
                    pw.println(GUTTER_BORDER_VISIBLE);
                    pw.println(GUTTER_BORDER_COLOR);
                    pw.println(GUTTER_SELECTION_COLOR);
                    pw.println(GUTTER_SELECTION_BORDER_COLOR);
                    pw.println(GUTTER_SELECTION_WIDTH);
                    pw.println(GUTTER_SELECTION_BORDER);
                    pw.println(GUTTER_BOOKMARK_BACKGROUND);
                    pw.println(GUTTER_BOOKMARK_COLOR);
                    pw.println(GUTTER_BOOKMARK_BORDER_COLOR);
                    pw.println(GUTTER_BOOKMARK_WIDTH);
                    pw.println(GUTTER_BOOKMARK_GAP);
                    pw.println(GUTTER_BRACKET_SCOPE_VISIBLE);
                    pw.println(GUTTER_BRACKET_SCOPE_COLOR);
                    pw.println();
                    pw.println();
                    pw.println("# Mark Strip:");
                    pw.println(MARKER_VISIBLE);
                    pw.println(MARKER_OCCURRENCE_COLOR);
                    pw.println(MARKER_OCCURRENCE_BORDER_COLOR);
                    pw.println(MARKER_SEARCH_COLOR);
                    pw.println(MARKER_SEARCH_BORDER_COLOR);
                    pw.println(MARKER_BOOKMARK_COLOR);
                    pw.println(MARKER_BOOKMARK_BORDER_COLOR);
                    pw.println(MARKER_CARET_COLOR);
                    pw.println(MARKER_PREFERRED_WIDTH);
                    pw.println();
                    pw.println();
                    pw.println("# Minimap [v0.3]: ");
                    pw.println(MINIMAP_VIEWRECT_VISIBLE);
                    pw.println(MINIMAP_VIEWRECT_COLOR);
                    pw.println(MINIMAP_VIEWRECT_BORDER_COLOR);
                    pw.println(MINIMAP_FONT_SIZE);
                    pw.println();
                    pw.println();
                    pw.println("# File Browser:");
                    pw.println(BROWSER_NORMAL_FONT);
                    pw.println(BROWSER_BOLD_FONT);
                    pw.println(BROWSER_DEVICE_FONT);
                    pw.println(BROWSER_DIR_FOREGROUND);
                    pw.println(BROWSER_EXEC_FOREGROUND);
                    pw.println(BROWSER_LINK_FOREGROUND);
                    pw.println(BROWSER_COMP_FOREGROUND);
                    pw.println(BROWSER_IMAGE_FOREGROUND);
                    pw.println(BROWSER_AUDIO_FOREGROUND);
                    pw.println(BROWSER_COLORS_ENABLED);
                    pw.println(BROWSER_HUMAN_READABLE);
                    pw.println(BROWSER_CLASSIFY);
                    pw.println(BROWSER_INFO_VISIBLE);
                    pw.println(BROWSER_TRANSPARENCY);
                    pw.println(BROWSER_LOCATION_HORIZONTAL);
                    pw.println(BROWSER_LOCATION_VERTICAL);
                    pw.println();
                    pw.println();
                    pw.println("# Perform Action:");
                    pw.println(PERFORM_ACTION_TRANSPARENCY);
                    pw.println(PERFORM_ACTION_LOCATION_HORIZONTAL);
                    pw.println(PERFORM_ACTION_LOCATION_VERTICAL);
                    pw.println(PERFORM_ACTION_COLUMNS);
                    pw.println();
                    pw.println();
                    pw.println("# Find:");
                    pw.println(FIND_LOOKIN);
                    pw.println(FIND_FROMCURSOR);
                    pw.println(FIND_MATCH_CASE);
                    pw.println(FIND_MATCH_WHOLEWORD);
                    pw.println(FIND_DIRECTION_DOWN);
                    pw.println(FIND_HIGHLIGHT_ALL);
                    pw.println(FIND_REGEX);
                    pw.println();
                    pw.println();
                    pw.println("# Replace:");
                    pw.println(REPLACE_LOOKIN);
                    pw.println(REPLACE_FROMCURSOR);
                    pw.println(REPLACE_MATCH_CASE);
                    pw.println(REPLACE_MATCH_WHOLEWORD);
                    pw.println(REPLACE_DIRECTION_DOWN);
                    pw.println(REPLACE_HIGHLIGHT_ALL);
                    pw.println(REPLACE_REGEX);
                    pw.println();
                    pw.println();
                    pw.println("# Print:");
                    pw.println(PRINT_LINE_NUMBERS);
                    pw.println(PRINT_HEADER);
                    pw.println(PRINT_WRAP_TEXT);
                    pw.println(PRINT_FONT);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    if (pw == null) break block12;
                    try {
                        pw.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (pw != null) {
                    try {
                        pw.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static <V> void addPropListener(Prop<V> prop, PropChangeListener<V> listener) {
        prop.addPropListener(listener);
    }

    public static <V> void removePropListener(Prop<V> prop, PropChangeListener<V> listener) {
        prop.removePropListener(listener);
    }
}

