/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jnpad.GUIUtilities;
import jnpad.JNPadFrame;
import jnpad.JNPadKeyboardHandler;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.config.KeyEventWorkaround;
import jnpad.text.AbstractTextArea;
import jnpad.text.CompletionPopup;
import jnpad.text.CompletionUtilities;
import jnpad.text.EditPane;
import jnpad.text.JNPadDocument;
import jnpad.text.JNPadTextAreaUI;
import jnpad.text.Scheme;
import jnpad.ui.plaf.LAFUtils;
import jnpad.util.Utilities;

public class JNPadTextArea
extends AbstractTextArea {
    private static final String PROPERTY_CARET_WIDTH = "caretWidth";
    private boolean isRightMarginLineVisible;
    private Color rightMarginLineColor;
    private int rightMarginLineWidth;
    private boolean isOverwriteTextMode;
    private Color oldCaretColor;
    private Color overwriteCaretColor;
    private boolean isAutoCompletionEnabled;
    private boolean isAutoCompletionAllViewsEnabled;
    private int autoCompletionTrigger = 4;
    private AutoCompletionListener autoCompletionListener = new AutoCompletionListener();
    private CompletionPopup completionPopup;
    private static final Logger LOGGER = Logger.getLogger(JNPadTextArea.class.getName());
    private static final long serialVersionUID = -8840535070140806189L;

    public JNPadTextArea(EditPane editPane) {
        super(editPane);
        try {
            this.configure(7);
            this.jbInit();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    JNPadTextArea(EditPane editPane, JNPadTextArea textArea) {
        super(editPane);
        try {
            Color bg = textArea.getBackground();
            if (LAFUtils.isNimbusLAF()) {
                UIDefaults overrides = new UIDefaults();
                overrides.put("TextPane[Enabled].backgroundPainter", bg);
                this.putClientProperty("Nimbus.Overrides", overrides);
                this.putClientProperty("Nimbus.Overrides.InheritDefaults", Boolean.TRUE);
            }
            this.setBackground(bg);
            this.setForeground(textArea.getForeground());
            this.setSelectionColor(textArea.getSelectionColor());
            this.setSelectedTextColor(textArea.getSelectedTextColor());
            this.setRightMarginLineColor(textArea.getRightMarginLineColor());
            this.setFont(textArea.getFont());
            this.setRightMarginLineVisible(textArea.isRightMarginLineVisible());
            this.setRightMarginLineWidth(textArea.getRightMarginLineWidth());
            this.setLineWrap(textArea.getLineWrap());
            this.setWrapStyleWord(textArea.getWrapStyleWord());
            this.setTabSize(textArea.getTabSize());
            this.setUseTabs(textArea.getUseTabs());
            this.setDelimiters(textArea.getDelimiters());
            this.setOverwriteCaretColor(textArea.getOverwriteCaretColor());
            this.oldCaretColor = textArea.oldCaretColor;
            this.setCaretColor(this.oldCaretColor);
            this.setAutoCompletionEnabled(textArea.isAutoCompletionEnabled());
            this.setAutoCompletionAllViewsEnabled(textArea.isAutoCompletionAllViewsEnabled());
            this.setAutoCompletionTrigger(textArea.getAutoCompletionTrigger());
            this.jbInit();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void jbInit() throws Exception {
        this.setUI(new JNPadTextAreaUI());
        this.setFilePath(this.editPane.getFilePath());
        if (Accelerators.isUsingCompositeShortcuts()) {
            this.enableEvents(8L);
        }
        this.setBorder(GUIUtilities.createEmptyBorder(Config.isDistractionFreeMode() ? 10 : 5));
        MyCaret c = new MyCaret();
        c.setBlinkRate(this.getCaret().getBlinkRate());
        this.setCaret(c);
        this.oldCaretColor = this.getCaretColor();
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (JNPadTextArea.this.isOverwriteTextMode()) {
                    JNPadTextArea.this.processCaretWidth();
                }
            }
        });
    }

    void setFilePath(String path) {
        if (Utilities.isFileExtension(path, "java")) {
            this.setContentType("text/java");
        } else if (Utilities.isFileExtension(path, new String[]{"properties", "props"})) {
            this.setContentType("text/properties");
        } else if (Utilities.isFileExtension(path, new String[]{"asn", "asn1"})) {
            this.setContentType("text/asn1");
        } else if (Utilities.isFileExtension(path, new String[]{"c"})) {
            this.setContentType("text/c");
        } else if (Utilities.isFileExtension(path, new String[]{"cpp", "cc", "h", "hpp"})) {
            this.setContentType("text/cpp");
        } else {
            this.setContentType("text/plain");
        }
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        Scheme scheme = this.getScheme();
        if (scheme != null) {
            scheme.setTextFont(f);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        Scheme scheme = this.getScheme();
        if (scheme != null) {
            scheme.setTextColor(fg);
        }
    }

    public Scheme getScheme() {
        Document doc = this.getDocument();
        if (doc != null && doc instanceof JNPadDocument) {
            return ((JNPadDocument)doc).getScheme();
        }
        return null;
    }

    @Override
    public String getContentType() {
        Document doc = this.getDocument();
        if (doc != null && doc instanceof JNPadDocument) {
            return ((JNPadDocument)doc).getContentType();
        }
        return "text/plain";
    }

    public void setContentType(String contentType) {
        String old;
        contentType = Utilities.defaultString(contentType, "text/plain");
        Document doc = this.getDocument();
        if (doc != null && doc instanceof JNPadDocument && !contentType.equals(old = ((JNPadDocument)doc).getContentType())) {
            boolean b = "text/plain".equals(contentType);
            this.setLineWrap(b ? Config.TEXT_LINE_WRAP.getValue() : false);
            this.setWrapStyleWord(b ? Config.TEXT_LINE_WRAP.getValue() : false);
            ((JNPadDocument)doc).setContentType(contentType);
            this.firePropertyChange("jnpad.contentType", old, contentType);
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (!Accelerators.isUsingCompositeShortcuts()) {
            super.processKeyEvent(e);
            return;
        }
        if ((e = KeyEventWorkaround.processKeyEvent(e)) == null) {
            return;
        }
        JNPadKeyboardHandler keyboardHandler = this.getKeyboardHandler();
        KeyListener keyEventInterceptor = this.getKeyEventInterceptor();
        switch (e.getID()) {
            case 400: {
                if (keyEventInterceptor != null) {
                    keyEventInterceptor.keyTyped(e);
                    break;
                }
                if (keyboardHandler == null) break;
                keyboardHandler.keyTyped(e);
                break;
            }
            case 401: {
                if (keyEventInterceptor != null) {
                    keyEventInterceptor.keyPressed(e);
                    break;
                }
                if (keyboardHandler == null) break;
                keyboardHandler.keyPressed(e);
                break;
            }
            case 402: {
                if (keyEventInterceptor != null) {
                    keyEventInterceptor.keyReleased(e);
                    break;
                }
                if (keyboardHandler == null) break;
                keyboardHandler.keyReleased(e);
                break;
            }
        }
        if (!e.isConsumed()) {
            super.processKeyEvent(e);
        }
    }

    @Override
    public void configure(int cfg) {
        Document doc = this.getDocument();
        if (doc != null && doc instanceof JNPadDocument) {
            Scheme mscheme;
            Scheme scheme = ((JNPadDocument)doc).getScheme();
            if (scheme != null) {
                scheme.configure(cfg);
            }
            if ((mscheme = ((JNPadDocument)doc).getMiniScheme()) != null) {
                mscheme.configure(cfg);
            }
        }
        if ((cfg & 1) != 0) {
            Color bg = Config.TEXT_BACKGROUND.getValue();
            if (LAFUtils.isNimbusLAF()) {
                UIDefaults overrides = new UIDefaults();
                overrides.put("TextPane[Enabled].backgroundPainter", bg);
                this.putClientProperty("Nimbus.Overrides", overrides);
                this.putClientProperty("Nimbus.Overrides.InheritDefaults", Boolean.TRUE);
            }
            this.setBackground(bg);
            this.setForeground(Config.TEXT_FOREGROUND.getValue());
            this.setSelectionColor(Config.TEXT_SELECTION_BACKGROUND.getValue());
            this.setSelectedTextColor(Config.TEXT_SELECTION_FOREGROUND.getValue());
            this.setRightMarginLineColor(Config.TEXT_RIGHT_MARGIN_LINE_COLOR.getValue());
            this.oldCaretColor = Config.TEXT_CARET_INS_COLOR.getValue();
            this.setOverwriteCaretColor(Config.TEXT_CARET_OVR_COLOR.getValue());
            this.setCaretColor(this.isOverwriteTextMode() ? this.getOverwriteCaretColor() : this.oldCaretColor);
        }
        if ((cfg & 2) != 0) {
            this.setFont(Config.TEXT_FONT.getValue());
        }
        if ((cfg & 4) != 0) {
            this.setRightMarginLineVisible(Config.TEXT_RIGHT_MARGIN_LINE_VISIBLE.getValue());
            this.setRightMarginLineWidth(Config.TEXT_RIGHT_MARGIN_LINE_WIDTH.getValue());
            this.setLineWrap(Config.TEXT_LINE_WRAP.getValue());
            this.setWrapStyleWord(Config.TEXT_LINE_WRAP.getValue());
            this.setTabSize(Config.TEXT_TAB_SIZE.getValue());
            this.setAutoIndent(Config.TEXT_AUTO_INDENT.getValue());
            this.setUseTabs(Config.TEXT_TAB_ENABLED.getValue());
            this.setAutoCompletionEnabled(Config.TEXT_AUTOCOMPLETION_ENABLED.getValue());
            this.setAutoCompletionAllViewsEnabled(Config.TEXT_AUTOCOMPLETION_ALL.getValue());
            this.setAutoCompletionTrigger(Config.TEXT_AUTOCOMPLETION_TRIGGER.getValue());
        }
    }

    public void setAutoIndent(boolean b) {
        Document doc = this.getDocument();
        if (doc != null) {
            boolean old = this.getAutoIndent();
            doc.putProperty("JNPadDocument.autoIndent", b);
            this.firePropertyChange("JNPadDocument.autoIndent", old, b);
        }
    }

    public boolean getAutoIndent() {
        Boolean b;
        Document doc = this.getDocument();
        if (doc != null && (b = (Boolean)doc.getProperty("JNPadDocument.autoIndent")) != null) {
            return b;
        }
        return Config.TEXT_AUTO_INDENT.getValue();
    }

    public void setDelimiters(String delimiters) {
        Document doc = this.getDocument();
        if (doc != null) {
            String old = this.getDelimiters();
            doc.putProperty("JNPadDocument.delimitersTabs", delimiters);
            this.firePropertyChange("JNPadDocument.delimitersTabs", old, delimiters);
        }
    }

    public String getDelimiters() {
        String delimiters;
        Document doc = this.getDocument();
        if (doc != null && (delimiters = (String)doc.getProperty("JNPadDocument.delimitersTabs")) != null) {
            return delimiters;
        }
        return Config.TEXT_DELIMITERS.getValue();
    }

    public void setUseTabs(boolean b) {
        Document doc = this.getDocument();
        if (doc != null) {
            boolean old = this.getUseTabs();
            doc.putProperty("JNPadDocument.useTabs", b);
            this.firePropertyChange("JNPadDocument.useTabs", old, b);
        }
    }

    public boolean getUseTabs() {
        Boolean b;
        Document doc = this.getDocument();
        if (doc != null && (b = (Boolean)doc.getProperty("JNPadDocument.useTabs")) != null) {
            return b;
        }
        return Config.TEXT_TAB_ENABLED.getValue();
    }

    @Override
    public void setRightMarginLineWidth(int width) {
        this.rightMarginLineWidth = width;
        this.repaint();
    }

    @Override
    public final int getRightMarginLineWidth() {
        return this.rightMarginLineWidth;
    }

    @Override
    public void setRightMarginLineVisible(boolean b) {
        this.isRightMarginLineVisible = b;
        this.repaint();
    }

    @Override
    public final boolean isRightMarginLineVisible() {
        return this.isRightMarginLineVisible;
    }

    @Override
    public void setRightMarginLineColor(Color c) {
        this.rightMarginLineColor = c;
        this.repaint();
    }

    @Override
    public final Color getRightMarginLineColor() {
        return this.rightMarginLineColor;
    }

    public Color getOverwriteCaretColor() {
        return this.overwriteCaretColor;
    }

    public void setOverwriteCaretColor(Color color) {
        if (color != null) {
            this.overwriteCaretColor = color;
        }
    }

    public void setOverwriteTextMode(boolean b) {
        if (this.isOverwriteTextMode != b) {
            this.isOverwriteTextMode = b;
            this.processMode();
        }
    }

    public boolean isOverwriteTextMode() {
        return this.isOverwriteTextMode;
    }

    private void processMode() {
        if (this.isOverwriteTextMode()) {
            this.processCaretWidth();
            this.setCaretColor(this.overwriteCaretColor);
        } else {
            this.setCaretColor(this.oldCaretColor);
            this.putClientProperty(PROPERTY_CARET_WIDTH, 1);
        }
    }

    private void processCaretWidth() {
        try {
            int pos = this.getCaretPosition();
            Rectangle rPos = this.modelToView(pos) != null ? this.modelToView(pos).getBounds() : new Rectangle();
            int caretX = rPos.x;
            int caretEndX = rPos.x;
            if (pos < this.getDocument().getLength()) {
                Rectangle rNextPos;
                Rectangle rectangle = rNextPos = this.modelToView(pos + 1) != null ? this.modelToView(pos + 1).getBounds() : new Rectangle();
                if (rPos.y == rNextPos.y) {
                    caretEndX = rNextPos.x;
                }
            }
            this.putClientProperty(PROPERTY_CARET_WIDTH, Math.max(1, caretEndX - caretX + 1));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void replaceSelection(String content) {
        if (this.isEditable() && this.isOverwriteTextMode() && this.getSelectionStart() == this.getSelectionEnd()) {
            int pos = this.getCaretPosition();
            int lastPos = Math.min(this.getDocument().getLength(), pos + content.length());
            this.select(pos, lastPos);
        }
        super.replaceSelection(content);
    }

    public void toUpperCase() {
        if (!this.isEditable()) {
            return;
        }
        String selectedText = this.getSelectedText();
        if (selectedText == null) {
            return;
        }
        this.replaceSelection(selectedText.toUpperCase());
    }

    public void toLowerCase() {
        if (!this.isEditable()) {
            return;
        }
        String selectedText = this.getSelectedText();
        if (selectedText == null) {
            return;
        }
        this.replaceSelection(selectedText.toLowerCase());
    }

    public void invertUpperLower() {
        if (!this.isEditable()) {
            return;
        }
        String selectedText = this.getSelectedText();
        if (selectedText == null) {
            return;
        }
        char[] charArray = selectedText.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            if (charArray[i] >= 'A' && charArray[i] <= 'Z') {
                int n = i;
                char c = (char)(charArray[n] + 32);
                charArray[n] = c;
                charArray[i] = c;
            } else if (charArray[i] >= 'a' && charArray[i] <= 'z') {
                int n = i;
                char c = (char)(charArray[n] - 32);
                charArray[n] = c;
                charArray[i] = c;
            }
            ++i;
        }
        this.replaceSelection(new String(charArray));
    }

    public void capitalize() {
        if (!this.isEditable()) {
            return;
        }
        String selectedText = this.getSelectedText();
        if (selectedText == null) {
            return;
        }
        this.replaceSelection(Utilities.capitalizeString(selectedText));
    }

    public void toTitle() {
        if (!this.isEditable()) {
            return;
        }
        String selectedText = this.getSelectedText();
        if (selectedText == null) {
            return;
        }
        this.replaceSelection(Utilities.toTitleString(selectedText));
    }

    @Override
    boolean isMain() {
        return this == this.getMain();
    }

    JNPadTextArea getMain() {
        try {
            return this.editPane.buffer.bufferSet.getViewer().getActiveBuffer().getSelectedTextArea();
        }
        catch (Exception ex) {
            JNPadFrame jNPad = GUIUtilities.getJNPadFrame(this);
            if (jNPad != null) {
                return jNPad.getActiveTextArea();
            }
            return this;
        }
    }

    JNPadKeyboardHandler getKeyboardHandler() {
        return this.editPane.buffer.getKeyboardHandler();
    }

    KeyListener getKeyEventInterceptor() {
        return this.editPane.buffer.getKeyEventInterceptor();
    }

    void setKeyEventInterceptor(KeyListener listener) {
        this.editPane.buffer.setKeyEventInterceptor(listener);
    }

    public int getAutoCompletionTrigger() {
        return this.autoCompletionTrigger;
    }

    public void setAutoCompletionTrigger(int i) {
        this.autoCompletionTrigger = i > 9 ? 9 : (i < 1 ? 1 : i);
    }

    public boolean isAutoCompletionEnabled() {
        return this.isAutoCompletionEnabled;
    }

    public void setAutoCompletionEnabled(boolean b) {
        if (b != this.isAutoCompletionEnabled) {
            this.isAutoCompletionEnabled = b;
            if (b) {
                this.autoCompletionListener.addTo(this);
            } else {
                this.autoCompletionListener.removeFrom(this);
            }
        }
    }

    public boolean isAutoCompletionAllViewsEnabled() {
        return this.isAutoCompletionAllViewsEnabled;
    }

    public void setAutoCompletionAllViewsEnabled(boolean b) {
        if (b != this.isAutoCompletionAllViewsEnabled) {
            this.isAutoCompletionAllViewsEnabled = b;
        }
    }

    public int getAutoCompletionDelay() {
        return this.autoCompletionListener.timer.getDelay();
    }

    public void setAutoCompletionDelay(int ms) {
        ms = Math.max(0, ms);
        this.autoCompletionListener.timer.stop();
        this.autoCompletionListener.timer.setInitialDelay(ms);
    }

    private boolean isCompletionPopupVisible() {
        return this.completionPopup != null && this.completionPopup.isVisible();
    }

    private boolean isAutoActivateOkay() {
        try {
            String word = CompletionUtilities.getWord(this, this.getCaretPosition() + 1);
            return !Utilities.isBlankString(word) && word.trim().length() >= this.getAutoCompletionTrigger();
        }
        catch (BadLocationException blex) {
            LOGGER.log(Level.WARNING, blex.getMessage(), blex);
            return false;
        }
    }

    private void doCompletion() {
        try {
            String word = CompletionUtilities.getWord(this, this.getCaretPosition());
            if (Utilities.isBlankString(word)) {
                return;
            }
            TreeSet<String> completions = new TreeSet<String>();
            int wordLen = word.length();
            String delimiters = this.getDelimiters();
            if (this.isAutoCompletionAllViewsEnabled()) {
                JNPadFrame jNPad = GUIUtilities.getJNPadFrame(this);
                if (jNPad != null) {
                    JNPadTextArea[] jNPadTextAreaArray = jNPad.getViewer().getTextAreas();
                    int n = jNPadTextAreaArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JNPadTextArea etxarea = jNPadTextAreaArray[n2];
                        CompletionUtilities.set(etxarea, word, wordLen, delimiters, completions);
                        ++n2;
                    }
                } else {
                    CompletionUtilities.set(this, word, wordLen, delimiters, completions);
                }
            } else {
                CompletionUtilities.set(this, word, wordLen, delimiters, completions);
            }
            if (completions.size() > 0) {
                String[] sCompletions = completions.toArray(new String[completions.size()]);
                if (this.completionPopup == null) {
                    this.completionPopup = new CompletionPopup(this);
                }
                this.completionPopup.showCompletions(word, sCompletions);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private class AutoCompletionListener
    extends FocusAdapter
    implements DocumentListener,
    CaretListener,
    ActionListener {
        private Timer timer = new Timer(200, this);
        private boolean justInserted;

        AutoCompletionListener() {
            this.timer.setRepeats(false);
        }

        void addTo(JTextComponent tc) {
            tc.addFocusListener(this);
            tc.getDocument().addDocumentListener(this);
            tc.addCaretListener(this);
        }

        void removeFrom(JTextComponent tc) {
            tc.removeFocusListener(this);
            tc.getDocument().removeDocumentListener(this);
            tc.removeCaretListener(this);
            this.timer.stop();
            this.justInserted = false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!JNPadTextArea.this.isCompletionPopupVisible()) {
                JNPadTextArea.this.doCompletion();
            }
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            if (this.justInserted) {
                this.justInserted = false;
            } else {
                this.timer.stop();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.timer.stop();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.justInserted = false;
            if (!JNPadTextArea.this.isCompletionPopupVisible() && JNPadTextArea.this.isAutoCompletionEnabled() && e.getLength() == 1) {
                if (JNPadTextArea.this.isAutoActivateOkay()) {
                    this.timer.restart();
                    this.justInserted = true;
                } else {
                    this.timer.stop();
                }
            } else {
                this.timer.stop();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.timer.stop();
        }
    }

    private class MyCaret
    extends DefaultCaret {
        private static final long serialVersionUID = -374425523031518455L;

        private MyCaret() {
        }

        @Override
        public void paint(Graphics g) {
            if (JNPadTextArea.this.isOverwriteTextMode()) {
                AffineTransform old = ((Graphics2D)g).getTransform();
                int w = (Integer)JNPadTextArea.this.getClientProperty(JNPadTextArea.PROPERTY_CARET_WIDTH);
                Color textAreaBg = JNPadTextArea.this.getBackground();
                if (textAreaBg == null) {
                    textAreaBg = Color.white;
                }
                g.setXORMode(textAreaBg);
                g.translate(w / 2, 0);
                super.paint(g);
                ((Graphics2D)g).setTransform(old);
            } else {
                super.paint(g);
            }
        }

        @Override
        protected synchronized void damage(Rectangle r) {
            if (JNPadTextArea.this.isOverwriteTextMode()) {
                if (r != null) {
                    int damageWidth = (Integer)JNPadTextArea.this.getClientProperty(JNPadTextArea.PROPERTY_CARET_WIDTH);
                    this.x = r.x - 4 - damageWidth / 2;
                    this.y = r.y;
                    this.width = 9 + 3 * damageWidth / 2;
                    this.height = r.height;
                    this.repaint();
                }
            } else {
                super.damage(r);
            }
        }
    }
}

