/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import jnpad.config.Configurable;
import jnpad.text.ActiveLine;
import jnpad.text.EditPane;
import jnpad.text.MiniViewerScrollPane;
import jnpad.text.MiniViewerTextArea;
import jnpad.text.SimpleGutter;
import jnpad.text.TextUtilities;

class MiniViewer
extends JPanel
implements Configurable {
    JScrollPane scrollPane = new MiniViewerScrollPane();
    MiniViewerTextArea textArea;
    private ActiveLine activeLine;
    private SimpleGutter gutter;
    private JViewport originalRowHeader;
    EditPane editPane;
    private static Logger LOGGER = Logger.getLogger(MiniViewer.class.getName());
    private static final long serialVersionUID = -189932606814033055L;

    MiniViewer(EditPane editPane) {
        super(new BorderLayout());
        this.editPane = editPane;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void jbInit() throws Exception {
        this.textArea = new MiniViewerTextArea(this.editPane);
        this.textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isPopupTrigger()) {
                    int pos = MiniViewer.this.textArea.getCaretPosition();
                    if (e.isControlDown()) {
                        MiniViewer.this.editPane.textArea.jumpToOffset(pos);
                        MiniViewer.this.editPane.tbShowMinimap.setSelected(false);
                    } else {
                        MiniViewer.this.editPane.textArea.setCaretPosition(pos);
                        TextUtilities.scrollToMiddle(MiniViewer.this.editPane.textArea, pos, 0.75f);
                    }
                }
            }
        });
        this.setOpaque(false);
        this.originalRowHeader = this.scrollPane.getRowHeader();
        this.setLineNumbersVisible(this.editPane.isLineNumbersVisible());
        this.setActiveLineVisible(this.editPane.isActiveLineVisible());
        this.scrollPane.getViewport().add((Component)this.textArea, null);
        this.add((Component)this.scrollPane, "Center");
    }

    void repaintGutter() {
        if (this.gutter != null) {
            this.gutter.repaint();
        }
    }

    void centerViewport() {
        this.textArea.scrollToMiddle(this.textArea.getCaretPosition());
    }

    void setActiveLineVisible(boolean b) {
        if (b) {
            if (this.activeLine == null) {
                this.activeLine = new ActiveLine(this.textArea);
            } else {
                this.activeLine.setVisible(true);
            }
        } else if (this.activeLine != null) {
            this.activeLine.setVisible(false);
        }
        this.revalidate();
        this.repaint();
    }

    void setLineNumbersVisible(boolean b) {
        if (b) {
            if (this.gutter == null) {
                this.gutter = new SimpleGutter(this.textArea);
            }
            this.scrollPane.setRowHeaderView(this.gutter);
        } else {
            this.scrollPane.setRowHeader(this.originalRowHeader);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void configure(int cfg) {
        this.textArea.configure(cfg);
        if (this.gutter != null) {
            this.gutter.configure(cfg);
        }
        if (this.activeLine != null) {
            this.activeLine.configure(cfg);
        }
        if ((cfg & 4) != 0) {
            this.setLineNumbersVisible(this.editPane.isLineNumbersVisible());
            this.setActiveLineVisible(this.editPane.isActiveLineVisible());
        }
    }
}

