/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text.syntax;

import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnpad.JNPad;
import jnpad.config.Config;
import jnpad.text.syntax.SyntaxScheme;
import jnpad.util.Utilities;

public class JavaScheme
extends SyntaxScheme {
    static Color modifierColor;
    static Color exceptionColor;
    static Color flowControlColor;
    static Color dataTypeColor;
    static Color dataValueColor;
    static Color annotationColor;
    static Color popClassColor;
    static Color javadocColor;
    static Color javadocTagColor;
    static Color javadocParamColor;
    static Color operatorColor_;
    static Color reservedColor;
    static Color classColor;
    static Color constantColor;
    Font modifierFont;
    Font exceptionFont;
    Font flowControlFont;
    Font dataTypeFont;
    Font dataValueFont;
    Font annotationFont;
    Font popClassFont;
    Font javadocFont;
    Font javadocTagFont;
    Font javadocParamFont;
    Font operatorFont_;
    Font reservedFont;
    Font classFont;
    Font constantFont;
    static boolean classify;
    static boolean classify2;
    static boolean known;
    private static final char[] OPERATORS;
    static Map<String, WordType> m_specialWords;
    static List<String> l_javadocTags;
    private static final Logger LOGGER;
    private static final long serialVersionUID = 394666138406715548L;

    static {
        block26: {
            OPERATORS = new char[]{'-', '+', '*', '/', '<', '>', '!', '~', '%', '^', '&', '|', '=', '.'};
            m_specialWords = new HashMap<String, WordType>();
            l_javadocTags = new ArrayList<String>();
            LOGGER = Logger.getLogger(JavaScheme.class.getName());
            if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.config("Java Scheme - init.");
            }
            classify = Config.SYNTAX_CLASSIFY_ENABLED.getValue();
            classify2 = Config.SYNTAX_CLASSIFY2_ENABLED.getValue();
            known = Config.SYNTAX_KNOWN_ENABLED.getValue();
            BufferedReader in = null;
            try {
                try {
                    String line;
                    String dir = String.valueOf(JNPad.PROPS_DIR) + Utilities.DIR_SEPARATOR + "schemes";
                    String file = String.valueOf(dir) + Utilities.DIR_SEPARATOR + "java.words";
                    in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                    while ((line = in.readLine()) != null && !line.equals(":KEYWORDS")) {
                    }
                    while ((line = in.readLine()) != null && !line.equals(":MODIFIERS")) {
                        JavaScheme.read(line, WordType.KEYWORD);
                    }
                    while ((line = in.readLine()) != null && !line.equals(":EXCEPTIONS")) {
                        JavaScheme.read(line, WordType.MODIFIER);
                    }
                    while ((line = in.readLine()) != null && !line.equals(":FLOW_CONTROLS")) {
                        JavaScheme.read(line, WordType.EXCEPTION);
                    }
                    while ((line = in.readLine()) != null && !line.equals(":DATA_TYPES")) {
                        JavaScheme.read(line, WordType.FLOW_CONTROL);
                    }
                    while ((line = in.readLine()) != null && !line.equals(":DATA_VALUES")) {
                        JavaScheme.read(line, WordType.DATA_TYPE);
                    }
                    while ((line = in.readLine()) != null && !line.equals(":OPERATORS")) {
                        JavaScheme.read(line, WordType.DATA_VALUE);
                    }
                    while ((line = in.readLine()) != null && !line.equals(":RESERVED")) {
                        JavaScheme.read(line, WordType.OPERATOR);
                    }
                    while ((line = in.readLine()) != null && !line.equals(":POP_CLASSES")) {
                        JavaScheme.read(line, WordType.RESERVED);
                    }
                    if (known) {
                        while ((line = in.readLine()) != null) {
                            JavaScheme.read(line, WordType.POP_CLASS);
                        }
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block26;
                    }
                    catch (IOException ex2) {
                        LOGGER.log(Level.WARNING, ex2.getMessage(), ex2);
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                }
                throw throwable;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        l_javadocTags.add("@author");
        l_javadocTags.add("@deprecated");
        l_javadocTags.add("@exception");
        l_javadocTags.add("@param");
        l_javadocTags.add("@return");
        l_javadocTags.add("@see");
        l_javadocTags.add("@serial");
        l_javadocTags.add("@serialData");
        l_javadocTags.add("@serialField");
        l_javadocTags.add("@since");
        l_javadocTags.add("@throws");
        l_javadocTags.add("@version");
    }

    private static void read(String line, WordType type) {
        if (Utilities.isBlankString(line) || line.startsWith("::")) {
            return;
        }
        m_specialWords.put(line.trim(), type);
    }

    public JavaScheme(boolean mini) {
        super(mini);
        this.doUpdateColors();
        this.doUpdateFonts();
    }

    private void doUpdateColors() {
        classify = Config.SYNTAX_CLASSIFY_ENABLED.getValue();
        classify2 = Config.SYNTAX_CLASSIFY2_ENABLED.getValue();
        modifierColor = Config.SYNTAX_KEYWORD2_COLOR.getValue();
        exceptionColor = Config.SYNTAX_KEYWORD3_COLOR.getValue();
        flowControlColor = Config.SYNTAX_KEYWORD4_COLOR.getValue();
        dataTypeColor = Config.SYNTAX_KEYWORD5_COLOR.getValue();
        dataValueColor = Config.SYNTAX_KEYWORD6_COLOR.getValue();
        operatorColor_ = Config.SYNTAX_KEYWORD7_COLOR.getValue();
        popClassColor = Config.SYNTAX_KEYWORD8_COLOR.getValue();
        reservedColor = Config.SYNTAX_KEYWORD9_COLOR.getValue();
        classColor = Config.SYNTAX_KEYWORD10_COLOR.getValue();
        constantColor = Config.SYNTAX_KEYWORD11_COLOR.getValue();
        javadocColor = Config.SYNTAX_COMMENT1_COLOR.getValue();
        javadocTagColor = Config.SYNTAX_COMMENT2_COLOR.getValue();
        annotationColor = Config.SYNTAX_COMMENT3_COLOR.getValue();
        javadocParamColor = Config.SYNTAX_COMMENT4_COLOR.getValue();
    }

    private void doUpdateFonts() {
        this.modifierFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD2_STYLE.getValue());
        this.exceptionFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD3_STYLE.getValue());
        this.flowControlFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD4_STYLE.getValue());
        this.dataTypeFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD5_STYLE.getValue());
        this.dataValueFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD6_STYLE.getValue());
        this.operatorFont_ = this.textFont.deriveFont(Config.SYNTAX_KEYWORD7_STYLE.getValue());
        this.popClassFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD8_STYLE.getValue());
        this.reservedFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD9_STYLE.getValue());
        this.classFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD10_STYLE.getValue());
        this.constantFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD11_STYLE.getValue());
        this.javadocFont = this.textFont.deriveFont(Config.SYNTAX_COMMENT1_STYLE.getValue());
        this.javadocTagFont = this.textFont.deriveFont(Config.SYNTAX_COMMENT2_STYLE.getValue());
        this.annotationFont = this.textFont.deriveFont(Config.SYNTAX_COMMENT3_STYLE.getValue());
        this.javadocParamFont = this.textFont.deriveFont(Config.SYNTAX_COMMENT4_STYLE.getValue());
    }

    @Override
    public void setTextFont(Font f) {
        super.setTextFont(f);
        this.doUpdateFonts();
    }

    @Override
    public void configure(int cfg) {
        super.configure(cfg);
        if ((cfg & 1) != 0) {
            this.doUpdateColors();
        }
        if ((cfg & 2) != 0) {
            this.doUpdateFonts();
        }
    }

    public boolean isJavadocTag(String tag) {
        return l_javadocTags.contains(tag);
    }

    public Color getJavadocTagColor() {
        return javadocTagColor;
    }

    public Font getJavadocTagFont() {
        return this.javadocTagFont;
    }

    public Color getJavadocColor() {
        return javadocColor;
    }

    public Font getJavadocFont() {
        return this.javadocFont;
    }

    public Color getJavadocParamColor() {
        return javadocParamColor;
    }

    public Font getJavadocParamFont() {
        return this.javadocParamFont;
    }

    public WordType getWordType(String word) {
        WordType type = m_specialWords.get(word);
        if (classify2 && type == null) {
            if (Utilities.isUpperCase2(word)) {
                return WordType.CONSTANT;
            }
            if (Utilities.isTitleCase(word)) {
                return WordType.CLASS;
            }
        }
        return type != null ? type : WordType.TEXT;
    }

    public Color getWordColor(WordType type) {
        if (type == null) {
            return this.textColor;
        }
        switch (type) {
            case KEYWORD: {
                return keywordColor;
            }
            case RESERVED: {
                return reservedColor;
            }
            case OPERATOR: {
                return classify ? operatorColor_ : keywordColor;
            }
            case EXCEPTION: {
                return classify ? exceptionColor : keywordColor;
            }
            case MODIFIER: {
                return classify ? modifierColor : keywordColor;
            }
            case FLOW_CONTROL: {
                return classify ? flowControlColor : keywordColor;
            }
            case DATA_TYPE: {
                return classify ? dataTypeColor : keywordColor;
            }
            case DATA_VALUE: {
                return classify ? dataValueColor : keywordColor;
            }
            case POP_CLASS: {
                return classify && known ? popClassColor : (classify2 ? classColor : this.textColor);
            }
            case CLASS: {
                return classify2 ? classColor : this.textColor;
            }
            case CONSTANT: {
                return classify2 ? constantColor : this.textColor;
            }
        }
        return this.textColor;
    }

    public Font getWordFont(WordType type) {
        if (type == null) {
            return this.textFont;
        }
        switch (type) {
            case KEYWORD: {
                return this.keywordFont;
            }
            case RESERVED: {
                return this.reservedFont;
            }
            case OPERATOR: {
                return classify ? this.operatorFont_ : this.keywordFont;
            }
            case EXCEPTION: {
                return classify ? this.exceptionFont : this.keywordFont;
            }
            case MODIFIER: {
                return classify ? this.modifierFont : this.keywordFont;
            }
            case FLOW_CONTROL: {
                return classify ? this.flowControlFont : this.keywordFont;
            }
            case DATA_TYPE: {
                return classify ? this.dataTypeFont : this.keywordFont;
            }
            case DATA_VALUE: {
                return classify ? this.dataValueFont : this.keywordFont;
            }
            case POP_CLASS: {
                return classify && known ? this.popClassFont : (classify2 ? this.classFont : this.textFont);
            }
            case CLASS: {
                return classify2 ? this.classFont : this.textFont;
            }
            case CONSTANT: {
                return classify2 ? this.constantFont : this.textFont;
            }
        }
        return this.textFont;
    }

    public Color getAnnotationColor() {
        return annotationColor;
    }

    public Font getAnnotationFont() {
        return this.annotationFont;
    }

    @Override
    public char[] getOperators() {
        return Utilities.copyOf(OPERATORS);
    }

    @Override
    public String getContentType() {
        return "text/java";
    }

    @Override
    public String[] getStartComment() {
        return new String[]{"//"};
    }

    @Override
    public String[] getEndComment() {
        return new String[]{"\n"};
    }

    @Override
    public String[] getStartMultilineComment() {
        return new String[]{"/*"};
    }

    @Override
    public String[] getEndMultilineComment() {
        return new String[]{"*/"};
    }

    static enum WordType {
        RESERVED,
        KEYWORD,
        MODIFIER,
        EXCEPTION,
        FLOW_CONTROL,
        DATA_TYPE,
        DATA_VALUE,
        OPERATOR,
        POP_CLASS,
        CLASS,
        CONSTANT,
        TEXT;

    }
}

