/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JRadioButtonMenuItem;
import jnpad.GUIUtilities;
import jnpad.action.JNPadAction;
import jnpad.ui.status.StatusDisplayable;

public class JNPadRadioButtonMenuItem
extends JRadioButtonMenuItem {
    private String _description;
    private boolean _descriptionSet;
    private StatusDisplayable _displayable;
    private static final long serialVersionUID = -2344486457780612910L;

    public JNPadRadioButtonMenuItem() {
    }

    public JNPadRadioButtonMenuItem(String text) {
        super(text);
    }

    public JNPadRadioButtonMenuItem(String text, boolean b) {
        super(text, b);
    }

    public JNPadRadioButtonMenuItem(Icon icon) {
        super(icon);
    }

    public JNPadRadioButtonMenuItem(Icon icon, boolean b) {
        super(icon, b);
    }

    public JNPadRadioButtonMenuItem(String text, Icon icon) {
        super(text, icon);
    }

    public JNPadRadioButtonMenuItem(String text, Icon icon, boolean b) {
        super(text, icon, b);
    }

    public JNPadRadioButtonMenuItem(Action a) {
        this(a, null);
    }

    public JNPadRadioButtonMenuItem(Action a, ButtonGroup group) {
        super(a);
        if (a instanceof JNPadAction) {
            this.setText(((JNPadAction)a).getLabel());
            this.setDescription(((JNPadAction)a).getDescription());
            this.addItemListener((JNPadAction)a);
        }
        if (group != null) {
            group.add(this);
        }
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void setStatusDisplayable(StatusDisplayable displayable) {
        this._displayable = displayable;
    }

    public StatusDisplayable getStatusDisplayable() {
        return this._displayable;
    }

    private StatusDisplayable getStatusDisplayable(MouseEvent e) {
        if (this._displayable == null) {
            this._displayable = GUIUtilities.getJNPadFrame(e);
        }
        return this._displayable;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (this._description != null) {
            switch (e.getID()) {
                case 504: {
                    this.getStatusDisplayable(e).setStatus(this._description);
                    this._descriptionSet = true;
                    break;
                }
                case 502: 
                case 505: {
                    if (!this._descriptionSet) break;
                    this.getStatusDisplayable(e).clearStatus();
                    this._descriptionSet = false;
                    break;
                }
            }
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void paintComponent(Graphics g) {
        GUIUtilities.setRenderingHints(g);
        super.paintComponent(g);
    }
}

