/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui;

import java.awt.Window;
import javax.swing.JOptionPane;
import jnpad.JNPadBundle;
import jnpad.ui.ExceptionDialog;

public final class ReporterUtilities {
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    private static final String ERROR_TITLE = JNPadBundle.getErrorTitle();
    private static final String INFORMATION_TITLE = JNPadBundle.getInformationTitle();
    private static final String WARNING_TITLE = JNPadBundle.getWarningTitle();
    private static final String OK_OPTION = JNPadBundle.getOkOptionText();
    private static final String DETAILS_OPTION = JNPadBundle.getDetailsOptionText();

    private ReporterUtilities() {
    }

    public static void reportError(Window window, String message, String title) {
        ReporterUtilities.reportMsg(window, 0, message, title, null);
    }

    public static void reportError(Window window, String message) {
        ReporterUtilities.reportMsg(window, 0, message, null, null);
    }

    public static void reportError(Window window, String message, String title, Throwable ex) {
        ReporterUtilities.reportMsg(window, 0, message, title, ex);
    }

    public static void reportInfo(Window window, String message, String title) {
        ReporterUtilities.reportMsg(window, 1, message, title, null);
    }

    public static void reportInfo(Window window, String message) {
        ReporterUtilities.reportMsg(window, 1, message, null, null);
    }

    public static void reportWarning(Window window, String message, String title) {
        ReporterUtilities.reportMsg(window, 2, message, title, null);
    }

    public static void reportWarning(Window window, String message) {
        ReporterUtilities.reportMsg(window, 2, message, null, null);
    }

    public static void reportMsg(Window window, int messageType, String message) {
        ReporterUtilities.reportMsg(window, messageType, message, null, null);
    }

    public static void reportMsg(Window window, int messageType, String message, String title) {
        ReporterUtilities.reportMsg(window, messageType, message, title, null);
    }

    public static void reportMsg(Window window, int messageType, String message, String title, Throwable ex) {
        if (messageType == 0) {
            if (ex == null) {
                JOptionPane.showMessageDialog(window, message, title == null ? ERROR_TITLE : title, 0);
            } else {
                Object[] options;
                int option = JOptionPane.showOptionDialog(window, message, title == null ? ERROR_TITLE : title, -1, 0, null, options = new String[]{OK_OPTION, DETAILS_OPTION}, options[0]);
                if (option == 1) {
                    new ExceptionDialog(window, title == null ? ERROR_TITLE : title, message, ex, true);
                }
            }
        } else if (messageType == 1) {
            JOptionPane.showMessageDialog(window, message, title == null ? INFORMATION_TITLE : title, 1);
        } else if (messageType == 2) {
            JOptionPane.showMessageDialog(window, message, title == null ? WARNING_TITLE : title, 2);
        } else {
            JOptionPane.showMessageDialog(window, JNPadBundle.getString("ReporterUtils.message.error", new Object[0]), ERROR_TITLE, 0);
        }
    }
}

