/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import jnpad.ui.table.TableUtilities;

public class BooleanRenderer
extends JCheckBox
implements TableCellRenderer {
    protected boolean supportsFocusBorder;
    protected boolean tooltipEnabled;
    protected boolean alternateRowColorEnabled = true;
    protected Color alternateRowColor;
    private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final long serialVersionUID = 1569030349242768678L;

    public BooleanRenderer() {
        this(0, true);
    }

    public BooleanRenderer(int alignment) {
        this(alignment, true);
    }

    public BooleanRenderer(int alignment, boolean tooltipEnabled) {
        this.tooltipEnabled = tooltipEnabled;
        this.setOpaque(true);
        this.setHorizontalAlignment(alignment);
        this.setSupportsFocusBorder(true);
    }

    public void setSupportsFocusBorder(boolean supportsFocusBorder) {
        this.supportsFocusBorder = supportsFocusBorder;
        if (supportsFocusBorder) {
            this.setBorder(BooleanRenderer.getNoFocusBorder());
        }
    }

    public boolean getSupportsFocusBorder() {
        return this.supportsFocusBorder;
    }

    protected static Border getNoFocusBorder() {
        Border border = UIManager.getBorder("Table.cellNoFocusBorder");
        if (border != null) {
            return border;
        }
        return DEFAULT_NO_FOCUS_BORDER;
    }

    public boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    public void setTooltipEnabled(boolean tooltipEnabled) {
        this.tooltipEnabled = tooltipEnabled;
    }

    public boolean isAlternateRowColorEnabled() {
        return this.alternateRowColorEnabled;
    }

    public void setAlternateRowColorEnabled(boolean alternateRowColorEnabled) {
        this.alternateRowColorEnabled = alternateRowColorEnabled;
    }

    public Color getAlternateRowColor() {
        return this.alternateRowColor;
    }

    public void setAlternateRowColor(Color alternateRowColor) {
        this.alternateRowColor = alternateRowColor;
        this.alternateRowColorEnabled = alternateRowColor != null;
    }

    protected void setColors(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableUtilities.setColors(this, table, isSelected, row, this.alternateRowColorEnabled, this.alternateRowColor);
    }

    protected void setBorder(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableUtilities.setBorder(this, table, isSelected, hasFocus, row, column, BooleanRenderer.getNoFocusBorder());
    }

    protected void setState(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
    }

    protected void setValue(JTable table, Object value, int row, int column) {
        if (value != null) {
            if (value instanceof Boolean) {
                this.setSelected((Boolean)value);
            } else {
                this.setSelected(Boolean.valueOf(value.toString()));
            }
        }
    }

    protected void setFont(JTable table, Object value, int row, int column) {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setColors(table, value, isSelected, hasFocus, row, column);
        this.setFont(table, value, row, column);
        if (this.supportsFocusBorder) {
            this.setBorder(table, value, isSelected, hasFocus, row, column);
        }
        this.setState(table, value, isSelected, hasFocus, row, column);
        this.setValue(table, value, row, column);
        return this;
    }
}

