/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.toolbar;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import jnpad.JNPadBundle;
import jnpad.ui.plaf.LAFUtils;
import jnpad.ui.toolbar.DropDownIcon;
import jnpad.ui.toolbar.ToolBarButton;

public class PopupButton2
extends ToolBarButton {
    private JPopupMenu popupMenu;
    private Icon _standardIcon;
    private Icon _realIcon;
    private boolean showSplitter;
    private String dropDownToolTip;
    private String tooltip;
    private static final Logger LOGGER = Logger.getLogger(PopupButton2.class.getName());
    private static final long serialVersionUID = -7604550184286894909L;

    public PopupButton2() {
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseMotionListener(mouseHandler);
        this.addMouseListener(mouseHandler);
    }

    public PopupButton2(JPopupMenu popup, Icon icon) {
        this();
        this.popupMenu = popup;
        this.setIcon(icon);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popup) {
        this.popupMenu = popup;
    }

    @Override
    public final void setIcon(Icon icon) {
        this._realIcon = icon;
        if (icon != null && icon instanceof ImageIcon) {
            this._standardIcon = new DropDownIcon((ImageIcon)icon);
            super.setIcon(this._standardIcon);
        } else {
            super.setIcon(icon);
        }
    }

    protected void showPopup() {
        if (this.popupMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.popupMenu);
            this.popupMenu.pack();
            this.popupMenu.show(this, 0, this.getHeight());
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        try {
            if (this.showSplitter) {
                this.showSplitter(LAFUtils.getControlDkShadow(), g, this.getSplitterPosn(), 1, this.getHeight() - 4);
                this.showSplitter(LAFUtils.getControlHighlight(), g, this.getSplitterPosn() + 1, 1, this.getHeight() - 4);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private int getSplitterPosn() {
        return this.getIconPosn() + this._realIcon.getIconWidth() + 3;
    }

    private int getIconPosn() {
        int x = (this.getWidth() - this._standardIcon.getIconWidth()) / 2;
        return x;
    }

    public void setDropDownToolTipText(String dropDownToolTip) {
        this.dropDownToolTip = dropDownToolTip;
    }

    private void showSplitter(Color c, Graphics g, int x, int y, int height) {
        g.setColor(c);
        g.drawLine(x, y + 0, x, y + height);
    }

    private void showSplitter(boolean show) {
        if (show && !this.showSplitter) {
            this.showSplitter = true;
            this.repaint();
            String tt = null;
            Container parent = this.getParent();
            if (parent instanceof JComponent) {
                tt = this.dropDownToolTip;
            }
            if (tt == null) {
                tt = JNPadBundle.getString("PopupButton.select", new Object[0]);
            }
            super.setToolTipText(tt);
        } else if (!show && this.showSplitter) {
            this.showSplitter = false;
            this.repaint();
            super.setToolTipText(this.tooltip);
        }
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.tooltip = text;
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        if (this.showSplitter) {
            this.showPopup();
        } else {
            super.fireActionPerformed(event);
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (PopupButton2.this._standardIcon != null) {
                PopupButton2.this.showSplitter(e.getX() >= PopupButton2.this.getSplitterPosn());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (PopupButton2.this._standardIcon != null) {
                PopupButton2.this.showSplitter(e.getX() >= PopupButton2.this.getSplitterPosn());
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (PopupButton2.this._standardIcon != null) {
                PopupButton2.this.showSplitter(false);
            }
        }
    }
}

