/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad;

import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import jnpad.text.BufferSet;
import jnpad.text.Buffer;

/**
 * The Class JNPadCardViewer.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class JNPadCardViewer extends JNPadViewer {
  /** UID */
  private static final long serialVersionUID = 2471521304520348152L;

  /**
   * Instantiates a new jNPad card viewer.
   *
   * @param jNPad the jNPpad's frame
   * @param mWindow the window menu
   */
  public JNPadCardViewer(JNPadFrame jNPad, JMenu mWindow) {
    super(jNPad, mWindow);
    
    _bufferSet = new JNPadCardPane(this);
    _bufferSet.addChangeListener(new ChangeListener() {
      public void stateChanged(final ChangeEvent e) {
        handleStateChanged(e);
      }
    });
    setMainContent((JNPadCardPane) _bufferSet);
  }

  /**
   * Gets the jNPad card pane.
   *
   * @return the jNPad card pane
   */
  public JNPadCardPane getJNPadCardPane() {
    return (JNPadCardPane) _bufferSet;
  }

  /**
   * Creates the buffer set.
   *
   * @param oldBufferSet the old buffer set
   * @return the buffer set
   * @see jnpad.text.Viewer#createBufferSet(jnpad.text.BufferSet)
   */
  @Override
  protected BufferSet createBufferSet(BufferSet oldBufferSet) {
    JNPadCardPane newBufferSet = new JNPadCardPane(this);

    for (int i = 0; i < _bufferSet.getTabCount(); i++) {
      Buffer buffer = _bufferSet.getBufferAt(i);
      
      Buffer e = create(newBufferSet, buffer);
      
      final String title = _bufferSet.getTitleAt(i);
      final String tip = _bufferSet.getToolTipTextAt(i);
      final Icon icon = _bufferSet.getIconAt(i);
      
      newBufferSet.insertTab(title, icon, e, tip, i); 
    }

    newBufferSet.addChangeListener(new ChangeListener() {
      public void stateChanged(final ChangeEvent e) {
        handleStateChanged(e);
      }
    });

    return newBufferSet;
  }
  
}
