/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui;

import java.awt.Graphics;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;

import jnpad.GUIUtilities;

/**
 * 
 * @version 0.3
 * @since   jNPad v0.1
 */
public class JNPadCheckBox extends JCheckBox {
  /** UID */
  private static final long serialVersionUID = 5356810033492166867L;

  /**
   * 
   */
  public JNPadCheckBox() {
    super();
  }

  /**
   * @param icon Icon
   */
  public JNPadCheckBox(Icon icon) {
    super(icon);
  }

  /**
   * @param text String
   */
  public JNPadCheckBox(String text) {
    super(text);
  }

  /**
   * @param a Action
   */
  public JNPadCheckBox(Action a) {
    super(a);
  }

  /**
   * @param icon Icon
   * @param selected boolean
   */
  public JNPadCheckBox(Icon icon, boolean selected) {
    super(icon, selected);
  }

  /**
   * @param text String
   * @param selected boolean
   */
  public JNPadCheckBox(String text, boolean selected) {
    super(text, selected);
  }

  /**
   * @param text String
   * @param icon Icon
   */
  public JNPadCheckBox(String text, Icon icon) {
    super(text, icon);
  }

  /**
   * @param text String
   * @param icon Icon
   * @param selected boolean
   */
  public JNPadCheckBox(String text, Icon icon, boolean selected) {
    super(text, icon, selected);
  }

  /**
   * 
   * @param g Graphics
   */
  @Override
  protected void paintComponent(Graphics g) {
    GUIUtilities.setRenderingHints(g);
    super.paintComponent(g);
  }
  
}
