/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.io.Serializable;

import javax.swing.BoxLayout;

/**
 * The Class BoxLayout2.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class BoxLayout2 implements LayoutManager2, Serializable {
  private BoxLayout         layout;
  private int               axis;

  /** UID */
  private static final long serialVersionUID = 8388127824798617473L;

  /**
   * Instantiates a new box layout2.
   */
  public BoxLayout2() {
    //empty
  }

  /**
   * Instantiates a new box layout2.
   *
   * @param parent Container
   * @param axis int
   */
  public BoxLayout2(Container parent, int axis) {
    this.axis = axis;
    layout = new BoxLayout(parent, axis);
  }

  /**
   * Gets the axis.
   *
   * @return the axis
   */
  public int getAxis() {
    return axis;
  }

  /**
   * Sets the axis.
   *
   * @param axis the new axis
   */
  public void setAxis(int axis) {
    if (axis != this.axis) {
      layout = null;
      this.axis = axis;
    }
  }

  /**
   * Verify instance.
   *
   * @param parent the parent
   */
  void verifyInstance(Container parent) {
    if (layout == null) {
      layout = new BoxLayout(parent, axis);
    }
  }

  /**
   * Adds the layout component.
   *
   * @param component the component
   * @param constraint the constraint
   * @see java.awt.LayoutManager2#addLayoutComponent(java.awt.Component, java.lang.Object)
   */
  @Override
  public void addLayoutComponent(Component component, Object constraint) {
    try {
      component.getParent().invalidate();
    }
    catch (Exception ex) {
      //ignored
    }
  }

  /**
   * Maximum layout size.
   *
   * @param parent the parent
   * @return the dimension
   * @see java.awt.LayoutManager2#maximumLayoutSize(java.awt.Container)
   */
  @Override
  public Dimension maximumLayoutSize(Container parent) {
    verifyInstance(parent);
    return layout.maximumLayoutSize(parent);
  }

  /**
   * Gets the layout alignment x.
   *
   * @param parent the parent
   * @return the layout alignment x
   * @see java.awt.LayoutManager2#getLayoutAlignmentX(java.awt.Container)
   */
  @Override
  public float getLayoutAlignmentX(Container parent) {
    verifyInstance(parent);
    return layout.getLayoutAlignmentX(parent);
  }

  /**
   * Gets the layout alignment y.
   *
   * @param parent the parent
   * @return the layout alignment y
   * @see java.awt.LayoutManager2#getLayoutAlignmentY(java.awt.Container)
   */
  @Override
  public float getLayoutAlignmentY(Container parent) {
    verifyInstance(parent);
    return layout.getLayoutAlignmentY(parent);
  }

  /**
   * Invalidate layout.
   *
   * @param parent the parent
   * @see java.awt.LayoutManager2#invalidateLayout(java.awt.Container)
   */
  @Override
  public void invalidateLayout(Container parent) {
    verifyInstance(parent);
    layout.invalidateLayout(parent);
  }

  /**
   * Adds the layout component.
   *
   * @param name the name
   * @param component the component
   * @see java.awt.LayoutManager#addLayoutComponent(java.lang.String, java.awt.Component)
   */
  @Override
  public void addLayoutComponent(String name, Component component) {
    try {
      component.getParent().invalidate();
    }
    catch (Exception ex) {
      //ignored
    }
  }

  /**
   * Removes the layout component.
   *
   * @param component the component
   * @see java.awt.LayoutManager#removeLayoutComponent(java.awt.Component)
   */
  @Override
  public void removeLayoutComponent(Component component) {
    try {
      component.getParent().invalidate();
    }
    catch (Exception ex) {
      //ignored
    }
  }

  /**
   * Preferred layout size.
   *
   * @param parent the parent
   * @return the dimension
   * @see java.awt.LayoutManager#preferredLayoutSize(java.awt.Container)
   */
  @Override
  public Dimension preferredLayoutSize(Container parent) {
    verifyInstance(parent);
    return layout.preferredLayoutSize(parent);
  }

  /**
   * Minimum layout size.
   *
   * @param parent the parent
   * @return the dimension
   * @see java.awt.LayoutManager#minimumLayoutSize(java.awt.Container)
   */
  @Override
  public Dimension minimumLayoutSize(Container parent) {
    verifyInstance(parent);
    return layout.minimumLayoutSize(parent);
  }

  /**
   * Layout container.
   *
   * @param parent the parent
   * @see java.awt.LayoutManager#layoutContainer(java.awt.Container)
   */
  @Override
  public void layoutContainer(Container parent) {
    verifyInstance(parent);
    layout.layoutContainer(parent);
  }

}
