/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentCache;
import sunw.hotjava.doc.DocumentPanel;
import sunw.hotjava.doc.MasterDocumentPanel;
import sunw.hotjava.misc.Hax;

class ClientPuller
extends Thread {
    MasterDocumentPanel topView;
    DocumentPanel target;
    URL originalURL;
    String refreshment;
    int delay;

    ClientPuller(MasterDocumentPanel masterDocumentPanel, DocumentPanel documentPanel, URL uRL, String string, int n) {
        this.topView = masterDocumentPanel;
        this.target = documentPanel;
        this.originalURL = uRL;
        this.refreshment = string == null || string.length() == 0 ? uRL.toExternalForm() : string;
        this.delay = n;
        this.setName("Client-pull: " + string);
        this.setPriority(3);
    }

    boolean isCurrentDoc() {
        return this.target.getDocument().getURL() == DocumentCache.getDocument(this.originalURL, null).getURL();
    }

    void refreshDocument() {
        try {
            URL uRL = this.target.getDocument().getBaseURL();
            URL uRL2 = new URL(uRL, this.refreshment);
            if (DocumentCache.seenDocument(uRL2)) {
                DocumentCache.removeDocument(uRL2);
            }
            Hax.debugln("hotjava.debug.MasterDocumentPanel.ClientPull", "... refreshing " + this.originalURL.toExternalForm() + " with " + uRL2.toExternalForm());
            this.topView.push((Component)this.target, "_replace", uRL2);
            Document document = DocumentCache.getDocument(uRL);
            document.setExpirationDate(new Date());
            return;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return;
        }
    }

    public void run() {
        Hax.debugln("hotjava.debug.MasterDocumentPanel.ClientPull", "ClientPuller refresh thread running:\n... refresh '" + this.refreshment + "'\n... delay = " + this.delay);
        long l = (long)(this.delay * 1000) + System.currentTimeMillis();
        while (this.isCurrentDoc()) {
            if (System.currentTimeMillis() >= l && this.isCurrentDoc()) {
                this.refreshDocument();
                return;
            }
            Hax.sleep(2000L);
        }
        return;
    }
}

