/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import sunw.hotjava.doc.DocumentFormatter;
import sunw.hotjava.doc.DocumentPanel;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.FormatterOwner;

public class DocumentFormatterPanel
extends Panel
implements FormatterOwner {
    DocumentPanel docPanel;
    int width;
    int height;
    private boolean completed = false;

    public DocumentFormatterPanel() {
        this.setLayout(null);
        1 var1_1 = new 1();
        this.addKeyListener(var1_1);
    }

    void setDocumentPanel(DocumentPanel documentPanel) {
        this.docPanel = documentPanel;
        this.height = 0;
        this.width = 0;
    }

    public void paint(Graphics graphics) {
        DocumentFormatter documentFormatter = this.docPanel.getFormatter();
        if (documentFormatter != null) {
            if (documentFormatter.getDocument() == null && (documentFormatter.docWidth == 0 || documentFormatter.docHeight == 0)) {
                return;
            }
            Point point = this.location();
            Dimension dimension = this.docPanel.size();
            int n = this.docPanel.getHorizontalInset(false);
            int n2 = this.docPanel.getVerticalInset(false);
            if (documentFormatter.docWidth <= dimension.width) {
                documentFormatter.setDocumentX(0);
            } else if (point.x + dimension.width - n > documentFormatter.docWidth) {
                documentFormatter.setDocumentX(documentFormatter.docWidth - dimension.width + n);
            } else {
                documentFormatter.setDocumentX(-point.x);
            }
            if (documentFormatter.docHeight <= dimension.height) {
                documentFormatter.setDocumentY(0);
            } else if (point.y + dimension.height - n2 > documentFormatter.docHeight) {
                documentFormatter.setDocumentY(documentFormatter.docHeight - dimension.height + n2);
            } else {
                documentFormatter.setDocumentY(-point.y);
            }
            documentFormatter.paint(graphics, true);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public Formatter getFormatter() {
        return this.docPanel.current.getFormatter();
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean clearCompleted() {
        boolean bl = this.completed;
        this.completed = false;
        return bl;
    }

    void setCompleted(boolean bl) {
        this.completed = bl;
    }

    private final class 1
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (DocumentFormatterPanel.this.docPanel != null && keyEvent.isActionKey()) {
                if (DocumentFormatterPanel.this.docPanel.getFormatter() != null) {
                    DocumentFormatterPanel.this.docPanel.processKeyActionEvent(keyEvent);
                    DocumentFormatterPanel.this.requestFocus();
                }
                return;
            }
        }

        /* synthetic */ 1() {
        }
    }
}

