/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.misc;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import sunw.hotjava.misc.Hax;

public class RfcDateParser {
    private static final String debugProp = "hotjava.debug.RfcDateParser";
    static final String[] standardFormats = new String[]{"EEEE', 'dd-MMM-yy HH:mm:ss z", "EEE', 'dd-MMM-yyyy HH:mm:ss z", "EEE', 'dd MMM yyyy HH:mm:ss z", "EEEE', 'dd MMM yyyy HH:mm:ss z", "EEE', 'dd MMM yyyy hh:mm:ss z", "EEEE', 'dd MMM yyyy hh:mm:ss z", "EEE MMM dd HH:mm:ss yyyy", "EEE', 'dd-MMM-yyyy HH:mm:ss", "EEE MMM dd HH:mm:ss z yyyy"};
    String dateString;

    public RfcDateParser(String string) {
        this.dateString = string.trim();
    }

    public Date getDate() {
        int n = 0;
        while (n < standardFormats.length) {
            Hax.debugln(debugProp, "RfcDateParser.getDate: try " + standardFormats[n]);
            Date date = this.tryParsing(standardFormats[n]);
            if (date != null) {
                return date;
            }
            ++n;
        }
        Hax.debugln(debugProp, "Failed to parse expiration date: " + this.dateString);
        return null;
    }

    private Date tryParsing(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.US);
        try {
            return simpleDateFormat.parse(this.dateString);
        }
        catch (Exception exception) {
            Hax.debugln(debugProp, "RfcDateParser.tryParsing: " + string + " ==> " + exception);
            return null;
        }
    }
}

