/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tags;

import sunw.hotjava.doc.BlockTagItem;
import sunw.hotjava.doc.DocItem;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.FormatState;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.tags.Align;
import sunw.hotjava.tags.LI;

public class Heading
extends BlockTagItem {
    private int fmt = 2;

    public String getText() {
        return "\n";
    }

    public void init(Document document) {
        if (this.atts != null) {
            this.fmt = Align.getFormat(this.atts, "align", 2);
        }
    }

    protected boolean beginState(Formatter formatter, FormatState formatState) {
        return formatState.state == 0 || this.enclosedInLI(formatter);
    }

    private boolean enclosedInLI(Formatter formatter) {
        if (this.getIndex() > 0) {
            Document document = formatter.getDocument();
            DocItem docItem = document.items[this.getIndex() - 1];
            if (docItem instanceof LI) {
                return true;
            }
        }
        return false;
    }

    protected boolean leaveSpace(Formatter formatter, FormatState formatState) {
        return super.leaveSpace(formatter, formatState) && !this.enclosedInLI(formatter);
    }

    public void modifyStyle(DocStyle docStyle) {
        super.modifyStyle(docStyle);
        if (this.fmt != 2) {
            docStyle.format = this.fmt;
        }
    }
}

