/*
 * Decompiled with CFR 0.152.
 */
package InnoHelp;

import InnoBarBean.InnoBar;
import InnoHelp.HelpContents;
import InnoHelp.HelpWin;
import InnoHelp.JBevelPanel;
import InnoHelp.Profile;
import borland.jbcl.control.BevelPanel;
import borland.jbcl.control.TextFieldControl;
import borland.jbcl.layout.PaneLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.io.File;
import jclass.bwt.JCSplitterWindow;

public class InnoHelp
extends Frame
implements TextListener,
KeyListener,
ActionListener,
ComponentListener {
    static final String TITLE = new String("InnoHelp");
    static final String TOOLBAR_GIF = new String("image/helpbar.gif");
    static final String SETTINGS = new String("HelpSettings");
    static final String EDITORKEY = new String("Editor");
    static final String TOCKEY = new String("TOCFileName");
    static final String IDXKEY = new String("IDXFileName");
    static final String WINDOWWIDTH = new String("WindowWidth");
    static final String WINDOWHEIGHT = new String("WindowHeight");
    static final String WINDOWXPOS = new String("WindowXPosition");
    static final String WINDOWYPOS = new String("WindowYPosition");
    static final String CONTENTPOS = new String("ContentsWidth");
    static final String BROWSERPOS = new String("BrowserWidth");
    static final String EDITOR = new String(" ");
    static final String CONTENT_FILE = new String("Contents.htm");
    static final String INDEX_FILE = new String("Index.htm");
    static final String HELP_DIR = new String("doc");
    static final String HELPPROFILE = new String("InnoHelp.ini");
    private HelpWin browser;
    private MenuBar menu;
    private Menu menuFile;
    public MenuItem IDM_HOME;
    public MenuItem IDM_BACKWARD;
    public MenuItem IDM_FORWARD;
    public MenuItem IDM_OPEN;
    public MenuItem IDM_PRINT;
    public MenuItem IDM_RELOAD;
    public MenuItem IDM_STOP;
    public MenuItem IDM_TOGGLE;
    private InnoBar toolbar;
    private JCSplitterWindow splitpanel;
    private PaneLayout paneLayout1;
    private PaneLayout paneLayout2;
    private JBevelPanel bevelPanel1;
    private JBevelPanel bevelPanel2;
    private Panel rightPanel;
    private Panel urlPanel;
    private TextFieldControl urlField;
    private HelpContents contents;
    private File rootDir;
    private Frame parent = null;
    private Profile helpProfile = null;
    private boolean contentsOn = true;
    private boolean InnoHelpEnabled = false;
    private boolean enableToolBar = true;
    private boolean InnoBarInstalled = false;
    private boolean closed = false;
    private String helpProfileName = null;
    private String tocFileName = CONTENT_FILE;
    private String idxFileName = INDEX_FILE;

    public InnoHelp() {
        this.initToolBar();
        this.setTitle(TITLE);
    }

    public InnoHelp(Frame parent, String helpDir, String profileName) {
        this.parent = parent;
        this.setHelpDir(helpDir);
        this.setHelpProfile(profileName);
        this.initToolBar();
        this.setTitle(TITLE);
        this.load();
    }

    public InnoHelp(Frame parent, String helpDir, String contentsName, String indexName) {
        this.parent = parent;
        this.tocFileName = contentsName;
        this.idxFileName = indexName;
        this.setHelpDir(helpDir);
        this.initToolBar();
        this.setTitle(TITLE);
        this.load();
    }

    private void initToolBar() {
        try {
            Class<?> InnoBarClass = Class.forName("InnoBarBean.InnoBar");
            if (InnoBarClass != null) {
                this.toolbar = new InnoBar();
                this.InnoBarInstalled = true;
            } else {
                this.InnoBarInstalled = false;
            }
        }
        catch (Exception e) {
            this.InnoBarInstalled = false;
        }
    }

    public boolean closed() {
        return this.closed;
    }

    public void enableToolBar(boolean val) {
        this.enableToolBar = val;
        if (this.InnoHelpEnabled && this.toolbar != null) {
            this.toolbar.setVisible(val);
        }
    }

    public void setHelpParent(Frame parent) {
        this.parent = parent;
    }

    public Frame getHelpParent() {
        return this.parent;
    }

    public void setHelpDir(String dir) {
        this.rootDir = new File(dir);
    }

    public String getHelpDir() {
        return this.rootDir.getAbsolutePath();
    }

    public void setHelpProfile(String profileName) {
        this.helpProfileName = profileName;
        this.helpProfile = new Profile(this, this.helpProfileName);
        this.tocFileName = this.helpProfile.ReadString(SETTINGS, TOCKEY, CONTENT_FILE).trim();
        if (this.tocFileName.length() == 0) {
            this.tocFileName = new String(CONTENT_FILE);
        }
        this.idxFileName = this.helpProfile.ReadString(SETTINGS, IDXKEY, INDEX_FILE).trim();
        if (this.idxFileName.length() == 0) {
            this.idxFileName = new String(INDEX_FILE);
        }
    }

    public String getHelpProfile() {
        return this.helpProfileName;
    }

    public void setContentsAndIndexFiles(String contentsName, String indexName) {
        this.tocFileName = contentsName.trim();
        if (this.tocFileName.length() == 0) {
            this.tocFileName = new String(CONTENT_FILE);
        }
        this.idxFileName = indexName.trim();
        if (this.idxFileName.length() == 0) {
            this.idxFileName = new String(INDEX_FILE);
        }
    }

    public String getContentsFileName() {
        return this.tocFileName;
    }

    public String getIndexFileName() {
        return this.idxFileName;
    }

    public void setTOCFile(String tocName) {
        this.tocFileName = tocName.trim();
    }

    public String getTOCFile() {
        return this.tocFileName;
    }

    public void setIndexFile(String indexName) {
        this.idxFileName = indexName.trim();
    }

    public String getIndexFile() {
        return this.idxFileName;
    }

    public InnoBar getToolbar() {
        return this.toolbar;
    }

    public void loadUrl(String url) {
        String chk = new String(url.toLowerCase());
        if (!(chk.startsWith("http:") || chk.startsWith("shttp:") || chk.startsWith("ftp:") || chk.startsWith("file:") || chk.charAt(1) == ':')) {
            url = new String(String.valueOf(String.valueOf(String.valueOf("file:///").concat(String.valueOf(this.rootDir.getAbsolutePath()))).concat(String.valueOf(File.separator))).concat(String.valueOf(url)));
        }
        this.browser.setCurrentLocation(url);
    }

    private void loadLocalUrl() {
        String url = this.urlField.getText().trim();
        if (url.length() > 0) {
            this.browser.setCurrentLocation(url);
        }
    }

    private void init() {
        this.enableEvents(64L);
        this.enableEvents(16L);
        this.enableEvents(1L);
        int winWidth = this.getSliderPanelPos(WINDOWWIDTH, 620);
        int winHeight = this.getSliderPanelPos(WINDOWHEIGHT, 400);
        ((Component)this).setSize(winWidth, winHeight);
        Dimension dim = this.getToolkit().getScreenSize();
        int winY = this.getWindowPos(WINDOWYPOS, (dim.width - this.getSize().width) / 2);
        int winX = this.getWindowPos(WINDOWXPOS, (dim.height - this.getSize().height) / 2);
        Dimension test = this.getSize();
        ((Component)this).setLocation(winX, winY);
        if (this.enableToolBar && this.InnoBarInstalled) {
            this.addNotify();
            int[] arrayOfX = new int[]{1, 31, 61, 91, 121, 151, 181, 211};
            String[] toolbarLabels = new String[]{"Home", "Backward", "Forward", "Open a File", "Print", "Reload", "Stop", "Toggle Contents"};
            if (this.toolbar.getImage() == null) {
                this.toolbar.setImage(this.getToolkit().getImage(TOOLBAR_GIF));
            }
            this.toolbar.setActionCommand("x-toolbar");
            this.toolbar.defineButton(arrayOfX, 1, 30, 30);
            this.toolbar.setButtonPrimaryImage(arrayOfX, 31);
            this.toolbar.setButtonMouseOverImage(arrayOfX, 61);
            this.toolbar.setButtonDisabledImage(arrayOfX, 91);
            this.toolbar.setButtonTag(toolbarLabels);
            this.toolbar.setLayout(null);
            this.toolbar.setSize(this.toolbar.getPreferredSize());
            this.toolbar.setVisible(true);
            this.toolbar.addActionListener(this);
            BevelPanel tbPanel = new BevelPanel();
            tbPanel.setBevelInner(0);
            tbPanel.setBevelOuter(0);
            tbPanel.setLayout(null);
            tbPanel.setSize(this.toolbar.getPreferredSize());
            tbPanel.add(this.toolbar);
            this.add("North", tbPanel);
            this.toolbar.Enable();
        } else {
            this.SetupMenuBar();
        }
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 26, 5};
        int[] columnWidths = new int[]{5, 10, 2, 200, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 10.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = -1;
        con.gridy = -1;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.weightx = 0.0;
        con.weighty = 0.0;
        con.anchor = 13;
        con.fill = 1;
        con.insets = new Insets(0, 0, 0, 0);
        con.ipadx = 0;
        con.ipady = 0;
        this.urlPanel = new Panel();
        this.urlPanel.setLayout(grid);
        Label label = new Label("URL", 0);
        this.urlPanel.add(label);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(label, con);
        this.urlField = new TextFieldControl();
        this.urlField.addKeyListener(this);
        this.urlPanel.add(this.urlField);
        con.gridx = 3;
        con.gridy = 1;
        grid.setConstraints(this.urlField, con);
        this.browser = new HelpWin();
        this.browser.addTextListener(this);
        this.rightPanel = new Panel();
        this.rightPanel.setLayout(new BorderLayout());
        this.rightPanel.add("North", this.urlPanel);
        this.rightPanel.add("Center", this.browser);
        int y = this.getSliderPanelPos(CONTENTPOS, 180);
        this.contents = new HelpContents(this, this.getSliderPanelPos(CONTENTPOS, 180));
        this.splitpanel = new JCSplitterWindow();
        this.splitpanel.setBackground(SystemColor.control);
        this.paneLayout1 = new PaneLayout();
        this.paneLayout2 = new PaneLayout();
        this.bevelPanel1 = new JBevelPanel();
        this.bevelPanel2 = new JBevelPanel();
        this.bevelPanel1.setBevelInner(0);
        this.bevelPanel1.setBevelOuter(2);
        this.bevelPanel1.setLayout(this.paneLayout1);
        this.bevelPanel1.addComponentListener(this);
        this.bevelPanel2.setBevelInner(0);
        this.bevelPanel2.setBevelOuter(2);
        this.bevelPanel2.setLayout(this.paneLayout2);
        this.bevelPanel2.addComponentListener(this);
        this.bevelPanel1.add((Component)this.contents, "Center");
        this.bevelPanel2.add((Component)this.rightPanel, "Center");
        this.bevelPanel1.setPreferredSize(0, this.getSliderPanelPos(CONTENTPOS, 380) + 2);
        this.splitpanel.add(this.bevelPanel1);
        this.splitpanel.add(this.bevelPanel2);
        this.splitpanel.setPreferredSize(0, this.getSliderPanelPos(BROWSERPOS, 380) + 2);
        this.add("Center", this.splitpanel);
        this.InnoHelpEnabled = true;
    }

    private void SetupMenuBar() {
        this.menu = new MenuBar();
        this.menuFile = new Menu("File");
        this.IDM_HOME = new MenuItem("Home");
        this.IDM_HOME.addActionListener(this);
        this.menuFile.add(this.IDM_HOME);
        this.IDM_BACKWARD = new MenuItem("Backward");
        this.IDM_BACKWARD.addActionListener(this);
        this.menuFile.add(this.IDM_BACKWARD);
        this.IDM_FORWARD = new MenuItem("Forward");
        this.IDM_FORWARD.addActionListener(this);
        this.menuFile.add(this.IDM_FORWARD);
        this.menuFile.addSeparator();
        this.IDM_OPEN = new MenuItem("Open a file");
        this.IDM_OPEN.addActionListener(this);
        this.menuFile.add(this.IDM_OPEN);
        this.menuFile.addSeparator();
        this.IDM_PRINT = new MenuItem("Print");
        this.IDM_PRINT.addActionListener(this);
        this.menuFile.add(this.IDM_PRINT);
        this.menuFile.addSeparator();
        this.IDM_RELOAD = new MenuItem("Reload");
        this.IDM_RELOAD.addActionListener(this);
        this.menuFile.add(this.IDM_RELOAD);
        this.IDM_STOP = new MenuItem("Stop");
        this.IDM_STOP.addActionListener(this);
        this.menuFile.add(this.IDM_STOP);
        this.menuFile.addSeparator();
        this.IDM_TOGGLE = new MenuItem("Toggle Contents");
        this.IDM_TOGGLE.addActionListener(this);
        this.menuFile.add(this.IDM_TOGGLE);
        this.menu.add(this.menuFile);
        this.setMenuBar(this.menu);
    }

    public void load() {
        if (!this.InnoHelpEnabled) {
            this.init();
        }
        if (this.rootDir != null) {
            File contentFile = new File(this.rootDir, this.tocFileName);
            File indexFile = new File(this.rootDir, this.idxFileName);
            this.contents.loadContentsFile(contentFile);
            this.contents.loadIndexFile(indexFile);
        }
        this.show();
        this.toFront();
        this.requestFocus();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        String[] toolbarLabels = new String[]{"Home", "Backward", "Forward", "Open a File", "Print", "Reload", "Stop", "Toggle Contents"};
        if (cmd.equals("x-toolbar")) {
            cmd = this.toolbar.getButtonClickedTag();
        }
        if (cmd == null) {
            cmd = new String("");
        }
        if (cmd.equals("Home") || e.getSource() == this.IDM_HOME) {
            this.contents.setHomePage();
        } else if (cmd.equals("Backward") || e.getSource() == this.IDM_BACKWARD) {
            this.browser.goBack();
        } else if (cmd.equals("Forward") || e.getSource() == this.IDM_FORWARD) {
            this.browser.goForward();
        } else if (cmd.equals("Open a File") || e.getSource() == this.IDM_OPEN) {
            FileDialog filedialog = new FileDialog((Frame)this, "Load a new HTML file", 0);
            filedialog.show();
            if (filedialog.getFile() != null) {
                this.browser.setCurrentLocation(String.valueOf(String.valueOf("File:///").concat(String.valueOf(filedialog.getDirectory()))).concat(String.valueOf(filedialog.getFile())));
            }
        } else if (cmd.equals("Print") || e.getSource() == this.IDM_PRINT) {
            PrintJob pj = this.getToolkit().getPrintJob(this, "Print Page", null);
            if (pj != null) {
                this.browser.printDoc(pj);
                pj.end();
            }
        } else if (cmd.equals("Reload") || e.getSource() == this.IDM_RELOAD) {
            this.browser.reload();
        } else if (cmd.equals("Stop") || e.getSource() == this.IDM_STOP) {
            this.browser.stopLoading();
        } else if (cmd.equals("Toggle Contents") || e.getSource() == this.IDM_TOGGLE) {
            this.contentsOn = !this.contentsOn;
            this.enableContents();
            this.show();
        }
    }

    public void textValueChanged(TextEvent e) {
        if (e.getSource() == this.browser) {
            this.urlField.setText(this.browser.getCurrentLocation());
        }
    }

    private void enableContents() {
        if (this.contentsOn) {
            this.bevelPanel1.setVisible(false);
            this.bevelPanel2.setVisible(false);
            this.remove(this.rightPanel);
            this.bevelPanel2.add((Component)this.rightPanel, "Center");
            this.add("Center", this.splitpanel);
            this.bevelPanel1.setVisible(true);
            this.bevelPanel2.setVisible(true);
            this.splitpanel.setVisible(true);
        } else {
            this.splitpanel.setVisible(false);
            this.rightPanel.setVisible(false);
            this.bevelPanel2.remove(this.rightPanel);
            this.remove(this.splitpanel);
            this.add("Center", this.rightPanel);
            this.rightPanel.setVisible(true);
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.Close();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public void componentHidden(ComponentEvent evt) {
    }

    public void componentMoved(ComponentEvent evt) {
    }

    public void componentShown(ComponentEvent evt) {
    }

    public void componentResized(ComponentEvent evt) {
        if (evt.getID() == 101) {
            int newContentWidth = this.bevelPanel1.getSize().width - 2;
            this.contents.setSize(newContentWidth);
        }
    }

    private void Close() {
        this.closed = true;
        this.storeSplits();
        ((Component)this).setVisible(false);
        if (this.menu != null) {
            this.remove(this.menu);
        }
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.parent.toFront();
            this.parent.requestFocus();
            this.dispose();
        }
    }

    private void storeSplits() {
        if (this.helpProfile != null) {
            Dimension dim = new Dimension(this.getSize());
            this.helpProfile.WriteString(SETTINGS, WINDOWWIDTH, Integer.toString(dim.width));
            this.helpProfile.WriteString(SETTINGS, WINDOWHEIGHT, Integer.toString(dim.height));
            this.helpProfile.WriteString(SETTINGS, CONTENTPOS, Integer.toString(this.contents.getSize().width));
            this.helpProfile.WriteString(SETTINGS, BROWSERPOS, Integer.toString(this.rightPanel.getSize().width));
            Point p = this.getLocation();
            this.helpProfile.WriteString(SETTINGS, WINDOWYPOS, Integer.toString(p.y));
            this.helpProfile.WriteString(SETTINGS, WINDOWXPOS, Integer.toString(p.x));
            this.helpProfile.Save();
        }
    }

    private int getSliderPanelPos(String parm, int def) {
        int val = def;
        try {
            if (this.helpProfile != null) {
                val = Integer.valueOf(this.helpProfile.ReadString(SETTINGS, parm, String.valueOf("").concat(String.valueOf(def))));
            }
            if (val < 20) {
                val = def;
            }
        }
        catch (NumberFormatException e) {
            val = def;
        }
        return val;
    }

    private int getWindowPos(String parm, int def) {
        int val = def;
        try {
            if (this.helpProfile != null) {
                val = Integer.valueOf(this.helpProfile.ReadString(SETTINGS, parm, String.valueOf("").concat(String.valueOf(def))));
            }
        }
        catch (NumberFormatException e) {
            val = def;
        }
        return val;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.urlField && e.getKeyCode() == 10) {
            this.loadLocalUrl();
        }
    }

    public static void main(String[] args) {
        InnoHelp client = new InnoHelp();
        client.setHelpDir(String.valueOf(String.valueOf(System.getProperty("user.dir")).concat(String.valueOf(File.separator))).concat(String.valueOf(HELP_DIR)));
        client.setHelpProfile(String.valueOf(String.valueOf(System.getProperty("user.dir")).concat(String.valueOf(File.separator))).concat(String.valueOf(HELPPROFILE)));
        client.load();
    }
}

