/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import COM.objectspace.jgl.Array;
import borland.jbcl.control.BevelPanel;
import borland.jbcl.util.BlackBox;
import borland.jbcl.util.FocusMulticaster;
import borland.jbcl.util.ItemMulticaster;
import borland.jbcl.util.KeyMulticaster;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;

public class CheckboxPanel
extends BevelPanel
implements BlackBox {
    private int orientation = 0;
    private CheckboxGroup group;
    private int groupSelectedIndex = -1;
    private String groupSelectedLabel;
    private GridLayout gridLayout = new GridLayout();
    private transient ItemMulticaster itemMulticaster = new ItemMulticaster();
    private transient FocusMulticaster focusMulticaster = new FocusMulticaster();
    private transient KeyMulticaster keyMulticaster = new KeyMulticaster();

    public CheckboxPanel() {
        super.setLayout(this.gridLayout);
        this.setMargins(new Insets(6, 6, 6, 6));
        this.setBevelInner(1);
        this.setBevelOuter(2);
        this.setOrientation(1);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setForeground(color);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).invalidate();
        }
    }

    public void setOrientation(int n) {
        if (this.orientation != n) {
            this.orientation = n;
            this.gridLayout.setColumns(1);
            this.gridLayout.setRows(this.orientation == 0 ? 1 : 0);
            this.gridLayout.setColumns(this.orientation == 0 ? 0 : 1);
            this.invalidate();
            this.repaint(100L);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setGrouped(boolean bl) {
        if (bl != (this.group != null)) {
            this.group = bl ? new CheckboxGroup() : null;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                ((Checkbox)this.getComponent(i)).setCheckboxGroup(this.group);
            }
        }
        if (bl && (this.groupSelectedIndex > 0 || this.groupSelectedLabel != null)) {
            if (this.groupSelectedIndex > 0) {
                this.setSelectedIndex(this.groupSelectedIndex);
            } else {
                this.setSelectedLabel(this.groupSelectedLabel);
            }
        }
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public boolean isGrouped() {
        return this.group != null;
    }

    public void setLabels(String[] stringArray) {
        this.removeAll();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Checkbox checkbox = new Checkbox(stringArray[i], false, this.group);
                checkbox.addItemListener(this.itemMulticaster);
                checkbox.addFocusListener(this.focusMulticaster);
                checkbox.addKeyListener(this.keyMulticaster);
                this.add(checkbox);
            }
        }
        this.repaint(100L);
    }

    public String[] getLabels() {
        String[] stringArray = new String[this.getComponentCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((Checkbox)this.getComponent(i)).getLabel();
        }
        return stringArray;
    }

    public void setSelectedLabels(String[] stringArray) {
        Array array = new Array(stringArray);
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Checkbox checkbox = (Checkbox)this.getComponent(i);
            checkbox.setState(array.contains(checkbox.getLabel()));
        }
    }

    public String[] getSelectedLabels() {
        Object object;
        String[] stringArray = new String[this.getComponentCount()];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            object = (Checkbox)this.getComponent(i);
            if (!((Checkbox)object).getState()) continue;
            ++n;
            stringArray[i] = ((Checkbox)object).getLabel();
        }
        object = new String[n];
        if (n > 0) {
            int n2 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                object[n2++] = stringArray[i];
            }
        }
        return object;
    }

    public void setLabel(int n, String string) {
        ((Checkbox)this.getComponent(n)).setLabel(string);
    }

    public void addLabel(String string) {
        Checkbox checkbox = new Checkbox(string, false, this.group);
        checkbox.addItemListener(this.itemMulticaster);
        checkbox.addFocusListener(this.focusMulticaster);
        checkbox.addKeyListener(this.keyMulticaster);
        this.add(checkbox);
        this.repaint(100L);
    }

    public String getLabel(int n) {
        return ((Checkbox)this.getComponent(n)).getLabel();
    }

    public void setSelectedIndex(int n) {
        if (this.group != null) {
            this.group.setSelectedCheckbox((Checkbox)this.getComponent(n));
        } else {
            this.groupSelectedIndex = n;
        }
    }

    public int getSelectedIndex() {
        if (this.group != null) {
            Checkbox checkbox = this.group.getSelectedCheckbox();
            for (int i = 0; i < this.getComponentCount(); ++i) {
                if (this.getComponent(i) != checkbox) continue;
                return i;
            }
        }
        return -1;
    }

    public void setSelectedLabel(String string) {
        if (this.group != null) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Checkbox checkbox = (Checkbox)this.getComponent(i);
                if (!checkbox.getLabel().equals(string)) continue;
                this.group.setSelectedCheckbox(checkbox);
                return;
            }
        } else {
            this.groupSelectedLabel = string;
        }
    }

    public String getSelectedLabel() {
        Checkbox checkbox;
        if (this.group != null && (checkbox = this.group.getSelectedCheckbox()) != null) {
            return checkbox.getLabel();
        }
        return null;
    }

    public void addFocusListener(FocusListener focusListener) {
        this.focusMulticaster.add(focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.focusMulticaster.remove(focusListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.keyMulticaster.add(keyListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.keyMulticaster.remove(keyListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemMulticaster.add(itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemMulticaster.remove(itemListener);
    }
}

