/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.control.Res;
import borland.jbcl.dataset.ColumnVariant;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.ValidationException;
import borland.jbcl.model.ItemEditMask;
import borland.jbcl.model.ItemEditMaskState;
import borland.jbcl.model.ItemEditMaskStr;
import borland.jbcl.model.ItemEditSite;
import borland.jbcl.model.ItemEditor;
import borland.jbcl.model.ItemFormatter;
import borland.jbcl.util.InvalidFormatException;
import borland.jbcl.util.Variant;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Locale;

public class MaskableTextItemEditor
extends TextField
implements ItemEditor {
    private ItemEditMask ems;
    private ItemEditMaskState state;
    private boolean hookedEvents;
    private boolean editingNow;
    private DataSet ds;
    private String startingText;
    private Object startingValue;
    boolean changed;
    boolean allSelected;
    ItemFormatter formatter;
    int alignment = 33;
    int dataType;

    public MaskableTextItemEditor() {
    }

    public MaskableTextItemEditor(int n, Insets insets) {
        this(n, insets, null, null);
    }

    public MaskableTextItemEditor(ItemFormatter itemFormatter, ItemEditMask itemEditMask) {
        this();
        this.formatter = itemFormatter;
        this.setEditMasker(itemEditMask);
    }

    public MaskableTextItemEditor(int n, Insets insets, ItemFormatter itemFormatter, ItemEditMask itemEditMask) {
        this();
        this.alignment = n;
        this.formatter = itemFormatter;
        this.setEditMasker(itemEditMask);
    }

    public Object getValue() {
        Variant variant = new Variant();
        if (this.ems == null) {
            String string = this.getText();
            if (this.startingText != null && string.equals(this.startingText)) {
                return this.startingValue;
            }
            if (this.formatter != null) {
                try {
                    variant = (Variant)this.formatter.parse(string);
                }
                catch (Exception exception) {
                    if (exception instanceof InvalidFormatException) {
                        this.state.cursorPos = ((InvalidFormatException)exception).getErrorOffset();
                    }
                    this.updateSelection();
                    if (this.ds != null) {
                        this.handleException(exception);
                    }
                    throw new IllegalStateException();
                }
                return variant;
            }
            variant.setString(string);
            return variant;
        }
        if (!this.changed) {
            return this.startingValue;
        }
        try {
            this.ems.getFinalValue(this.state, variant);
            Variant variant2 = variant;
            return variant2;
        }
        catch (Exception exception) {
            if (exception instanceof InvalidFormatException) {
                this.state.cursorPos = ((InvalidFormatException)exception).getErrorOffset();
            }
            this.updateSelection();
            if (this.ds != null) {
                this.handleException(exception);
            }
            throw new IllegalStateException();
        }
    }

    public Component getComponent() {
        return this;
    }

    public void startEdit(Object object, Rectangle rectangle, ItemEditSite itemEditSite) {
        Object object2;
        block22: {
            if (object != null && object instanceof Variant) {
                this.startingValue = new Variant();
                ((Variant)this.startingValue).setVariant((Variant)object);
            } else {
                this.startingValue = object;
            }
            this.startingText = null;
            this.changed = false;
            DataSet dataSet = this.ds = object != null && object instanceof ColumnVariant ? ((ColumnVariant)object).getDataSet() : null;
            if (this.ems == null) {
                try {
                    if (object == null) {
                        ((TextComponent)this).setText("");
                        break block22;
                    }
                    if (this.formatter != null && object instanceof Variant) {
                        ((TextComponent)this).setText(this.formatter.format(object));
                        break block22;
                    }
                    ((TextComponent)this).setText(object.toString());
                }
                catch (Exception exception) {
                    ((TextComponent)this).setText("");
                }
            } else {
                if (object == null || !(object instanceof Variant)) {
                    object2 = new Variant();
                    if (object == null) {
                        ((Variant)object2).setNull(1);
                    } else {
                        ((Variant)object2).setString(object.toString());
                    }
                    object = object2;
                }
                this.state = this.ems.prepare((Variant)object);
                this.allSelected = true;
                this.updateDisplay();
            }
        }
        this.editingNow = true;
        this.startingText = this.getText();
        if (rectangle != null) {
            this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (itemEditSite != null) {
            ((Component)this).setBackground(itemEditSite.getBackground());
            this.setForeground(itemEditSite.getForeground());
            this.setFont(itemEditSite.getFont());
        }
        this.setVisible(true);
        object2 = this.getText();
        Point point = itemEditSite != null ? itemEditSite.getEditClickPoint() : null;
        int n = 0;
        if (point == null && object2 != null) {
            n = this.state == null ? ((String)object2).length() : this.state.cursorPos;
        } else if (object2 != null) {
            int n2;
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
            int[] nArray = fontMetrics.getWidths();
            int n3 = point.x - rectangle.x;
            int n4 = 0;
            for (n2 = 0; n2 < ((String)object2).length(); ++n2) {
                int n5;
                int n6 = ((String)object2).charAt(n2) < '\u0100' ? nArray[((String)object2).charAt(n2)] : fontMetrics.charWidth(((String)object2).charAt(n2));
                int n7 = n5 = n6 > 3 ? n6 / 3 : 1;
                if (n4 + n5 >= n3) {
                    --n2;
                    break;
                }
                if (n4 + n6 - n5 >= n3) break;
                n4 += n6;
            }
            n = n2;
        }
        if (this.ems == null) {
            if (point != null) {
                this.select(n, n);
            } else {
                this.select(0, n);
            }
        } else {
            this.state.cursorPos = n;
            this.ems.move(this.state, 501);
            this.updateDisplay();
        }
        this.requestFocus();
    }

    public void changeBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void handleException(Exception exception) {
        String string = Res.getString(75);
        exception = new ValidationException(1035, string, null, exception);
        DataSetException.handleException(this.ds, this, exception);
    }

    public boolean canPost() {
        if (this.ems == null) {
            if (this.formatter == null) {
                return true;
            }
            String string = this.getText();
            if (this.startingText != null && string.equals(this.startingText)) {
                return true;
            }
            try {
                this.formatter.parse(string);
            }
            catch (Exception exception) {
                this.handleException(exception);
                boolean bl = false;
                return bl;
            }
            return true;
        }
        String string = null;
        if (!this.changed) {
            return true;
        }
        boolean bl = false;
        try {
            bl = this.ems.isComplete(this.state);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateSelection();
        if (bl) {
            try {
                this.ems.getFinalValue(this.state, new Variant());
            }
            catch (Exception exception) {
                if (exception instanceof InvalidFormatException) {
                    string = exception.getMessage();
                }
                bl = false;
            }
        }
        if (!bl && this.ds != null) {
            if (string == null) {
                string = Res.getString(74);
            }
            this.handleException(new InvalidFormatException(string));
        }
        return bl;
    }

    public void endEdit(boolean bl) {
        this.editingNow = false;
        this.startingValue = null;
        this.startingText = null;
        this.changed = false;
    }

    public void setEditMask(String string, int n, Locale locale) {
        this.setEditMasker(new ItemEditMaskStr(string, null, n, locale));
    }

    public void setEditMasker(ItemEditMask itemEditMask) {
        this.ems = itemEditMask;
        this.state = null;
        if (this.ems != null) {
            this.hookEvents();
        }
        if (this.editingNow) {
            this.startEdit(null, null, null);
        }
    }

    private boolean isVirtualKey(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (c) {
            case '\u0000': 
            case '\u007f': {
                return true;
            }
        }
        return false;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (this.hookedEvents) {
            if (keyEvent.getID() == 401) {
                this.allSelected = false;
                if (this.isVirtualKey(keyEvent)) {
                    this.handleVirtualKey(keyEvent.getKeyCode());
                    keyEvent.consume();
                }
            } else if (keyEvent.getID() == 400) {
                this.allSelected = false;
                if (this.isVirtualKey(keyEvent)) {
                    this.handleVirtualKey(keyEvent.getKeyCode());
                } else {
                    this.handleKey(keyEvent.getKeyChar());
                }
                keyEvent.consume();
            }
        }
        super.processKeyEvent(keyEvent);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        this.maskControl_gotFocus();
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.hookedEvents && this.ems != null && mouseEvent.getID() == 502) {
            this.updateSelection();
        } else if (this.hookedEvents && this.ems != null && mouseEvent.getID() == 500) {
            this.handleMouseClicked(mouseEvent);
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
    }

    void maskControl_gotFocus() {
        if (this.hookedEvents && this.state == null) {
            this.startEdit(null, null, null);
        }
        this.updateSelection();
    }

    void updateSelection() {
        if (this.state != null) {
            if (this.allSelected) {
                this.select(0, this.state.displayString.toString().length());
            } else {
                this.select(this.state.cursorPos, this.state.cursorPos + 1);
            }
        }
    }

    void updateDisplay() {
        if (this.state != null) {
            ((TextComponent)this).setText(this.state.displayString.toString());
            this.updateSelection();
        }
    }

    void deleteSelection(boolean bl) {
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        int n3 = n2 - n;
        if (n3 < 0) {
            n = n2;
            n3 = -n3;
        }
        if (n3 > 1 || !bl) {
            this.ems.delete(this.state, n, n3);
        }
        this.allSelected = false;
        this.changed = true;
    }

    void handleVirtualKey(int n) {
        switch (n) {
            case 16: {
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 39: {
                this.ems.move(this.state, n);
                this.updateSelection();
                break;
            }
            case 8: 
            case 127: {
                this.deleteSelection(false);
                this.ems.move(this.state, n == 8 ? 37 : 39);
                this.updateDisplay();
                break;
            }
            case 9: 
            case 10: {
                this.canPost();
                break;
            }
            case 27: {
                this.startEdit(null, null, null);
                this.changed = false;
                break;
            }
        }
    }

    void handleKey(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 8: 
            case 127: {
                this.deleteSelection(false);
                this.ems.move(this.state, n == 8 ? 37 : 39);
                this.updateDisplay();
                break;
            }
            case 9: 
            case 10: {
                this.canPost();
                break;
            }
            case 27: {
                this.startEdit(null, null, null);
                this.changed = false;
                break;
            }
            default: {
                this.deleteSelection(true);
                this.ems.insert(this.state, (char)n);
                this.updateDisplay();
            }
        }
    }

    private void handleMouseClicked(MouseEvent mouseEvent) {
        int n;
        Point point = mouseEvent.getPoint();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        int[] nArray = fontMetrics.getWidths();
        int n2 = point.x;
        String string = this.state.displayString.toString();
        int n3 = 0;
        for (n = 0; n < string.length(); ++n) {
            int n4;
            int n5 = string.charAt(n) < '\u0100' ? nArray[string.charAt(n)] : fontMetrics.charWidth(string.charAt(n));
            int n6 = n4 = n5 > 3 ? n5 / 3 : 1;
            if (n3 + n4 >= n2) {
                --n;
                break;
            }
            if (n3 + n5 - n4 >= n2) break;
            n3 += n5;
        }
        this.state.cursorPos = n;
        this.ems.move(this.state, 500);
        this.updateSelection();
    }

    private void hookEvents() {
        if (!this.hookedEvents) {
            this.enableEvents(60L);
            this.hookedEvents = true;
        }
    }
}

