/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.BrowserAppletThreadGroup;
import ice.htmlbrowser.BrowserURLLoader;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Properties;
import java.util.zip.ZipInputStream;

public class BrowserClassLoader
extends ClassLoader {
    private Hashtable loadedJarFiles = new Hashtable();
    BrowserAppletThreadGroup threadGroup;
    URL classURL = null;
    private URL codebase = null;
    private URL archiveCodeBase = null;
    private static Hashtable appletCache = new Hashtable();
    private static Hashtable loaderCache = new Hashtable();
    private Hashtable jarRAMDisk = new Hashtable();
    private String[] archiveList = null;
    private static boolean debug = false;

    BrowserClassLoader(String cb) {
        if (cb != null) {
            try {
                this.codebase = new URL(cb);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    BrowserClassLoader(URL cb) {
        this.codebase = cb;
    }

    static synchronized BrowserClassLoader getClassLoader(String key, String codebase) {
        Object object = loaderCache.get(key);
        if (object != null) {
            return (BrowserClassLoader)object;
        }
        BrowserClassLoader browserClassLoader = new BrowserClassLoader(codebase);
        loaderCache.put(key, browserClassLoader);
        return browserClassLoader;
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        byte[] classBin;
        if (!this.constructURL(name)) {
            return null;
        }
        String hashkey = new String(this.classURL.toString());
        Class<?> c = (Class<?>)appletCache.get(hashkey);
        if (c != null) {
            BrowserClassLoader.debug(String.valueOf(String.valueOf("Found ").concat(String.valueOf(name))).concat(String.valueOf(" in cache")));
        }
        if (c == null) {
            try {
                c = this.findSystemClass(name);
                BrowserClassLoader.debug(String.valueOf(String.valueOf("Found ").concat(String.valueOf(name))).concat(String.valueOf(" in system")));
                Class<?> clazz = c;
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (c == null && this.archiveList != null && (classBin = this.loadClassDataFromJAR(name)) != null) {
            BrowserClassLoader.debug(String.valueOf(String.valueOf("Found ").concat(String.valueOf(name))).concat(String.valueOf(" in JAR")));
            c = this.defineClass(name, classBin, 0, classBin.length);
            appletCache.put(hashkey, c);
            BrowserClassLoader.debug(String.valueOf(String.valueOf(name).concat(String.valueOf(" cached as "))).concat(String.valueOf(hashkey)));
        }
        if (c == null && (classBin = this.loadClassDataFromURL(name)) != null) {
            BrowserClassLoader.debug(String.valueOf(String.valueOf(String.valueOf("Found ").concat(String.valueOf(name))).concat(String.valueOf(" at URL "))).concat(String.valueOf(this.classURL)));
            c = this.defineClass(name, classBin, 0, classBin.length);
            if (c != null) {
                appletCache.put(hashkey, c);
                BrowserClassLoader.debug(String.valueOf(String.valueOf(name).concat(String.valueOf(" cached as "))).concat(String.valueOf(hashkey)));
            }
        }
        if (c == null) {
            throw new ClassNotFoundException(String.valueOf(String.valueOf("Class <").concat(String.valueOf(name))).concat(String.valueOf("> not found anywhere")));
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private synchronized byte[] loadClassDataFromJAR(String className) {
        URL resourceURL;
        String fileName = new String(className);
        if (fileName.indexOf(".") >= 0) {
            fileName = fileName.replace('.', '/');
        }
        fileName = String.valueOf(fileName).concat(String.valueOf(".class"));
        try {
            resourceURL = new URL(this.codebase, fileName);
        }
        catch (MalformedURLException e) {
            System.err.println("BrowserClassLoader : serious error in JAM");
            System.err.println(String.valueOf("                     ").concat(String.valueOf(e.getMessage())));
            System.err.println(String.valueOf(String.valueOf("                     ").concat(String.valueOf(this.codebase))).concat(String.valueOf(fileName)));
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        byte[] data = (byte[])this.jarRAMDisk.get(resourceURL);
        if (data == null) {
            BrowserClassLoader.debug(" ...not found");
        }
        return data;
    }

    private synchronized byte[] loadClassDataFromURL(String name) throws ClassNotFoundException {
        BrowserURLLoader urlLoader = new BrowserURLLoader(this.classURL);
        byte[] data = null;
        try {
            data = urlLoader.loadURL();
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(ioe.getMessage());
        }
        return data;
    }

    Image getImage(URL url) {
        Image img;
        String proto = url.getProtocol();
        String file = url.getFile();
        Toolkit tk = Toolkit.getDefaultToolkit();
        byte[] data = (byte[])this.jarRAMDisk.get(url);
        if (data != null && (img = tk.createImage(data)) != null) {
            return img;
        }
        BrowserClassLoader.debug(String.valueOf(String.valueOf("Getting image ").concat(String.valueOf(url))).concat(String.valueOf(" from net")));
        BrowserURLLoader bul = new BrowserURLLoader(url);
        img = bul.getImage();
        return img;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void loadJar(URL jarURL) {
        block19: {
            if (this.loadedJarFiles.get(jarURL) != null) {
                return;
            }
            bul = new BrowserURLLoader(jarURL);
            try {
                is = bul.getInputStream();
                jarStream = new BufferedInputStream(is);
            }
            catch (Exception e) {
                BrowserClassLoader.debug(String.valueOf("could NOT access ").concat(String.valueOf(jarURL)));
                return;
            }
            zis = null;
            buffer = new byte[1024];
            try {
                try {
                    zis = new ZipInputStream(jarStream);
                    ent = null;
                    block15: while ((ent = zis.getNextEntry()) != null) {
                        name = ent.getName();
                        try {
                            resourceURL = new URL(this.codebase, name);
                        }
                        catch (MalformedURLException e) {
                            System.err.println("BrowserClassLoader : serious error in JAM");
                            System.err.println(String.valueOf("                     ").concat(String.valueOf(e.getMessage())));
                            System.err.println(String.valueOf(String.valueOf("                     ").concat(String.valueOf(this.codebase))).concat(String.valueOf(name)));
                            e.printStackTrace();
                            var12_16 = null;
                            if (zis == null) return;
                            try {
                                zis.close();
                                return;
                            }
                            catch (Exception var13_21) {
                                // empty catch block
                            }
                            return;
                        }
                        baos = new ByteArrayOutputStream();
                        while (true) {
                            if ((len = zis.read(buffer)) < 0) {
                                buf = baos.toByteArray();
                                this.jarRAMDisk.put(resourceURL, buf);
                                BrowserClassLoader.debug(String.valueOf("stashed ").concat(String.valueOf(resourceURL)));
                                continue block15;
                            }
                            baos.write(buffer, 0, len);
                        }
                    }
                    var12_17 = null;
                    if (zis == null) break block19;
                }
                catch (IOException e) {
                    var12_18 = null;
                    if (zis == null) return;
                    ** try [egrp 4[TRYBLOCK] [5 : 303->311)] { 
lbl54:
                    // 1 sources

                    zis.close();
                    return;
lbl56:
                    // 1 sources

                    catch (Exception var13_23) {
                        // empty catch block
                    }
                    return;
                }
                catch (Throwable ex) {
                    var12_19 = null;
                    if (zis == null) return;
                    ** try [egrp 4[TRYBLOCK] [5 : 303->311)] { 
lbl64:
                    // 1 sources

                    zis.close();
                    return;
lbl66:
                    // 1 sources

                    catch (Exception var13_24) {
                        // empty catch block
                    }
                    return;
                }
            }
            catch (Throwable var11_26) {
                var12_20 = null;
                if (zis == null) throw var11_26;
                ** try [egrp 4[TRYBLOCK] [5 : 303->311)] { 
lbl74:
                // 1 sources

                zis.close();
                throw var11_26;
lbl76:
                // 1 sources

                catch (Exception var13_25) {
                    // empty catch block
                }
                throw var11_26;
            }
            try {}
            catch (Exception var13_22) {}
            zis.close();
        }
        this.loadedJarFiles.put(jarURL, jarURL);
    }

    private boolean constructURL(String name) {
        Properties prop = new Properties(System.getProperties());
        char fileSep = prop.getProperty("file.separator").charAt(0);
        if (name.indexOf(".") >= 0) {
            name = name.replace('.', fileSep);
        }
        if (this.codebase == null) {
            try {
                this.classURL = new URL(String.valueOf(name).concat(String.valueOf(".class")));
            }
            catch (MalformedURLException e) {
                boolean bl = false;
                return bl;
            }
        }
        try {
            this.classURL = new URL(this.codebase, String.valueOf(name).concat(String.valueOf(".class")));
        }
        catch (MalformedURLException e) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    void setArchiveList(String[] list) {
        this.archiveList = list;
        for (int i = 0; i < list.length; ++i) {
            try {
                URL jarURL = new URL(this.codebase, list[i]);
                this.loadJar(jarURL);
                continue;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
    }

    synchronized ThreadGroup getThreadGroup() {
        if (this.threadGroup == null || this.threadGroup.isDestroyed()) {
            this.threadGroup = new BrowserAppletThreadGroup(String.valueOf(this.codebase).concat(String.valueOf("-threadGroup")));
            this.threadGroup.setDaemon(true);
        }
        return this.threadGroup;
    }

    public static Object getSecurityContext(ClassLoader loader) {
        if (loader instanceof BrowserClassLoader) {
            return ((BrowserClassLoader)loader).classURL;
        }
        return null;
    }

    public InputStream getResourceAsStream(String name) {
        BrowserClassLoader.debug("getResourceAsStream");
        InputStream str = ClassLoader.getSystemResourceAsStream("name");
        if (str != null) {
            return str;
        }
        str = this.getResourceAsStreamFromJar(name);
        if (str != null) {
            return str;
        }
        str = this.getResourceAsStreamFromURL(name);
        return str;
    }

    private InputStream getResourceAsStreamFromJar(String name) {
        URL resourceURL;
        String fileName = new String(name);
        try {
            resourceURL = new URL(this.codebase, fileName);
        }
        catch (MalformedURLException e) {
            System.err.println("BrowserClassLoader : serious error in JAM");
            System.err.println(String.valueOf("                     ").concat(String.valueOf(e.getMessage())));
            System.err.println(String.valueOf(String.valueOf("                     ").concat(String.valueOf(this.codebase))).concat(String.valueOf(fileName)));
            e.printStackTrace();
            InputStream inputStream = null;
            return inputStream;
        }
        byte[] data = (byte[])this.jarRAMDisk.get(resourceURL);
        if (data != null) {
            return new BufferedInputStream(new ByteArrayInputStream(data));
        }
        return null;
    }

    private InputStream getResourceAsStreamFromURL(String name) {
        URL resourceURL;
        InputStream str = null;
        String fileName = new String(name);
        try {
            resourceURL = new URL(this.codebase, fileName);
        }
        catch (MalformedURLException e) {
            System.err.println("BrowserClassLoader : serious error in JAM");
            System.err.println(String.valueOf("                     ").concat(String.valueOf(e.getMessage())));
            System.err.println(String.valueOf(String.valueOf("                     ").concat(String.valueOf(this.codebase))).concat(String.valueOf(fileName)));
            e.printStackTrace();
            InputStream inputStream = null;
            return inputStream;
        }
        try {
            BrowserURLLoader urlLoader = new BrowserURLLoader(resourceURL);
            URLConnection conn = urlLoader.openConnection();
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection hconn = (HttpURLConnection)conn;
                int code = hconn.getResponseCode();
                if (code == 200) {
                    str = urlLoader.getInputStream();
                }
                if (code >= 400) {
                    str = null;
                }
            } else {
                str = urlLoader.getInputStream();
            }
        }
        catch (Exception ex) {
            InputStream inputStream = null;
            return inputStream;
        }
        return str;
    }

    public String toString() {
        if (this.classURL == null) {
            return String.valueOf(super.toString()).concat(String.valueOf("<null>"));
        }
        return String.valueOf(String.valueOf(String.valueOf(super.toString()).concat(String.valueOf("<"))).concat(String.valueOf(this.classURL.toString()))).concat(String.valueOf(">"));
    }

    private static void debug(String msg) {
        if (debug) {
            System.out.println(String.valueOf("BrowserClassLoader:: ").concat(String.valueOf(msg)));
        }
    }
}

