/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Tag;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

class CoordsList {
    private int coord_value;
    private int coord_type;
    private int[] values;
    private int[] types;

    CoordsList(String str) {
        StringTokenizer subParser = new StringTokenizer(str, " \t\n\r,");
        int count = subParser.countTokens();
        this.values = new int[count];
        this.types = new int[count];
        try {
            int i = 0;
            while (subParser.hasMoreElements()) {
                this.makeCoord(subParser.nextToken());
                this.values[i] = this.coord_value;
                this.types[i] = this.coord_type;
                ++i;
            }
        }
        catch (NoSuchElementException e) {
            System.out.println(e);
        }
    }

    private void makeCoord(String str) {
        this.coord_value = Tag.decStrToInt(str);
        if (str.indexOf("%") != -1) {
            this.coord_type = 1;
        } else if (str.indexOf("*") != -1) {
            this.coord_type = 2;
            if (this.coord_value == 0) {
                ++this.coord_value;
            }
        } else {
            this.coord_type = 0;
        }
    }

    int[] getListOfValues() {
        return this.values;
    }

    int[] getListOfTypes() {
        return this.types;
    }

    int getItemValue(int idx) {
        return this.values[idx];
    }

    int getItemType(int idx) {
        return this.types[idx];
    }

    int size() {
        return this.values.length;
    }
}

