/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import java.util.Vector;

public class AddressGroup {
    private String nickname = new String("");
    private String fullname = new String("");
    private boolean shortlist = false;
    private Vector member = new Vector();
    private int groupIndex;
    private int listIndex;

    AddressGroup() {
        this.member.removeAllElements();
    }

    AddressGroup(String text) {
        this.member.removeAllElements();
        this.parseGroupRecord(text);
    }

    public void changeGroupNickname(String old, String val) {
        int spot = this.member.indexOf(old);
        if (spot >= 0) {
            this.member.setElementAt(val, spot);
        }
    }

    public int getGroupIndex() {
        return this.groupIndex;
    }

    public int getListIndex() {
        return this.listIndex;
    }

    public void setGroupIndex(int val) {
        this.groupIndex = val;
    }

    public void setListIndex(int val) {
        this.listIndex = val;
    }

    public void decListIndex() {
        --this.listIndex;
    }

    public int size() {
        return this.member.size();
    }

    public String getName() {
        if (this.fullname == null || this.fullname.length() == 0) {
            this.fullname = new String(String.valueOf(this.nickname).concat(String.valueOf(" Group")));
        }
        return this.fullname;
    }

    public String getNickname() {
        return this.nickname;
    }

    public boolean getShortlist() {
        return this.shortlist;
    }

    public void setName(String fullname) {
        this.fullname = new String(fullname);
    }

    public void setNickname(String nickname) {
        this.nickname = new String(nickname);
    }

    public void setShortlist(boolean shortlist) {
        this.shortlist = shortlist;
    }

    public String get(int i) {
        String text = null;
        if (i < this.member.size()) {
            text = new String((String)this.member.elementAt(i));
        }
        return text;
    }

    public boolean remove(String nick) {
        boolean ret_code = false;
        int i = this.member.indexOf(nick = new String(nick.toUpperCase().trim()));
        if (i >= 0) {
            this.member.removeElementAt(i);
            ret_code = true;
        }
        return ret_code;
    }

    public void clear() {
        this.member.removeAllElements();
    }

    public boolean add(String text) {
        boolean ret_code = false;
        if (this.member.indexOf(text = new String(text.toUpperCase())) < 0) {
            this.member.addElement(text);
            ret_code = true;
        }
        return ret_code;
    }

    public void parseGroupRecord(String text) {
        int spot = 0;
        spot = (text = text.substring(6)).indexOf("</B>");
        if (spot >= 0) {
            this.fullname = new String(text.substring(0, spot).trim());
            if ((spot = (text = new String(text.substring(spot + 4))).indexOf(91)) >= 0 && (spot = (text = new String(text.substring(spot + 1))).indexOf(93)) >= 0) {
                this.nickname = new String(text.substring(0, spot));
                text = new String(text.substring(spot + 1).trim());
                this.shortlist = text.equalsIgnoreCase("shortlist");
            }
        }
    }

    public void copy(AddressGroup group) {
        this.nickname = new String(group.getNickname());
        this.fullname = new String(group.getName());
        this.shortlist = group.getShortlist();
        this.clear();
        for (int i = 0; i < group.size(); ++i) {
            this.add(group.get(i));
        }
    }

    public boolean compareTo(AddressGroup group) {
        boolean ret_code = true;
        if (group.getShortlist() != this.shortlist || group.size() != this.size() || this.nickname.compareTo(group.getNickname()) != 0 || this.fullname.compareTo(group.getName()) != 0) {
            ret_code = false;
        } else {
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i).compareTo(group.get(i)) == 0) continue;
                ret_code = false;
                break;
            }
        }
        return ret_code;
    }
}

