/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.EditColorCode;
import innoval.mailer.MsgBox;
import innoval.mailer.Profile;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCMultiColumnList;
import jclass.util.JCUtilConverter;

public class ColorCodeList
extends Dialog
implements KeyListener,
JCActionListener,
ActionListener {
    static final String SAVENAME = new String("ColorCode");
    static final String DESC = new String("Description");
    private String[] desc = new String[]{"None", "Priority 1", "Priority 2", "Priority 3", "Priority 4", "Priority 5"};
    private jstreet Jstreet;
    private Frame frame;
    private Button okButton;
    private Button cancelButton;
    private Button changeButton;
    private boolean ret_code = false;
    private int selectedCode = 0;
    private JCMultiColumnList list;

    ColorCodeList(Frame frame, jstreet Jstreet) {
        super(frame, "Specify a Message Color Code", true);
        this.frame = frame;
        this.Jstreet = Jstreet;
        this.setupDialog();
        this.show();
    }

    ColorCodeList(Frame frame, jstreet Jstreet, String altDesc) {
        super(frame, "Specify a Message Color Code", true);
        this.frame = frame;
        this.Jstreet = Jstreet;
        this.desc[0] = altDesc;
        this.setupDialog();
        this.changeButton.setEnabled(false);
        this.list.select(0);
        this.show();
    }

    public void setupDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{150, 5, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 5, 60, 60};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.list = new JCMultiColumnList();
        this.list.addActionListener(this);
        this.list.setBackground(SystemColor.control);
        this.list.setColumnWidths(JCUtilConverter.toIntList("50,150", ','));
        this.list.setSpacing(2);
        this.list.setNumColumns(2);
        this.list.setAllowMultipleSelections(false);
        this.add(this.list);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 7;
        grid.setConstraints(this.list, con);
        this.readDescriptions();
        this.loadColorCodeList();
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 2;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 2;
        grid.setConstraints(this.cancelButton, con);
        this.changeButton = new Button("Change");
        this.changeButton.addActionListener(this);
        this.changeButton.addKeyListener(this);
        this.add(this.changeButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 2;
        grid.setConstraints(this.changeButton, con);
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, this.frame);
        this.enableEvents(64L);
    }

    public void readDescriptions() {
        Profile profile = this.Jstreet.getProfile();
        String text = "";
        for (int i = 0; i < 6; ++i) {
            text = new String(profile.ReadString(SAVENAME, String.valueOf(String.valueOf(String.valueOf(DESC).concat(String.valueOf("["))).concat(String.valueOf(i))).concat(String.valueOf("]")), ""));
            if (text.trim().length() <= 0) continue;
            this.desc[i] = text;
        }
    }

    public void loadColorCodeList() {
        String[] array = new String[6];
        array[0] = new String(String.valueOf(",").concat(String.valueOf(this.desc[0])));
        for (int i = 0; i < 5; ++i) {
            array[i + 1] = new String(String.valueOf(String.valueOf(String.valueOf("[img=").concat(String.valueOf(jstreet.flag[i]))).concat(String.valueOf("],"))).concat(String.valueOf(this.desc[i + 1])));
        }
        this.list.setItems(array);
    }

    public boolean getReturn() {
        return this.ret_code;
    }

    public int getSelectedCode() {
        return this.selectedCode;
    }

    public static String getCodeImage(int ind) {
        String image = " ";
        if (ind > 0 && ind < 6) {
            image = new String(String.valueOf(String.valueOf("[img=").concat(String.valueOf(jstreet.flag[ind - 1]))).concat(String.valueOf("]")));
        }
        return image;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            int item = this.list.getSelectedIndex();
            if (item >= 0) {
                this.selectedCode = item;
                this.ret_code = true;
                this.dispose();
            } else {
                MsgBox msgBox = new MsgBox(this.frame, "No color code is selected.");
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        } else if (e.getSource() == this.changeButton) {
            int item = this.list.getSelectedIndex();
            if (item >= 0) {
                EditColorCode edit = new EditColorCode(this.frame, this.desc[item]);
                if (edit.getReturn()) {
                    this.desc[item] = new String(edit.toString());
                    this.Jstreet.getProfile().WriteString(SAVENAME, String.valueOf(String.valueOf(String.valueOf(DESC).concat(String.valueOf("["))).concat(String.valueOf(item))).concat(String.valueOf("]")), this.desc[item], true);
                    this.list.clear();
                    this.loadColorCodeList();
                }
            } else {
                MsgBox msgBox = new MsgBox(this.frame, "No color code is selected.");
            }
        }
    }

    public void actionPerformed(JCActionEvent e) {
        Button evt = this.okButton;
        ActionEvent ae = new ActionEvent(evt, 1001, "");
        this.actionPerformed(ae);
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.dispose();
        } else {
            super.processWindowEvent(evt);
        }
    }
}

