/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.ConnectThread;
import innoval.mailer.DownloadFileRun;
import innoval.mailer.FileToDownload;
import innoval.mailer.GetFileThread;
import innoval.mailer.GetHttpFileThread;
import innoval.mailer.InternetDownload;
import innoval.mailer.MsgBox;
import innoval.mailer.WaitStringThread;
import innoval.mailer.jstreet;
import java.awt.Frame;
import java.awt.Label;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;

public class DownloadFile {
    static final int MAX_RECONNECT = 2;
    static final int MAX_RETRY = 1;
    static final int TIME_OUT = 1;
    static final int SIGNAL = 2;
    private String userid;
    private String password;
    private String server;
    private String hostFile;
    private String httpLocation;
    private File localFile;
    private boolean isFtp;
    private boolean isHttp;
    private boolean isRunning;
    private Label textLabel;
    private int httpRc;
    private int ftpPort;
    private int httpPort;
    private int connectTime;
    private int idleTime;
    private int waitstate;
    private DownloadFileRun downloadfilerun;
    private InternetDownload dialog;
    private Frame frame;
    private Socket socket;
    private BufferedReader in;
    private DataOutputStream out;
    private FileOutputStream fout;
    private BufferedWriter httpOut;
    private DataInputStream data_in;

    DownloadFile(Frame frame, InternetDownload dialog) {
        this.frame = frame;
        this.dialog = dialog;
    }

    public void setFtpPort(int port) {
        this.ftpPort = port;
    }

    public void setHttpPort(int port) {
        this.httpPort = port;
    }

    public void setConnectTime(int time) {
        this.connectTime = time;
    }

    public void setIdleTime(int time) {
        this.idleTime = time;
    }

    public void setHost(String server) {
        this.server = new String(server);
    }

    public void setHostFile(String hostfile) {
        this.hostFile = new String(hostfile);
    }

    public void setLocalFile(String localfile) {
        this.localFile = new File(localfile);
    }

    public void setFtpUserid(String userid) {
        this.userid = new String(userid);
    }

    public void setFtpPassword(String password) {
        this.password = new String(password);
    }

    public void setTextLabel(Label textLabel) {
        this.textLabel = textLabel;
    }

    public void setFtp() {
        this.isFtp = true;
        this.isHttp = false;
    }

    public void setHttp() {
        this.isFtp = false;
        this.isHttp = true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setText(String text) {
        if (this.textLabel != null) {
            this.textLabel.setText(text);
        }
    }

    public String getText() {
        if (this.textLabel != null) {
            return this.textLabel.getText();
        }
        return "";
    }

    synchronized void setWaitState(int val) {
        this.waitstate = val;
    }

    public void halt() {
        this.isRunning = false;
        this.setText("Requesting download to halt...");
    }

    private void sayMessage(String text) {
        MsgBox msg = new MsgBox(this.frame, text);
    }

    public static void Sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            System.out.println("Sleeping interrupted...");
        }
    }

    public void start() {
        this.isRunning = true;
        this.setText("Downloading internet file...");
        this.downloadfilerun = new DownloadFileRun(this);
        this.downloadfilerun.start();
    }

    public void Start() {
        if (this.isHttp) {
            this.downloadHttpFile();
        } else if (this.isFtp) {
            this.downloadFtpFile();
        }
        if (!this.isRunning) {
            this.setText("Download halted.");
        }
        this.dialog.completed();
    }

    public void downloadHttpFile() {
        FileToDownload file = new FileToDownload(this.server, this.hostFile, this.httpPort);
        if (this.isRunning) {
            this.getHttpFile(file);
        }
    }

    public void downloadFtpFile() {
        FileToDownload file = new FileToDownload(this.server, this.hostFile, this.ftpPort);
        if (this.isRunning && this.accessFtp(file.getServer(), file.getPort()) && this.setHostFileType()) {
            this.getFtpFile(file);
        }
    }

    public boolean setHostFileType() {
        boolean ret_code = true;
        try {
            String text = new String("type i");
            this.setText("Setting For Binary Transfer");
            String srvline = this.sendCommand(text);
            if (srvline == null) {
                this.sayMessage("Host did not respond after issuing \"TYPE\" command to FTP server.");
                ret_code = false;
            }
        }
        catch (IOException e) {
            this.sayMessage(String.valueOf("Error: ").concat(String.valueOf(e)));
            ret_code = false;
        }
        return ret_code;
    }

    public boolean getFtpFile(FileToDownload file) {
        boolean ret_code;
        block16: {
            ret_code = true;
            long bytes = 0L;
            long timeout = 0L;
            String text = null;
            Object inchar = null;
            boolean len = false;
            ServerSocket ls = null;
            Socket ds = null;
            try {
                this.setText(String.valueOf("Retrieving File...").concat(String.valueOf(file.getFile())));
                if (this.localFile.exists()) {
                    this.localFile.delete();
                }
                if (!this.IssuePortCommand(this.socket, ls = this.GetListenSocket())) {
                    ls.close();
                    ls = null;
                    ret_code = false;
                    this.sayMessage("Error issuing FTP PORT command.");
                } else if (this.isRunning) {
                    text = this.sendCommand(String.valueOf("RETR ").concat(String.valueOf(file.getFile())));
                    if (text != null) {
                        if (!text.startsWith("150")) {
                            this.sayMessage(String.valueOf("Error retrieving FTP file: ").concat(String.valueOf(text)));
                            ret_code = false;
                        } else {
                            ds = ls.accept();
                            if (ds == null) {
                                this.sayMessage("Error FTP data socket was not created.");
                                ret_code = false;
                            }
                        }
                    } else {
                        this.sayMessage("Error issuing FTP RETR command.");
                        ret_code = false;
                    }
                    ls.close();
                }
                if (!this.isRunning || ds == null) break block16;
                GetFileThread thread = new GetFileThread(this);
                thread.setSocket(ds);
                this.fout = null;
                thread.go = true;
                try {
                    thread.start();
                    while (this.isRunning && thread.go && ret_code) {
                        this.setWaitState(1);
                        thread.join(this.idleTime * 1000);
                        if (!thread.go || this.waitstate != 1) continue;
                        thread.stop();
                        this.sayMessage("Host is not responding.");
                        ret_code = false;
                    }
                    ds.close();
                }
                catch (InterruptedException e) {
                    this.sayMessage(String.valueOf("Error: ").concat(String.valueOf(e)));
                    ret_code = false;
                }
                ds.close();
                if (this.fout != null) {
                    this.fout.close();
                }
                if (ret_code) {
                    this.GetStrWait(this.idleTime, true);
                }
            }
            catch (IOException e) {
                this.sayMessage(String.valueOf("Error: ").concat(String.valueOf(e)));
                ret_code = false;
            }
        }
        return ret_code;
    }

    public void getFile(GetFileThread thread, Socket s) {
        int bytes = 0;
        boolean i = false;
        int cnt = 0;
        long total = 0L;
        byte[] buffer = new byte[2048];
        boolean cons = false;
        Object test = null;
        Object inchar = null;
        if (this.isRunning) {
            this.setText(String.valueOf("Bytes transferred: ").concat(String.valueOf(total)));
        }
        try {
            this.data_in = new DataInputStream(s.getInputStream());
            this.fout = new FileOutputStream(this.localFile);
            do {
                this.setWaitState(2);
                bytes = this.data_in.read(buffer, 0, buffer.length);
                if (bytes < 0) continue;
                if (bytes > 0) {
                    this.fout.write(buffer, 0, bytes);
                }
                total += (long)bytes;
                if (!this.isRunning || ++cnt >= 5 && cnt % 5 != 0) continue;
                this.setText(String.valueOf("Bytes transferred: ").concat(String.valueOf(total)));
            } while (this.isRunning && bytes >= 0);
            if (this.fout != null) {
                this.fout.close();
                this.fout = null;
            }
            this.data_in.close();
            thread.go = false;
            if (this.isRunning) {
                this.setText(String.valueOf(String.valueOf("Bytes transferred: ").concat(String.valueOf(total))).concat(String.valueOf(" (done)")));
            }
            this.setWaitState(2);
        }
        catch (IOException e) {
            this.sayMessage(String.valueOf("Error: ").concat(String.valueOf(e)));
        }
    }

    public ServerSocket GetListenSocket() throws IOException {
        ServerSocket socket = new ServerSocket(0);
        return socket;
    }

    public boolean IssuePortCommand(Socket s, ServerSocket ls) {
        boolean ret_code = false;
        int port = ls.getLocalPort();
        String addr1 = s.getLocalAddress().getHostAddress().replace('.', ',');
        String text = new String(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("PORT ").concat(String.valueOf(addr1))).concat(String.valueOf(","))).concat(String.valueOf((port & 0xFF00) >> 8))).concat(String.valueOf(","))).concat(String.valueOf(port & 0xFF)));
        try {
            String srvline = this.sendCommand(text);
            if (srvline.startsWith("200")) {
                ret_code = true;
            }
        }
        catch (IOException e) {
            this.sayMessage(String.valueOf("Error: ").concat(String.valueOf(e)));
        }
        return ret_code;
    }

    public boolean accessFtp(String host, int port) {
        boolean ret_code = false;
        boolean qconnect = false;
        try {
            this.setText(String.valueOf("Connecting to host...").concat(String.valueOf(host)));
            for (int cconnect = 0; this.isRunning && !qconnect && cconnect < 2; ++cconnect) {
                if (this.connectToFtpHost(host, port)) {
                    qconnect = true;
                    this.setText("Connected.");
                    continue;
                }
                this.setText("Connect Error...");
                DownloadFile.Sleep(500L);
                this.setText(String.valueOf("Re-Trying Connection...").concat(String.valueOf(host)));
            }
            if (this.isRunning) {
                if (qconnect) {
                    ret_code = this.logonToFtp();
                } else {
                    this.sayMessage(String.valueOf(String.valueOf("Could not connect to host [").concat(String.valueOf(host))).concat(String.valueOf("]")));
                }
            }
        }
        catch (IOException e) {
            this.sayMessage(String.valueOf("Error: ").concat(String.valueOf(e)));
        }
        return ret_code;
    }

    public boolean accessHttp(String host, int port) {
        boolean ret_code = false;
        boolean qconnect = false;
        this.setText(String.valueOf("Connecting to host...").concat(String.valueOf(host)));
        for (int cconnect = 0; this.isRunning && !qconnect && cconnect < 2; ++cconnect) {
            if (this.connectToFtpHost(host, port)) {
                qconnect = true;
                this.setText("Connected.");
                continue;
            }
            this.setText("Connect Error...");
            DownloadFile.Sleep(500L);
            this.setText(String.valueOf("Re-Trying Connection...").concat(String.valueOf(host)));
        }
        if (this.isRunning) {
            if (qconnect) {
                ret_code = true;
            } else {
                this.sayMessage(String.valueOf(String.valueOf("Could not connect to host [").concat(String.valueOf(host))).concat(String.valueOf("]")));
            }
        }
        return ret_code;
    }

    public boolean connectToFtpHost(String host, int port) {
        boolean ret_code = true;
        long timeout = 0L;
        ConnectThread thread = new ConnectThread(this);
        String oldtext = this.getText();
        try {
            thread.setPort(port);
            thread.setHost(host);
            thread.start();
            for (int i = this.connectTime; this.isRunning && i > 0; --i) {
                thread.join(1000L);
                this.setText(String.valueOf(String.valueOf(String.valueOf(oldtext).concat(String.valueOf("  [Timeout in: "))).concat(String.valueOf(i))).concat(String.valueOf(" seconds]")));
                if (!thread.isAlive()) break;
            }
            this.setText(oldtext);
            if (thread.isAlive()) {
                if (this.isRunning) {
                    this.sayMessage(String.valueOf(String.valueOf("Connection attempt timed out after [").concat(String.valueOf(this.connectTime))).concat(String.valueOf("] seconds.")));
                }
                thread.stop();
                ret_code = false;
            } else if (this.socket == null) {
                ret_code = false;
            }
        }
        catch (InterruptedException e) {
            this.sayMessage(String.valueOf("Error: ").concat(String.valueOf(e)));
            ret_code = false;
        }
        return ret_code;
    }

    public void performConnect(String host, int port) {
        try {
            this.socket = new Socket(host, port);
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.out = new DataOutputStream(this.socket.getOutputStream());
        }
        catch (IOException e) {
            this.sayMessage(String.valueOf("Connection error: ").concat(String.valueOf(e)));
        }
    }

    public String sendCommand(String text) throws IOException {
        String srvline = null;
        this.out.writeBytes(String.valueOf(text).concat(String.valueOf("\r\n")));
        srvline = this.GetStrWait(this.idleTime, true);
        while (this.isRunning && srvline.charAt(3) == '-') {
            srvline = this.GetStrWait(5, false);
        }
        return srvline;
    }

    public boolean logonToFtp() throws IOException {
        boolean ret_code;
        block11: {
            ret_code = true;
            String srvline = this.GetStrWait(this.idleTime, true);
            if (this.isRunning && srvline != null && srvline.startsWith("220")) {
                this.setText("Logging on to FTP server");
                while (this.isRunning && srvline.charAt(3) == '-') {
                    srvline = this.GetStrWait(5, false);
                }
                srvline = this.sendCommand(String.valueOf("user ").concat(String.valueOf(this.userid)));
                if (this.isRunning && srvline != null) {
                    if (!srvline.startsWith("331")) {
                        this.sayMessage(String.valueOf("Unexpected FTP error while issuing \"USER\" command: ").concat(String.valueOf(srvline)));
                        ret_code = false;
                    }
                } else {
                    this.sayMessage("Host did not respond after issuing the \"USER\" command to FTP server.");
                    ret_code = false;
                }
                if (this.isRunning && ret_code) {
                    this.setText("Issuing Password");
                    srvline = this.sendCommand(String.valueOf("pass ").concat(String.valueOf(this.password)));
                    if (this.isRunning && srvline != null) {
                        if (!srvline.startsWith("230")) {
                            this.sayMessage(String.valueOf("Unexpected FTP error while issuing \"PASS\" command: ").concat(String.valueOf(srvline)));
                            ret_code = false;
                        }
                    } else {
                        this.sayMessage("Host did not respond after issuing the \"PASS\" command to FTP server.");
                        ret_code = false;
                    }
                }
            } else {
                this.sayMessage(String.valueOf("Unexpected FTP error while connecting to server: ").concat(String.valueOf(srvline)));
                ret_code = false;
            }
            if (!this.isRunning || !ret_code) break block11;
            while (this.isRunning && srvline.charAt(3) == '-') {
                srvline = this.GetStrWait(5, false);
            }
            this.setText("Logon Successful");
        }
        return ret_code;
    }

    public String GetStrWait(int wait, boolean giveError) {
        String text = null;
        WaitStringThread waitstring = new WaitStringThread(this);
        try {
            waitstring.start();
            waitstring.join(wait * 1000);
            if (!waitstring.isAlive()) {
                waitstring.stop();
            }
            if ((text = waitstring.getText()) == null && giveError && this.isRunning) {
                this.sayMessage(String.valueOf(String.valueOf("Host timeout.  No response was received in allotted timeframe (").concat(String.valueOf(wait))).concat(String.valueOf(") seconds.")));
            }
        }
        catch (InterruptedException e) {
            this.sayMessage(String.valueOf("Error: ").concat(String.valueOf(e)));
        }
        return text;
    }

    public String getString() {
        String text = null;
        try {
            text = this.in.readLine();
        }
        catch (IOException e) {
            this.sayMessage(String.valueOf("Error: ").concat(String.valueOf(e)));
        }
        return text;
    }

    public boolean getHttpFile(FileToDownload file) {
        boolean ret_code = true;
        boolean qconnect = false;
        boolean qdownload = false;
        int cconnect = 0;
        int cdownload = 0;
        boolean spot = false;
        Object tchar = null;
        Object tchar1 = null;
        String text = null;
        String auth = null;
        Object localfile = null;
        Object domain = null;
        Object link = null;
        Object naddr = null;
        this.setText(String.valueOf("Connecting to host...").concat(String.valueOf(file.getServer())));
        while (this.isRunning && file.getFile().length() > 0 && !qdownload && cdownload < 1) {
            ++cdownload;
            qconnect = false;
            for (cconnect = 0; this.isRunning && !qconnect && cconnect < 2; ++cconnect) {
                if (this.connectToFtpHost(file.getServer(), file.getPort())) {
                    qconnect = true;
                    this.setText("Connected.");
                    continue;
                }
                this.setText("Connect Error...");
                DownloadFile.Sleep(500L);
                this.setText(String.valueOf("Re-Trying Connection...").concat(String.valueOf(file.getServer())));
            }
            if (!qconnect) continue;
            this.setText(String.valueOf("Retrieving HTTP file...").concat(String.valueOf(file.getFile())));
            DownloadFile.Sleep(1000L);
            text = new String(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("GET ").concat(String.valueOf(file.getFile()))).concat(String.valueOf(" HTTP/1.0\r\n"))).concat(String.valueOf("Host: "))).concat(String.valueOf(file.getServer()))).concat(String.valueOf("\r\n"))).concat(String.valueOf("Accept: */*; q=0.300\r\n"))).concat(String.valueOf("Accept: application/octet-stream; q=0.100\r\n"))).concat(String.valueOf("Accept: text/plain\r\n"))).concat(String.valueOf("Accept: text/html\r\n"))).concat(String.valueOf("Accept: text/map\r\n"))).concat(String.valueOf("Accept: application/rsu\r\n"))).concat(String.valueOf("Accept: application/inf\r\n"))).concat(String.valueOf("Accept: text/plain\r\n"))).concat(String.valueOf("Accept: audio/x-wav\r\n"))).concat(String.valueOf("Accept: audio/x-aiff\r\n"))).concat(String.valueOf("Accept: audio/basic\r\n"))).concat(String.valueOf("Accept: video/avs-video\r\n"))).concat(String.valueOf("Accept: video/x-msvideo\r\n"))).concat(String.valueOf("Accept: video/quicktime\r\n"))).concat(String.valueOf("Accept: video/mpeg\r\n"))).concat(String.valueOf("Accept: image/x-bitmap\r\n"))).concat(String.valueOf("Accept: image/bmp\r\n"))).concat(String.valueOf("Accept: image/tiff\r\n"))).concat(String.valueOf("Accept: image/jpeg\r\n"))).concat(String.valueOf("Accept: image/gif\r\n"))).concat(String.valueOf("Accept: image/map\r\n"))).concat(String.valueOf("Accept: application/editor\r\n")));
            if (file.getUserid().length() > 0 && file.getPassword().length() > 0) {
                auth = this.base64Encode(String.valueOf(String.valueOf(file.getUserid()).concat(String.valueOf(":"))).concat(String.valueOf(file.getPassword())));
                text = new String(String.valueOf(String.valueOf(String.valueOf(text).concat(String.valueOf("Authorization: Basic "))).concat(String.valueOf(auth))).concat(String.valueOf("\r\n")));
            }
            text = new String(String.valueOf(String.valueOf(String.valueOf(text).concat(String.valueOf("User-Agent: "))).concat(String.valueOf(jstreet.XMAILER))).concat(String.valueOf("\r\n\r\n")));
            try {
                this.out.writeBytes(text);
                ret_code = this.retrieveHttpFile(file);
                if (ret_code) {
                    if ((this.httpRc == 302 || this.httpRc == 301) && this.httpLocation != null && this.httpLocation.length() > 0) {
                        file = new FileToDownload(this.httpLocation, "", this.httpPort);
                    } else {
                        if (this.httpRc < 200 || this.httpRc > 299) {
                            this.sayMessage(String.valueOf(String.valueOf("HTTP error(").concat(String.valueOf(this.httpRc))).concat(String.valueOf(") returned while retrieving URL.")));
                        }
                        qdownload = true;
                    }
                } else {
                    this.setText("HTTP Download Error");
                    DownloadFile.Sleep(500L);
                    this.setText("Re-Trying Download...");
                }
            }
            catch (IOException e) {
                this.sayMessage(String.valueOf("Error: ").concat(String.valueOf(e)));
                ret_code = false;
            }
            if (this.socket == null) continue;
            this.CloseUpSocket();
        }
        if (!qconnect) {
            this.sayMessage("A connection to the HTTP server could not be established.");
            this.setText("Connection failed.");
            ret_code = false;
        }
        return ret_code;
    }

    public void CloseUpSocket() {
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            this.socket.close();
        }
        catch (IOException e) {
            this.sayMessage(String.valueOf("Error: ").concat(String.valueOf(e)));
        }
    }

    public String base64Encode(String line) {
        char[] text = new char[line.length() * 2];
        int len = 0;
        int cnt = 0;
        char ch = '\u0000';
        char[] list = new String("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/").toCharArray();
        while (line.length() % 3 != 0) {
            line = new String(String.valueOf(line).concat(String.valueOf(" ")));
        }
        for (len = line.length(); len > 0; len -= 3) {
            ch = (char)(line.charAt(0) >> 2);
            text[cnt++] = list[ch];
            ch = (char)(line.charAt(0) << 4 & 0x30 | line.charAt(1) >> 4 & 0xF);
            text[cnt++] = list[ch];
            ch = (char)(line.charAt(1) << 2 & 0x3C | line.charAt(2) >> 6 & 3);
            text[cnt++] = list[ch];
            ch = (char)(line.charAt(2) & 0x3F);
            text[cnt++] = list[ch];
            if (line.length() <= 3) continue;
            line = new String(line.substring(3));
        }
        line = new String(text, 0, cnt);
        while (line.length() % 4 != 0) {
            line = new String(String.valueOf(line).concat(String.valueOf("=")));
        }
        return line;
    }

    public boolean retrieveHttpFile(FileToDownload file) {
        boolean ret_code = true;
        this.httpRc = 0;
        this.httpLocation = new String("");
        GetHttpFileThread thread = new GetHttpFileThread(this);
        this.httpOut = null;
        thread.go = true;
        try {
            thread.start();
            while (this.isRunning && thread.go && ret_code) {
                this.setWaitState(1);
                thread.join(this.idleTime * 1000);
                if (!this.isRunning || !thread.go || this.waitstate != 1) continue;
                thread.stop();
                this.setText("Host is not responding.");
                ret_code = false;
            }
        }
        catch (InterruptedException e) {
            this.sayMessage(String.valueOf("Error: ").concat(String.valueOf(e)));
            ret_code = false;
        }
        try {
            if (this.httpOut != null) {
                this.httpOut.close();
            }
        }
        catch (IOException e) {
            this.sayMessage(String.valueOf("Error: ").concat(String.valueOf(e)));
        }
        return ret_code;
    }

    public void downloadHttpFile(GetHttpFileThread thread) {
        boolean i = false;
        int bytes = 0;
        int spot = 0;
        double per = 0.0;
        long fbytes = 0L;
        long total = 0L;
        long length = 0L;
        long cnt = 0L;
        char[] buffer = new char[1024];
        boolean error = false;
        String tchar = null;
        String srvline = null;
        Object inchar = null;
        String text = null;
        Object test = null;
        try {
            this.httpOut = new BufferedWriter(new FileWriter(this.localFile));
            do {
                if ((srvline = this.in.readLine()) == null) continue;
                if (srvline.toLowerCase().startsWith("http/")) {
                    text = new String(srvline.substring(9));
                    spot = text.indexOf(32);
                    if (spot >= 0) {
                        text = new String(text.substring(0, spot));
                    }
                    this.httpRc = Integer.parseInt(text);
                    continue;
                }
                if (srvline.toLowerCase().startsWith("location:")) {
                    this.httpLocation = new String(srvline.substring(10));
                    continue;
                }
                if (!srvline.toLowerCase().startsWith("content-length:")) continue;
                tchar = new String(srvline.substring(15));
                while (tchar.charAt(0) == ' ') {
                    tchar = new String(tchar.substring(1));
                }
                fbytes = length = (long)Integer.parseInt(tchar);
            } while (srvline != null && srvline.length() > 0);
            do {
                this.setWaitState(2);
                bytes = this.in.read(buffer, 0, buffer.length);
                if (bytes < 0) continue;
                if (bytes > 0) {
                    this.httpOut.write(buffer, 0, bytes);
                }
                total += (long)bytes;
                if (!this.isRunning || ++cnt >= (long)5 && cnt % (long)5 != (long)0) continue;
                if (length > (long)0) {
                    per = (double)total / (double)length * (double)100;
                    this.setText(String.valueOf(String.valueOf("").concat(String.valueOf((int)per))).concat(String.valueOf("% Completed")));
                    continue;
                }
                this.setText(String.valueOf(String.valueOf("").concat(String.valueOf((int)(total / (long)1024)))).concat(String.valueOf("k Completed")));
            } while (bytes >= 0);
            if (length == (long)0) {
                this.setText(String.valueOf(String.valueOf("").concat(String.valueOf(total / (long)1024))).concat(String.valueOf("k Done")));
            } else {
                per = (double)total / (double)length * (double)100;
                this.setText(String.valueOf(String.valueOf("").concat(String.valueOf((int)per))).concat(String.valueOf("% Done")));
            }
            if (this.fout != null) {
                this.fout.close();
                this.fout = null;
            }
        }
        catch (IOException e) {
            this.sayMessage(String.valueOf("Error: ").concat(String.valueOf(e)));
        }
        thread.go = false;
        this.setWaitState(2);
    }
}

