/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.Addresses;
import innoval.mailer.RfcStandards;
import innoval.mailer.TextMisc;
import java.util.Hashtable;
import java.util.Vector;

public class Headers {
    static final String HASH = "|";
    private Hashtable headerLines = null;
    private Hashtable mimeLines = null;
    private int[] headerLinesCnt;
    private int[] linesRead;
    private int[] mimeLinesCnt;
    private int headerLineCount = 0;

    public void Headers() {
    }

    public void init() {
        this.headerLines = new Hashtable();
        this.headerLinesCnt = new int[128];
        this.mimeLines = new Hashtable();
        this.mimeLinesCnt = new int[128];
        this.linesRead = new int[128];
        this.headerLineCount = 0;
        this.clearHeaderTable();
    }

    public void clearHeaderTable() {
        this.headerLines.clear();
        for (int i = 0; i < 128; ++i) {
            this.headerLinesCnt[i] = 0;
            this.mimeLinesCnt[i] = 0;
            this.linesRead[i] = 0;
        }
    }

    public void linesRead(int piece, int lines) {
        int n = piece;
        this.linesRead[n] = this.linesRead[n] + lines;
    }

    public int getLinesRead(int piece) {
        return this.linesRead[piece];
    }

    public int size(int piece) {
        return this.headerLinesCnt[piece];
    }

    public String getHtml(int piece, int i) {
        int spot;
        String r = this.get(piece, i);
        if (r.length() > 0 && (spot = r.indexOf(58)) >= 0) {
            r = new String(String.valueOf(String.valueOf(String.valueOf("<BR><B>").concat(String.valueOf(r.substring(0, spot + 1)))).concat(String.valueOf("</B>"))).concat(String.valueOf(Headers.fixHtmlLine(r.substring(spot + 1)))));
        }
        return r;
    }

    public String get(int i) {
        return this.get(0, i);
    }

    public String get(int piece, int i) {
        return (String)this.headerLines.get(String.valueOf(String.valueOf(piece).concat(String.valueOf(HASH))).concat(String.valueOf(i)));
    }

    public void parse(String headerLine, int piece) {
        String longLine = "";
        String tag = "";
        String theRest = "";
        Addresses addr = new Addresses();
        if (headerLine.indexOf(":") >= 0) {
            tag = TextMisc.leftParse(':', headerLine);
            theRest = TextMisc.rightParse(':', headerLine);
            longLine = String.valueOf(tag).concat(String.valueOf(":"));
        } else {
            tag = "";
            theRest = headerLine.trim();
            longLine = "";
        }
        tag.replace('\t', ' ');
        tag = TextMisc.rTrim(tag);
        theRest = theRest.trim();
        while (theRest.startsWith("\t")) {
            theRest = theRest.substring(1);
        }
        while (theRest.endsWith("\t")) {
            theRest = theRest.substring(0, theRest.length() - 2);
        }
        theRest = theRest.trim();
        String temp = headerLine.trim();
        int typ = RfcStandards.getHeaderType(tag);
        if (RfcStandards.getHeaderType(tag) == 2) {
            int rc = addr.parse(theRest, true);
            longLine = String.valueOf(tag).concat(String.valueOf(":"));
            for (int i = 0; i < rc; ++i) {
                longLine = String.valueOf(String.valueOf(String.valueOf(longLine).concat(String.valueOf(" "))).concat(String.valueOf(addr.getAddress(i)))).concat(String.valueOf(","));
            }
            if (longLine.endsWith(",")) {
                longLine = longLine.substring(0, longLine.length() - 1);
            }
        } else {
            String s1 = TextMisc.elimExtraSpaces(theRest);
            String s2 = RfcStandards.filterRfc2047(s1, 'x');
            longLine = String.valueOf(String.valueOf(longLine).concat(String.valueOf(" "))).concat(String.valueOf(s2));
        }
        this.headerLines.put(String.valueOf(String.valueOf(piece).concat(String.valueOf(HASH))).concat(String.valueOf(this.headerLinesCnt[piece])), longLine.trim());
        int n = piece;
        this.headerLinesCnt[n] = this.headerLinesCnt[n] + 1;
    }

    public String getHeaderLine(int piece, String tag) {
        String r = "";
        int j = this.headerLines.size();
        for (int i = 0; i < this.headerLinesCnt[0]; ++i) {
            String t;
            String x = (String)this.headerLines.get(String.valueOf(String.valueOf(piece).concat(String.valueOf(HASH))).concat(String.valueOf(i)));
            String y = x.toUpperCase();
            if (!y.startsWith(t = String.valueOf(tag.toUpperCase()).concat(String.valueOf(": ")))) continue;
            r = x;
        }
        return r;
    }

    public String getHeaderLine(int piece) {
        String r = "";
        for (int i = 0; i < this.headerLinesCnt[0]; ++i) {
            String x = (String)this.headerLines.get(String.valueOf(String.valueOf(piece).concat(String.valueOf(HASH))).concat(String.valueOf(i)));
            r = String.valueOf(String.valueOf(r).concat(String.valueOf(" "))).concat(String.valueOf(x));
        }
        return r;
    }

    public Vector getHeaderLines(int piece, String tag) {
        Vector<String> lines = new Vector<String>();
        String t = String.valueOf(tag.trim().toUpperCase()).concat(String.valueOf(": "));
        for (int i = 0; i < this.headerLinesCnt[0]; ++i) {
            String x = (String)this.headerLines.get(String.valueOf(String.valueOf(piece).concat(String.valueOf(HASH))).concat(String.valueOf(i)));
            String y = x.toUpperCase();
            if (!tag.equalsIgnoreCase("all") && !y.startsWith(t)) continue;
            lines.addElement(TextMisc.rightParse(':', x));
        }
        return lines;
    }

    public boolean isHeaderLine(int piece, String tag) {
        boolean ret_code = false;
        String t = String.valueOf(tag.toUpperCase()).concat(String.valueOf(":"));
        for (int i = 0; i < this.headerLinesCnt[0]; ++i) {
            String x = (String)this.headerLines.get(String.valueOf(String.valueOf(piece).concat(String.valueOf(HASH))).concat(String.valueOf(i)));
            String y = x.toUpperCase();
            if (!y.startsWith(t)) continue;
            ret_code = true;
            break;
        }
        return ret_code;
    }

    public String formatHeaderLine(String tag, boolean html) {
        String r = this.getHeaderLine(0, tag);
        if (r.length() > 0) {
            if (html) {
                int spot = r.indexOf(58);
                if (spot >= 0) {
                    r = new String(String.valueOf(String.valueOf(String.valueOf("<BR><B>").concat(String.valueOf(r.substring(0, spot + 1)))).concat(String.valueOf("</B>"))).concat(String.valueOf(Headers.fixHtmlLine(r.substring(spot + 1)))));
                }
            } else {
                r = new String(String.valueOf(r).concat(String.valueOf("\n")));
            }
        }
        return r;
    }

    public static String fixHtmlLine(String text) {
        text = Headers.replace(text, "<", "&lt;");
        text = Headers.replace(text, ">", "&gt;");
        return text;
    }

    public static String replace(String text, String find, String rep) {
        int spot = 0;
        while (spot >= 0) {
            spot = text.indexOf(find);
            if (spot < 0) continue;
            text = new String(String.valueOf(String.valueOf(text.substring(0, spot)).concat(String.valueOf(rep))).concat(String.valueOf(text.substring(spot + 1))));
        }
        return text;
    }

    public String getHeaderValue(String tag) {
        String r = this.getHeaderLine(0, tag);
        if (r.length() > 0) {
            int spot = r.indexOf(58);
            r = spot >= 0 ? new String(r.substring(spot + 1).trim()) : new String("");
        }
        return r;
    }

    public int getHeaderLineCount(int piece) {
        return this.headerLinesCnt[piece];
    }

    public String getHeaderLine(int piece, int index) {
        return (String)this.headerLines.get(String.valueOf(String.valueOf(piece).concat(String.valueOf(HASH))).concat(String.valueOf(index)));
    }

    public String getMimeSpec(int piece, int index) {
        String x = (String)this.mimeLines.get(String.valueOf(String.valueOf(String.valueOf("").concat(String.valueOf(piece))).concat(String.valueOf(HASH))).concat(String.valueOf(index)));
        try {
            int i = x.length();
            if (i > 0 && x.trim().charAt(0) == '\"' && (x = new String(x.substring(1))).endsWith("\"")) {
                x = new String(x.substring(0, x.length() - 1));
            }
        }
        catch (NullPointerException e) {
            x = "";
        }
        return x;
    }

    public void parseForMime(int piece) {
        block9: {
            String typeFileName;
            block10: {
                block8: {
                    typeFileName = "";
                    String descriptionFileName = "";
                    String dispositionFileName = "";
                    if (this.headerLinesCnt[piece] == 0) {
                        return;
                    }
                    for (int c = 0; c < this.headerLinesCnt[piece]; ++c) {
                        String header = (String)this.headerLines.get(String.valueOf(String.valueOf(piece).concat(String.valueOf(HASH))).concat(String.valueOf(c)));
                        String headerTag = TextMisc.leftParse(' ', header);
                        String theRest = TextMisc.rightParse(':', header);
                        String ucRest = theRest.toUpperCase();
                        if (headerTag.equalsIgnoreCase("mime-version:")) {
                            theRest = TextMisc.elimComments(theRest);
                            this.mimeLines.put(String.valueOf(String.valueOf(piece).concat(String.valueOf(HASH))).concat(String.valueOf(1)), theRest.trim());
                        }
                        if (headerTag.equalsIgnoreCase("content-type:")) {
                            theRest = TextMisc.elimComments(theRest);
                            this.mimeLines.put(String.valueOf(String.valueOf(piece).concat(String.valueOf(HASH))).concat(String.valueOf(2)), theRest.trim());
                            if (ucRest.indexOf("MULTIPART/") >= 0) {
                                String bound = TextMisc.getParameter("BOUNDARY", theRest);
                                this.mimeLines.put(String.valueOf(String.valueOf(piece).concat(String.valueOf(HASH))).concat(String.valueOf(3)), bound);
                            } else {
                                typeFileName = TextMisc.getParameter("NAME", theRest);
                            }
                        }
                        if (headerTag.equalsIgnoreCase("content-description:")) {
                            this.mimeLines.put(String.valueOf(String.valueOf(piece).concat(String.valueOf(HASH))).concat(String.valueOf(4)), theRest.trim());
                            descriptionFileName = TextMisc.getParameter("NAME", theRest);
                        }
                        if (headerTag.equalsIgnoreCase("content-disposition:")) {
                            this.mimeLines.put(String.valueOf(String.valueOf(piece).concat(String.valueOf(HASH))).concat(String.valueOf(5)), theRest.trim());
                            dispositionFileName = TextMisc.getParameter("NAME", theRest);
                        }
                        if (!headerTag.equalsIgnoreCase("content-transfer-encoding:")) continue;
                        theRest = TextMisc.elimComments(theRest);
                        this.mimeLines.put(String.valueOf(String.valueOf(piece).concat(String.valueOf(HASH))).concat(String.valueOf(7)), theRest.trim());
                    }
                    if (typeFileName.length() <= 0) break block8;
                    this.mimeLines.put(String.valueOf(String.valueOf(piece).concat(String.valueOf(HASH))).concat(String.valueOf(6)), typeFileName);
                    break block9;
                }
                if (typeFileName.length() <= 0) break block10;
                this.mimeLines.put(String.valueOf(String.valueOf(piece).concat(String.valueOf(HASH))).concat(String.valueOf(6)), typeFileName);
                break block9;
            }
            if (typeFileName.length() <= 0) break block9;
            this.mimeLines.put(String.valueOf(String.valueOf(piece).concat(String.valueOf(HASH))).concat(String.valueOf(6)), typeFileName);
        }
    }
}

