/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mail.Imap4;
import innoval.mail.Imap4Exception;
import innoval.mail.Imap4Folder;
import innoval.mailer.ImapCreateFolder;
import innoval.mailer.ImapMailbox;
import innoval.mailer.ImapRenameFolder;
import innoval.mailer.MsgBox;
import innoval.mailer.PreviewImapMail;
import innoval.mailer.SettingsGeneral;
import java.awt.Frame;
import java.awt.Label;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCOutliner;
import jclass.bwt.JCOutlinerEvent;
import jclass.bwt.JCOutlinerFolderNode;
import jclass.bwt.JCOutlinerListener;
import jclass.bwt.JCOutlinerNode;
import jclass.bwt.JCOutlinerNodeStyle;
import jclass.util.JCVector;

public class ImapTree
extends JCOutliner
implements JCOutlinerListener,
MouseListener {
    public ImapMailbox rootNode = null;
    private PopupMenu popup;
    private PreviewImapMail parent = null;
    public JCOutlinerNodeStyle defStyle = null;
    public JCOutlinerNodeStyle parentStyle = null;

    ImapTree(PreviewImapMail parent) {
        this.parent = parent;
        this.setRootVisible(false);
        this.setAutoSelect(false);
        this.initTree();
        this.addItemListener(this);
    }

    public ImapTree cloneTree() {
        ImapTree tree = new ImapTree(this.parent);
        this.copyTree(tree);
        return tree;
    }

    public void copyTree(ImapTree newTree) {
        newTree.setVisible(false);
        newTree.setBatched(true);
        newTree.rootNode = new ImapMailbox();
        newTree.setRootNode(newTree.rootNode);
        JCVector children = this.rootNode.getChildren();
        ImapMailbox item = null;
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                item = (ImapMailbox)children.elementAt(i);
                this.loadFolderItem(item, newTree.rootNode);
            }
        }
        newTree.setBatched(false);
        newTree.selectFirst();
        newTree.setVisible(true);
        newTree.folderChanged(newTree.rootNode);
    }

    private void loadFolderItem(ImapMailbox item, ImapMailbox node) {
        ImapMailbox newitem = new ImapMailbox(item.getFolder(), node);
        newitem.setLabel(item.getLabel());
        newitem.setState(1);
        JCVector children = item.getChildren();
        if (children != null && children.size() > 0) {
            newitem.setStyle(this.parentStyle);
            for (int i = 0; i < children.size(); ++i) {
                ImapMailbox childItem = (ImapMailbox)children.elementAt(i);
                this.loadFolderItem(childItem, newitem);
            }
        }
    }

    public void selectFirst() {
        ImapMailbox item = (ImapMailbox)this.rootNode.getChildren().getFirst();
        if (item != null) {
            this.selectNode(item, null);
        }
    }

    public void setPopup(PopupMenu popup) {
        this.popup = popup;
    }

    private void initTree() {
        this.setNumColumns(1);
        this.setColumnWidth(0, 200);
        this.getDefaultNodeStyle().setShortcut(true);
        this.defStyle = this.getDefaultNodeStyle();
        this.defStyle.setShortcut(true);
        this.parentStyle = new JCOutlinerNodeStyle(this.defStyle);
        this.getViewport().addMouseListener(this);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getModifiers() == 4) {
            this.calcItem(e.getY());
            if (this.popup != null) {
                this.popup.show(this, e.getX(), e.getY());
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void outlinerFolderStateChangeBegin(JCOutlinerEvent ev) {
        JCOutliner outliner;
        JCOutlinerFolderNode folder = (JCOutlinerFolderNode)ev.getNode();
        if (folder == (outliner = (JCOutliner)ev.getSource()).getRootNode()) {
            return;
        }
        outliner.folderChanged(folder);
    }

    public void outlinerFolderStateChangeEnd(JCOutlinerEvent ev) {
    }

    public void outlinerNodeSelectBegin(JCOutlinerEvent ev) {
    }

    public void outlinerNodeSelectEnd(JCOutlinerEvent ev) {
    }

    public void itemStateChanged(JCItemEvent ev) {
    }

    public void calcItem(int y) {
        JCVector node = this.getVisibleNodes();
        int item = 0;
        JCOutlinerNode tnode = null;
        Rectangle rect = null;
        if (node != null && node.size() > 0) {
            do {
                tnode = (JCOutlinerNode)node.elementAt(item);
                rect = this.getBounds(tnode, null);
            } while (++item < node.size() && y > rect.getLocation().y + rect.getSize().height);
            if (tnode != this.getSelectedNode()) {
                this.selectNode(tnode, null);
            }
        }
    }

    public ImapMailbox getCurrent() {
        JCOutlinerNode node = this.getSelectedNode();
        ImapMailbox current = null;
        if (node != null) {
            current = (ImapMailbox)node;
        }
        return current;
    }

    public void expandCollapse(boolean way) {
        int stat = 1;
        if (way) {
            stat = 5;
        }
        this.setVisible(false);
        this.setBatched(true);
        this.expandCollapse(this.rootNode, stat);
        this.rootNode.setState(5);
        this.setBatched(false);
        this.folderChanged(this.rootNode);
        this.setVisible(true);
        this.repaint();
    }

    public void expandCollapse(ImapMailbox node, int stat) {
        while (node != null) {
            this.expandChildren(node, stat);
            node = (ImapMailbox)this.getNextNode(node);
        }
    }

    public void expandChildren(ImapMailbox node, int stat) {
        JCVector child = node.getChildren();
        node.setState(stat);
        if (child != null) {
            for (int i = 0; i < child.size(); ++i) {
                this.expandChildren((ImapMailbox)child.elementAt(i), stat);
            }
        }
    }

    public void createFolder(PreviewImapMail frame, Imap4 imap) {
        ImapCreateFolder createfolder = new ImapCreateFolder(frame, imap, "Create a New Folder");
        createfolder.show();
        if (createfolder.getFolder() != null) {
            ImapMailbox newitem = new ImapMailbox(createfolder.getFolder(), this.rootNode);
            newitem.setState(1);
            this.folderChanged(newitem);
            this.repaint();
        }
    }

    public void createSubFolder(PreviewImapMail frame, Imap4 imap) {
        ImapMailbox item = (ImapMailbox)this.getSelectedNode();
        if (item != null) {
            String name = new String(item.getName());
            String title = new String(String.valueOf(String.valueOf("Create a Subfolder Under [").concat(String.valueOf(item.getLabel()))).concat(String.valueOf("]")));
            ImapCreateFolder createfolder = new ImapCreateFolder(frame, imap, item, title);
            createfolder.show();
            if (createfolder.getFolder() != null) {
                ImapMailbox newitem = new ImapMailbox(createfolder.getFolder(), item);
                this.setBatched(true);
                newitem.setState(1);
                this.setBatched(false);
                item.setStyle(this.parentStyle);
                this.folderChanged(newitem);
                this.repaint();
                this.makeNodeVisible(newitem);
            }
        } else {
            MsgBox msgBox = new MsgBox(frame, "No folder is currently selected.");
        }
    }

    public void renameFolder(Frame frame) {
        ImapMailbox item = (ImapMailbox)this.getSelectedNode();
        if (item != null) {
            String title = new String(String.valueOf(String.valueOf("Rename Folder [").concat(String.valueOf(item.getLabel()))).concat(String.valueOf("]")));
            ImapRenameFolder renamefolder = new ImapRenameFolder(frame, item, title);
            renamefolder.show();
            if (renamefolder.getReturn()) {
                this.folderChanged(item);
                this.repaint();
                this.makeNodeVisible(item);
            }
        } else {
            MsgBox msgBox = new MsgBox(frame, "No folder is currently selected.");
        }
    }

    public boolean deleteFolder(Frame frame, ImapMailbox folder) {
        MsgBox msgBox;
        boolean ret_code = false;
        ImapMailbox parent = (ImapMailbox)folder.getParent();
        this.setBatched(true);
        try {
            folder.getFolder().close();
        }
        catch (Imap4Exception e) {
            msgBox = new MsgBox(frame, e.toString());
        }
        try {
            folder.getFolder().delete();
            if (parent != null) {
                parent.removeChild(folder);
                folder = null;
                this.selectNode(null, null);
                if (parent.getChildren() == null || parent.getChildren().size() == 0) {
                    parent.setStyle(this.defStyle);
                }
                System.gc();
            }
            ret_code = true;
        }
        catch (Imap4Exception e) {
            msgBox = new MsgBox(frame, e.toString());
        }
        this.setBatched(false);
        this.repaint();
        this.folderChanged(this.rootNode);
        return ret_code;
    }

    public void load(Imap4 imap, Label text) {
        text.setText("Reading list of Mailboxes...");
        this.setVisible(false);
        this.setBatched(true);
        this.rootNode = new ImapMailbox();
        this.setRootNode(this.rootNode);
        String maildir = this.parent.getFrameParent().getProfile().ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.MAILFOLDER, "");
        try {
            Imap4Folder root = imap.getAllFolders(maildir);
            if (maildir.length() > 0) {
                while (root.getChildrenCount() == 1 && maildir.startsWith(root.getWholeName())) {
                    root = root.getChild(0);
                }
            }
            for (int i = 0; i < root.getChildrenCount(); ++i) {
                ImapMailbox node = new ImapMailbox(root.getChild(i), this.rootNode);
                node.setState(1);
                this.loadChildren(node);
            }
        }
        catch (Imap4Exception e) {
            MsgBox msgBox = new MsgBox(this, e.toString());
        }
        this.setBatched(false);
        this.repaint();
        this.setVisible(true);
        this.folderChanged(this.rootNode);
        text.setText("Mailboxes have been loaded.");
    }

    private void loadChildren(ImapMailbox node) {
        for (int i = 0; i < node.getChildrenCount(this); ++i) {
            ImapMailbox child = new ImapMailbox(node.getChild(this, i), node);
            child.setState(1);
            this.loadChildren(child);
        }
    }
}

