/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.InternetDownload;
import innoval.mailer.MsgBox;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;

public class InternetFileOptions
extends Dialog
implements KeyListener,
ActionListener {
    private jstreet Jstreet;
    private InternetDownload download;
    private Button okButton;
    private Button cancelButton;
    private boolean ret_code = false;
    private TextField ftpField;
    private TextField httpField;
    private TextField idleField;
    private TextField connectField;

    InternetFileOptions(jstreet Jstreet, InternetDownload download) {
        super(Jstreet, "Internet File Transfer Options", true);
        this.Jstreet = Jstreet;
        this.download = download;
        this.setupDialog();
    }

    public void setupDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 5, 20, 5, 20, 5, 20, 10, 20, 5};
        int[] columnWidths = new int[]{5, 80, 5, 80, 60};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("FTP Port", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(label, con);
        this.ftpField = new TextField(String.valueOf("").concat(String.valueOf(this.download.getFtpPort())));
        this.add(this.ftpField);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 1;
        grid.setConstraints(this.ftpField, con);
        label = new Label("HTTP Port", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        grid.setConstraints(label, con);
        this.httpField = new TextField(String.valueOf("").concat(String.valueOf(this.download.getHttpPort())));
        this.add(this.httpField);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 3;
        grid.setConstraints(this.httpField, con);
        label = new Label("Connect Time", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 5;
        grid.setConstraints(label, con);
        this.connectField = new TextField(String.valueOf("").concat(String.valueOf(this.download.getConnectTime())));
        this.add(this.connectField);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 5;
        grid.setConstraints(this.connectField, con);
        label = new Label("Idle Time", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 7;
        grid.setConstraints(label, con);
        this.idleField = new TextField(String.valueOf("").concat(String.valueOf(this.download.getIdleTime())));
        this.add(this.idleField);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 7;
        grid.setConstraints(this.idleField, con);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 9;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 9;
        grid.setConstraints(this.cancelButton, con);
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, this.Jstreet);
        this.enableEvents(64L);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.checkFields()) {
                this.download.setFtpPort(InternetDownload.makeInt(this.ftpField.getText()));
                this.download.setHttpPort(InternetDownload.makeInt(this.httpField.getText()));
                this.download.setConnectTime(InternetDownload.makeInt(this.connectField.getText()));
                this.download.setIdleTime(InternetDownload.makeInt(this.idleField.getText()));
                this.dispose();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.dispose();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public boolean checkFields() {
        MsgBox msg;
        boolean ret_code = true;
        int val = 0;
        val = InternetDownload.makeInt(this.ftpField.getText());
        if (val < 0 || val > 10000) {
            msg = new MsgBox(this.Jstreet, "The FTP port must be between 1 and 10000.");
            this.ftpField.requestFocus();
            ret_code = false;
        }
        if (ret_code && ((val = InternetDownload.makeInt(this.httpField.getText())) < 0 || val > 10000)) {
            msg = new MsgBox(this.Jstreet, "The HTTP port must be between 1 and 10000.");
            this.httpField.requestFocus();
            ret_code = false;
        }
        if (ret_code && ((val = InternetDownload.makeInt(this.connectField.getText())) < 30 || val > 1000)) {
            msg = new MsgBox(this.Jstreet, "The connect time must be between 30 and 1000 seconds.");
            this.connectField.requestFocus();
            ret_code = false;
        }
        if (ret_code && ((val = InternetDownload.makeInt(this.idleField.getText())) < 30 || val > 1000)) {
            msg = new MsgBox(this.Jstreet, "The idle time must be between 30 and 1000 seconds.");
            this.idleField.requestFocus();
            ret_code = false;
        }
        return ret_code;
    }
}

