/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import borland.jbcl.control.BevelPanel;
import innoval.mailer.AbandonThread;
import innoval.mailer.AddressBook;
import innoval.mailer.AutoRefresh;
import innoval.mailer.JBevelPanel;
import innoval.mailer.JButton;
import innoval.mailer.JList;
import innoval.mailer.JTextArea;
import innoval.mailer.JstreetLdap;
import innoval.mailer.JstreetLdapAddAddress;
import innoval.mailer.JstreetLdapMailkey;
import innoval.mailer.LDAPSearchThread;
import innoval.mailer.MsgBox;
import innoval.mailer.Profile;
import innoval.mailer.SelectAddressBook;
import innoval.mailer.jstreet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import jclass.bwt.JCSplitterWindow;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;

public class JstreetLdapSearch
extends Dialog
implements KeyListener,
ActionListener,
ItemListener,
ClipboardOwner {
    static final int MAX = 100;
    static final String SAVE_MAILKEY = new String("MailKey");
    static final String DEF_MAILKEY = new String("mail");
    private Frame frame = null;
    private Profile profile = null;
    private String server = null;
    private String mailkey = null;
    public LDAPConnection ldap = null;
    public LDAPSearchResults search = null;
    public LDAPSearchThread thread = null;
    public Vector results = new Vector();
    private TextField toField = null;
    private Label text = null;
    private Checkbox checkPw = null;
    private JBevelPanel detPanel = null;
    private jstreet Jstreet = null;
    private Button okButton;
    private Button cancelButton;
    private Button toButton;
    private Button ccButton;
    private Button bccButton;
    private Button clearButton;
    private Button addButton;
    private JButton selallButton;
    private JButton copyButton;
    private JList list;
    private JTextArea detailarea;
    private TextField email;
    private TextField firstname;
    private TextField lastname;
    private TextField unit;
    private TextField maxsearch;
    private TextField organization;
    private TextField country;

    public JstreetLdapSearch(Frame frame, jstreet Jstreet, TextField toField, LDAPConnection ldap, Profile profile, String server, String title) {
        super(frame, title, true);
        this.frame = frame;
        this.Jstreet = Jstreet;
        this.toField = toField;
        this.ldap = ldap;
        this.profile = profile;
        this.server = server;
        this.initWindow();
        this.enableEvents(64L);
        this.show();
        this.toFront();
    }

    public void initWindow() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 5, 20, 5, 20, 5, 200, 5, 20, 5, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 80, 60, 5, 140, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 10.0, 0.0, 0.0, 10.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("First Name", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(label, con);
        label = new Label("Last Name", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        grid.setConstraints(label, con);
        label = new Label("Org. Unit(ou)", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        grid.setConstraints(label, con);
        label = new Label("Organization(o)", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 3;
        grid.setConstraints(label, con);
        label = new Label("Country(c)", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 5;
        grid.setConstraints(label, con);
        label = new Label("Max Returns", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 5;
        grid.setConstraints(label, con);
        this.firstname = new TextField(this.profile.ReadString(this.server, JstreetLdap.FIRSTNAME, ""));
        this.firstname.addKeyListener(this);
        this.add(this.firstname);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 1;
        con.gridwidth = 2;
        grid.setConstraints(this.firstname, con);
        this.lastname = new TextField(this.profile.ReadString(this.server, JstreetLdap.LASTNAME, ""));
        this.lastname.addKeyListener(this);
        this.add(this.lastname);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 1;
        grid.setConstraints(this.lastname, con);
        this.unit = new TextField(this.profile.ReadString(this.server, JstreetLdap.UNIT, ""));
        this.unit.addKeyListener(this);
        this.add(this.unit);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 3;
        con.gridwidth = 2;
        grid.setConstraints(this.unit, con);
        this.organization = new TextField(this.profile.ReadString(this.server, JstreetLdap.ORG, ""));
        this.organization.addKeyListener(this);
        this.add(this.organization);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 3;
        grid.setConstraints(this.organization, con);
        this.country = new TextField(this.profile.ReadString(this.server, JstreetLdap.COUNTRY, "US"));
        this.country.addKeyListener(this);
        this.add(this.country);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 5;
        con.gridwidth = 2;
        grid.setConstraints(this.country, con);
        this.maxsearch = new TextField(this.profile.ReadString(this.server, JstreetLdap.MAXSEARCH, "100"));
        this.maxsearch.addKeyListener(this);
        this.add(this.maxsearch);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 5;
        grid.setConstraints(this.maxsearch, con);
        JCSplitterWindow split = new JCSplitterWindow(0);
        split.setMinChildSize(1);
        this.detPanel = this.setupDetailPanel();
        this.detPanel.setPreferredSize(50, 0);
        this.list = new JList();
        this.list.addItemListener(this);
        this.list.setPreferredSize(300, 0);
        split.add(this.list);
        split.add(this.detPanel);
        BevelPanel panel = new BevelPanel();
        panel.setBevelInner(2);
        panel.setBevelOuter(2);
        panel.setLayout(new BorderLayout());
        panel.add("Center", split);
        this.add(panel);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 7;
        con.gridwidth = 9;
        grid.setConstraints(panel, con);
        this.text = new Label("");
        this.add(this.text);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 9;
        con.gridwidth = 7;
        grid.setConstraints(this.text, con);
        Panel buttonPanel = this.setupButtonPanel();
        this.add(buttonPanel);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 11;
        con.gridwidth = 9;
        grid.setConstraints(buttonPanel, con);
        this.setLayout(grid);
        this.pack();
        jstreet.centerDialog(this, null);
    }

    private JBevelPanel setupDetailPanel() {
        JBevelPanel panel = new JBevelPanel();
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{200, 15};
        int[] columnWidths = new int[]{60, 20, 40};
        double[] rowWeights = new double[]{10.0, 0.0};
        double[] columnWeights = new double[]{0.0, 10.0, 0.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.detailarea = new JTextArea("");
        this.detailarea.setEditable(false);
        panel.add(this.detailarea);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 3;
        grid.setConstraints(this.detailarea, con);
        this.selallButton = new JButton("Select All");
        this.selallButton.addActionListener(this);
        this.selallButton.addKeyListener(this);
        this.selallButton.setFont(new Font("Dialog", 0, 10));
        panel.add(this.selallButton);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 1;
        grid.setConstraints(this.selallButton, con);
        this.copyButton = new JButton("Copy");
        this.copyButton.addActionListener(this);
        this.copyButton.addKeyListener(this);
        this.copyButton.setFont(new Font("Dialog", 0, 10));
        panel.add(this.copyButton);
        jstreet.reset(con);
        con.gridx = 2;
        con.gridy = 1;
        grid.setConstraints(this.copyButton, con);
        panel.setLayout(grid);
        return panel;
    }

    private Panel setupButtonPanel() {
        Panel panel = new Panel();
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{20, 5, 20};
        int[] columnWidths = new int[]{5, 60, 5, 60, 30, 60, 5, 60, 20, 40, 5, 40, 5, 40, 5};
        double[] rowWeights = new double[]{10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.okButton = new Button("Search");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        panel.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 0;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Close");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        panel.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 0;
        grid.setConstraints(this.cancelButton, con);
        this.toButton = new Button("To:");
        this.toButton.addActionListener(this);
        this.toButton.addKeyListener(this);
        this.toButton.setEnabled(false);
        panel.add(this.toButton);
        jstreet.reset(con);
        con.gridx = 9;
        con.gridy = 0;
        grid.setConstraints(this.toButton, con);
        this.ccButton = new Button("Cc:");
        this.ccButton.addActionListener(this);
        this.ccButton.addKeyListener(this);
        this.ccButton.setEnabled(false);
        panel.add(this.ccButton);
        jstreet.reset(con);
        con.gridx = 11;
        con.gridy = 0;
        grid.setConstraints(this.ccButton, con);
        this.bccButton = new Button("Bcc:");
        this.bccButton.addActionListener(this);
        this.bccButton.addKeyListener(this);
        this.bccButton.setEnabled(false);
        panel.add(this.bccButton);
        jstreet.reset(con);
        con.gridx = 13;
        con.gridy = 0;
        grid.setConstraints(this.bccButton, con);
        this.clearButton = new Button("Clear");
        this.clearButton.addActionListener(this);
        this.clearButton.addKeyListener(this);
        panel.add(this.clearButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 2;
        grid.setConstraints(this.clearButton, con);
        this.addButton = new Button("Add to Address Book");
        this.addButton.addActionListener(this);
        this.addButton.addKeyListener(this);
        this.addButton.setEnabled(false);
        panel.add(this.addButton);
        jstreet.reset(con);
        con.gridx = 9;
        con.gridy = 2;
        con.gridwidth = 5;
        grid.setConstraints(this.addButton, con);
        panel.setLayout(grid);
        return panel;
    }

    private void addedFeedback(Object val) {
        if (val instanceof Button) {
            Button button = (Button)val;
            String text = button.getLabel();
            Color color = button.getForeground();
            button.setForeground(Color.red);
            button.setLabel("Added");
            AutoRefresh.Sleep(400L);
            button.setLabel(text);
            button.setForeground(color);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.list) {
            this.loadDetail((LDAPEntry)this.results.elementAt(this.list.getSelectedIndex()));
        }
    }

    public void loadDetail(LDAPEntry entry) {
        StringBuffer sb = new StringBuffer(1024);
        LDAPAttributeSet findAttrs = entry.getAttributeSet();
        Enumeration enumAttrs = findAttrs.getAttributes();
        while (enumAttrs.hasMoreElements()) {
            LDAPAttribute anAttr = (LDAPAttribute)enumAttrs.nextElement();
            String attrName = anAttr.getName();
            sb.append(String.valueOf(attrName).concat(String.valueOf("\n")));
            Enumeration enumVals = anAttr.getStringValues();
            while (enumVals.hasMoreElements()) {
                String aVal = (String)enumVals.nextElement();
                sb.append(String.valueOf(String.valueOf("\t").concat(String.valueOf(aVal))).concat(String.valueOf("\n")));
            }
        }
        this.detailarea.setText(sb.toString());
        this.detailarea.setCaretPosition(0);
    }

    public void actionPerformed(ActionEvent e) {
        String user;
        if (e.getSource() == this.okButton) {
            if (this.firstname.getText().trim().length() == 0 && this.lastname.getText().trim().length() == 0 && this.unit.getText().trim().length() == 0 && this.organization.getText().trim().length() == 0) {
                MsgBox msg = new MsgBox(this.frame, "Please enter your search criteria.");
                this.firstname.requestFocus();
            } else {
                this.profile.WriteString(this.server, JstreetLdap.FIRSTNAME, this.firstname.getText().trim());
                this.profile.WriteString(this.server, JstreetLdap.LASTNAME, this.lastname.getText().trim());
                this.profile.WriteString(this.server, JstreetLdap.UNIT, this.unit.getText().trim());
                this.profile.WriteString(this.server, JstreetLdap.ORG, this.organization.getText().trim());
                this.profile.WriteString(this.server, JstreetLdap.COUNTRY, this.country.getText().trim(), true);
                int max = 100;
                try {
                    max = Integer.valueOf(this.maxsearch.getText().trim());
                }
                catch (NumberFormatException ex) {
                    max = 100;
                }
                if (max < 1) {
                    max = 100;
                }
                this.profile.WriteString(this.server, JstreetLdap.MAXSEARCH, String.valueOf("").concat(String.valueOf(max)));
                this.text.setText("Searching directory...");
                this.cancelButton.setLabel("Cancel");
                this.enableDialog(this, false);
                this.thread = new LDAPSearchThread(this);
                this.thread.start();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.closeWindow();
        } else if (e.getSource() == this.toButton || e.getSource() == this.ccButton || e.getSource() == this.bccButton) {
            int[] sel = this.list.getSelectedIndexes();
            if (sel != null && sel.length > 0) {
                this.processAddrButton(e);
            }
        } else if (e.getSource() == this.clearButton) {
            ((TextComponent)this.firstname).setText("");
            ((TextComponent)this.lastname).setText("");
            ((TextComponent)this.unit).setText("");
            ((TextComponent)this.organization).setText("");
            ((TextComponent)this.country).setText("");
        } else if (e.getSource() == this.selallButton) {
            this.detailarea.selectAll();
        } else if (e.getSource() == this.copyButton) {
            this.copy(this.detailarea);
        } else if (e.getSource() == this.addButton && (user = this.list.getSelectedItem()) != null && user.length() > 0) {
            SelectAddressBook sel;
            if (this.Jstreet.addrbook == null && (sel = new SelectAddressBook(this.frame, this.Jstreet)).getName() != null) {
                this.Jstreet.addrbook = new AddressBook(this.frame, this.Jstreet, new File(sel.getName()));
                this.Jstreet.addrbook.read();
            }
            if (this.Jstreet.addrbook != null) {
                JstreetLdapAddAddress jstreetLdapAddAddress = new JstreetLdapAddAddress(this.frame, this.Jstreet, user, this.organization.getText().trim());
            }
        }
    }

    private void processAddrButton(ActionEvent e) {
        String prefix = "";
        if (e.getSource() == this.toButton) {
            prefix = new String("To: ");
        } else if (e.getSource() == this.ccButton) {
            prefix = new String("cc: ");
        } else if (e.getSource() == this.bccButton) {
            prefix = new String("bcc: ");
        }
        String addrlist = null;
        String tadr = null;
        int[] sel = this.list.getSelectedIndexes();
        for (int i = 0; i < sel.length; ++i) {
            tadr = new String(String.valueOf(prefix).concat(String.valueOf(this.list.getItem(sel[i]))));
            addrlist = addrlist == null ? new String(tadr) : new String(String.valueOf(String.valueOf(addrlist).concat(String.valueOf(","))).concat(String.valueOf(tadr)));
        }
        if (this.toField != null) {
            String adr = this.toField.getText();
            adr = adr.length() > 0 ? new String(String.valueOf(String.valueOf(adr).concat(String.valueOf(","))).concat(String.valueOf(addrlist))) : new String(addrlist);
            ((TextComponent)this.toField).setText(adr);
            this.addedFeedback(e.getSource());
        }
    }

    public void enableDialog(Container cont, boolean val) {
        Component ccomp = null;
        for (int i = 0; i < cont.getComponentCount(); ++i) {
            ccomp = cont.getComponent(i);
            if (ccomp instanceof Container) {
                this.enableDialog((Container)ccomp, val);
            }
            if (ccomp == this.cancelButton || ccomp == this.text || ccomp instanceof Panel) continue;
            ccomp.setEnabled(val);
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            if (!this.closeWindow()) {
                this.closeWindow();
            }
        } else {
            super.processWindowEvent(evt);
        }
    }

    public boolean closeWindow() {
        boolean ret_code = false;
        if (this.thread != null && this.search != null) {
            this.text.setText("Abandoning search...");
            this.abandonSearch();
            this.cancelButton.setLabel("Close");
        } else {
            try {
                this.dispose();
                ret_code = true;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return ret_code;
    }

    private void abandonSearch() {
        AbandonThread abandon = new AbandonThread(this);
        abandon.start();
    }

    public void performSearch() {
        int cnt = 0;
        int max = 100;
        String text = "";
        String filter = "";
        String base = "";
        String fn = this.firstname.getText().trim();
        String ln = this.lastname.getText().trim();
        String unit = this.unit.getText().trim();
        String org = this.organization.getText().trim();
        String ctry = this.country.getText().trim();
        try {
            max = Integer.valueOf(this.maxsearch.getText().trim());
        }
        catch (NumberFormatException e) {
            max = 100;
        }
        if (max < 1) {
            max = 100;
        }
        if (fn.length() > 0 && ln.length() > 0) {
            filter = new String(String.valueOf(String.valueOf(String.valueOf("cn=").concat(String.valueOf(fn))).concat(String.valueOf(" "))).concat(String.valueOf(ln)));
        } else if (fn.length() == 0 && ln.length() > 0) {
            filter = new String(String.valueOf("sn=").concat(String.valueOf(ln)));
        } else if (fn.length() > 0) {
            filter = new String(String.valueOf("cn=").concat(String.valueOf(fn)));
        }
        if (unit.length() > 0) {
            base = new String(String.valueOf("ou=").concat(String.valueOf(unit)));
        }
        if (org.length() > 0) {
            if (base.length() > 0) {
                base = base.concat(",");
            }
            base = new String(String.valueOf("o=").concat(String.valueOf(org)));
        }
        if (ctry.length() > 0) {
            if (base.length() > 0) {
                base = base.concat(",");
            }
            base = new String(String.valueOf(String.valueOf(base).concat(String.valueOf("c="))).concat(String.valueOf(ctry)));
        }
        this.list.setVisible(false);
        this.detPanel.setVisible(false);
        this.detailarea.setText("");
        this.list.removeAll();
        this.results.removeAllElements();
        this.search = null;
        LDAPSearchConstraints cons = this.ldap.getSearchConstraints();
        cons.setBatchSize(10);
        cons.setMaxResults(max);
        cons.setReferrals(true);
        try {
            this.search = this.ldap.search(base, 2, filter, null, false, cons);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 53 && filter.length() > 0 && filter.charAt(0) == 's') {
                filter = new String(String.valueOf("cn=* ").concat(String.valueOf(ln)));
                try {
                    this.search = this.ldap.search(base, 2, filter, null, false, cons);
                }
                catch (LDAPException ex) {
                    MsgBox msgBox = new MsgBox(this.frame, String.valueOf(String.valueOf(ex.toString()).concat(String.valueOf(" "))).concat(String.valueOf(this.errorText(ex.getLDAPResultCode()))));
                }
            }
            MsgBox ex = new MsgBox(this.frame, String.valueOf(String.valueOf(e.toString()).concat(String.valueOf(" "))).concat(String.valueOf(this.errorText(e.getLDAPResultCode()))));
        }
        try {
            while (this.search != null && this.search.hasMoreElements()) {
                LDAPEntry findEntry = null;
                if (this.search != null) {
                    findEntry = (LDAPEntry)this.search.nextElement();
                }
                if (findEntry == null) continue;
                if (this.mailkey == null) {
                    this.mailkey = this.findMailKey(findEntry);
                }
                this.results.addElement(findEntry);
                LDAPAttribute name = findEntry.getAttribute("cn");
                LDAPAttribute email = findEntry.getAttribute(DEF_MAILKEY);
                String sname = this.getValue(name);
                String semail = this.getValue(email);
                String addr = "";
                if (semail.trim().length() == 0 && this.mailkey.length() > 0) {
                    semail = this.getValue(findEntry.getAttribute(this.mailkey));
                }
                if (sname.length() > 0 && semail.length() > 0) {
                    addr = new String(String.valueOf(String.valueOf(String.valueOf(sname).concat(String.valueOf(" <"))).concat(String.valueOf(semail))).concat(String.valueOf(">")));
                } else if (sname.length() > 0) {
                    addr = new String(sname);
                } else if (semail.length() > 0) {
                    addr = new String(semail);
                }
                if (addr.length() <= 0) continue;
                this.list.add(addr);
                if (++cnt == 1) {
                    this.text.setText("Searching...[1] item found.");
                    continue;
                }
                this.text.setText(String.valueOf(String.valueOf("Searching...[").concat(String.valueOf(cnt))).concat(String.valueOf("] items found.")));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.search = null;
        cnt = this.list.getItemCount();
        if (cnt == 1) {
            text = new String("Search completed.  [1] item found.");
        } else {
            text = new String(String.valueOf(String.valueOf("Search completed.  [").concat(String.valueOf(cnt))).concat(String.valueOf("] items found.")));
            if (cnt == 100) {
                text = new String(text.concat("  Maximum [100] reached."));
            }
        }
        this.text.setText(text);
        this.enableDialog(this, true);
        this.list.setVisible(true);
        this.detPanel.setVisible(true);
        this.cancelButton.setLabel("Close");
    }

    public String errorText(int code) {
        String text = "";
        switch (code) {
            case 36: {
                text = new String("An error occurred when dereferencing an alias.");
                break;
            }
            case 33: {
                text = new String("An problem occurred with an alias.");
                break;
            }
            case 20: {
                text = new String("The value that you are adding to an attribute already exists in the attribute.");
                break;
            }
            case 7: {
                text = new String("The specified authentication method is not supported by the LDAP server that you are connecting to.");
                break;
            }
            case 51: {
                text = new String("The DSA is busy.");
                break;
            }
            case 5: {
                text = new String("Value returned by an LDAP compare operation if the specified attribute and value is not found in the entry (no matching value found).");
                break;
            }
            case 6: {
                text = new String("Value returned by an LDAP compare operation if the specified attribute and value is found in the entry (matching value found).");
                break;
            }
            case 91: {
                text = new String("Your LDAP client failed to connect to the LDAP server.");
                break;
            }
            case 19: {
                text = new String("An internal error occurred in the LDAP server.");
                break;
            }
            case 68: {
                text = new String("The specified entry already exists.");
                break;
            }
            case 48: {
                text = new String("The authentication presented to the server is inappropriate.");
                break;
            }
            case 18: {
                text = new String("An inappropriate type of matching was used.");
                break;
            }
            case 50: {
                text = new String("The client is authenticated as a user who does not have the access privileges to perform this operation.");
                break;
            }
            case 21: {
                text = new String("The request contains invalid syntax.");
                break;
            }
            case 49: {
                text = new String("The credentials presented to the server for authentication are not valid.");
                break;
            }
            case 34: {
                text = new String("The specified distinguished name (DN) uses invalid syntax.");
                break;
            }
            case 35: {
                text = new String("The specified entry is a \"leaf\" entry (it has no entries beneath it in the directory tree).");
                break;
            }
            case 9: {
                text = new String("The LDAP server is referring your client to another LDAP server.");
                break;
            }
            case 54: {
                text = new String("A loop has been detected.");
                break;
            }
            case 64: {
                text = new String("A naming violation has occurred.");
                break;
            }
            case 16: {
                text = new String("The specified attribute could not be found.");
                break;
            }
            case 32: {
                text = new String("The entry specified in the request does not exist.");
                break;
            }
            case 66: {
                text = new String("The requested operation can only be performed on an entry that has no entries beneath it in the directory tree (in other words, a \"leaf\" entry).");
                break;
            }
            case 67: {
                text = new String("The specified operation cannot be performed on a relative distinguished name (RDN).");
                break;
            }
            case 69: {
                text = new String("You cannot modify the specified object class.");
                break;
            }
            case 65: {
                text = new String("The requested operation will add or change data so that the data no longer complies with the schema.");
                break;
            }
            case 1: {
                text = new String("An internal error occurred in the LDAP server.");
                break;
            }
            case 80: {
                text = new String("Other types of errors.");
                break;
            }
            case 89: {
                text = new String("When calling a constructor or method from your client, one or more parameters were incorrectly specified.");
                break;
            }
            case 2: {
                text = new String("A LDAP server could not correctly interpret the request sent by your client because the request does not strictly comply with the LDAP protocol.");
                break;
            }
            case 81: {
                text = new String("The LDAP server cannot be contacted.");
                break;
            }
            case 4: {
                text = new String("The search found more than the maximum number of results.");
                break;
            }
            case 8: {
                text = new String("A stronger authentication method (more than LDAP_AUTH_SIMPLE) is required by the LDAP server that you are connecting to.");
                break;
            }
            case 0: {
                text = new String("The operation completed successfully.");
                break;
            }
            case 3: {
                text = new String("The search operation could not be completed within the maximum time limit.");
                break;
            }
            case 52: {
                text = new String("The DSA is unavailable.");
                break;
            }
            case 17: {
                text = new String("The specified attribute is not defined.");
                break;
            }
            case 53: {
                text = new String("The DSA is unable to perform the specified operation.");
                break;
            }
            default: {
                text = new String("Unknow LDAP exception code.");
            }
        }
        return text;
    }

    private String getValue(LDAPAttribute attr) {
        String text = "";
        if (attr != null) {
            Enumeration enumeration = attr.getStringValues();
            if (enumeration.hasMoreElements()) {
                text = new String(String.valueOf(String.valueOf(text).concat(String.valueOf((String)enumeration.nextElement()))).concat(String.valueOf(" ")));
            }
            text = new String(text.trim());
        }
        return text;
    }

    public void lostOwnership(Clipboard board, Transferable trans) {
    }

    private boolean copy(JTextArea text) {
        boolean ret_code = false;
        String str = text.getSelectedText();
        if (str != null) {
            StringSelection s = new StringSelection(str);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s, s);
            if (str.length() > 0) {
                ret_code = true;
            }
        }
        return ret_code;
    }

    private String findMailKey(LDAPEntry entry) {
        JstreetLdapMailkey prompt;
        String mailkey = new String(DEF_MAILKEY);
        LDAPAttributeSet findAttrs = entry.getAttributeSet();
        LDAPAttribute attr = null;
        Enumeration enumAttrs = findAttrs.getAttributes();
        boolean found = false;
        while (!found && enumAttrs.hasMoreElements()) {
            attr = (LDAPAttribute)enumAttrs.nextElement();
            if (!attr.getName().equals(mailkey)) continue;
            found = true;
        }
        if (!found && (mailkey = this.profile.ReadString(this.server, SAVE_MAILKEY, "")).trim().length() > 0) {
            enumAttrs = findAttrs.getAttributes();
            while (!found && enumAttrs.hasMoreElements()) {
                attr = (LDAPAttribute)enumAttrs.nextElement();
                if (!attr.getName().equals(mailkey)) continue;
                found = true;
            }
        }
        if (!found && (prompt = new JstreetLdapMailkey(this.frame, entry)).getReturn()) {
            mailkey = prompt.getMailkey();
            this.profile.WriteString(this.server, SAVE_MAILKEY, mailkey, true);
        }
        return mailkey;
    }
}

