/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.AutoRefresh;
import innoval.mailer.ColorCodeList;
import innoval.mailer.CopyThread;
import innoval.mailer.FolderIndex;
import innoval.mailer.FolderIndexItem;
import innoval.mailer.FolderItem;
import innoval.mailer.ListMsg;
import innoval.mailer.NoteListLoad;
import innoval.mailer.NoteSelectThread;
import innoval.mailer.NotesLabel;
import innoval.mailer.PopFileProcedure;
import innoval.mailer.SettingsGeneral;
import innoval.mailer.SortAddress;
import innoval.mailer.SortBytes;
import innoval.mailer.SortData;
import innoval.mailer.SortDates;
import innoval.mailer.SortImage;
import innoval.mailer.SortSubject;
import innoval.mailer.SortText;
import innoval.mailer.VirtualFolderList;
import innoval.mailer.jstreet;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.util.Vector;
import jclass.bwt.JCMultiColumnList;
import jclass.util.JCSortInterface;
import jclass.util.JCString;
import jclass.util.JCUtilConverter;
import jclass.util.JCVector;

public class NoteList
extends JCMultiColumnList
implements KeyListener,
MouseListener {
    static final int NEW = 0;
    static final int EXISTS = 1;
    static final int DELETE = 2;
    static final int COPYMESSAGE = 0;
    static final int MOVEMESSAGE = 1;
    static final int GIFCOL = 0;
    static final int COLORCODECOL = 1;
    static final int SUBJCOL = 2;
    static final int FROMCOL = 3;
    static final int TOCOL = 4;
    static final int DATECOL = 5;
    static final int DATERECCOl = 6;
    static final int BYTECOL = 7;
    static final int POPCOL = 8;
    static final int FOLDERCOL = 9;
    private int currentMessage = -1;
    private String[] labels = new String[]{" ", " ", "Subject", "From", "To", "Date", "Date Received", "Size", "Pop File Name", "Folder Name"};
    public FolderItem folderitem;
    private BufferedReader in;
    public jstreet parent;
    public VirtualFolderList virtfolder;
    private ListMsg first;
    public NoteListLoad notelistload;
    private NoteSelectThread selThread;
    public NotesLabel notesLabel;
    public PopupMenu messagePopup = null;
    public Label textLabel;
    public boolean doorOpened = false;
    public boolean stopLoading = false;
    public boolean vfolder = false;
    public boolean spacebar = false;

    NoteList(jstreet frame) {
        this.parent = frame;
        this.folderitem = null;
        this.notesLabel = this.parent.notes;
        this.textLabel = this.parent.text;
        this.messagePopup = this.parent.messagePopup;
        this.setBackground(SystemColor.control);
        this.setColumnWidths(jstreet.MSGCOLWIDTHS);
        this.setColumnButtons(this.labels);
        this.setColumnAlignment(7, 5);
        this.setSpacing(2);
        this.setNumColumns(9);
        this.setAllowMultipleSelections(true);
        this.setAutoSelect(true);
        this.getViewport().addMouseListener(this);
        this.setRowHeight(20);
        this.selThread = new NoteSelectThread(this);
        this.selThread.start();
    }

    public void Close() {
        if (this.selThread != null) {
            this.selThread.setStop(true);
            this.selThread.awake();
            this.selThread = null;
        }
    }

    NoteList(VirtualFolderList frame) {
        this.vfolder = true;
        this.parent = frame.Jstreet;
        this.virtfolder = frame;
        this.notesLabel = frame.notes;
        this.textLabel = frame.text;
        this.messagePopup = frame.messagePopup;
        this.folderitem = null;
        this.setBackground(SystemColor.control);
        this.setColumnWidths(jstreet.VFLDRCOLWIDTHS);
        this.setColumnButtons(this.labels);
        this.setColumnAlignment(7, 5);
        this.setSpacing(2);
        this.setNumColumns(10);
        this.setAllowMultipleSelections(true);
        this.setAutoSelect(true);
        this.getViewport().addMouseListener(this);
        this.setRowHeight(20);
        this.selThread = new NoteSelectThread(this);
        this.selThread.start();
    }

    public void setColumnWidths(String key) {
        String text = this.parent.getProfile().ReadString(jstreet.DEFAULT, key, "");
        if (text.length() == 0) {
            text = key.equals(jstreet.MSGCOLWIDTHS) ? new String("30,30,170,170,170,108,108,60,108") : new String("30,30,170,170,170,108,108,60,108,108");
        }
        super.setColumnWidths(JCUtilConverter.toIntList(text, ','));
    }

    public void saveColumnWidths(String key) {
        int[] col = this.getColumnWidths();
        String text = new String("");
        for (int i = 0; i < col.length; ++i) {
            text = i == 0 ? new String(String.valueOf(text).concat(String.valueOf(col[i]))) : new String(String.valueOf(String.valueOf(text).concat(String.valueOf(","))).concat(String.valueOf(col[i])));
        }
        this.parent.getProfile().WriteString(jstreet.DEFAULT, key, text, true);
    }

    public void setMessagePopup(PopupMenu messagePopup) {
        this.messagePopup = messagePopup;
    }

    public void StopLoading() {
        this.stopLoading = true;
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            this.spacebar = true;
        }
        super.keyPressed(e);
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
            this.selThread.awake();
        } else if (e.getKeyCode() == 32) {
            this.spacebar = false;
        }
        super.keyReleased(e);
    }

    public void keyTyped(KeyEvent e) {
        super.keyTyped(e);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int i;
        if (e.getModifiers() == 4 && (i = this.calcItem(e.getY())) < this.countItems()) {
            if (!this.isSelected(i)) {
                this.deSelectAll();
                this.select(i);
                this.displayMessage();
            }
            if (this.messagePopup != null) {
                this.messagePopup.show(this, e.getX(), e.getY());
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        int[] sel;
        if (e.getModifiers() == 16 && (sel = this.getSelectedIndexes()) != null) {
            if (this.vfolder) {
                if (!this.spacebar && sel.length == 1) {
                    if (sel[0] != this.currentMessage) {
                        this.displayMessage();
                    }
                } else {
                    this.virtfolder.clearMessage();
                    this.currentMessage = -1;
                }
            } else if (!this.spacebar && sel.length == 1) {
                if (sel[0] != this.currentMessage) {
                    this.displayMessage();
                }
            } else {
                this.parent.clearMessage();
                this.currentMessage = -1;
            }
        }
    }

    public void deSelectAll() {
        int[] index = this.getSelectedIndexes();
        if (index != null) {
            for (int i = 0; i < index.length; ++i) {
                this.deselect(index[i]);
            }
        }
    }

    public void setDirty() {
        this.folderitem.indexfile.setDirty(true);
    }

    public int calcItem(int y) {
        int height;
        int item = this.getTopRow();
        int base = height = this.getRowHeight();
        while (y > base) {
            base += height;
            ++item;
        }
        return item;
    }

    public boolean nextMessage() {
        boolean ret_code = false;
        int val = this.getSelectedIndex();
        if (this.countItems() > 0) {
            if (val >= 0 && val < this.countItems() - 1) {
                this.deSelectAll();
                this.select(val + 1);
                this.makeVisible(val + 1);
                ret_code = true;
            } else if (val < 0) {
                this.select(0);
                this.makeVisible(0);
                ret_code = true;
            } else {
                this.parent.getToolkit().beep();
            }
            if (ret_code) {
                this.displayMessage();
            }
        }
        return ret_code;
    }

    public boolean prevMessage() {
        boolean ret_code = false;
        int val = this.getSelectedIndex();
        if (this.countItems() > 0) {
            if (val > 0) {
                this.deSelectAll();
                this.select(val - 1);
                this.makeVisible(val - 1);
                ret_code = true;
            } else if (val < 0) {
                val = this.countItems() - 1;
                this.select(val);
                this.makeVisible(val);
                ret_code = true;
            } else {
                this.parent.getToolkit().beep();
            }
            if (ret_code) {
                this.displayMessage();
            }
        }
        return ret_code;
    }

    public boolean nextUnreadMessage() {
        boolean ret_code = false;
        int val = this.getSelectedIndex();
        if (this.countItems() > 0) {
            if (val < 0) {
                val = -1;
            }
            if ((val = val >= this.countItems() - 1 ? -1 : this.nextUnread(val)) >= 0) {
                this.deSelectAll();
                this.select(val);
                this.makeVisible(val);
                ret_code = true;
            } else {
                this.parent.getToolkit().beep();
            }
            if (ret_code) {
                this.displayMessage();
            }
        }
        return ret_code;
    }

    public int nextUnread(int start) {
        int val = -1;
        Vector element = null;
        String text = null;
        for (int i = start + 1; i < this.countItems(); ++i) {
            element = (Vector)this.getItem(i);
            text = ((JCString)element.elementAt(0)).toString2();
            if (text.indexOf(jstreet.CLOSEDENVELOPEGIF) < 0) continue;
            val = i;
            break;
        }
        return val;
    }

    public boolean prevUnreadMessage() {
        boolean ret_code = false;
        int val = this.getSelectedIndex();
        if (this.countItems() > 0) {
            if (val < 0) {
                val = this.countItems();
            }
            if ((val = val > 0 ? this.prevUnread(val) : -1) >= 0) {
                this.deSelectAll();
                this.select(val);
                this.makeVisible(val);
                ret_code = true;
            } else {
                this.parent.getToolkit().beep();
            }
            if (ret_code) {
                this.displayMessage();
            }
        }
        return ret_code;
    }

    public int prevUnread(int start) {
        int val = -1;
        Vector element = null;
        String text = null;
        for (int i = start - 1; i >= 0; --i) {
            element = (Vector)this.getItem(i);
            text = ((JCString)element.elementAt(0)).toString2();
            if (text.indexOf(jstreet.CLOSEDENVELOPEGIF) < 0) continue;
            val = i;
            break;
        }
        return val;
    }

    public void displayMessage() {
        if (this.getSelectedIndex() != this.currentMessage) {
            if (this.vfolder) {
                this.virtfolder.displayMessage();
            } else {
                this.parent.displayMessage();
            }
            this.currentMessage = this.getSelectedIndex();
        }
    }

    public void clearMessage() {
        if (this.vfolder) {
            this.virtfolder.clearMessage();
        } else {
            this.parent.clearMessage();
        }
        this.currentMessage = -1;
    }

    public void clear() {
        super.clear();
        this.notesLabel.setText("");
    }

    public void sortByColumn(int column, JCSortInterface sort_if, int direction) {
        Label text = null;
        text = this.virtfolder == null ? this.parent.text : this.virtfolder.text;
        text.setText("Sorting messages...");
        Object[] obj = this.getSelectedObjects();
        switch (column) {
            case 0: 
            case 1: {
                sort_if = new SortImage();
                break;
            }
            case 2: {
                sort_if = new SortSubject();
                break;
            }
            case 3: 
            case 4: {
                sort_if = new SortAddress();
                break;
            }
            case 5: 
            case 6: {
                sort_if = new SortDates();
                break;
            }
            case 7: {
                sort_if = new SortBytes();
                break;
            }
            case 8: 
            case 9: {
                sort_if = new SortText();
            }
        }
        JCVector vector = this.getItems();
        int sort_type = 0;
        switch (column) {
            case 2: {
                sort_type = 2;
                break;
            }
            case 3: 
            case 4: {
                sort_type = 1;
                break;
            }
            case 5: 
            case 6: {
                sort_type = 4;
                break;
            }
            case 7: {
                sort_type = 3;
            }
        }
        SortData sort = new SortData(vector, column, sort_type);
        if (direction == 1) {
            NoteList.reverseVector(vector);
        }
        this.setItems(vector);
        if (obj != null && obj.length > 0) {
            int min = vector.size() - 1;
            int spot = 0;
            for (int i = 0; i < obj.length; ++i) {
                spot = vector.indexOf(obj[i]);
                if (spot < min) {
                    min = spot;
                }
                this.select(spot);
            }
            this.makeVisible(min);
        }
        text.setText("Sorting completed.");
    }

    public static void reverseVector(JCVector vector) {
        Object obj = null;
        int j = vector.size() - 1;
        for (int i = 0; i < vector.size() && i < j; --j, ++i) {
            obj = vector.elementAt(i);
            vector.setElementAt(vector.elementAt(j), i);
            vector.setElementAt(obj, j);
        }
    }

    public Dimension getMinimumSize() {
        Dimension dim = new Dimension(100, 100);
        return dim;
    }

    public String getDir() {
        return this.folderitem.getPath().getAbsolutePath();
    }

    public static void printMem() {
    }

    public void stopLoading() {
        if (this.notelistload != null) {
            this.parent.text.setText("Halting message load...");
            this.notelistload.stopLoading();
        }
    }

    public void load(FolderItem folderitem) {
        if (this.notelistload != null) {
            this.notelistload.stopLoading();
        }
        NoteList.printMem();
        if (this.folderitem != null) {
            this.folderitem.indexfile.saveIndex();
            this.folderitem.setCurrent(false);
            this.folderitem.setActive(false);
        }
        this.folderitem = folderitem;
        this.folderitem.setActive(true);
        if (!this.stopLoading) {
            this.notelistload = new NoteListLoad(this);
            this.notelistload.start();
        }
    }

    public void reload() {
        if (this.notelistload != null) {
            this.notelistload.stopLoading();
        }
        if (this.folderitem != null) {
            this.folderitem.indexfile.saveIndex();
            if (!this.stopLoading) {
                this.notelistload = new NoteListLoad(this);
                this.notelistload.start();
            }
        }
    }

    public int selected() {
        int[] sel = this.getSelectedIndexes();
        int val = 0;
        if (sel != null) {
            val = sel.length;
        }
        return val;
    }

    public synchronized void loadNotes(NoteListLoad thread) {
        this.parent.sayLine("Loading messages...");
        this.openDoor();
        this.parent.sayLine("Removing existing messages...");
        if (this.countItems() > 0) {
            AutoRefresh.Sleep(300L);
            this.clear();
            AutoRefresh.Sleep(100L);
        }
        this.notesLabel.setText("");
        System.gc();
        int itemCount = 0;
        int i = 0;
        if (!thread.getStop()) {
            itemCount = this.vfolder ? this.folderitem.indexfile.vPopName.size() : this.folderitem.indexfile.loadIndex();
        }
        this.parent.sayLine("Building array of messages...");
        String[] array = new String[itemCount];
        while (!thread.getStop() && !this.stopLoading && i < itemCount) {
            array[i] = new String(String.valueOf(String.valueOf(String.valueOf("[img=").concat(String.valueOf(this.determineGif(i)))).concat(String.valueOf("],"))).concat(String.valueOf(this.folderitem.indexfile.getListString(i, this.vfolder))));
            ++i;
        }
        this.parent.sayLine("Adding items to control...");
        if (!thread.getStop() && !this.stopLoading) {
            this.setItems(array);
            this.updateCounter();
        }
        this.currentMessage = -1;
        this.closeDoor();
        this.parent.sayLine("Notifing J street that messages are loaded...");
        this.parent.notelistLoadCompleted();
        this.parent.sayLine("Message load completed.");
    }

    public String determineGif(int num) {
        String gif = jstreet.CLOSEDENVELOPEGIF;
        if (this.folderitem.indexfile.isOpened(num)) {
            gif = jstreet.OPENEDENVELOPEGIF;
        }
        return gif;
    }

    public void updateCounter() {
        this.notesLabel.setText(Integer.toString(this.countItems()));
    }

    private boolean loadListItem(File popfile) {
        boolean ret_code = false;
        FolderIndexItem item = null;
        Vector<JCString> element = null;
        if (popfile.exists()) {
            PopFileProcedure pop = new PopFileProcedure();
            if (this.folderitem != null && this.folderitem.indexfile != null && pop.readHeaders(popfile)) {
                item = this.folderitem.indexfile.addToIndex(pop);
                element = new Vector<JCString>();
                this.setBatched(true);
                element.addElement(JCString.parse(this, String.valueOf(String.valueOf("[img=").concat(String.valueOf(jstreet.CLOSEDENVELOPEGIF))).concat(String.valueOf("]"))));
                item.addListItem(this, element);
                this.addItem(element);
                this.setBatched(false);
                ret_code = true;
            }
        }
        return ret_code;
    }

    private boolean loadListItem(FolderIndexItem item) {
        boolean ret_code = false;
        Vector<JCString> element = null;
        element = new Vector<JCString>();
        this.setBatched(true);
        this.folderitem.indexfile.addToIndex(item);
        if (!item.opened) {
            element.addElement(JCString.parse(this, String.valueOf(String.valueOf("[img=").concat(String.valueOf(jstreet.CLOSEDENVELOPEGIF))).concat(String.valueOf("]"))));
        } else {
            element.addElement(JCString.parse(this, String.valueOf(String.valueOf("[img=").concat(String.valueOf(jstreet.OPENEDENVELOPEGIF))).concat(String.valueOf("]"))));
        }
        item.addListItem(this, element);
        this.addItem(element);
        this.setBatched(false);
        ret_code = true;
        return ret_code;
    }

    public File getCurrent() {
        File file = null;
        this.openDoor();
        Vector element = (Vector)this.getSelectedItem();
        if (element != null) {
            if (this.vfolder) {
                FolderIndexItem item = this.getVfolderItem(element);
                file = new File(item.popdir, item.getPopName());
            } else {
                file = new File(this.folderitem.getPath(), (String)element.elementAt(8));
            }
        }
        this.closeDoor();
        return file;
    }

    private FolderIndexItem getVfolderItem(Vector element) {
        String pname = new String((String)element.elementAt(8));
        String vdir = new String((String)element.elementAt(9));
        FolderIndexItem item = this.folderitem.indexfile.getIndexItem(pname, vdir);
        return item;
    }

    private int getVfolderItemIndex(Vector element) {
        String pname = new String((String)element.elementAt(8));
        String vdir = new String((String)element.elementAt(9));
        int index = this.folderitem.indexfile.getItemIndex(pname, vdir);
        return index;
    }

    public File getMessageFile(int num) {
        File file = null;
        this.openDoor();
        Vector element = (Vector)this.getItem(num);
        if (element != null) {
            if (this.vfolder) {
                String popname = (String)element.elementAt(8);
                String dir = (String)element.elementAt(9);
                FolderIndexItem item = this.folderitem.indexfile.getIndexItem(popname, dir);
                file = new File(item.popdir, item.getPopName());
            } else {
                file = new File(this.folderitem.getPath(), (String)element.elementAt(8));
            }
        }
        this.closeDoor();
        return file;
    }

    public Vector getSelectedFiles() {
        int[] index = this.getSelectedIndexes();
        Vector<File> vector = new Vector<File>();
        Vector element = null;
        Object file = null;
        this.openDoor();
        if (index != null) {
            for (int i = 0; i < index.length; ++i) {
                element = (Vector)this.getItem(index[i]);
                if (element == null) continue;
                if (this.vfolder) {
                    int ind = this.folderitem.indexfile.vPopName.indexOf((String)element.elementAt(8));
                    FolderIndexItem item = (FolderIndexItem)this.folderitem.indexfile.vItem.elementAt(ind);
                    vector.addElement(new File(item.popdir, item.getPopName()));
                    continue;
                }
                vector.addElement(new File(this.folderitem.getPath(), (String)element.elementAt(8)));
            }
        }
        this.closeDoor();
        return vector;
    }

    public boolean AddMessage(File popfile) {
        this.sayLine(String.valueOf("Adding message: ").concat(String.valueOf(popfile)));
        this.openDoor();
        boolean ret_code = true;
        if (this.getMessageIndex(popfile.getName()) < 0) {
            this.loadListItem(popfile);
            this.updateCounter();
        }
        this.closeDoor();
        return ret_code;
    }

    public boolean AddMessage(FolderIndexItem item) {
        this.openDoor();
        boolean ret_code = true;
        if (this.getMessageIndex(item.getPopName()) < 0) {
            this.loadListItem(item);
            this.updateCounter();
        }
        this.closeDoor();
        return ret_code;
    }

    public boolean trashMessages() {
        return Boolean.valueOf(this.parent.getProfile().ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.USETRASH, "false")) == false;
    }

    public void deleteNote(String popfile, FolderItem trashFolder) {
        this.deleteNote(popfile, trashFolder, true);
    }

    public void deleteNote(String popfile, FolderItem trashFolder, boolean changeMsg) {
        File file = this.getMessageFile(popfile);
        if (this.trashMessages()) {
            trashFolder.copyMessage(popfile, this.getDirName(file), this.folderitem.indexfile.getIndexItem(popfile));
        }
        if (this.vfolder) {
            this.removeVFolderNote(this.folderitem.indexfile.getIndexItem(popfile));
        }
        this.updateCounter();
        this.currentMessage = -1;
        if (this.countItems() > 0 && changeMsg) {
            int ind;
            for (ind = this.removePopfile(popfile); ind >= this.countItems(); --ind) {
            }
            this.select(ind);
            this.makeVisible(ind);
            this.displayMessage();
        } else {
            this.parent.clearMessage();
        }
    }

    public boolean deleteNotes(FolderItem trashFolder) {
        block10: {
            boolean ret_code = true;
            boolean trash = this.trashMessages();
            boolean go = true;
            int first = 0;
            Vector element = null;
            String popfile = null;
            File file = null;
            FolderIndexItem item = null;
            this.openDoor();
            int[] index = this.getSelectedIndexes();
            this.closeDoor();
            this.setVisible(false);
            if (index != null && index.length > 0) {
                first = index[0];
                for (int i = index.length - 1; i >= 0; --i) {
                    this.sayLine(String.valueOf("working on index: ").concat(String.valueOf(i)));
                    element = (Vector)this.getItem(index[i]);
                    popfile = new String((String)element.elementAt(8));
                    if (this.vfolder) {
                        String vdir = new String((String)element.elementAt(9));
                        file = this.getMessageFile(popfile, vdir);
                        item = this.folderitem.indexfile.getIndexItem(popfile, vdir);
                        this.removeVFolderNote(item);
                        this.folderitem.indexfile.removeFromIndex(popfile, vdir);
                    } else {
                        file = this.getMessageFile(popfile);
                        item = this.folderitem.indexfile.getIndexItem(popfile);
                        this.folderitem.indexfile.removeFromIndex(popfile);
                    }
                    if (!file.exists() || !trash || trashFolder.copyMessage(popfile, this.getDirName(file), item)) {
                        if (file.exists()) {
                            int z = 0;
                            go = false;
                            while (file.exists() && !go && z < 5) {
                                go = file.delete();
                                if (go) continue;
                                AutoRefresh.Sleep(2000L);
                            }
                        } else {
                            go = true;
                        }
                    } else {
                        go = false;
                    }
                    if (!go) continue;
                    this.deselect(index[i]);
                    this.deleteItem(index[i]);
                }
                this.updateCounter();
            }
            this.setVisible(true);
            System.gc();
            this.currentMessage = -1;
            if (this.countItems() <= 0) break block10;
            while (first >= this.countItems()) {
                --first;
            }
            this.select(first);
            this.makeVisible(first);
            this.displayMessage();
        }
        return true;
    }

    public File getMessageFile(String pname) {
        return this.getMessageFile(pname, null);
    }

    public File getMessageFile(String pname, String dir) {
        File file = null;
        if (dir != null) {
            FolderIndexItem item = this.folderitem.indexfile.getIndexItem(pname, dir);
            file = new File(item.popdir, item.getPopName());
        } else {
            file = new File(this.folderitem.getPath(), pname);
        }
        return file;
    }

    public String getDirName(File file) {
        String dir = file.getAbsolutePath();
        int spot = dir.lastIndexOf(File.separator);
        if (spot >= 0) {
            dir = new String(dir.substring(0, spot));
        }
        return dir;
    }

    public int removePopfile(String fname) {
        String cfile;
        if (fname.length() > 12) {
            fname = new String(fname.substring(0, 12));
        }
        this.folderitem.indexfile.removeFromIndex(fname);
        this.openDoor();
        boolean ret_code = false;
        Vector item = null;
        String fn = null;
        File file = null;
        int ind = -1;
        for (int i = 0; i < this.countItems(); ++i) {
            item = (Vector)this.getItem(i);
            fn = (String)item.elementAt(8);
            if (fname.toLowerCase().compareTo(fn.toLowerCase()) != 0) continue;
            file = new File(this.folderitem.getPath().getAbsolutePath(), fn);
            if (file.exists()) {
                file.delete();
            }
            this.deselect(i);
            this.deleteItem(i);
            ret_code = true;
            ind = i;
            break;
        }
        if ((cfile = this.parent.textarea.getPopFile()) != null && cfile.length() > 12) {
            cfile = new String(cfile.substring(0, 12));
        }
        if (cfile != null && fname.equalsIgnoreCase(cfile)) {
            this.parent.textarea.clear();
        }
        this.closeDoor();
        this.updateCounter();
        return ind;
    }

    public boolean UpdateMessage(String fname) {
        this.openDoor();
        boolean ret_code = false;
        Vector item = null;
        String fn = null;
        File file = null;
        for (int i = 0; i < this.countItems(); ++i) {
            item = (Vector)this.getItem(i);
            fn = (String)item.elementAt(8);
            if (fname.toLowerCase().compareTo(fn.toLowerCase()) != 0) continue;
            file = new File(this.folderitem.getPath().getAbsolutePath(), fn);
            PopFileProcedure pop = new PopFileProcedure();
            pop.readHeaders(file);
            item.setElementAt(pop.getHeader("subject"), 2);
            item.setElementAt(pop.getHeader("from"), 3);
            item.setElementAt(pop.getHeader("to"), 4);
            item.setElementAt(pop.getHeader("date"), 5);
            item.setElementAt(new String(String.valueOf("").concat(String.valueOf(file.length()))), 7);
            this.folderitem.indexfile.updateIndex(pop);
            if (fname.equalsIgnoreCase(this.parent.textarea.getPopFile())) {
                this.parent.textarea.reload();
            }
            ret_code = true;
            break;
        }
        this.closeDoor();
        return ret_code;
    }

    public void refreshList() {
        if (this.notelistload != null) {
            this.notelistload.stop();
        }
        this.notelistload = new NoteListLoad(this);
        this.notelistload.start();
    }

    public void copyMessages(FolderItem folder, int parm) {
        CopyThread copy = new CopyThread(this, folder, parm);
        copy.start();
        copy.showDialog();
    }

    public void copyMessages(CopyThread thread, FolderItem folder, int parm) {
        this.openDoor();
        Vector element = null;
        boolean go = false;
        String popfile = null;
        String popdir = null;
        boolean cnt = false;
        int first = 0;
        Object[] msgs = this.getSelectedObjects();
        int[] index = this.getSelectedIndexes();
        thread.setTotal(msgs.length);
        if (parm == 1) {
            this.setVisible(false);
        }
        first = index[0];
        for (int i = msgs.length - 1; i >= 0; --i) {
            thread.setCurrent(i + 1);
            element = (Vector)msgs[i];
            popfile = new String((String)element.elementAt(8));
            if (this.vfolder) {
                int ind = this.folderitem.indexfile.vPopName.indexOf((String)element.elementAt(8));
                FolderIndexItem item = (FolderIndexItem)this.folderitem.indexfile.vItem.elementAt(ind);
                popdir = new String(item.popdir);
            } else {
                popdir = new String(this.folderitem.getPath().getAbsolutePath());
            }
            this.closeDoor();
            if (folder.copyMessage(popfile, popdir, this.folderitem.indexfile.getIndexItem(popfile), true) && parm == 1) {
                FolderItem rfolder;
                if (this.vfolder && (rfolder = this.parent.folderlist.FindLeaf(popdir)) != null && rfolder.isCurrent()) {
                    this.parent.notelist.removePopfile(popfile);
                }
                File file = new File(popdir, popfile);
                file.delete();
                this.folderitem.indexfile.removeFromIndex(file.getName());
                go = true;
            } else {
                go = false;
            }
            this.openDoor();
            if (go) {
                this.deselect(index[i]);
                this.deleteItem(index[i]);
            }
            if (thread.getStop()) break;
        }
        if (parm == 1) {
            this.updateCounter();
            this.setVisible(true);
        }
        this.closeDoor();
        if (parm == 1) {
            this.currentMessage = -1;
            if (this.countItems() > 0) {
                while (first >= this.countItems()) {
                    --first;
                }
                this.select(first);
                this.makeVisible(first);
                this.displayMessage();
            }
        }
        if (this.virtfolder != null) {
            this.virtfolder.copyCompleted();
        } else {
            this.parent.copyCompleted();
        }
    }

    public void copyMessages(String popfile, FolderItem folder, int parm) {
        this.openDoor();
        String popdir = null;
        if (this.vfolder) {
            int ind = this.folderitem.indexfile.vPopName.indexOf(popfile);
            FolderIndexItem item = (FolderIndexItem)this.folderitem.indexfile.vItem.elementAt(ind);
            popdir = new String(item.popdir);
        } else {
            popdir = new String(this.folderitem.getPath().getAbsolutePath());
        }
        this.closeDoor();
        if (folder.copyMessage(popfile, popdir, this.folderitem.indexfile.getIndexItem(popfile)) && parm == 1) {
            FolderItem rfolder;
            if (this.vfolder && (rfolder = this.parent.folderlist.FindLeaf(popdir)) != null && rfolder.isCurrent()) {
                this.parent.notelist.removePopfile(popfile);
            }
            File file = new File(popdir, popfile);
            file.delete();
            this.folderitem.indexfile.removeFromIndex(file.getName());
            this.deleteItem(this.getMsgIndex(popfile));
        }
        this.openDoor();
        if (parm == 1) {
            this.updateCounter();
        }
        this.closeDoor();
    }

    public int getMsgIndex(String fname) {
        int ind = -1;
        Vector item = null;
        String fn = null;
        for (int i = 0; i < this.countItems(); ++i) {
            item = (Vector)this.getItem(i);
            fn = (String)item.elementAt(8);
            if (fname.toLowerCase().compareTo(fn.toLowerCase()) != 0) continue;
            ind = i;
            break;
        }
        return ind;
    }

    public FolderItem getCurrentFolder() {
        return this.folderitem;
    }

    public void setColorCode(int code) {
        this.openDoor();
        Object[] item = this.getSelectedObjects();
        Vector element = null;
        if (item != null) {
            for (int i = 0; i < item.length; ++i) {
                element = (Vector)item[i];
                String fname = (String)element.elementAt(8);
                int num = this.folderitem.indexfile.getItemNumber(fname);
                this.closeDoor();
                this.folderitem.indexfile.setColorCode(num, code);
                if (this.vfolder) {
                    this.updateVirtualFolderItem(this.folderitem.indexfile.getIndexItem(num));
                }
                this.openDoor();
                element.setElementAt(JCString.parse(this, ColorCodeList.getCodeImage(code)), 1);
                this.paintRow(this.getSelectedIndex());
            }
        }
        this.closeDoor();
        this.repaint();
    }

    public void sayLine(String text) {
    }

    public FolderIndexItem getSelectedMessage() {
        this.openDoor();
        FolderIndexItem item = null;
        Vector element = (Vector)this.getSelectedItem();
        this.closeDoor();
        if (element != null) {
            String fname = (String)element.elementAt(8);
            item = this.folderitem.indexfile.getIndexItem(fname);
        }
        return item;
    }

    public void updateCurrentMessage() {
        int num = 0;
        this.openDoor();
        Vector element = (Vector)this.getSelectedItem();
        if (element != null) {
            String fname = (String)element.elementAt(8);
            num = this.vfolder ? this.getVfolderItemIndex(element) : this.folderitem.indexfile.getItemNumber(fname);
            if (!this.folderitem.indexfile.isOpened(num)) {
                this.folderitem.indexfile.setOpened(num);
                String val = new String(String.valueOf(String.valueOf("[IMG=").concat(String.valueOf(jstreet.OPENEDENVELOPEGIF))).concat(String.valueOf("]")));
                element.setElementAt(JCString.parse(this, val), 0);
                val = null;
            }
            this.paintRow(this.getSelectedIndex());
            this.closeDoor();
            if (this.vfolder) {
                this.updateVirtualFolderItem(this.folderitem.indexfile.getIndexItem(num));
            }
        } else {
            this.closeDoor();
        }
    }

    public void setOpened(boolean open) {
        this.openDoor();
        int[] item = this.getSelectedIndexes();
        if (item != null && item.length > 0) {
            for (int i = 0; i < item.length; ++i) {
                Vector element = (Vector)this.getItem(item[i]);
                if (element != null) {
                    String fname = (String)element.elementAt(8);
                    int num = this.folderitem.indexfile.getItemNumber(fname);
                    this.folderitem.indexfile.setOpened(num, open);
                    String val = new String(String.valueOf(String.valueOf("[IMG=").concat(String.valueOf(this.determineGif(num)))).concat(String.valueOf("]")));
                    element.setElementAt(JCString.parse(this, val), 0);
                    val = null;
                    if (this.vfolder) {
                        this.updateVirtualFolderItem(this.folderitem.indexfile.getIndexItem(num));
                    }
                }
                this.paintRow(item[i]);
            }
            this.closeDoor();
        } else {
            this.closeDoor();
        }
    }

    public void refreshCurrentMessage() {
        this.openDoor();
        Vector element = (Vector)this.getSelectedItem();
        FolderIndexItem item = null;
        if (element != null) {
            String fname = (String)element.elementAt(8);
            int num = this.folderitem.indexfile.getItemNumber(fname);
            element.setElementAt(JCString.parse(this, String.valueOf(String.valueOf("[img=").concat(String.valueOf(this.determineGif(num)))).concat(String.valueOf("]"))), 0);
            this.closeDoor();
            item = this.folderitem.indexfile.getIndexItem(num);
            this.openDoor();
            item.updateListItem(this, element);
            this.paintRow(this.getSelectedIndex());
            if (this.vfolder) {
                this.updateVirtualFolderItem(item);
            }
        }
        this.closeDoor();
    }

    public int getMessageIndex(String pname) {
        Vector item = null;
        int ind = -1;
        String fn = null;
        for (int i = 0; i < this.countItems(); ++i) {
            item = (Vector)this.getItem(i);
            fn = (String)item.elementAt(8);
            if (!fn.equalsIgnoreCase(pname)) continue;
            ind = i;
            break;
        }
        return ind;
    }

    public void updateMessage(FolderIndexItem nitem) {
        this.openDoor();
        int index = this.getMessageIndex(nitem.getPopName());
        if (index >= 0) {
            Vector element = (Vector)this.getItem(index);
            this.closeDoor();
            FolderIndexItem litem = this.folderitem.indexfile.getIndexItem(nitem.getPopName());
            this.openDoor();
            litem.update(nitem);
            element.setElementAt(JCString.parse(this, String.valueOf(String.valueOf("[img=").concat(String.valueOf(this.determineGif(index)))).concat(String.valueOf("]"))), 0);
            litem.updateListItem(this, element);
            if (index < this.countItems()) {
                this.paintRow(index);
            }
            this.setDirty();
        }
        this.closeDoor();
        this.repaint();
    }

    public boolean currentFolder(String dir) {
        return this.getDir().equalsIgnoreCase(dir);
    }

    public void updateVirtualFolderItem(FolderIndexItem item) {
        if (this.parent.notelist.currentFolder(item.popdir)) {
            this.parent.notelist.updateMessage(item);
        } else {
            FolderIndex index = new FolderIndex(this.parent, item.popdir);
            index.loadIndex();
            index.updateIndexItem(item);
            index.setDirty(true);
            index.saveIndex();
            Object var2_2 = null;
        }
    }

    public void removeVFolderNote(FolderIndexItem item) {
        if (this.parent.notelist.currentFolder(item.popdir)) {
            this.parent.notelist.deleteNote(item.getPopName(), this.parent.folderlist.getTrashFolder(), false);
        } else {
            FolderIndex index = new FolderIndex(this.parent, item.popdir);
            index.loadIndex();
            index.removeFromIndex(item.getPopName());
            index.saveIndex();
            Object var2_2 = null;
        }
    }

    private synchronized void openDoor() {
        this.sayLine("Opening notelist door...");
        try {
            if (this.doorOpened) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            System.out.println(String.valueOf("Error: ").concat(String.valueOf(e)));
        }
        this.doorOpened = true;
        this.sayLine("Notelist door opened...");
    }

    private synchronized void closeDoor() {
        this.sayLine("Closing notelist door...");
        this.doorOpened = false;
        this.notifyAll();
        this.sayLine("Notelist door closed...");
    }
}

