/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import ice.htmlbrowser.Browser;
import ice.htmlbrowser.Document;
import innoval.mailer.FolderIndexItem;
import innoval.mailer.MsgBox;
import innoval.mailer.NoteWin;
import innoval.mailer.NoteWinLoadVBrowser;
import innoval.mailer.NoteWinText;
import innoval.mailer.PopFileProcedure;
import innoval.mailer.VirtualFolderList;
import innoval.mailer.jstreet;
import java.awt.Label;
import java.awt.Scrollbar;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.File;

public class NoteWinVBrowser
extends Browser
implements MouseListener,
KeyListener {
    private VirtualFolderList parent;
    private BufferedInputStream in;
    private File popfile = null;
    private jstreet Jstreet;
    private NoteWinLoadVBrowser notewinload;
    private int headerState = 2;
    private int fontSize = 1;
    private int reloads = 0;
    private int bottomCnt = 0;
    private Document rootDoc = null;
    private boolean formatState = true;
    private boolean decodeState = true;

    NoteWinVBrowser(VirtualFolderList frame, jstreet Jstreet) {
        this.Jstreet = Jstreet;
        this.parent = frame;
        this.setVisibleControl(false);
        this.notewinload = null;
        this.newDocument();
        this.rootDoc = this.getCurrentDocument();
        this.getCurrentDocument().addKeyListener(this);
    }

    public void setHeaderState(int val, Label text) {
        this.headerState = val;
        if (this.popfile != null) {
            this.load(this.popfile, text);
        }
    }

    public int getHeaderState() {
        return this.headerState;
    }

    public void setFontSize(int val, Label text) {
        this.fontSize = val;
        if (this.popfile != null) {
            this.load(this.popfile, text);
        }
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFormatState(boolean val, Label text) {
        this.formatState = val;
        if (this.popfile != null) {
            this.load(this.popfile, text);
        }
    }

    public boolean getFormatState() {
        return this.formatState;
    }

    public void setDecodeState(boolean val, Label text) {
        this.decodeState = val;
        if (this.popfile != null) {
            this.load(this.popfile, text);
        }
    }

    public boolean getDecodeState() {
        return this.decodeState;
    }

    public File getFile() {
        return this.popfile;
    }

    public String getPopFile() {
        String pname = "";
        if (this.popfile != null) {
            pname = new String(this.popfile.getName());
        }
        return pname;
    }

    public void mouseClicked(MouseEvent e) {
        String text;
        if (e.getClickCount() == 2 && NoteWinText.isUrl(text = this.getCurrentDocument().getSelectedText(e))) {
            this.Jstreet.runBrowser(text);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.popfile != null && e.getModifiers() == 4) {
            this.parent.viewPopup.show(this, e.getX(), e.getY());
        } else if (e.getModifiers() == 16) {
            int wide = this.getSize().width;
            int x = e.getX();
            int y = e.getY();
            if (e.getX() > this.getSize().width - 60 && e.getY() < 30) {
                this.parent.clickSticky();
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            if (!this.goToNextPage()) {
                this.parent.executeNoteCommand(0);
            }
        } else {
            int cmd = NoteWin.determineCommand(e, this.Jstreet.textarea.getKeyCmd());
            if (cmd >= 0) {
                this.parent.executeNoteCommand(cmd);
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public boolean goToNextPage() {
        int page;
        Scrollbar hs = (Scrollbar)this.getVScrollbar();
        boolean ret_code = true;
        int val = hs.getValue();
        int max = hs.getMaximum();
        int left = max - val;
        if (left <= (page = hs.getBlockIncrement())) {
            if (this.bottomCnt > 0 || max <= page) {
                this.bottomCnt = 0;
                ret_code = false;
            } else {
                ++this.bottomCnt;
            }
        } else {
            this.bottomCnt = 0;
        }
        return ret_code;
    }

    public void clear() {
        this.stopLoading();
        this.setVisible(false);
        this.parseHTMLString("");
        this.setVisible(true);
        NoteWinVBrowser.clearDirectory(this.parent.getAttachDir());
        this.parent.attachbar.setup(this.parent.getAttachDir());
        this.popfile = null;
    }

    public static void clearDirectory(File dir) {
        String[] file = dir.list();
        for (int i = 0; i < file.length; ++i) {
            File tfile = new File(dir.getPath(), file[i]);
            tfile.delete();
        }
    }

    public void updateTitle(String title) {
    }

    public void stopLoading() {
        if (this.notewinload != null) {
            this.notewinload.setStop(true);
            this.getCurrentDocument().stopLoading();
        }
    }

    public void load(File file, Label text) {
        if (this.notewinload != null) {
            this.notewinload.setStop(true);
        }
        this.popfile = file;
        this.notewinload = new NoteWinLoadVBrowser(this, text);
        this.notewinload.start();
    }

    public void reload() {
        if (this.notewinload != null) {
            this.notewinload.setStop(true);
        }
        this.notewinload = new NoteWinLoadVBrowser(this, null);
        this.notewinload.start();
    }

    public synchronized void loadNote(NoteWinLoadVBrowser thread) throws NullPointerException {
        PopFileProcedure pop = null;
        FolderIndexItem item = null;
        thread.setText("Loading message...");
        this.setVisible(false);
        this.getCurrentDocument().stopLoading();
        if (this.getCurrentDocument() != this.rootDoc) {
            this.newDocument();
            this.rootDoc = this.getCurrentDocument();
            this.getCurrentDocument().addKeyListener(this);
        } else {
            this.parseHTMLString("");
            this.getCurrentDocument().scrollTo(0, 0);
        }
        NoteWinVBrowser.clearDirectory(this.parent.getAttachDir());
        this.parent.attachbar.setup(this.parent.getAttachDir());
        ++this.reloads;
        if (this.reloads % 5 == 0) {
            System.gc();
        }
        if (!thread.getStop()) {
            pop = new PopFileProcedure();
            thread.setPopFileProcedure(pop);
            pop.setAttachDir(this.parent.getAttachDir());
            pop.setHtml(true);
            pop.setDecode(this.decodeState);
            pop.setFormat(this.formatState);
            pop.setHtmlFontSize(this.fontSize);
        }
        if (!thread.getStop()) {
            item = this.parent.getSelectedMessage();
            if (item != null && item.getNotes().length() > 0) {
                pop.setStickyNotes(true);
            } else {
                pop.setStickyNotes(false);
            }
        }
        if (!thread.getStop() && this.popfile != null) {
            if (this.popfile.exists()) {
                pop.readFile(this.Jstreet, this.popfile.getAbsolutePath());
                if (item != null && !thread.getStop() && pop.countAttachments() > 0 && !item.getAttach()) {
                    item.setAttach(true);
                    this.parent.notelist.setDirty();
                    this.parent.notelist.refreshCurrentMessage();
                }
            } else {
                MsgBox msgBox = new MsgBox(this.parent, String.valueOf(String.valueOf("The selected message file [").concat(String.valueOf(this.popfile.getAbsolutePath()))).concat(String.valueOf("] was not found.")));
            }
        }
        if (!thread.getStop()) {
            this.parent.attachbar.setup(this.parent.getAttachDir());
        }
        if (!thread.getStop()) {
            if (this.popfile.exists()) {
                this.parseHTMLString(pop.getPopHTMLText(this.headerState));
            } else {
                this.parseHTMLString("");
            }
            this.refresh();
            this.setVisible(true);
            this.getCurrentDocument().requestFocus();
        }
        this.parent.validateMessageWindow();
        if (thread.getStop()) {
            this.clear();
        }
        this.notewinload = null;
        pop = null;
        thread.setText("");
    }

    public int removeChar(byte[] text, int bytes, char tchar) {
        int cnt = 0;
        for (int i = 0; i < bytes; ++i) {
            if (text[i] == (byte)tchar) continue;
            text[cnt++] = text[i];
        }
        for (int i = cnt; i < bytes; ++i) {
            text[i] = 0;
        }
        return cnt;
    }
}

