/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.ConnectSocketThread;
import innoval.mailer.DownLoadMail;
import innoval.mailer.FilterExecute;
import innoval.mailer.FolderItem;
import innoval.mailer.GenPopName;
import innoval.mailer.MailMsg;
import innoval.mailer.MsgBox;
import innoval.mailer.NewInboxMessage;
import innoval.mailer.NewsPost;
import innoval.mailer.NoteList;
import innoval.mailer.PopFileProcedure;
import innoval.mailer.PopFilter;
import innoval.mailer.Profile;
import innoval.mailer.SendItem;
import innoval.mailer.SettingsAdvanced;
import innoval.mailer.SettingsGeneral;
import innoval.mailer.UIDLHandler;
import innoval.mailer.UpLoadMail;
import innoval.mailer.jstreet;
import java.awt.Frame;
import java.awt.Label;
import java.awt.TextArea;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.Vector;

public class Pop3 {
    public static final int WHOLEMESSAGE = 0;
    public static final int ONLYHEADERS = 3;
    public static final int FIRST50 = 4;
    private String server;
    private String userid;
    private String password;
    private NewsPost post = null;
    private Socket socket;
    private int notes;
    private int filtered;
    private int downloaded;
    private int port;
    private int maxBytes;
    private int firstMessage;
    private int connectTime = 60;
    private int lastMessage;
    private String inchar = new String("");
    private BufferedReader in;
    private BufferedWriter bwrite;
    private DataOutputStream out;
    private jstreet frame;
    private Frame parentFrame;
    private DownLoadMail downloadmail;
    private UpLoadMail uploadmail;
    private File popname;
    private File currentPopfile;
    private NoteList notelist;
    private boolean deleteMessages;
    private boolean stop;
    private boolean newonly = false;
    private boolean active;

    Pop3(jstreet parent, Frame parentFrame, NoteList notelist, String serv, String user, String pw, int pnum) {
        this.server = serv;
        this.parentFrame = parentFrame;
        this.userid = user;
        this.password = pw;
        this.port = pnum;
        this.frame = parent;
        this.notelist = notelist;
        this.firstMessage = 1;
        this.lastMessage = 0;
        this.active = true;
        this.setTimeout();
    }

    Pop3(jstreet parent, Frame parentFrame, String server, String userid, String password, int port) {
        this.server = new String(server);
        this.userid = new String(userid);
        this.password = new String(password);
        this.port = port;
        this.active = true;
        this.frame = parent;
        this.parentFrame = parentFrame;
        this.setTimeout();
    }

    private void setTimeout() {
        try {
            this.connectTime = Integer.valueOf(this.frame.getProfile().ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.POPTIMEOUT, "60"));
        }
        catch (NumberFormatException e) {
            this.connectTime = 60;
        }
    }

    public void clearSocket() {
        this.socket = null;
    }

    public void setStop(boolean val) {
        this.stop = val;
        if (this.post != null) {
            this.post.setQuit(val);
        }
    }

    public void setMaxKiloBytes(int maxBytes) {
        this.maxBytes = maxBytes * 1024;
    }

    public String Userid() {
        return this.userid;
    }

    public String Password() {
        return this.password;
    }

    public String Server() {
        return this.server;
    }

    public int Port() {
        return this.port;
    }

    public void setNewOnly(boolean newonly) {
        this.newonly = newonly;
    }

    public void setFirstMessage(int val) {
        this.firstMessage = val;
    }

    public int getLastMessage() {
        return this.lastMessage;
    }

    public void setDelete(boolean val) {
        this.deleteMessages = val;
    }

    public boolean getDelete() {
        return this.deleteMessages;
    }

    public int Notes() {
        return this.notes;
    }

    public int Filtered() {
        return this.filtered;
    }

    public int Downloaded() {
        return this.downloaded;
    }

    public int CountNotes(Label text) {
        if (this.Logon(text)) {
            this.ExecuteStat();
            this.Logoff();
        }
        return this.notes;
    }

    public boolean outReady() {
        boolean ret_code = false;
        if (this.out != null) {
            ret_code = true;
        }
        return ret_code;
    }

    public boolean ExecuteStat() {
        boolean ret_code = false;
        try {
            if (!this.stop) {
                this.out.writeBytes("STAT\r\n");
                this.inchar = this.in.readLine();
                if (this.inchar.charAt(0) == '+') {
                    int end = this.inchar.indexOf(32, 4);
                    String text = new String(this.inchar.substring(4, end));
                    this.notes = Integer.parseInt(text);
                    ret_code = true;
                }
            }
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.parentFrame, String.valueOf("Error").concat(String.valueOf(e)));
        }
        return ret_code;
    }

    public int runStat() {
        boolean ret_code = false;
        int notes = 0;
        try {
            this.out.writeBytes("STAT\r\n");
            this.inchar = this.in.readLine();
            if (this.inchar.charAt(0) == '+') {
                int end = this.inchar.indexOf(32, 4);
                String text = new String(this.inchar.substring(4, end));
                notes = Integer.parseInt(text);
            }
        }
        catch (IOException e) {
            System.out.println(String.valueOf("Stat Error: ").concat(String.valueOf(e)));
            this.clearSocket();
        }
        return notes;
    }

    public boolean runUIDL() {
        boolean ret_code = false;
        try {
            this.out.writeBytes("UIDL\r\n");
            this.inchar = this.in.readLine();
            if (this.inchar.charAt(0) == '+') {
                ret_code = true;
            }
        }
        catch (IOException e) {
            System.out.println(String.valueOf("UIDL Error: ").concat(String.valueOf(e)));
        }
        return ret_code;
    }

    public void GetMail(jstreet parent, Label text, File file) {
        this.downloadmail = new DownLoadMail(this, parent, text, file);
        this.downloadmail.start();
    }

    public void BreakMail(Frame parent, Label text) {
        if (this.downloadmail != null) {
            text.setText("Halting message download...");
            this.setStop(true);
            this.downloadmail.setStop(true);
            this.downloadmail = null;
        }
    }

    public int goGetMail(DownLoadMail thread, jstreet parent, Label text, File file) {
        boolean logon = false;
        boolean large = false;
        boolean quit = false;
        boolean go = true;
        MailMsg mailmsg = null;
        String retCode = null;
        NewInboxMessage newmsg = null;
        PopFileProcedure pop = null;
        UIDLHandler huidl = null;
        int count = 0;
        int total = 0;
        int mailmapstyle = 0;
        String mailmapEmail = parent.getProfile().ReadString(SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.MAILMAPEMAIL, "");
        boolean uidl = Boolean.valueOf(parent.getProfile().ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.UIDLCMD, "true"));
        this.downloaded = 0;
        this.filtered = 0;
        this.notes = 0;
        if (!thread.stop) {
            jstreet.runExitProgram(parent, SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.REFRESHEXIT);
        }
        if (mailmapEmail.length() > 0) {
            mailmapstyle = Integer.valueOf(parent.getProfile().ReadString(SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.MAILMAPSTYLE, "0"));
        }
        try {
            if (!thread.stop) {
                logon = this.Logon(text);
            }
            if (logon) {
                text.setText("Counting available messages...");
                if (!thread.stop && this.ExecuteStat()) {
                    total = this.notes;
                    if (!thread.stop && total > 0 && uidl) {
                        text.setText("Requesting UIDL message ids...");
                        huidl = new UIDLHandler(parent);
                        if (this.runUIDL()) {
                            huidl.retrieveIds(this.in);
                        } else {
                            uidl = false;
                            huidl.setSetting(false);
                            MsgBox msg = new MsgBox(parent, "The UIDL command is not supported on this mail server.  Your UIDL command setting has been deactivated.");
                            huidl = null;
                        }
                    }
                    if (!thread.stop && total > 0) {
                        text.setText("Retrieving messages...");
                    }
                    if (mailmapEmail.length() > 0 || uidl || this.firstMessage - 1 > total || this.firstMessage == 0) {
                        this.firstMessage = 1;
                    }
                    this.lastMessage = this.firstMessage - 1;
                    for (int i = this.firstMessage; !thread.stop && !quit && i <= total; ++i) {
                        this.popname = new File(new GenPopName(file.getAbsolutePath()).getName());
                        if (!thread.stop && mailmapEmail.length() > 0) {
                            text.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Mailmapping [").concat(String.valueOf(i))).concat(String.valueOf("] of ["))).concat(String.valueOf(total))).concat(String.valueOf("].")));
                            pop = this.getMessage(i, this.popname, 3, text);
                            go = pop.mailMap(mailmapEmail, mailmapstyle);
                            pop = null;
                            this.popname.delete();
                        } else {
                            go = true;
                        }
                        if (!thread.stop && go && this.newonly && uidl) {
                            boolean bl = go = !huidl.findId(i - 1);
                        }
                        if (thread.stop || !go) continue;
                        text.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Retrieving message [").concat(String.valueOf(i))).concat(String.valueOf("] of ["))).concat(String.valueOf(total))).concat(String.valueOf("].")));
                        this.bwrite = new BufferedWriter(new FileWriter(this.popname.getAbsolutePath()));
                        mailmsg = new MailMsg();
                        mailmsg.setMaxBytes(this.maxBytes);
                        mailmsg.getMessage(this.frame, this.in, this.out, i, this.bwrite, text, thread);
                        mailmsg.setPopfile(this.popname.getCanonicalPath());
                        large = mailmsg.getLarge();
                        this.bwrite.close();
                        this.bwrite = null;
                        mailmsg = null;
                        if (!thread.stop && this.popname.exists() && this.popname.length() > (long)0) {
                            if (uidl) {
                                huidl.addId(i - 1);
                            }
                            ++this.downloaded;
                            if (this.deleteMessages && !large) {
                                this.out.writeBytes(String.valueOf(String.valueOf("DELE ").concat(String.valueOf(i))).concat(String.valueOf("\r\n")));
                                this.inchar = this.in.readLine();
                            } else {
                                this.lastMessage = i;
                            }
                            FilterExecute runFilters = new FilterExecute(parent, this.popname.getParent(), this.popname.getName());
                            retCode = runFilters.getReturnCode();
                            runFilters = null;
                        } else if (this.popname.exists() && this.popname.length() == (long)0) {
                            System.out.println(String.valueOf(String.valueOf("Message [").concat(String.valueOf(i))).concat(String.valueOf("] was found to be zero bytes prior to filter execution.")));
                        }
                        if (!thread.stop && this.popname.exists() && this.popname.length() > (long)0) {
                            if (newmsg == null) {
                                newmsg = new NewInboxMessage(parent);
                            }
                            if (retCode != null && retCode.startsWith("cc")) {
                                newmsg.add(this.popname, Integer.valueOf(retCode.substring(2, 3)));
                            } else {
                                newmsg.add(this.popname);
                            }
                            this.popname.delete();
                            this.popname = null;
                            ++count;
                            continue;
                        }
                        if (!this.popname.exists() || this.popname.length() != (long)0) continue;
                        this.popname.delete();
                        System.out.println(String.valueOf(String.valueOf("Halting message retrieve due to an erroneous zero length message [").concat(String.valueOf(i))).concat(String.valueOf("].")));
                        quit = true;
                    }
                }
            }
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(parent, String.valueOf("Error").concat(String.valueOf(e)));
        }
        if (huidl != null) {
            huidl.saveServer();
            huidl = null;
        }
        this.notes = count;
        this.filtered = this.downloaded - this.notes;
        if (logon) {
            this.Logoff();
        }
        this.downloadmail = null;
        if (!thread.stop) {
            jstreet.runExitProgram(parent, SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.REFRESHFEXIT);
        }
        parent.RetrieveComplete();
        return count;
    }

    public PopFileProcedure getMessage(int msgnum, File file, int parm, Label textField) {
        boolean ret_code = false;
        PopFileProcedure pop = null;
        long bytes = 0L;
        int buflen = 0;
        int cnt = 0;
        int read = 0;
        String oldMsg = new String("");
        String end = new String("");
        String note = new String("");
        Object text = null;
        String oldText = null;
        char[] buffer = new char[1024];
        if (textField != null) {
            oldText = textField.getText();
        }
        try {
            this.bwrite = new BufferedWriter(new FileWriter(file.getAbsolutePath()));
            this.out.writeBytes(String.valueOf(String.valueOf("LIST ").concat(String.valueOf(msgnum))).concat(String.valueOf("\r\n")));
            this.inchar = this.in.readLine();
            if (this.inchar.length() > 0 && this.inchar.charAt(0) == '+') {
                bytes = Long.valueOf(this.inchar.substring(this.inchar.trim().lastIndexOf(32)).trim());
            }
            switch (parm) {
                case 0: {
                    this.out.writeBytes(String.valueOf(String.valueOf("RETR ").concat(String.valueOf(msgnum))).concat(String.valueOf("\r\n")));
                    break;
                }
                case 4: {
                    this.out.writeBytes(String.valueOf(String.valueOf("TOP ").concat(String.valueOf(msgnum))).concat(String.valueOf(" 50\r\n")));
                    break;
                }
                case 3: {
                    this.out.writeBytes(String.valueOf(String.valueOf("TOP ").concat(String.valueOf(msgnum))).concat(String.valueOf(" 1\r\n")));
                }
            }
            this.inchar = this.in.readLine();
            if (this.inchar.length() > 0 && this.inchar.charAt(0) == '+') {
                ret_code = true;
                do {
                    if ((buflen = this.in.read(buffer, 0, buffer.length)) <= 0) continue;
                    ++cnt;
                    read += buflen;
                    if (textField != null) {
                        if (bytes == (long)0) {
                            textField.setText(String.valueOf(String.valueOf(String.valueOf(oldText).concat(String.valueOf(" ("))).concat(String.valueOf(read))).concat(String.valueOf(" bytes)")));
                        } else if ((long)read <= bytes) {
                            textField.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(oldText).concat(String.valueOf(" ("))).concat(String.valueOf((int)((double)read / (double)bytes * (double)100)))).concat(String.valueOf("% of "))).concat(String.valueOf(bytes))).concat(String.valueOf(")")));
                        }
                    }
                    end = (note = new String(String.valueOf(note).concat(String.valueOf(new String(buffer, 0, buflen))))).length() > 10 ? new String(note.substring(note.length() - 10)) : new String(String.valueOf(end).concat(String.valueOf(note)));
                    if (note.length() <= 40000) continue;
                    this.bwrite.write(MailMsg.fixMessage(note));
                    note = null;
                    note = new String("");
                } while (!this.stop && !end.endsWith("\n.\r\n") && !end.endsWith("\n.\n") && (cnt > 1 || !end.equals(".\r\n") && !end.equals(".\n")));
                this.bwrite.write(MailMsg.fixMessage(note));
            }
            this.bwrite.close();
            this.bwrite = null;
            if (ret_code) {
                pop = new PopFileProcedure();
                pop.readHeaders(file);
                pop.setBytes(bytes);
            }
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.parentFrame, String.valueOf("Error").concat(String.valueOf(e)));
        }
        return pop;
    }

    public static long parseBytes(String text) {
        long bytes = 0L;
        int start = 0;
        int end = 0;
        start = text.indexOf("(");
        if (start < 0) {
            start = text.indexOf(" ");
        }
        if (start > 0) {
            end = text.indexOf(" ", start + 1);
            if (end < 0) {
                end = text.indexOf("(", start + 1);
            }
            if (Pop3.isNumeric(text = end > start ? new String(text.substring(start + 1, end)) : new String(text.substring(start + 1)))) {
                bytes = Long.valueOf(text);
            }
        }
        return bytes;
    }

    public static boolean isNumeric(String text) {
        boolean ret_code = true;
        char[] chars = text.toCharArray();
        if (chars != null && chars.length > 0) {
            for (int i = 0; i < chars.length; ++i) {
                if (Character.isDigit(chars[i])) continue;
                ret_code = false;
                break;
            }
        } else {
            ret_code = false;
        }
        return ret_code;
    }

    public boolean deleteMessage(int msgnum) {
        boolean ret_code = false;
        try {
            this.out.writeBytes(String.valueOf(String.valueOf("DELE ").concat(String.valueOf(msgnum))).concat(String.valueOf("\r\n")));
            this.inchar = this.in.readLine();
            if (this.inchar.length() > 0 && this.inchar.charAt(0) == '+') {
                ret_code = true;
            }
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.parentFrame, String.valueOf("Error").concat(String.valueOf(e)));
        }
        return ret_code;
    }

    public boolean LoadMessage(Frame parent, Label text, int msgnum, TextArea msg) {
        boolean ret_code = true;
        try {
            if (this.Logon(text)) {
                this.out.writeBytes(String.valueOf(String.valueOf("RETR ").concat(String.valueOf(msgnum))).concat(String.valueOf("\r\n")));
                this.inchar = this.in.readLine();
                if (this.inchar.charAt(0) == '+') {
                    msg.setVisible(false);
                    this.inchar = this.in.readLine();
                    while (this.inchar.compareTo(".") != 0) {
                        msg.append(String.valueOf(this.inchar).concat(String.valueOf("\n")));
                        this.inchar = this.in.readLine();
                    }
                    msg.setVisible(true);
                } else {
                    ret_code = false;
                }
                this.Logoff();
            }
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(parent, String.valueOf("Error").concat(String.valueOf(e)));
        }
        return ret_code;
    }

    public boolean Logon(Label text) {
        boolean ret_code = false;
        text.setText("Connecting to message server...");
        try {
            this.socket = this.connectSocket(text, this.server, this.port);
            if (!this.stop && this.socket != null) {
                text.setText("Logging on to message server...");
                this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                this.inchar = this.in.readLine();
                if (!this.stop && this.inchar.length() > 0 && this.inchar.charAt(0) == '+') {
                    this.out = new DataOutputStream(this.socket.getOutputStream());
                    text.setText("Issuing USER command...");
                    this.out.writeBytes(String.valueOf(String.valueOf("USER ").concat(String.valueOf(this.userid))).concat(String.valueOf("\r\n")));
                    this.inchar = this.in.readLine();
                    if (!this.stop && this.inchar.charAt(0) == '+') {
                        text.setText("Issuing PASS command...");
                        this.out.writeBytes(String.valueOf(String.valueOf("PASS ").concat(String.valueOf(this.password))).concat(String.valueOf("\r\n")));
                        this.inchar = this.in.readLine();
                        if (!this.stop && this.inchar.charAt(0) == '+') {
                            ret_code = true;
                        } else if (!this.stop) {
                            MsgBox msgBox = new MsgBox(this.parentFrame, String.valueOf("Pop3 Error: ").concat(String.valueOf(this.inchar)));
                        }
                    } else if (!this.stop) {
                        MsgBox msgBox = new MsgBox(this.parentFrame, String.valueOf("Pop3 Error: ").concat(String.valueOf(this.inchar)));
                    }
                } else if (!this.stop) {
                    MsgBox msgBox = new MsgBox(this.parentFrame, String.valueOf("Pop3 Error: ").concat(String.valueOf(this.inchar)));
                }
            } else if (!this.stop) {
                MsgBox msgBox = new MsgBox(this.parentFrame, "No connection could be established with your POP3 server.");
            }
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.parentFrame, String.valueOf("Error").concat(String.valueOf(e)));
        }
        if (this.stop) {
            text.setText("Logon was halted.");
        } else if (!ret_code) {
            text.setText("Logon Unsuccessful.");
            this.Logoff();
        } else {
            text.setText("Logon Successful.");
        }
        return ret_code;
    }

    public Socket connectSocket(Label text, String server, int port) {
        Socket socket = null;
        ConnectSocketThread thread = new ConnectSocketThread(this.frame, server, port);
        String oldText = text.getText();
        try {
            thread.start();
            for (int i = this.connectTime; i > 0; --i) {
                thread.join(1000L);
                if (!this.stop) {
                    text.setText(String.valueOf(String.valueOf(String.valueOf(oldText).concat(String.valueOf(" [Timeout in: "))).concat(String.valueOf(i))).concat(String.valueOf(" seconds]")));
                }
                if (!thread.isAlive() || this.stop) break;
            }
            text.setText(oldText);
            if (thread.isAlive()) {
                thread.stop();
                if (!this.stop) {
                    MsgBox msgBox = new MsgBox(this.parentFrame, String.valueOf(String.valueOf("Connection attempt timed out after ").concat(String.valueOf(this.connectTime))).concat(String.valueOf(" seconds.")));
                }
            }
            if (!this.stop) {
                socket = thread.getSocket();
            }
        }
        catch (InterruptedException e) {
            MsgBox msgBox = new MsgBox(this.parentFrame, String.valueOf("Error: ").concat(String.valueOf(e)));
        }
        return socket;
    }

    public void Logoff() {
        boolean ret_code = false;
        if (this.socket != null) {
            try {
                if (this.in != null && this.out != null) {
                    this.out.writeBytes("QUIT\r\n");
                    this.inchar = this.in.readLine();
                }
                this.socket.close();
            }
            catch (IOException e) {
                MsgBox msgBox = new MsgBox(this.parentFrame, String.valueOf("Error").concat(String.valueOf(e)));
            }
        }
        this.in = null;
        this.out = null;
        this.socket = null;
    }

    public void SendMail(File popfile, Profile profile, FolderItem outbasket, FolderItem trash) {
        this.currentPopfile = popfile;
        this.uploadmail = new UpLoadMail(this, profile, outbasket, trash);
        this.uploadmail.start();
    }

    public void sendMail(Profile profile, FolderItem outbasket, FolderItem trash) {
        boolean logon = false;
        boolean go = false;
        boolean ret_code = false;
        String[] names = new String[1];
        int num = 0;
        SendItem senditem = null;
        Vector addr = null;
        Label text = this.frame.text;
        jstreet.runExitProgram(this.frame, SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.SENDEXIT);
        if (this.currentPopfile != null) {
            names[0] = new String(this.currentPopfile.getName());
        } else {
            names = outbasket.getPath().list(new PopFilter());
        }
        for (int i = 0; i < names.length; ++i) {
            num = i + 1;
            text.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Sending message [").concat(String.valueOf(num))).concat(String.valueOf(" of "))).concat(String.valueOf(names.length))).concat(String.valueOf("]...")));
            File popfile = new File(outbasket.getPath(), names[i]);
            senditem = new SendItem(this.frame, popfile, outbasket, trash);
            addr = senditem.getAddresses();
            go = true;
            if (addr.size() > 0) {
                if (!logon) {
                    logon = this.Logon(text);
                }
                if (logon) {
                    if (!this.uploadMessage(senditem, popfile)) {
                        ret_code = false;
                        go = false;
                    } else {
                        ret_code = true;
                    }
                } else {
                    this.stop = true;
                }
            }
            if (!this.stop && go && senditem.isNewsItem()) {
                this.post = new NewsPost(this.frame, senditem, popfile);
                ret_code = this.post.uploadMessage();
                this.post = null;
            }
            if (this.stop || !ret_code) break;
            senditem.fileMessage();
        }
        if (ret_code) {
            if (names.length == 1) {
                text.setText("Your message was sent successfully.");
            } else {
                text.setText("Your messages were sent successfully.");
            }
        } else if (names.length == 1) {
            text.setText("Errors occurred sending your message.");
        } else {
            text.setText("Errors occurred sending your messages.");
        }
        if (logon) {
            this.Logoff();
        }
        this.uploadmail = null;
        this.active = false;
        jstreet.runExitProgram(this.frame, SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.SENDFEXIT);
        this.frame.SendComplete();
    }

    public boolean active() {
        return this.active;
    }

    public void breakSend() {
        if (this.uploadmail != null) {
            this.uploadmail.stop();
            this.uploadmail = null;
        }
    }

    public boolean uploadMessage(SendItem senditem, File popfile) {
        if (senditem.addrapproach == 0) {
            return this.uploadSingleMessage(senditem, popfile);
        }
        return this.uploadMultipleMessage(senditem, popfile);
    }

    private boolean uploadMultipleMessage(SendItem senditem, File popfile) {
        boolean ret_code = true;
        Vector addr = senditem.getAddresses();
        for (int i = 0; i < addr.size(); ++i) {
            try {
                MsgBox msgBox;
                this.out.writeBytes("XTND XMIT\r\n");
                String inchar = this.in.readLine();
                if (inchar.charAt(0) == '+') {
                    senditem.setAddress((String)addr.elementAt(i));
                    ret_code = senditem.uploadMessage(this.out, popfile, true, true, false);
                    if (!ret_code) continue;
                    this.out.writeBytes(".\r\n");
                    inchar = this.in.readLine();
                    if (inchar.charAt(0) == '+') continue;
                    ret_code = false;
                    msgBox = new MsgBox(this.parentFrame, String.valueOf("POP3 Error: ").concat(String.valueOf(inchar)));
                    continue;
                }
                ret_code = false;
                msgBox = new MsgBox(this.parentFrame, String.valueOf("POP3 Error: ").concat(String.valueOf(inchar)));
                continue;
            }
            catch (IOException e) {
                ret_code = false;
                MsgBox msgbox = new MsgBox(this.parentFrame, String.valueOf("POP3 Error: ").concat(String.valueOf(e)));
            }
        }
        return ret_code;
    }

    private boolean uploadSingleMessage(SendItem senditem, File popfile) {
        boolean ret_code;
        block4: {
            ret_code = true;
            try {
                this.out.writeBytes("XTND XMIT\r\n");
                String inchar = this.in.readLine();
                if (inchar.charAt(0) == '+') {
                    ret_code = senditem.uploadMessage(this.out, popfile, true, true, false);
                    if (!ret_code) break block4;
                    this.out.writeBytes(".\r\n");
                    inchar = this.in.readLine();
                    if (inchar.charAt(0) != '+') {
                        ret_code = false;
                        MsgBox msgBox = new MsgBox(this.parentFrame, String.valueOf("POP3 Error: ").concat(String.valueOf(inchar)));
                    }
                    break block4;
                }
                ret_code = false;
                MsgBox msgBox = new MsgBox(this.parentFrame, String.valueOf("POP3 Error: ").concat(String.valueOf(inchar)));
            }
            catch (IOException e) {
                ret_code = false;
                MsgBox msgbox = new MsgBox(this.parentFrame, String.valueOf("POP3 Error: ").concat(String.valueOf(e)));
            }
        }
        return ret_code;
    }
}

