/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.PopFileProcedure;
import innoval.mailer.SendItem;
import innoval.mailer.SettingsAdvanced;
import innoval.mailer.jstreet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.io.File;
import java.util.Vector;

public class PrintMsg {
    File popfile;
    jstreet parent;
    PrintJob job;
    Graphics g;
    int headerState = 2;
    int page = 0;
    Font font;
    FontMetrics tm;
    String timestamp = SendItem.getPopDate();
    int inch;
    int lheight;
    int lmargin = 0;
    int rmargin = 0;
    int tmargin = 0;
    int bmargin = 0;
    int lastpos = 0;
    boolean ret_code = true;
    boolean decodeState = true;
    boolean eject = false;
    boolean wraplines = true;
    boolean footer = true;

    PrintMsg(jstreet parent, String file, int headerState, boolean decodeState) {
        this.parent = parent;
        this.headerState = headerState;
        this.decodeState = decodeState;
        this.popfile = new File(file);
        if (this.popfile.exists() && this.setupPrinter()) {
            this.PrintChosenMsg(this.popfile);
        }
        if (this.job != null) {
            if (this.g != null) {
                this.g.dispose();
            }
            this.job.end();
            System.out.println("Printing completed.");
        }
    }

    PrintMsg(jstreet parent, Vector fvector, int headerState, boolean decodeState) {
        this.parent = parent;
        this.headerState = headerState;
        this.decodeState = decodeState;
        if (this.setupPrinter()) {
            File file = null;
            for (int i = 0; i < fvector.size(); ++i) {
                if (i > 0 && this.eject) {
                    this.g.dispose();
                    this.g = this.job.getGraphics();
                    this.g.setColor(Color.black);
                    this.g.setFont(this.font);
                    if (this.wraplines) {
                        this.tm = this.g.getFontMetrics();
                    }
                }
                file = (File)fvector.elementAt(i);
                this.PrintChosenMsg(file);
            }
        }
        if (this.job != null) {
            if (this.g != null) {
                this.g.dispose();
            }
            this.job.end();
            System.out.println("Printing completed.");
        }
    }

    PrintMsg(jstreet parent, String dir, String[] files, boolean delete) {
        int i = 0;
        boolean check = false;
        this.parent = parent;
        if (this.setupPrinter()) {
            for (i = 0; i < files.length; ++i) {
                this.popfile = new File(String.valueOf(dir).concat(String.valueOf(files[i])));
                if (!this.popfile.exists()) continue;
                if (i > 0 && this.eject) {
                    this.g.dispose();
                    this.g = this.job.getGraphics();
                    this.g.setColor(Color.black);
                    this.g.setFont(this.font);
                    if (this.wraplines) {
                        this.tm = this.g.getFontMetrics();
                    }
                }
                this.ret_code = this.PrintChosenMsg(this.popfile);
                if (!delete || !this.popfile.exists()) continue;
                check = this.popfile.delete();
            }
        } else {
            this.ret_code = false;
        }
        if (this.job != null) {
            this.g.dispose();
            this.job.end();
            System.out.println("Printing completed.");
        }
    }

    public boolean getReturnCode() {
        return this.ret_code;
    }

    private boolean PrintChosenMsg(File popfile) {
        boolean ok;
        block5: {
            PopFileProcedure pop = new PopFileProcedure();
            ok = false;
            Vector lVector = new Vector();
            int x = 0;
            int y = 0;
            y = this.eject || this.lastpos == 0 ? this.tmargin : this.lastpos + this.lheight;
            x = this.lmargin;
            if (!this.eject && y == this.tmargin && this.page > 0) {
                this.g.dispose();
                this.g = this.job.getGraphics();
                this.g.setFont(this.font);
                if (this.wraplines) {
                    this.tm = this.g.getFontMetrics();
                }
                this.g.setColor(Color.black);
                if (this.footer) {
                    this.drawPageNumber(++this.page);
                }
            }
            pop.setHtml(false);
            pop.setDecode(this.decodeState);
            pop.setFormat(true);
            pop.setHeaderState(this.headerState);
            pop.setLineVector(lVector);
            pop.readFile(this.parent, popfile.getAbsolutePath());
            if (this.footer && (this.eject || this.page == 0)) {
                this.drawPageNumber(++this.page);
            }
            for (int i = 0; i < lVector.size(); ++i) {
                ok = true;
                String text = (String)lVector.elementAt(i);
                y = this.writeLine(text, x, y, i, lVector.size());
                y += this.lheight;
            }
            this.lastpos = y;
            if (y < this.bmargin) break block5;
            this.lastpos = 0;
        }
        return ok;
    }

    private int writeLine(String text, int x, int y, int rec, int max) {
        boolean quit = false;
        int llen = this.rmargin - this.lmargin;
        do {
            if (this.wraplines && this.tm.stringWidth(text) > llen) {
                int spot = this.getSplitSpot(this.tm, text);
                this.g.drawString(text.substring(0, spot), x, y);
                text = new String(text.substring(spot));
                y += this.lheight;
            } else {
                this.g.drawString(text, x, y);
                quit = true;
            }
            if (y <= this.bmargin || rec >= max - 1) continue;
            y = this.tmargin;
            this.g.dispose();
            this.g = this.job.getGraphics();
            this.g.setFont(this.font);
            if (this.wraplines) {
                this.tm = this.g.getFontMetrics();
            }
            this.g.setColor(Color.black);
            if (!this.footer) continue;
            this.drawPageNumber(++this.page);
        } while (!quit);
        return y;
    }

    private int getSplitSpot(FontMetrics tm, String text) {
        int spot = text.indexOf(32);
        int nspot = 0;
        int llen = this.rmargin - this.lmargin;
        boolean quit = false;
        if (spot >= 0 && tm.stringWidth(text.substring(0, spot)) < llen) {
            do {
                if ((nspot = text.indexOf(32, spot + 1)) < 0 || tm.stringWidth(text.substring(0, nspot)) > llen) {
                    ++spot;
                    quit = true;
                    continue;
                }
                spot = nspot;
            } while (!quit);
        } else {
            spot = 0;
            while (tm.stringWidth(text.substring(0, spot)) < llen) {
                spot += 2;
            }
            spot -= 2;
        }
        return spot;
    }

    private void drawPageNumber(int page) {
        int x = 0;
        int y = this.bmargin + 3 * this.lheight;
        this.g.drawLine(this.lmargin, this.bmargin + 2 * this.lheight, this.rmargin, this.bmargin + 2 * this.lheight);
        x = this.lmargin;
        this.g.drawString(this.timestamp, x, y);
        x = this.rmargin - 4 * this.lheight;
        this.g.drawString(String.valueOf("Page ").concat(String.valueOf(page)), x, y);
    }

    private boolean setupPrinter() {
        boolean ok = true;
        int inch = 0;
        this.job = Toolkit.getDefaultToolkit().getPrintJob(this.parent, jstreet.TITLE, null);
        if (this.job != null) {
            this.g = this.job.getGraphics();
            if (this.g != null) {
                this.font = SettingsAdvanced.readFont(this.parent.getProfile(), SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.PRINTFONT);
                this.g.setFont(this.font);
                this.g.setColor(Color.black);
                this.tm = this.g.getFontMetrics();
                Dimension dim = this.job.getPageDimension();
                this.eject = Boolean.valueOf(this.parent.getProfile().ReadString(SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.PAGEEJECTS, "true"));
                this.footer = Boolean.valueOf(this.parent.getProfile().ReadString(SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.PRINTFOOTER, "true"));
                this.wraplines = Boolean.valueOf(this.parent.getProfile().ReadString(SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.WRAPLINES, "true"));
                inch = Boolean.valueOf(this.parent.getProfile().ReadString(SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.USEINCHSIZE, "false")) != false ? Integer.valueOf(this.parent.getProfile().ReadString(SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.INCHSIZE, "14")) : (dim.height > 200 ? dim.height / 11 : (int)((double)this.job.getPageResolution() / 3.2));
                this.lheight = this.tm.getHeight();
                this.tmargin = this.getMargin(SettingsAdvanced.TOPMARGIN, inch);
                this.bmargin = 11 * inch - this.getMargin(SettingsAdvanced.BOTMARGIN, inch);
                this.lmargin = this.getMargin(SettingsAdvanced.LEFTMARGIN, inch);
                this.rmargin = (int)(8.5 * (double)inch) - this.getMargin(SettingsAdvanced.RIGHTMARGIN, inch);
                System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("PrintJob successfully initiated: Page=").concat(String.valueOf((int)(8.5 * (double)inch)))).concat(String.valueOf("x"))).concat(String.valueOf(11 * inch))).concat(String.valueOf(" Res="))).concat(String.valueOf(this.job.getPageResolution()))).concat(String.valueOf(" 1 inch="))).concat(String.valueOf(inch))).concat(String.valueOf(" lineheight="))).concat(String.valueOf(this.lheight)));
            } else {
                System.out.println("Could not get printjob graphics handle.");
            }
        } else {
            ok = false;
        }
        return ok;
    }

    private int getMargin(String key, int inch) {
        double[] mar = new double[]{0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0};
        int val = 0;
        int ind = Integer.valueOf(this.parent.getProfile().ReadString(SettingsAdvanced.SAVEADVANCED, key, "3"));
        val = (int)(mar[ind] * (double)inch);
        return val;
    }
}

