/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.MsgBox;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;

public class SelectDraftMessage
extends Dialog
implements KeyListener,
ActionListener {
    private Frame frame;
    private Panel panel;
    private Button okButton;
    private Button cancelButton;
    private Button deleteButton;
    private String ext = new String(String.valueOf(".").concat(String.valueOf(jstreet.DRAFTEXT)));
    private boolean ret_code;
    private boolean template;
    private String filename;
    private File dir;
    private List list;

    SelectDraftMessage(Frame frame, File dir) {
        super(frame, "Open a Draft Message", true);
        this.frame = frame;
        this.dir = dir;
        this.setupDialog();
    }

    SelectDraftMessage(Frame frame, File dir, boolean template) {
        super(frame, "Open a Message Template", true);
        this.frame = frame;
        this.dir = dir;
        this.template = template;
        this.ext = new String(String.valueOf(".").concat(String.valueOf(jstreet.TEMPLATEEXT)));
        this.setupDialog();
    }

    public void setupDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{150, 5, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 5, 60, 100, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.list = new List();
        this.list.addActionListener(this);
        this.add(this.list);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 8;
        grid.setConstraints(this.list, con);
        this.loadDraftList();
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 2;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 2;
        grid.setConstraints(this.cancelButton, con);
        this.deleteButton = new Button("Delete");
        this.deleteButton.addActionListener(this);
        this.deleteButton.addKeyListener(this);
        this.add(this.deleteButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 2;
        grid.setConstraints(this.deleteButton, con);
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, this.frame);
        this.enableEvents(64L);
        this.show();
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean getReturn() {
        return this.ret_code;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        int item;
        if (e.getSource() == this.okButton || e.getSource() == this.list) {
            int item2 = this.list.getSelectedIndex();
            if (item2 >= 0) {
                File file = new File(this.dir, String.valueOf(this.list.getItem(item2)).concat(String.valueOf(this.ext)));
                this.filename = file.getAbsolutePath();
                this.ret_code = true;
                this.dispose();
            } else {
                MsgBox file = new MsgBox(this.frame, "No item is selected.");
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        } else if (e.getSource() == this.deleteButton && (item = this.list.getSelectedIndex()) >= 0) {
            File file = new File(this.dir, String.valueOf(this.list.getItem(item)).concat(String.valueOf(this.ext)));
            file.delete();
            this.list.remove(item);
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.dispose();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public void loadDraftList() {
        String[] file = this.dir.list();
        int spot = 0;
        if (file != null) {
            for (int i = 0; i < file.length; ++i) {
                if (!file[i].endsWith(this.ext)) continue;
                spot = file[i].lastIndexOf(46);
                this.list.add(file[i].substring(0, spot));
            }
            if (this.list.getItemCount() > 0) {
                this.list.select(0);
            }
        }
    }
}

