/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import borland.jbcl.control.BevelPanel;
import innoval.mailer.AttachToolbar;
import innoval.mailer.GenDirectory;
import innoval.mailer.HandleAttachFile;
import innoval.mailer.ImageWin;
import innoval.mailer.MsgBox;
import innoval.mailer.NoteWinVFolder;
import innoval.mailer.PopFileProcedure;
import innoval.mailer.PrintMsg;
import innoval.mailer.jstreet;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;

public class ViewFormattedMessage
extends Frame
implements ItemListener,
ActionListener {
    static final String TITLE = new String("Formatted Message Window");
    static final int WINCX = 500;
    static final int WINCY = 300;
    private int headerState = 0;
    private int fontSize = 0;
    private boolean delete = true;
    private boolean formatState = false;
    private boolean decodeState = false;
    private boolean closed = false;
    private Frame parent = null;
    private jstreet Jstreet = null;
    private AttachToolbar attachbar;
    private BevelPanel bevpanel2;
    private ImageWin textarea = null;
    private Label text = null;
    private MenuBar menu = null;
    private Menu menuNote = null;
    private Menu menuHeader = null;
    private Menu menuFont = null;
    private CheckboxMenuItem IDM_NOTE_FORMAT;
    private CheckboxMenuItem IDM_NOTE_DECODE;
    private CheckboxMenuItem IDM_HEADER_NONE;
    private CheckboxMenuItem IDM_HEADER_BRIEF;
    private CheckboxMenuItem IDM_HEADER_NORMAL;
    private CheckboxMenuItem IDM_HEADER_ALL;
    private CheckboxMenuItem IDM_FONT_SMALL;
    private CheckboxMenuItem IDM_FONT_MEDIUM;
    private CheckboxMenuItem IDM_FONT_LARGE;
    private CheckboxMenuItem IDM_FONT_XLARGE;
    private MenuItem IDM_FILE_PRINT;
    private File file = null;
    private File attachDir;

    public ViewFormattedMessage(Frame parent, jstreet Jstreet, String title) {
        this.parent = parent;
        this.Jstreet = Jstreet;
        this.formatState = Jstreet.textarea.getFormatState();
        this.decodeState = Jstreet.textarea.getDecodeState();
        this.headerState = Jstreet.textarea.getHeaderState();
        this.fontSize = Jstreet.textarea.getFontSize();
        this.setTitle(title);
        this.initWindow();
        this.enableEvents(64L);
        this.show();
        this.attachbar.Enable();
    }

    protected void finalize() {
        if (this.delete && this.file != null && this.file.exists()) {
            this.file.delete();
        }
    }

    public void setWindowTitle(String text) {
        this.setTitle(text);
    }

    public void setDelete(boolean val) {
        this.delete = val;
    }

    public Label getTextWindow() {
        return this.text;
    }

    public void setFormatState(boolean val) {
        this.IDM_NOTE_FORMAT.setState(val);
        this.formatState = val;
        this.loadFile(this.file);
    }

    public void setDecodeState(boolean val) {
        this.IDM_NOTE_DECODE.setState(val);
        this.decodeState = val;
        this.loadFile(this.file);
    }

    public void setHeaderState(int val) {
        this.headerState = val;
        this.loadFile(this.file);
    }

    public void setFontSize(int val) {
        this.fontSize = val;
        this.loadFile(this.file);
    }

    public void loadFile(File file) {
        Object in = null;
        Object text = null;
        StringBuffer ttext = new StringBuffer(1024);
        ttext.setLength(0);
        this.file = file;
        this.bevpanel2.setVisible(true);
        if (file.exists()) {
            PopFileProcedure pop = new PopFileProcedure();
            pop.setAttachDir(this.getAttachDir());
            pop.setHtml(true);
            pop.setDecode(this.decodeState);
            pop.setFormat(this.formatState);
            pop.setHtmlFontSize(this.fontSize);
            pop.setStickyNotesOff();
            pop.readFile(this.Jstreet, file.getAbsolutePath());
            this.attachbar.setup(this.getAttachDir());
            this.textarea.setText(pop.getPopHTMLText(this.headerState));
        }
        this.bevpanel2.validate();
    }

    public int removeChar(byte[] text, int bytes, char tchar) {
        int cnt = 0;
        for (int i = 0; i < bytes; ++i) {
            if (text[i] == (byte)tchar) continue;
            text[cnt++] = text[i];
        }
        for (int i = cnt; i < bytes; ++i) {
            text[i] = 0;
        }
        return cnt;
    }

    private void initWindow() {
        Panel panel = new Panel();
        this.setupMenu();
        ((Component)this).setSize(this.getInsets().left + this.getInsets().right + 500, this.getInsets().top + this.getInsets().bottom + 300);
        Dimension dim = this.getToolkit().getScreenSize();
        ((Component)this).setLocation((dim.width - this.getSize().width) / 2, (dim.height - this.getSize().height) / 2);
        this.attachbar = new AttachToolbar(this, this.Jstreet);
        this.attachbar.setVisible(false);
        this.attachbar.addActionListener(this);
        BevelPanel panelAttach = new BevelPanel();
        panelAttach.add("Center", this.attachbar);
        this.textarea = new ImageWin();
        this.bevpanel2 = new BevelPanel();
        this.bevpanel2.setLayout(new BorderLayout());
        this.bevpanel2.add("South", panelAttach);
        this.bevpanel2.add("Center", this.textarea);
        this.bevpanel2.setVisible(false);
        this.text = new Label("");
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gb);
        try {
            ViewFormattedMessage.addComponent(panel, this.text, 0, 0, 8, 1, 1, 17, 1, 1);
        }
        catch (Exception e) {
            MsgBox msgBox = new MsgBox(this, String.valueOf("Error").concat(String.valueOf(e)));
        }
        this.add("South", panel);
        this.add("Center", this.bevpanel2);
    }

    private void setupMenu() {
        this.menu = new MenuBar();
        this.menuNote = new Menu("Message");
        this.IDM_FILE_PRINT = new MenuItem("Print...");
        this.IDM_FILE_PRINT.addActionListener(this);
        this.menuNote.add(this.IDM_FILE_PRINT);
        this.menuNote.addSeparator();
        this.IDM_NOTE_FORMAT = new CheckboxMenuItem("Word wrap");
        this.IDM_NOTE_FORMAT.addItemListener(this);
        this.IDM_NOTE_FORMAT.setState(this.formatState);
        this.menuNote.add(this.IDM_NOTE_FORMAT);
        this.IDM_NOTE_DECODE = new CheckboxMenuItem("Decode attachments");
        this.IDM_NOTE_DECODE.addItemListener(this);
        this.IDM_NOTE_DECODE.setState(this.decodeState);
        this.menuNote.add(this.IDM_NOTE_DECODE);
        this.menuHeader = new Menu("Headers");
        this.IDM_HEADER_NONE = new CheckboxMenuItem("None");
        this.IDM_HEADER_NONE.addItemListener(this);
        this.menuHeader.add(this.IDM_HEADER_NONE);
        this.IDM_HEADER_BRIEF = new CheckboxMenuItem("Brief");
        this.IDM_HEADER_BRIEF.addItemListener(this);
        this.menuHeader.add(this.IDM_HEADER_BRIEF);
        this.IDM_HEADER_NORMAL = new CheckboxMenuItem("Normal");
        this.IDM_HEADER_NORMAL.addItemListener(this);
        this.menuHeader.add(this.IDM_HEADER_NORMAL);
        this.IDM_HEADER_ALL = new CheckboxMenuItem("All");
        this.IDM_HEADER_ALL.addItemListener(this);
        this.menuHeader.add(this.IDM_HEADER_ALL);
        switch (this.headerState) {
            case 0: {
                this.IDM_HEADER_NONE.setState(true);
                break;
            }
            case 1: {
                this.IDM_HEADER_BRIEF.setState(true);
                break;
            }
            case 2: {
                this.IDM_HEADER_NORMAL.setState(true);
                break;
            }
            case 3: {
                this.IDM_HEADER_ALL.setState(true);
            }
        }
        this.menuNote.add(this.menuHeader);
        this.menuFont = new Menu("Browser window font size");
        this.IDM_FONT_SMALL = new CheckboxMenuItem("Small");
        this.IDM_FONT_SMALL.addItemListener(this);
        this.menuFont.add(this.IDM_FONT_SMALL);
        this.IDM_FONT_MEDIUM = new CheckboxMenuItem("Medium");
        this.IDM_FONT_MEDIUM.addItemListener(this);
        this.menuFont.add(this.IDM_FONT_MEDIUM);
        this.IDM_FONT_LARGE = new CheckboxMenuItem("Large");
        this.IDM_FONT_LARGE.addItemListener(this);
        this.menuFont.add(this.IDM_FONT_LARGE);
        this.IDM_FONT_XLARGE = new CheckboxMenuItem("Extra large");
        this.IDM_FONT_XLARGE.addItemListener(this);
        this.menuFont.add(this.IDM_FONT_XLARGE);
        switch (this.fontSize) {
            case 0: {
                this.IDM_FONT_SMALL.setState(true);
                break;
            }
            case 1: {
                this.IDM_FONT_MEDIUM.setState(true);
                break;
            }
            case 2: {
                this.IDM_FONT_LARGE.setState(true);
                break;
            }
            case 3: {
                this.IDM_FONT_XLARGE.setState(true);
            }
        }
        this.menuNote.add(this.menuFont);
        this.menu.add(this.menuNote);
        this.setMenuBar(this.menu);
    }

    public static void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int fill, int anchor, int weightx, int weighty) throws AWTException {
        LayoutManager lm = container.getLayout();
        if (!(lm instanceof GridBagLayout)) {
            throw new AWTException(String.valueOf("Invalid layout").concat(String.valueOf(lm)));
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        container.add(component, gbc);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == null) {
            cmd = new String("");
        }
        if (cmd.equals("attach-toolbar")) {
            HandleAttachFile handleAttachFile = new HandleAttachFile((Frame)this, this.Jstreet, this.getAttachDir(), this.attachbar.getButtonClickedTag());
        } else if (e.getSource() == this.IDM_FILE_PRINT) {
            PrintMsg printMsg = new PrintMsg(this.Jstreet, this.file.getAbsolutePath(), this.headerState, this.decodeState);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        CheckboxMenuItem item = (CheckboxMenuItem)e.getSource();
        if (item.getLabel().equals("Word wrap")) {
            this.setFormatState(!this.formatState);
        } else if (item.getLabel().equals("Decode attachments")) {
            this.setDecodeState(!this.decodeState);
        } else if (item.getLabel().equals("None")) {
            this.setHeaderState(0);
            this.clearHeaderChecks();
            this.IDM_HEADER_NONE.setState(true);
        } else if (item.getLabel().equals("Brief")) {
            this.setHeaderState(1);
            this.clearHeaderChecks();
            this.IDM_HEADER_BRIEF.setState(true);
        } else if (item.getLabel().equals("Normal")) {
            this.setHeaderState(2);
            this.clearHeaderChecks();
            this.IDM_HEADER_NORMAL.setState(true);
        } else if (item.getLabel().equals("All")) {
            this.setHeaderState(3);
            this.clearHeaderChecks();
            this.IDM_HEADER_ALL.setState(true);
        } else if (item.getLabel().equals("Small")) {
            this.setFontSize(0);
            this.clearFontChecks();
            this.IDM_FONT_SMALL.setState(true);
        } else if (item.getLabel().equals("Medium")) {
            this.setFontSize(1);
            this.clearFontChecks();
            this.IDM_FONT_MEDIUM.setState(true);
        } else if (item.getLabel().equals("Large")) {
            this.setFontSize(2);
            this.clearFontChecks();
            this.IDM_FONT_LARGE.setState(true);
        } else if (item.getLabel().equals("Extra large")) {
            this.setFontSize(3);
            this.clearFontChecks();
            this.IDM_FONT_XLARGE.setState(true);
        }
    }

    public void clearHeaderChecks() {
        this.IDM_HEADER_NONE.setState(false);
        this.IDM_HEADER_BRIEF.setState(false);
        this.IDM_HEADER_NORMAL.setState(false);
        this.IDM_HEADER_ALL.setState(false);
    }

    public void clearFontChecks() {
        this.IDM_FONT_SMALL.setState(false);
        this.IDM_FONT_MEDIUM.setState(false);
        this.IDM_FONT_LARGE.setState(false);
        this.IDM_FONT_XLARGE.setState(false);
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.Close();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public boolean getClosed() {
        return this.closed;
    }

    public void Close() {
        if (this.attachDir != null) {
            NoteWinVFolder.clearDirectory(this.attachDir);
            this.attachDir.delete();
        }
        if (this.delete && this.file != null) {
            this.file.delete();
        }
        this.closed = true;
        ((Component)this).setVisible(false);
        this.dispose();
        this.parent.toFront();
    }

    public File getAttachDir() {
        if (this.attachDir == null) {
            this.attachDir = GenDirectory.make(this.Jstreet.getSystemDir());
        }
        return this.attachDir;
    }

    public void runBrowser(String text) {
        this.Jstreet.runBrowser(text);
    }
}

