/*
 * Decompiled with CFR 0.152.
 */
package innoval.popper;

import innoval.mailer.JBevelPanel;
import innoval.mailer.MsgBox;
import innoval.mailer.jstreet;
import innoval.popper.PopperAccount;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;

public class Popper
extends Frame
implements ItemListener {
    static final String SAVENAME = new String("Popper");
    static final String SAVEWINDOWPOS = new String("WindowPos");
    static final String TITLE = new String("Popper Message Retrieval Center");
    static final String DEFAULT_DIR = new String("POPPER");
    static final int WINCX = 540;
    static final int WINCY = 300;
    private jstreet Jstreet;
    private File rootDir;
    private Vector accountVector;
    private ScrollPane pane;
    private Checkbox activeCheck;

    public Popper(jstreet Jstreet) {
        this.Jstreet = Jstreet;
        this.rootDir = new File(Jstreet.getSystemDir(), DEFAULT_DIR);
        if (!this.rootDir.exists()) {
            this.rootDir.mkdir();
        }
        if (this.rootDir.exists()) {
            this.initWindow();
            this.setTitle(TITLE);
            this.enableEvents(64L);
        } else {
            MsgBox msgBox = new MsgBox(Jstreet, String.valueOf(String.valueOf("Error creating Popper directory [").concat(String.valueOf(this.rootDir.getAbsolutePath()))).concat(String.valueOf("]")));
        }
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public void showWindow() {
        super.show();
    }

    private void initWindow() {
        if (!this.restorePosition()) {
            ((Component)this).setSize(this.getInsets().left + this.getInsets().right + 540, this.getInsets().top + this.getInsets().bottom + 300);
            Dimension dim = this.getToolkit().getScreenSize();
            ((Component)this).setLocation((dim.width - this.getSize().width) / 2, (dim.height - this.getSize().height) / 2);
        }
        this.accountVector = new Vector();
        this.setupPanel();
        JBevelPanel panel = new JBevelPanel();
        panel.setBackground(Color.lightGray);
        panel.setBevelInner(2);
        panel.setBevelOuter(2);
        panel.setPreferredSize(25, 50);
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 15, 5};
        int[] columnWidths = new int[]{5, 100, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.activeCheck = new Checkbox("Retrieval Center is Active", false);
        this.activeCheck.addItemListener(this);
        panel.add(this.activeCheck);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(this.activeCheck, con);
        panel.setLayout(grid);
        this.add("South", panel);
    }

    public void setupPanel() {
        if (this.pane != null) {
            this.remove(this.pane);
        }
        this.pane = new ScrollPane();
        this.pane.setBackground(Color.lightGray);
        this.pane.add(this.setupScrollPanel());
        this.add("Center", this.pane);
        if (this.isVisible()) {
            this.validate();
            if (this.activeCheck.getState()) {
                this.startAccounts();
            }
        }
    }

    public Panel setupScrollPanel() {
        Panel panel = new Panel();
        Panel tpanel = null;
        Vector vector = this.Jstreet.accountIndex.getAccounts();
        PopperAccount account = null;
        int cnt = 0;
        panel.setBackground(Color.lightGray);
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int[] columnWidths = new int[]{100, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.setChecks();
        for (int i = 0; i < vector.size(); ++i) {
            account = this.findAccount((String)vector.elementAt(i));
            if (account == null) {
                account = new PopperAccount(this, this.Jstreet.getAllAccountDir(), (String)vector.elementAt(i));
            } else {
                account.readProfile();
            }
            if (account.isAuto()) {
                tpanel = account.setupPanel();
                panel.add(tpanel);
                jstreet.reset(con);
                con.gridx = 0;
                con.gridy = cnt++;
                grid.setConstraints(tpanel, con);
                if (!account.getCheck()) {
                    this.accountVector.addElement(account);
                    continue;
                }
                account.setCheck(false);
                continue;
            }
            if (!account.getCheck()) continue;
            account.setStop(true);
            this.accountVector.removeElement(account);
        }
        this.cleanupAccounts();
        panel.setLayout(grid);
        return panel;
    }

    public void updateMessages() {
        PopperAccount account = null;
        for (int i = this.accountVector.size() - 1; i >= 0; --i) {
            account = (PopperAccount)this.accountVector.elementAt(i);
            account.updateMessages();
        }
    }

    private void cleanupAccounts() {
        PopperAccount account = null;
        for (int i = this.accountVector.size() - 1; i >= 0; --i) {
            account = (PopperAccount)this.accountVector.elementAt(i);
            if (!account.getCheck()) continue;
            account.setStop(true);
            this.accountVector.removeElementAt(i);
        }
    }

    private PopperAccount findAccount(String name) {
        PopperAccount account = null;
        int cnt = 0;
        do {
            if (cnt >= this.accountVector.size()) continue;
            account = (PopperAccount)this.accountVector.elementAt(cnt);
            if (!account.getName().equals(name)) {
                account = null;
            }
            ++cnt;
        } while (account == null && cnt < this.accountVector.size());
        return account;
    }

    private void setChecks() {
        for (int i = 0; i < this.accountVector.size(); ++i) {
            ((PopperAccount)this.accountVector.elementAt(i)).setCheck(true);
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.Close();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public void Close() {
        this.stopAccounts();
        this.storePosition();
        ((Component)this).setVisible(false);
        try {
            this.dispose();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.Jstreet.setPopper(null);
    }

    public void storePosition() {
        Point point = new Point(this.getLocation());
        Dimension dim = new Dimension(this.getSize());
        String text = new String(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(point.x).concat(String.valueOf(","))).concat(String.valueOf(point.y))).concat(String.valueOf(","))).concat(String.valueOf(dim.width))).concat(String.valueOf(","))).concat(String.valueOf(dim.height))).concat(String.valueOf(",")));
        this.Jstreet.getSystemProfile().WriteString(SAVENAME, SAVEWINDOWPOS, text);
    }

    public boolean restorePosition() {
        boolean ret_code = false;
        String text = new String(this.Jstreet.getSystemProfile().ReadString(SAVENAME, SAVEWINDOWPOS, ""));
        String val = new String("");
        int start = 0;
        int x = 0;
        int y = 0;
        int cx = 0;
        int cy = 0;
        if (text.length() > 0) {
            int spot = text.indexOf(44, start);
            if (spot >= 0) {
                val = new String(text.substring(start, spot));
                text = new String(text.substring(spot + 1));
                x = Integer.parseInt(val);
            }
            if ((spot = text.indexOf(44, start)) >= 0) {
                val = new String(text.substring(start, spot));
                text = new String(text.substring(spot + 1));
                y = Integer.parseInt(val);
            }
            if ((spot = text.indexOf(44, start)) >= 0) {
                val = new String(text.substring(start, spot));
                text = new String(text.substring(spot + 1));
                cx = Integer.parseInt(val);
            }
            if ((spot = text.indexOf(44, start)) >= 0) {
                val = new String(text.substring(start, spot));
                text = new String(text.substring(spot + 1));
                cy = Integer.parseInt(val);
                ret_code = true;
                ((Component)this).setLocation(x, y);
                ((Component)this).setSize(cx, cy);
            }
        }
        return ret_code;
    }

    private void startAccounts() {
        for (int i = 0; i < this.accountVector.size(); ++i) {
            ((PopperAccount)this.accountVector.elementAt(i)).start();
        }
    }

    private void stopAccounts() {
        PopperAccount account = null;
        for (int i = 0; i < this.accountVector.size(); ++i) {
            account = (PopperAccount)this.accountVector.elementAt(i);
            account.setStop(true);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.activeCheck) {
            if (this.activeCheck.getState()) {
                this.startAccounts();
            } else {
                this.stopAccounts();
            }
        }
    }

    public static boolean mailExists(jstreet Jstreet, String account) {
        String[] file;
        boolean ret_code = false;
        File dir = Popper.getDir(Jstreet, account);
        if (dir.exists() && (file = dir.list()) != null && file.length > 0) {
            ret_code = true;
        }
        return ret_code;
    }

    public static File getDir(jstreet Jstreet, String account) {
        File dir = new File(Jstreet.getSystemDir(), DEFAULT_DIR);
        dir = new File(dir, account);
        return dir;
    }

    public synchronized void refreshAccount(PopperAccount account) {
        account.retrieveMail();
        if (this.Jstreet.getAccount().equals(account.getName())) {
            this.Jstreet.getPopperMail(account.getDir());
        }
    }
}

