/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttrStrEnumeration;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERSet;

public class LDAPAttribute {
    private String name;
    private Vector values;

    public LDAPAttribute(LDAPAttribute lDAPAttribute) {
        this.name = lDAPAttribute.name;
        this.values = (Vector)lDAPAttribute.values.clone();
    }

    public LDAPAttribute(String string) {
        this.name = string;
        this.values = new Vector();
    }

    public LDAPAttribute(String string, byte[] byArray) {
        this.name = string;
        this.values = new Vector();
        this.addValue(byArray);
    }

    public LDAPAttribute(String string, String string2) {
        this.name = string;
        this.values = new Vector();
        this.addValue(string2);
    }

    public LDAPAttribute(String string, String[] stringArray) {
        this.name = string;
        this.values = new Vector();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.addValue(stringArray[n]);
                ++n;
            }
            return;
        }
        this.addValue((String)null);
    }

    public LDAPAttribute(BERElement bERElement) throws IOException {
        this.values = new Vector();
        BERSequence bERSequence = (BERSequence)bERElement;
        BEROctetString bEROctetString = (BEROctetString)bERSequence.elementAt(0);
        byte[] byArray = bEROctetString.getValue();
        if (byArray == null) {
            this.name = null;
        } else {
            try {
                this.name = new String(byArray, "UTF8");
            }
            catch (Throwable throwable) {}
        }
        BERSet bERSet = (BERSet)bERSequence.elementAt(1);
        if (bERSet.size() > 0) {
            int n = 0;
            while (n < bERSet.size()) {
                BEROctetString bEROctetString2 = (BEROctetString)bERSet.elementAt(n);
                this.addValue(bEROctetString2.getValue());
                ++n;
            }
        }
    }

    public int size() {
        return this.values.size();
    }

    public Enumeration getStringValues() {
        return new LDAPAttrStrEnumeration(this.values);
    }

    public Enumeration getByteValues() {
        return this.values.elements();
    }

    public String getName() {
        return this.name;
    }

    public static String[] getSubtypes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.hasMoreElements()) {
            stringTokenizer.nextElement();
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                stringArray[n++] = (String)stringTokenizer.nextElement();
            }
            return stringArray;
        }
        return null;
    }

    public String[] getSubtypes() {
        return LDAPAttribute.getSubtypes(this.name);
    }

    public String getLangSubtype() {
        String[] stringArray = this.getSubtypes();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].substring(0, 5).equalsIgnoreCase("lang-")) {
                    return stringArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public static String getBaseName(String string) {
        String string2 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.hasMoreElements()) {
            string2 = (String)stringTokenizer.nextElement();
        }
        return string2;
    }

    public String getBaseName() {
        return LDAPAttribute.getBaseName(this.name);
    }

    public boolean hasSubtype(String string) {
        String[] stringArray = this.getSubtypes();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean hasSubtypes(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (!this.hasSubtype(stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public synchronized void addValue(String string) {
        if (string == null) {
            this.values.addElement(string);
            return;
        }
        try {
            byte[] byArray = string.getBytes("UTF8");
            this.values.addElement(byArray);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public synchronized void addValue(byte[] byArray) {
        this.values.addElement(byArray);
    }

    public synchronized void removeValue(String string) {
        if (string == null) {
            this.values.addElement(string);
            return;
        }
        try {
            byte[] byArray = string.getBytes("UTF8");
            this.values.removeElement(byArray);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public synchronized void removeValue(byte[] byArray) {
        this.values.removeElement(byArray);
    }

    public BERElement getBERElement() {
        try {
            BERSequence bERSequence = new BERSequence();
            bERSequence.addElement(new BEROctetString(this.name));
            BERSet bERSet = new BERSet();
            int n = 0;
            while (n < this.values.size()) {
                bERSet.addElement(new BEROctetString((byte[])this.values.elementAt(n)));
                ++n;
            }
            bERSequence.addElement(bERSet);
            return bERSequence;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String getParamString() {
        String string = "";
        if (this.values.size() > 0) {
            int n = 0;
            while (n < this.values.size()) {
                if (n != 0) {
                    string = String.valueOf(string) + ",";
                }
                string = String.valueOf(string) + LDAPAttrStrEnumeration.convertToUTF8((byte[])this.values.elementAt(n));
                ++n;
            }
        }
        return "{type='" + this.name + "', values='" + string + "'}";
    }

    public String toString() {
        return "LDAPAttribute " + this.getParamString();
    }
}

