/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.javafaces.Face;
import com.jthomas.javafaces.MailList;
import com.jthomas.util.Debug;
import com.jthomas.util.ImageButton;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;

public class FaceButton
extends ImageButton {
    private int _Count = 1;
    private Face _Face;
    private boolean _Paint1 = false;
    private MailList _MailList;
    private String[] _OverlayText;
    private boolean _GrayOut = false;

    public FaceButton(Image image) {
        super(image);
    }

    public void reset() {
        if (this._MailList != null) {
            this._MailList.dispose();
            this._MailList = null;
        }
    }

    public void setCount(int count) {
        this._Count = count;
        this._GrayOut = false;
        Graphics g = this.getGraphics();
        this.paint(g);
    }

    public void setText(String[] overlay) {
        this._OverlayText = overlay;
    }

    public void setFace(Face face) {
        this._Face = face;
    }

    public void paint(Graphics g) {
        Font f;
        super.paint(g);
        if (this._GrayOut) {
            if (this.explicitSize) {
                g.drawImage(this.grayImage, this.margin, this.margin, this.width - 2 * this.margin, this.height - 2 * this.margin, this);
            } else {
                g.drawImage(this.grayImage, this.margin, this.margin, this);
            }
            this.drawBorder(false);
        }
        if (this._Count > 1 || this._Paint1) {
            g.setColor(Color.white);
            g.fillRect(2, 32, 14, 14);
            f = new Font("Monospaced", 1, 14);
            g.setFont(f);
            g.setColor(Color.black);
            g.drawString(Integer.toString(this._Count), 4, 44);
            this._Paint1 = true;
        }
        if (this._OverlayText != null) {
            f = new Font("Monospaced", 0, 12);
            g.setFont(f);
            g.setColor(Color.black);
            g.drawString(this._OverlayText[0], 4, 12);
            g.drawString(this._OverlayText[1], 4, 24);
            g.drawString(this._OverlayText[2], 4, 36);
        }
    }

    private void drawBorder(boolean isUp) {
        Graphics g = this.getGraphics();
        g.setColor(this.marginColor);
        int left = 0;
        int top = 0;
        int width = this.width;
        int height = this.height;
        int i = 0;
        while (i < this.margin) {
            g.draw3DRect(left, top, width, height, isUp);
            ++left;
            ++top;
            width -= 2;
            height -= 2;
            ++i;
        }
    }

    public boolean action(Event event, Object arg) {
        Debug.out("action: " + event.toString());
        if (event.target instanceof FaceButton) {
            if (this._Face != null) {
                if (this._MailList != null) {
                    this._MailList.dispose();
                }
                this._MailList = new MailList(this._Face);
                this._GrayOut = true;
                Graphics g = this.getGraphics();
                this.paint(g);
            } else {
                Debug.out("Ignore select of NoMail Button");
            }
            return true;
        }
        return false;
    }

    public boolean mouseEnter(Event evt, int x, int y) {
        Graphics g = this.getGraphics();
        this.paint(g);
        return true;
    }
}

