/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.javafaces.FaceCacheEntry;
import com.jthomas.javafaces.FaceEvent;
import com.jthomas.javafaces.FaceEventListener;
import com.jthomas.javafaces.FaceOptions;
import com.jthomas.javafaces.JavaFaces;
import com.jthomas.javafaces.MsgDialog;
import com.jthomas.javafaces.PiconDBServer;
import com.jthomas.util.Debug;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class FaceCache
implements FaceEventListener {
    static final int MAX_ENTRIES = 200;
    public boolean _Active = false;
    private Hashtable _ByUser;
    private Hashtable _ByHost;
    private Hashtable _ByURL;
    private Vector _Entries;
    private File _DirFile;
    private File _IndexFile;
    private String _Path;
    private String _PathURL;
    private int _FileNumber;
    private boolean _Updated = false;
    private int _Count;
    private PiconDBServer[] _PiconDBList;
    private FaceOptions _Options;

    public FaceCache(String directory) throws IOException {
        try {
            this._Options = FaceOptions.getRef();
            this._DirFile = new File(directory);
            if (!this._DirFile.exists()) {
                Debug.out(String.valueOf(directory) + "Directory does not exist");
                this._DirFile.mkdir();
            }
            if (!this._DirFile.canWrite()) {
                Debug.out(String.valueOf(directory) + "Directory is not writable");
                throw new IOException();
            }
            this._Path = this._DirFile.getAbsolutePath();
            if (!this._Path.endsWith(new Character(File.separatorChar).toString())) {
                this._Path = String.valueOf(this._Path) + File.separatorChar;
            }
            this._PathURL = "file:" + this._Path.replace(File.separatorChar, '/');
            Debug.out(String.valueOf(this._Path) + " ?= " + this._PathURL);
            this.readIndex();
            JavaFaces.getRef().addFaceEventListener(this);
        }
        catch (Exception e) {
            Debug.out(e);
            Debug.out("Failed to create Cache Object.");
            MsgDialog.create("Failed creating Cache.");
            this._Active = false;
        }
    }

    public void actionPerformed(FaceEvent e) {
        switch (e.getID()) {
            case 10: {
                this.expire();
                break;
            }
            case 11: {
                this.clearIndex();
                break;
            }
            case 13: {
                this.verify(0);
                break;
            }
            case 12: {
                this.listIndex();
                break;
            }
        }
    }

    private synchronized void readIndex() {
        int count = 0;
        this._ByUser = new Hashtable(200);
        this._ByHost = new Hashtable(200);
        this._ByURL = new Hashtable(200);
        this._Entries = new Vector(200);
        try {
            this._IndexFile = new File(this._Path, "Index");
            this._FileNumber = 0;
            if (this._IndexFile.exists()) {
                String entrystr;
                FaceCacheEntry entry = null;
                BufferedReader datafile = new BufferedReader(new FileReader(this._IndexFile));
                while ((entrystr = datafile.readLine()) != null) {
                    entry = new FaceCacheEntry(entrystr);
                    if (entry._CacheURL != null) {
                        this._FileNumber = Math.max(this._FileNumber, this.getFileNumber(entry));
                    }
                    this.addIndex(entry);
                    ++count;
                }
                Debug.out("Read " + count + " entries from Cache index " + this._IndexFile + " Next:" + this._FileNumber);
                this._Active = true;
                datafile.close();
                this._Count = count;
            } else {
                Debug.out("Cache Index file " + this._IndexFile + " not found.  Start from scratch");
                this._Active = true;
                this._Count = 0;
            }
            this._Updated = false;
        }
        catch (IOException e) {
            Debug.out("Failed reading the Index file - " + this._IndexFile + " " + e);
            this._Active = false;
        }
    }

    public synchronized void addIndex(FaceCacheEntry entry) {
        this._Entries.addElement(entry);
        if (entry._Host != null) {
            if (entry._User != null) {
                String key = String.valueOf(entry._User) + "@" + entry._Host;
                this._ByUser.put(key, entry);
            } else {
                this._ByHost.put(entry._Host, entry);
            }
        }
        if (entry._URL != null) {
            this._ByURL.put(entry._URL, entry);
        }
        ++this._Count;
        this._Updated = true;
    }

    public synchronized void deleteIndex(FaceCacheEntry entry) {
        entry.setExpired(true);
        if (entry._Host != null) {
            if (entry._User != null) {
                String key = String.valueOf(entry._User) + "@" + entry._Host;
                this._ByUser.remove(key);
            } else {
                this._ByHost.remove(entry._Host);
            }
        }
        if (entry._URL != null) {
            this._ByURL.remove(entry._URL);
        }
        --this._Count;
        this._Updated = true;
    }

    public synchronized void writeIndex() {
        if (!this._Updated) {
            return;
        }
        int count = 0;
        boolean expired = false;
        try {
            DataOutputStream datafile = new DataOutputStream(new FileOutputStream(this._IndexFile));
            Enumeration e = this._Entries.elements();
            while (e.hasMoreElements()) {
                FaceCacheEntry entry = (FaceCacheEntry)e.nextElement();
                if (entry.getExpired()) continue;
                datafile.writeBytes(entry.dump());
                ++count;
            }
            datafile.close();
            Debug.out("Wrote " + count + " entries to Cache index " + this._IndexFile);
        }
        catch (IOException e) {
            Debug.out("Failed writing the Index file - " + this._IndexFile, e);
        }
    }

    public void listIndex() {
        int count = 0;
        Enumeration e = this._Entries.elements();
        while (e.hasMoreElements()) {
            FaceCacheEntry entry = (FaceCacheEntry)e.nextElement();
            Debug.out(entry.list());
            ++count;
        }
        Debug.out("Index has " + count + " entries");
    }

    public void clearIndex() {
        int count = 0;
        Enumeration e = this._Entries.elements();
        while (e.hasMoreElements()) {
            FaceCacheEntry entry = (FaceCacheEntry)e.nextElement();
            Debug.out("<- Deleting " + entry.toString());
            this.deleteIndex(entry);
            this.deleteCacheImage(entry);
            ++count;
        }
        Debug.out("Deleted " + count + " entries");
        if (this._IndexFile.delete()) {
            Debug.out("Deleted " + this._IndexFile);
        } else {
            Debug.out("Deletion of " + this._IndexFile + " failed.");
        }
        this.readIndex();
    }

    public synchronized String getHost(String host) {
        FaceCacheEntry entry = (FaceCacheEntry)this._ByHost.get(host);
        if (entry == null) {
            return null;
        }
        entry.reference();
        if (entry._CacheURL == null) {
            return "";
        }
        return entry._CacheURL;
    }

    public synchronized String getUser(String user, String host) {
        String key = String.valueOf(user) + "@" + host;
        FaceCacheEntry entry = (FaceCacheEntry)this._ByUser.get(key);
        if (entry == null) {
            return null;
        }
        entry.reference();
        if (entry._CacheURL == null) {
            return "";
        }
        return entry._CacheURL;
    }

    public synchronized String getURL(String url) {
        FaceCacheEntry entry = (FaceCacheEntry)this._ByURL.get(url);
        if (entry == null) {
            return null;
        }
        entry.reference();
        if (entry._CacheURL == null) {
            return "";
        }
        return entry._CacheURL;
    }

    public int getCount() {
        return this._Count;
    }

    public synchronized String cacheImage(String urlstr, String user, String host) {
        if (urlstr == null || urlstr.equals("")) {
            FaceCacheEntry entry = new FaceCacheEntry(null, host, user, null);
            this.addIndex(entry);
            return "";
        }
        String type = ".gif";
        if (urlstr.endsWith(".xbm")) {
            type = ".xbm";
        } else if (!urlstr.endsWith(".gif")) {
            Debug.out("Image type is not .gif or .xbm. ");
            return urlstr;
        }
        String filename = this.getTempFilename(type);
        String path = String.valueOf(this._Path) + filename;
        if (!this.copyURL2File(urlstr, path)) {
            Debug.out("Failed to cache the image");
            return urlstr;
        }
        String pathurl = String.valueOf(this._PathURL) + filename;
        FaceCacheEntry entry = new FaceCacheEntry(urlstr, host, user, pathurl);
        this.addIndex(entry);
        return pathurl;
    }

    public void indexImage(String urlstr, String user, String host, String pathurl) {
        FaceCacheEntry entry = new FaceCacheEntry(urlstr, host, user, pathurl);
        this.addIndex(entry);
    }

    public synchronized void expire() {
        int maxUnusedAge;
        int expire = 0;
        long day = 86400000L;
        try {
            maxUnusedAge = Integer.parseInt(this._Options.get("CacheExpire", "0"));
        }
        catch (Exception exception) {
            MsgDialog.create("CacheExpire not specified or was invalid.");
            maxUnusedAge = 0;
        }
        if (maxUnusedAge > 0) {
            Date unusedDate = new Date(new Date().getTime() - (long)maxUnusedAge * day);
            Debug.out("Expire based on Last Used date > " + unusedDate);
            Enumeration e = this._Entries.elements();
            while (e.hasMoreElements()) {
                FaceCacheEntry entry = (FaceCacheEntry)e.nextElement();
                if (!entry.checkExpire(unusedDate)) continue;
                Debug.out("***Expire this entry***");
                Debug.out(entry.list());
                this.deleteIndex(entry);
                this.deleteCacheImage(entry);
                ++expire;
            }
            Debug.out("Expired " + expire + " entries.");
            if (expire > 0) {
                this._Updated = true;
                this.writeIndex();
                this.readIndex();
            }
        }
    }

    public synchronized void verify(int verifyAge) {
        int reset = 0;
        long day = 86400000L;
        Date verifyDate = new Date(new Date().getTime() - (long)verifyAge * day);
        Debug.out(verifyDate.toString());
        Enumeration e = this._Entries.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            FaceCacheEntry entry = (FaceCacheEntry)e.nextElement();
            ++i;
            if (!entry.checkVerify(verifyDate)) continue;
            Debug.out(String.valueOf(i) + " - " + entry.toString());
            if (entry._CacheURL == null) {
                Debug.out(String.valueOf(i) + " - " + entry);
            } else {
                String pathurl = entry._CacheURL;
                int index1 = pathurl.lastIndexOf(47) + 1;
                String filename = pathurl.substring(index1);
                filename = String.valueOf(this._Path) + filename;
                if (!this.copyURL2File(entry._URL, filename)) {
                    Debug.out(String.valueOf(i) + " - Caching failed for " + entry._URL + " to " + filename);
                }
            }
            ++reset;
        }
        Debug.out("Verified " + reset + " entries");
        if (reset > 0) {
            this._Updated = true;
            this.writeIndex();
            this.readIndex();
        }
    }

    private synchronized String getTempFilename(String type) {
        ++this._FileNumber;
        return String.valueOf(Integer.toString(this._FileNumber)) + type;
    }

    private int getFileNumber(FaceCacheEntry entry) {
        String pathurl = entry._CacheURL;
        try {
            int index1 = pathurl.lastIndexOf(47) + 1;
            int index2 = pathurl.lastIndexOf(46);
            String filename = pathurl.substring(index1, index2);
            Debug.out("entry=" + entry + " FileNumber=" + filename);
            return Integer.parseInt(filename);
        }
        catch (Exception exception) {
            Debug.out("Could not parse " + pathurl);
            return 0;
        }
    }

    private boolean deleteCacheImage(FaceCacheEntry entry) {
        String pathurl = entry._CacheURL;
        if (pathurl == null) {
            return false;
        }
        boolean found = false;
        Enumeration e = this._Entries.elements();
        while (e.hasMoreElements()) {
            FaceCacheEntry thisentry = (FaceCacheEntry)e.nextElement();
            if (thisentry._CacheURL == null || thisentry.getExpired() || !thisentry._CacheURL.equals(pathurl)) continue;
            found = true;
            break;
        }
        if (!found) {
            try {
                int index1 = pathurl.lastIndexOf(47) + 1;
                String filename = pathurl.substring(index1);
                File file = new File(this._Path, filename);
                if (file.delete()) {
                    Debug.out("Deleted file " + filename);
                } else {
                    Debug.out("Delete failed for file " + filename);
                }
                return true;
            }
            catch (Exception exception) {
                Debug.out("Could not delete " + pathurl);
                return false;
            }
        }
        return false;
    }

    private synchronized boolean copyURL2File(String urlstr, String filename) {
        InputStream istream = this.getInputStream(urlstr);
        Debug.out("copyURL2File: " + urlstr + " -> " + filename);
        if (istream == null) {
            System.err.println("copyURL2File: Unable to get data for " + urlstr);
            return false;
        }
        byte[] buffer = new byte[1024];
        try {
            boolean header = true;
            int numbytes = 0;
            FileOutputStream file = new FileOutputStream(filename);
            while ((numbytes = istream.read(buffer)) != -1) {
                if (header) {
                    String data = new String(buffer, 0, 4);
                    if (data.equals("HTTP")) {
                        this.handleHTTPStream(buffer, numbytes, istream, file);
                        break;
                    }
                    header = false;
                }
                file.write(buffer, 0, numbytes);
            }
            file.close();
            istream.close();
        }
        catch (IOException iOException) {
            System.out.println("copyURL2File: IO Failure " + urlstr + " to " + filename);
            return false;
        }
        return true;
    }

    private InputStream getInputStream(String urlstr) {
        String[] hosts = null;
        boolean found = false;
        int dbcount = 0;
        URL url = null;
        Object urlconnection = null;
        InputStream istream = null;
        if (this._PiconDBList == null) {
            this._PiconDBList = JavaFaces.getRef().getPiconDBRef().getList();
        }
        if (this._PiconDBList != null) {
            hosts = new String[this._PiconDBList.length];
            int i = 0;
            while (i < this._PiconDBList.length) {
                hosts[i] = this._PiconDBList[i].getHost();
                Debug.out("hosts=" + hosts[i]);
                ++i;
            }
        } else {
            hosts = new String[]{};
        }
        try {
            url = new URL(urlstr);
            if (urlstr.startsWith("http")) {
                dbcount = 0;
                while (dbcount < hosts.length) {
                    found = url.getHost().equalsIgnoreCase(hosts[dbcount]);
                    if (found) break;
                    ++dbcount;
                }
            }
            if (found && this._PiconDBList[dbcount].getProxy() != null) {
                Debug.out("Get input stream from PiconDB");
                istream = this._PiconDBList[dbcount].getInputStream(urlstr);
            } else {
                istream = url.openStream();
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("FaceCache: InvalidURL - " + urlstr);
            return null;
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            System.err.println("FaceCache: Cannot connect to server for URL: " + urlstr);
            Debug.out(e);
            return null;
        }
        return istream;
    }

    private void handleHTTPStream(byte[] buffer, int len, InputStream istream, FileOutputStream file) throws IOException {
        int numbytes;
        Debug.out("handleHTTPStream()");
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        bytes.write(buffer, 0, len);
        while ((numbytes = istream.read(buffer)) != -1) {
            bytes.write(buffer, 0, numbytes);
        }
        byte[] filebuffer = bytes.toByteArray();
        String filestring = bytes.toString();
        Debug.out("Total=" + filebuffer.length);
        BufferedReader br = new BufferedReader(new StringReader(filestring));
        int headerlen = 0;
        try {
            String line;
            do {
                line = br.readLine();
                Debug.out(String.valueOf(line.length()) + ":" + line);
                headerlen += line.length();
            } while (line.length() != 0);
            int offset = filestring.length() - br.read();
            Debug.out("offset=" + offset);
            file.write(filebuffer, offset, filebuffer.length - offset);
            file.close();
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public static void main(String[] args) {
        String dir = null;
        String user = "jthomas";
        String host1 = "cruzio.com";
        String host2 = "webcom.com";
        String url = "file://picon.gif";
        boolean list = false;
        boolean expire = false;
        boolean create = false;
        Debug.setDebugOn(true);
        if (args.length < 1) {
            Debug.out("syntax: java FaceCache directory");
            System.exit(4);
        } else {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-l")) {
                    list = true;
                } else if (args[i].equals("-e")) {
                    expire = true;
                } else if (args[i].equals("-c")) {
                    create = true;
                } else {
                    dir = args[i];
                }
                ++i;
            }
        }
        Debug.out(dir);
        FaceCache cache = null;
        try {
            cache = new FaceCache(dir);
        }
        catch (IOException iOException) {}
        if (cache.getCount() == 0 && create) {
            String newurl = cache.cacheImage(url, null, host1);
            Debug.out(newurl);
            newurl = cache.cacheImage(url, user, host2);
            Debug.out(newurl);
            newurl = cache.getHost(host1);
            Debug.out(newurl);
            cache.writeIndex();
            Debug.out("Wrote the Index file");
            cache.readIndex();
            newurl = cache.getHost(host2);
            Debug.out(newurl);
        }
        if (list) {
            cache.listIndex();
            System.exit(0);
        }
        if (expire) {
            cache.expire();
            cache.verify(5);
            cache.listIndex();
        }
        System.exit(0);
    }
}

